/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* -------------------------------------------------------------------- */
/*  myMenu.c                                                            */
/*            create menu bar                                           */
/* -------------------------------------------------------------------- */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/CascadeB.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/RowColumn.h>
#include   <string.h>

extern XmFontList fontlist;

Widget simple_menu(menu_bar,name,mnemonic)
     Widget          menu_bar;  /* parent */
     char            *name;
     int             mnemonic;
/* create simple pull-down menu */
{
  Widget     cascade_button;
  Widget     menu_widget;
  Arg        args[10];
  int        n;
  char       new_name[400];

  n=0;
  XtSetArg( args[n],XmNmnemonic,mnemonic );
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(menu_bar),"wheat"));
  n++;
  XtSetArg(args[n],XmNbuttonFontList,fontlist); 
  n++;
  cascade_button = XmCreateCascadeButton(menu_bar, name, args,n );
  XtManageChild(cascade_button);

/* create a new name for the actual menu */
  strcpy(new_name, name);
  strcat( new_name, "Menu");

  n = 0;
  n=0;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(menu_bar),"wheat"));
  n++;
  XtSetArg(args[n],XmNbuttonFontList,fontlist); 
  n++;
  menu_widget = XmCreatePulldownMenu(menu_bar, new_name, args, n);

  n = 0;
  XtSetArg(args[n],XmNsubMenuId,menu_widget);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(menu_bar),"wheat"));
  n++; 
  XtSetValues(cascade_button, args, n);

  return(menu_widget);
 
}


Widget simple_menu_item(menu_widget, name, mnemonic , NeedsSeparator)
     Widget       menu_widget;
     char         *name;
     int          mnemonic;
     Boolean      NeedsSeparator; /* True if leading separator needed */
/* create push button gadget to simple menu */
{
  Widget        widget, sep;
  Arg           args[10];
  int           n;

  if(NeedsSeparator == True)
    {
      sep = XmCreateSeparatorGadget(menu_widget, "sep", NULL, 0);
      XtManageChild(sep);
    }

  n = 0;
  XtSetArg( args[n], XmNmnemonic, mnemonic);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(menu_widget),"wheat"));
  n++;
  XtSetArg(args[n],XmNbuttonFontList,fontlist); 
  n++;
  widget = XmCreatePushButtonGadget(menu_widget, name, args, n);
  XtManageChild(widget);
  return(widget);
}

Widget  simple_menu_call(menu_widget, name, mnemonic, NeedsSeparator, callback)
     Widget         menu_widget;
     char           *name;
     int            mnemonic;
     Boolean        NeedsSeparator; /* True if leading separator needed */
     void           (*callback)();
/* create push button gadget using simple_menu_item() */
/* add in callback function for the menu choice */
{
  Widget        widget;

  widget = simple_menu_item(menu_widget,name,mnemonic,NeedsSeparator);
  XtAddCallback(widget, XmNactivateCallback,callback,NULL);
/*  printf("callback add!\n"); */
  return(widget);
}

/* ---------------- end of "myMenu.c" -------------------------------- */
