/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/MainW.h>
#include <Xm/DrawingA.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/Separator.h>
#include <Xm/RowColumn.h>
#include <Xm/PushBG.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/FileSB.h>
#include <sys/types.h>
#include <stdio.h>
#include   <string.h>
#include   <ctype.h>
#include  "stem.h"

extern Widget simple_menu();
extern Widget simple_menu_call();
extern void   exposeHandle();
extern void   dispSeqs(); 
extern void   createColormap();
extern void   createCircle();
extern void   call_dispCircle();
extern void   dispSelectedPair();
extern void   select_dispSelectedPair();
extern void   selectSeqs();
extern int    checkSelectedSeqs();
extern void   show_select_seqs();

extern int    select_columns[MAXPAIRS][2];

extern Widget circle_pop;
extern XColor Colors[COLORS];
extern GC     gc_for_Num;
extern GC     gc_da;
extern  int   dispPairs;
extern int height,width;

Pixmap  pixmap_da;
XmFontList fontlist;
Widget qd,fd, da,errorMB, select_errorMB;
static char   *file;
int  selectMode; /* flag select mode or not */


void generic_callback(widget,client_data,call_data)
     Widget       widget;
     caddr_t      client_data,call_data;
{
  /* does nothing */
  printf("generic call back\n");
}

/* callback for "select_ok" button */
void select_okB(w,client_data,call_data)
     Widget   w;
     caddr_t  client_data,call_data;
{
  NoOfSelectedSeqs = checkSelectedSeqs(selectedSeqs);
  if(NoOfSelectedSeqs == 0) /* warn if no sequences selected */
    XtManageChild(select_errorMB);
  else
    show_select_seqs(circle_pop,client_data,call_data);
}

/* callback for "select_cancel" button */
void select_cancelB(w,client_data,call_data)
     Widget   w;
     caddr_t  client_data,call_data;
{
  int x,y ,x_start,y_start,i;
  x_start = XSTART;
  y_start = YSTART;

  /* clear emphasis of selected sequences */
  x = x_start;
  for(i=0 ; i != NoOfSeqs ; i++)
    {
      if(selectedSeqs[i] == 0)
	;
      else
	{
	  selectedSeqs[i] = 0;
	  y = y_start + i*height;
	  XSetBackground(XtDisplay(da),gc_for_Num,MyColor(XtDisplay(da),"black"));
	  XDrawImageString(XtDisplay(da),pixmap_da,gc_for_Num,x,y,
			   sequences[i].seqName,sequences[i].nameLength);
	}
    }
  NoOfSelectedSeqs = 0;
  XCopyArea(XtDisplay(da),pixmap_da,XtWindow(da),gc_da,0,0,1000,1000,0,0); 
  XCopyArea(XtDisplay(da),pixmap_da,XtWindow(da),gc_for_Num,0,0,1000,1000,0,0);

}

/* callback for "Veiw mode" button */
void viewModeFunc(w,client_data,cdata)
     Widget   w;     
     caddr_t client_data,cdata;
{
  int x,y ,x_start,y_start,i;
  x_start = XSTART;
  y_start = YSTART;

  if(selectMode) /* if in select mode */
    {            /* remove event handler of selection */
      XtRemoveEventHandler(da, ButtonPressMask | Button1MotionMask,
			   False,selectSeqs,NULL);
      selectMode = FALSE;
      /* cancel emphasis of selected sequences */
      x = x_start;
      NoOfSelectedSeqs = 0;
      for(i=0 ; i != NoOfSeqs ; i++)
	{
	  if(selectedSeqs[i] == 0)
	    ;
	  else
	    { /* selected sequence */
	      selectedSeqs[i] = 0;
	      y = y_start + i*height;
	      XSetBackground(XtDisplay(da),gc_for_Num,MyColor(XtDisplay(da),"black"));
	      XDrawImageString(XtDisplay(da),pixmap_da,gc_for_Num,x,y,
			       sequences[i].seqName,sequences[i].nameLength);
	    }
	}
      XCopyArea(XtDisplay(da),pixmap_da,XtWindow(da),gc_da,0,0,1000,1000,0,0); 
      XCopyArea(XtDisplay(da),pixmap_da,XtWindow(da),gc_for_Num,0,0,1000,1000,0,0);
    }
}

void selectModeFunc(w,client_data,cdata)
     Widget   w;     
     caddr_t client_data,cdata;
{
  if(!selectMode) /* if not in select mode */
    {             /* add event handler for sequence selection */
      XtAddEventHandler(da, ButtonPressMask | Button1MotionMask,
			   False,selectSeqs,NULL);
      selectMode = TRUE;
    }
}

/* called when "ok" button in  FileSelectionBox pushed */
void okFB(w,client_data,cdata)
     Widget   w;     
     caddr_t client_data;
     XmFileSelectionBoxCallbackStruct *cdata;
{
  int dataRead;
  int x,y ,x_start,y_start,i;
  x_start = XSTART;
  y_start = YSTART;
  XmStringGetLtoR(cdata->value,XmSTRING_DEFAULT_CHARSET,&file);
/*  printf("selected file is %s\n",file); */
  strcpy(datafile,file);
/*  printf("data file is %s\n",datafile); */
  table_made = FALSE;
  file_flag = TRUE;

  fpr=fopen(datafile,"r");/*  open new data file*/
  if((dataRead=read_datafile(fpr))==TRUE)
    { /* read new data file */
      NoOfSelectedSeqs=checkSelectedSeqs(selectedSeqs);
/*      printf("NoOfselectedSeqs=%d\n",NoOfSelectedSeqs); */
      if(selectMode)
	{ /* set to view mode */
/*	  printf("selectMode=%d\n",selectMode); */
	  selectMode = FALSE;
	  XtRemoveEventHandler(da, ButtonPressMask | Button1MotionMask,
			       False,selectSeqs,NULL);
	}
      if(NoOfSelectedSeqs)
	{ /* if sequences are selected,cancel them */
	  x = x_start;
	  for(i=0 ; i != NoOfSeqs ; i++)
	    {
	      if(selectedSeqs[i] == 0)
		;
	      else
		{
		  selectedSeqs[i] = 0;
		  y = y_start + i*height;
		}
	    }
	  NoOfSelectedSeqs = 0;
	}

      check_consensus(ORIGINAL);  /* check consensus columns */
      make_consensus_for_hyoji(ORIGINAL);  /* make consensus table without gap column */
      calc_zahyou_data(ORIGINAL); /* calculate radius,etc. */
      make_matrix_all(ORIGINAL);      /* make pair matrix */
      makePairList();                 /* make pair list   */
      makePairListForHyouji(ORIGINAL); /* make pair list table without gap columns */
/*      printf("dataRead = %d\n",dataRead); */
      XtFree(file);
      dispSeqs(da);
      XCopyArea(XtDisplay(da),pixmap_da,XtWindow(da),gc_da,0,0,1000,1000,0,0);
      XCopyArea(XtDisplay(da),pixmap_da,XtWindow(da),gc_for_Num,0,0,1000,1000,0,0);
      XtUnmanageChild(fd);
      fileChanged = TRUE;
    }
  else
    { /* illegal data file */
      XtManageChild(errorMB);
    }

}

/* called when "cancel" button in fileSelectionBox pushed */
void quitFB(w,fb,call_data)
     Widget   w,fb;
     caddr_t call_data;
{
  XtUnmanageChild(fd);
}

/* callback for "Open" button in menu bar*/
void buttonFB(w,client_data,call_data)
     Widget   w;
     caddr_t  client_data,call_data;
{
  XtManageChild(fd);
}

/* called buttons of dialog box of "quit" pushed */
void messageQB(w,client_data,msg_data)
     Widget w;
     caddr_t client_data;
     XmAnyCallbackStruct *msg_data;
{
  switch(msg_data->reason)
    { 
    case XmCR_OK:          exit(1);
      /*    case XmCR_CANCEL:      printf("Pushed cancel button\n"); */
    }
}

/* callback for "quit" button */
void buttonQB(w,client_data,call_data)
     Widget   w;
     caddr_t  client_data,call_data;
{
  XtManageChild(qd);
}


main(argc,argv)
int   argc;
char  *argv[];
{
  Widget parent,main_window,menu_bar,file_menu,pair_menu,select_menu,pair_b,pbq1,pbf1,
         errorbcan,errorbhlp ,select_errorbcan,select_errorbhlp;
  Arg    args[10];
  int    n ,fileRead;
  Display  *d;
  XmString    x_charsetTitle,x_charsetQuitmsg ,x_charsetOk,x_charsetNo,
              x_charsetFiltermsg,x_charsetErrormsg,
              x_charsetSelectErrormsg ;
  XFontStruct  *font;

  /* initialize many values */

/*  putenv(XENV); */ /* set XENVIROMENT  */

  Percent = PERCENT_D;  /* default consensus percent */
  pre_percent = Percent;
  Renzoku = RENZOKU;  /* default value of consecutive pairs */
  seqRead = FALSE;
/*
  pairListCreated = 0; 
*/
  file_flag = TRUE;
  toggle_flag = TRUE;
  NoOfHyoujiColumn = 0;    /* number of columns which is not gap column */ 
  resized = 0;
  daCreated = NULL; 
  GCcreated = NULL;
  hanrei_start_x = HANREI_START_X;  /* position of explanatory notes */
  hanrei_start_y = HANREI_START_Y;
  default_hankei = HANKEIL;         /* default radius size */
  dispPairs = FALSE;
  selectMode = FALSE;

  /* initialize intrinsics and create toplevelshellwidget */
  
  parent = XtInitialize(argv[0],"Ste",NULL,0,&argc,argv); 

  /* decide font */
  font= XLoadQueryFont(XtDisplay(parent),"r16");
  if(!font) 
    font = XLoadQueryFont(XtDisplay(parent),"a16");
  if(!font)
    font = XLoadQueryFont(XtDisplay(parent),"r14");
  if(!font)	
    font = XLoadQueryFont(XtDisplay(parent),"a14");
  if(!font)
    font = XLoadQueryFont(XtDisplay(parent),"k14");
  if(!font)
    font = XLoadQueryFont(XtDisplay(parent),"9x13");
  if(!font)
    font = XLoadQueryFont(XtDisplay(parent),"variable");
  if(!font)
    font = XLoadQueryFont(XtDisplay(parent),"fixed");
  if(!font)
    font = XLoadQueryFont(XtDisplay(parent),"6x13");
  if(!font)
    {
      fprintf(stderr,"Can't find font for Stem finder\n");
      exit(1);
    }
  fontlist = XmFontListCreate(font,XmSTRING_DEFAULT_CHARSET);

  n = 0;
  XtSetArg(args[n], XmNallowShellResize,True);
  n++;
  XtSetArg(args[n], XmNtitle,"Stem finder");
  n++; 
  XtSetArg(args[n],XmNdefaultFontList,fontlist); 
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(parent),"wheat"));
  n++;
  XtSetValues(parent,args,n);

  /* create main window */

  n=0;
  XtSetArg(args[n],XmNshadowThickness,4);
  n++;
  XtSetArg(args[n],XmNshowSeparator,True);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(parent),"wheat"));
  n++;
  XtSetArg(args[n],XmNwidth,800);
  n++;
  XtSetArg(args[n],XmNheight,800);
  n++;
  XtSetArg(args[n],XmNscrollingPolicy,XmAUTOMATIC);
  n++;
  main_window = XmCreateMainWindow(parent,"mainW",args,n);
  XtManageChild(main_window);

  /* create menu bar */
 
  n = 0;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(parent),"wheat"));
  n++;
  XtSetArg(args[n],XmNdefaultFontList,fontlist); 
  n++;
  menu_bar = XmCreateMenuBar(main_window,"menu_bar", args, n);
  XtManageChild(menu_bar);

  /* create file menu (Open,Quit) */
  file_menu = simple_menu(menu_bar, "File",'F');

  simple_menu_call(file_menu, "Open",'O',False,buttonFB);

  simple_menu_call(file_menu, "Quit",'Q',True,buttonQB);

  /* create Pair menu */
  pair_menu = simple_menu(menu_bar, "Pair",'P');

  simple_menu_call(pair_menu, "Show Pairs",'H',False,call_dispCircle); 
    /* callback for display circles */

  /* create Select menu */
  select_menu = simple_menu(menu_bar, "Select",'S');

  simple_menu_call(select_menu, "View Mode",'V',False,viewModeFunc);
  /* callback for Select mode */
  simple_menu_call(select_menu, "Select Mode",'L',False,selectModeFunc);
  /* add callbacks for select_ok and select_cancel*/
  simple_menu_call(select_menu, "Select_Ok",'O',True,select_okB); 
  simple_menu_call(select_menu, "Select_Cancel",'C',False,select_cancelB); 

  

/* create question dialog */
  n=0;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(parent),"yellow"));
  n++;
  XtSetArg(args[n],XmNforeground,MyColor(XtDisplay(parent),"red"));
  n++;
  XtSetArg(args[n],XmNlabelFontList,fontlist); 
  n++;
  XtSetArg(args[n],XmNbuttonFontList,fontlist); 
  n++;
  x_charsetQuitmsg = XmStringCreateLtoR("Really Quit?",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNmessageString,x_charsetQuitmsg);
  n++;
  x_charsetOk = XmStringCreateLtoR("Yes",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNokLabelString,x_charsetOk);
  n++;
  x_charsetNo = XmStringCreateLtoR("No",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNcancelLabelString,x_charsetNo);
  qd = XmCreateQuestionDialog(menu_bar,"qd",args,n);
  XmStringFree(x_charsetQuitmsg); 
  XmStringFree(x_charsetOk);
  XmStringFree(x_charsetNo);
  XtAddCallback(qd,XmNcancelCallback,messageQB,NULL);
  XtAddCallback(qd,XmNokCallback,messageQB,NULL);


/* erase "help" button in question dialog */
  pbq1 = XmMessageBoxGetChild(qd,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(pbq1);

/* create fileSelectionBox and add callbacks */
  n=0;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(menu_bar),"wheat"));
  n++;
  x_charsetFiltermsg = XmStringCreateLtoR("*.aed",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNdirMask,x_charsetFiltermsg);
  n++;
  XtSetArg(args[n],XmNfileTypeMask,XmFILE_ANY_TYPE);
  n++;
  XtSetArg(args[n],XmNlabelFontList,fontlist); 
  n++;
  XtSetArg(args[n],XmNbuttonFontList,fontlist); 
  n++;
  fd = XmCreateFileSelectionDialog(menu_bar,"fd",args,n);
  XmStringFree(x_charsetFiltermsg);
  XtAddCallback(fd,XmNcancelCallback,quitFB,NULL); 
  XtAddCallback(fd,XmNokCallback,okFB,NULL);

/* erase "help" button in fileSelectionBox */
  pbf1 = XmFileSelectionBoxGetChild(fd,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(pbf1); 


/* create error dialogs */
/* for illegal data files */
  n=0;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(parent),"yellow"));
  n++;
  XtSetArg(args[n],XmNforeground,MyColor(XtDisplay(parent),"red"));
  n++;
  x_charsetErrormsg = XmStringCreateLtoR("Data file is illegal!",
					 XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNmessageString,x_charsetErrormsg);
  n++;
  XtSetArg(args[n],XmNlabelFontList,fontlist); 
  n++;
  XtSetArg(args[n],XmNbuttonFontList,fontlist); 
  n++;
  errorMB = XmCreateErrorDialog(menu_bar,"errorMB",args,n);
/* erase "help"button and "cancel" button */
  errorbcan = XmMessageBoxGetChild(errorMB,XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(errorbcan); 
  errorbhlp = XmMessageBoxGetChild(errorMB,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(errorbhlp); 
  XmStringFree(x_charsetErrormsg); 

/* for select mode */
  n=0;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(parent),"yellow"));
  n++;
  XtSetArg(args[n],XmNforeground,MyColor(XtDisplay(parent),"red"));
  n++;
  x_charsetSelectErrormsg = XmStringCreateLtoR("no selected sequences",
					 XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNmessageString,x_charsetSelectErrormsg);
  n++;
  XtSetArg(args[n],XmNlabelFontList,fontlist); 
  n++;
  XtSetArg(args[n],XmNbuttonFontList,fontlist); 
  n++;
  select_errorMB = XmCreateErrorDialog(menu_bar,"select_errorMB",args,n);
  XmStringFree(x_charsetSelectErrormsg); 
/* erase "help"button and "cancel" button */
  select_errorbcan = XmMessageBoxGetChild(select_errorMB,XmDIALOG_CANCEL_BUTTON);
  XtUnmanageChild(select_errorbcan); 
  select_errorbhlp = XmMessageBoxGetChild(select_errorMB,XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(select_errorbhlp); 

/* create drawing area */
  n=0;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(parent),"black"));
  n++;
  XtSetArg(args[n],XmNwidth,1000);
  n++;
  XtSetArg(args[n],XmNheight,1000);
  n++;
  da = XmCreateDrawingArea(main_window,"da",args,n);
  XtManageChild(da);

  XmMainWindowSetAreas(main_window,
		       menu_bar,
		       (Widget)NULL, /* command area */
		       (Widget)NULL, /* horizontal scroll */
		       (Widget)NULL, /* vertical scroll */
		       da);
		       
		       
  XtRealizeWidget(parent);

/* create pixmap */
  d = XtDisplay(da);
  pixmap_da = XCreatePixmap(d,XtWindow(da),1000,1000,
			    DefaultDepth(d,DefaultScreen(d)) );

/* create color map */
  createColormap(da);

/* add callback to drawing area */
  XtAddCallback(da,XmNexposeCallback,exposeHandle,NULL); 

  if(argc == 1) 
    { /* no arguments  */
      file_flag = FALSE;
  }
  
  if(argc == 2)
    {
    if((fpr=fopen(argv[1],"r"))==NULL)
      { /* false file name */
	printf("can't open input file %s \n",argv[1]);
	file_flag = FALSE;
    }
    else
      {
	strcpy(datafile,argv[1]);
	printf("datafile = %s\n",datafile);
	file_flag = TRUE;
      }
  }


  if(file_flag)
    { /* datafile name is given */
      if((fileRead=read_datafile(fpr)) == FALSE)
	{ /* data file is illegal */
	  /* show warning dialog and set to no file mode */
	  XtManageChild(errorMB);
	  file_flag = FALSE;
	}
      else
	{  
/*	  printf("file read.\n");  */
	  check_consensus(ORIGINAL); /* check consensus */
	  make_consensus_for_hyoji(ORIGINAL);  /* make consensus table without gap column */
	  calc_zahyou_data(ORIGINAL); /* calculate radius,etc. */
	  make_matrix_all(ORIGINAL);  /* make pair matrix */
	  makePairList();     /* make pair lists */
	  makePairListForHyouji(ORIGINAL);  /* make pair list table without gap columns */
	}
    }

  dispSeqs(da);

/* create popup shell widget for circle representation */

  createCircle(main_window);

  XtMainLoop();
}


/* -------------------- end of "main.c" ------------------------------------- */
