/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*-----------------------------------------------------------------*/
/*     dispCircleSelect.c                                          */
/*        make widgets and callback functions for                  */
/*                circular representation (for selected sequences) */
/*-----------------------------------------------------------------*/


#include <X11/Intrinsic.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <X11/Shell.h>
#include <Xm/Form.h>
#include <Xm/DrawingA.h>
#include <Xm/PushB.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/MessageB.h>
#include <Xm/Frame.h>
#include <Xm/Scale.h>
#include <sys/types.h>
#include <stdio.h>
#include   <string.h>
#include   <ctype.h>
#include  "stem.h"

extern void scale_callback_percent();
extern void scale_callback_renzoku();
extern void createListS();
extern void dispCircleS(); /* draw circle (select mode) */
extern void selectUndispSelect();
extern unsigned long MyColor();

extern XmFontList fontlist;

Widget  select_pop,select_form, select_da,
        select_frame,select_scale_p,select_scale_r; 
extern Widget select_list_pair;

/* called when "close" button pushed */
void select_close(w,client_data,call_data)
     Widget       w;
     caddr_t      client_data;
     XmAnyCallbackStruct *call_data;
{
  if(select_list_pair)
    selectUndispSelect(w,client_data,call_data);  /* pairListSelect.c */
  XtPopdown(select_pop);
}



void createCircleS(parent)
     Widget     parent;
{
  Widget pb_select_close;
  Arg    args[20];
  int    n ;
  XmString x_charsetCloseS,x_charsetPercentS,x_charsetConsecutiveS;
  
  /* create popup shell */
  
  select_pop = XtCreatePopupShell("select_pop",topLevelShellWidgetClass,parent,NULL,0);
  n = 0;
  XtSetArg(args[n],XmNwidth,500);
  n++;
  XtSetArg(args[n],XmNheight,500);
  n++; 
  XtSetArg(args[n],XmNdefaultFontList,fontlist); 
  n++;
  XtSetValues(select_pop,args,n);
  
  /* create form  */
  n = 0;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(select_pop),"wheat"));
  n++;
  XtSetArg(args[n],XmNwidth,500);
  n++;
  XtSetArg(args[n],XmNheight,500);
  n++;
  select_form = XtCreateManagedWidget("select_form",xmFormWidgetClass,select_pop,args,n);
  
  /* create push button "close" and add callback function */
  n = 0;
  XtSetArg(args[n],XmNwidth,70);
  n++;
  XtSetArg(args[n],XmNheight,30);
  n++; 
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(select_pop),"wheat"));
  n++;
  x_charsetCloseS = XmStringCreateLtoR("Close",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNlabelString,x_charsetCloseS);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNtopOffset,20);
  n++;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNleftOffset,3);
  n++;
  pb_select_close = XmCreatePushButton(select_form,"pb_select_close",args,n);
  XtManageChild(pb_select_close);
  XtAddCallback(pb_select_close,XmNactivateCallback,select_close,NULL);
  XmStringFree(x_charsetCloseS); 

  /* create "percent" scale and add callback function */
  n=0;
  XtSetArg(args[n],XmNvalue,Percent); /* set parent's Percent value */
  n++;
  XtSetArg(args[n],XmNleftWidget,pb_select_close);
  n++;
  XtSetArg(args[n],XmNwidth,120);
  n++;
  XtSetArg(args[n],XmNmaximum,100);
  n++;
  XtSetArg(args[n],XmNminimum,10);
  n++;
  XtSetArg(args[n],XmNshowValue,True);
  n++;
  XtSetArg(args[n],XmNprocessingDirection,XmMAX_ON_RIGHT);
  n++;
  XtSetArg(args[n],XmNorientation,XmHORIZONTAL);
  n++;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);
  n++;
  XtSetArg(args[n],XmNleftOffset,3);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNtopOffset,3);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(select_pop),"wheat"));
  n++;
  x_charsetPercentS = XmStringCreateLtoR("percent",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNtitleString,x_charsetPercentS);
  n++;
  select_scale_p = XmCreateScale(select_form,"select_scale_p",args,n);
  XtManageChild(select_scale_p);
  XtAddCallback(select_scale_p,XmNvalueChangedCallback,scale_callback_percent,SELECT);
  XmStringFree(x_charsetPercentS); 
  
  /* create "consecutive" scale and add callback function */
  n=0;
  XtSetArg(args[n],XmNvalue,Renzoku); /* set parent's consecutive value */
  n++;
  XtSetArg(args[n],XmNleftWidget,select_scale_p);
  n++;
  XtSetArg(args[n],XmNwidth,100);
  n++;
  XtSetArg(args[n],XmNmaximum,10);
  n++;
  XtSetArg(args[n],XmNminimum,1);
  n++;
  XtSetArg(args[n],XmNshowValue,True);
  n++;
  XtSetArg(args[n],XmNprocessingDirection,XmMAX_ON_RIGHT);
  n++;
  XtSetArg(args[n],XmNorientation,XmHORIZONTAL);
  n++;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_WIDGET);
  n++;
  XtSetArg(args[n],XmNleftOffset,3);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNtopOffset,3);
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(select_pop),"wheat"));
  n++;
  x_charsetConsecutiveS = XmStringCreateLtoR("consecutive",XmSTRING_DEFAULT_CHARSET);
  XtSetArg(args[n],XmNtitleString,x_charsetConsecutiveS);
  n++;
  select_scale_r = XmCreateScale(select_form,"select_scale_r",args,n);
  XtManageChild(select_scale_r);
  XmStringFree(x_charsetConsecutiveS);
  XtAddCallback(select_scale_r,XmNvalueChangedCallback,scale_callback_renzoku,SELECT);

  /* create list */
  createListS(select_form);
  
  /* create drawingArea */
  /* create frame */
  n=0;
  XtSetArg(args[n],XmNshadowThickness,4);
  n++;
  XtSetArg(args[n],XmNshadowType,XmSHADOW_ETCHED_OUT);
  n++;
/*  XtSetArg(args[n],XmNwidth,600);
  n++;
  XtSetArg(args[n],XmNheight,600);
  n++; */
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNrightOffset,100);
  n++;
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNtopOffset,70);
  n++;
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM);
  n++;
  select_frame = XmCreateFrame(select_form,"select_frame",args,n);
  XtManageChild(select_frame); 

  n=0;
/*  XtSetArg(args[n],XmNwidth,610);
  n++;
  XtSetArg(args[n],XmNheight,600); */
  n++;
  XtSetArg(args[n],XmNbackground,MyColor(XtDisplay(select_pop),"white"));
  n++;
  XtSetArg(args[n],XmNleftAttachment,XmATTACH_FORM);
  n++;
  XtSetArg(args[n],XmNrightAttachment,XmATTACH_FORM);
  n++;
/*  XtSetArg(args[n],XmNrightOffset,100);
  n++; */
  XtSetArg(args[n],XmNtopAttachment,XmATTACH_FORM);
  n++;
/*  XtSetArg(args[n],XmNtopOffset,80);
  n++; */
  XtSetArg(args[n],XmNbottomAttachment,XmATTACH_FORM);
  n++;
  select_da = XmCreateDrawingArea(select_frame,"select_da",args,n);
  XtManageChild(select_da);

  XtRealizeWidget(select_pop);

  XtAddCallback(select_da,XmNexposeCallback,dispCircleS,NULL); 

}

/*-------------- end of "dispCircleSelect.c" ------------------------------*/
