/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "aedit.h"
#include "align.h"

#define CONSNUM 100

tree_base_ria_i1()
{
  struct DATA0 d0;
  struct ALIGN ps;
  int i,j,k,leng;

  readSeq_tria(&ps,&d0);

  display_alignment_monitor(1,ps.SeqNum);
  d0.Cut = ps.CutT;
  for(j=0;j<ps.SeqNum;j++){
    for(i=j+1;i<ps.SeqNum;i++){

      d0.X = ps.Leng[i];
      d0.Y = ps.Leng[j];
      d0.NumX = 1;
      d0.NumY = 1;

      for(k=0;k<ps.Leng[i];k++){
	d0.CSeq1[0][k] = ps.CSeq[i][k];
	d0.Seq1[0][k] = ps.Seq[i][k];
      }
      for(k=0;k<ps.Leng[j];k++){
	d0.CSeq2[0][k] = ps.CSeq[j][k];
	d0.Seq2[0][k] = ps.Seq[j][k];
      }

      generateD_00(&d0);

      if(d0.J % 2 == 0) ps.CMatrix[i][j] = d0.Vec0[d0.I].xy;
      if(d0.J % 2 == 1) ps.CMatrix[i][j] = d0.Vec1[d0.I].xy;

    }
  }

  display_alignment_monitor(0,1);
  for(i=0;i<ps.SeqNum-1;i++){
    d0.Cut = ps.CutT;
    minimumCost(&ps,&d0);
    d0.Cut = ps.CutR;
    leng = tria_i1(&ps,&d0);
    display_alignment_monitor(0,i+2);
  }
  writeSeq_align(&ps,&d0,leng);
}


int tria_i1(fs,d0)
struct ALIGN *fs;
struct DATA0 *d0;
{
  int i,j,k,m,mx,my,M;
  int energy,oldenergy,pos,lengx,lengy;

  for(i=0;i<fs-> Num[fs->R1];i++){
    m = fs->NumVec[fs->R1][i];
    for(j=0;j< fs->Leng[fs->R1];j++){
      fs->OSeq[m][j] = fs->Seq[m][j];
      fs->OCSeq[m][j] = fs->CSeq[m][j];
      fs->OCons[m][j] = fs->Cons[m][j];
    }
  }

  d0->NumX = 1;
  d0->NumY = fs->Num[fs->R1] - 1;

  d0->X = d0->Y = fs->Leng[fs->R1];

  oldenergy = makeEnergy(fs,d0,d0->X);

  for(M=0;M< fs->Num[fs->R1];M++){

    mx = fs->NumVec[fs->R1][M];
    k = 0;
    while(fs->OCSeq[mx][k] == '-'){
      fs->CSeq1_C[0][k] = '#';
      fs->Seq1_C[0][k] = fs->OSeq[mx][k];
      fs->Cons1_C[0][k] = fs->OCons[mx][k];
      k++;
    }
    while(k<d0->X){
      fs->CSeq1_C[0][k] = fs->OCSeq[mx][k];
      fs->Seq1_C[0][k] = fs->OSeq[mx][k];
      fs->Cons1_C[0][k] = fs->OCons[mx][k];
      k++;
    }
    k--;
    while(fs->OCSeq[mx][k] == '-'){
      fs->CSeq1_C[0][k] = '#';
      k--;
    }
      
    for(j=0;j<M;j++){
      my = fs->NumVec[fs->R1][j];
      k = 0;
      while(fs->OCSeq[my][k] == '-'){
	fs->CSeq2_C[j][k] = '#';
	fs->Seq2_C[j][k] = fs->OSeq[my][k];
	fs->Cons2_C[j][k] = fs->OCons[my][k];
	k++;
      }
      while(k<d0->Y){
	fs->CSeq2_C[j][k] = fs->OCSeq[my][k];
	fs->Seq2_C[j][k] = fs->OSeq[my][k];
	fs->Cons2_C[j][k] = fs->OCons[my][k];
	k++;
      }
      k--;
      while(fs->OCSeq[my][k] == '-'){
	fs->CSeq2_C[j][k] = '#';
	k--;
      }
    }
    for(j=M+1;j<fs->Num[fs->R1];j++){
      my = fs->NumVec[fs->R1][j];
      k = 0;
      while(fs->OCSeq[my][k] == '-'){
	fs->CSeq2_C[j-1][k] = '#';
	fs->Seq2_C[j-1][k] = fs->OSeq[my][k];
	fs->Cons2_C[j-1][k] = fs->OCons[my][k];
	k++;
      }
      while(k<d0->Y){
	fs->CSeq2_C[j-1][k] = fs->OCSeq[my][k];
	fs->Seq2_C[j-1][k] = fs->OSeq[my][k];
	fs->Cons2_C[j-1][k] = fs->OCons[my][k];
	k++;
      }
      k--;
      while(fs->OCSeq[my][k] == '-'){
	fs->CSeq2_C[j-1][k] = '#';
	k--;
      }
    }
    
    remove_allgap(fs,d0);
    
    lengx = d0->X;
    lengy = d0->Y;
    
    pos = constraint_tria(fs,d0,M,lengx,lengy); 
    d0->X = d0->Y = pos;
    
    mx = fs->NumVec[fs->R1][M];
    for(j=0;j<pos;j++){
      fs->OCSeq[mx][j] = fs->DCSeq[mx][j];
      fs->OSeq[mx][j] = fs->DSeq[mx][j];
      fs->OCons[mx][j] = fs->DCons[mx][j];
    }
    for(i=0;i<M;i++){
      my = fs->NumVec[fs->R1][i];
      for(j=0;j<pos;j++){
	fs->OCSeq[my][j] = fs->DCSeq[my][j];
	fs->OSeq[my][j] = fs->DSeq[my][j];
	fs->OCons[my][j] = fs->DCons[my][j];
      }
    }
    for(i=M+1;i< fs->Num[fs->R1];i++){
      my = fs->NumVec[fs->R1][i];
      for(j=0;j<pos;j++){
	fs->OCSeq[my][j] = fs->DCSeq[my][j];
	fs->OSeq[my][j] = fs->DSeq[my][j];
	fs->OCons[my][j] = fs->DCons[my][j];
      }
      
    }
    
  }
    
  energy = makeEnergy(fs,d0,d0->X);

  if(energy < oldenergy){
    oldenergy = energy;
    fs->Leng[fs->R1] = pos;
    for(i=0;i< fs->Num[fs->R1];i++){
      m = fs->NumVec[fs->R1][i];
      for(k=0;k< fs->Leng[fs->R1];k++){
	fs->CSeq[m][k] = fs->OCSeq[m][k];
	fs->Seq[m][k] = fs->OSeq[m][k];
	fs->Cons[m][k] = fs->OCons[m][k];
      }
    }
  }

  return fs->Leng[fs->R1];
}
