/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	options_menu.c 
		treat options items commands.
----------------------------------------------------------------------*/

#include <stdio.h>
#include <unistd.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <Xm/Text.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/SeparatoG.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/RowColumn.h>
#include <Xm/BulletinB.h>
#include <Xm/Scale.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/CascadeBG.h>
#include <Xm/CascadeB.h>

#include "menu.h"
#include "aedit.h"

/*--------------------------------------------------------------------*/

/* append (begin) */

#if	0
#define	DEBUG
#endif

/* append (eof) */

/*--------------------------------------------------------------------*/

void editEH(), cancelCB(), toggle3();

static int method;
extern Widget  menu_top;
extern int send_left, New_calc_leng;
int UU_s, VV_s, WW_s = 0, PP_s = 0, QQ_s = 0, SS_s;
int Cut_s = 80;

/*--------------------------------------------------------------------*/

extern MENUITEM	color_menu[];

extern void	english_cb();

/*--------------------------------------------------------------------*/

static int	costparam_uu_old;
static int	costparam_vv_old;
static int	costparam_ww_old;
static int	costparam_pp_old;
static int	costparam_qq_old;
static int	costparam_ss_old;

/*--------------------------------------------------------------------*/

/* append (begin) */

static int	alarm_clock_interval;	/* second */

/* append (end) */

/*--------------------------------------------------------------------*/

static void scaleCB(w,client_data,call_data)
Widget   w;
caddr_t  client_data;
XmScaleCallbackStruct  *call_data;
{
  IdenticalRatio = call_data->value;

  if (Result_draw){
      display_ident(send_left, New_calc_leng);
  }else{
      display_ident(Info.dispStartIndex,PerLine);
  }
}


static void ident_column(w,client_data,cbs)
Widget   w;
int     client_data;  /* not used */
XmAnyCallbackStruct *cbs;
{
  int i,x,y,dummy;
  static Widget dialog=NULL;
  static Widget scale, rc, ok;
  Arg    args[10];
  XButtonEvent *ev;
  XmString  xms;

  ev = (XButtonEvent *)cbs->event;
  if(!dialog) {
     XtSetArg(args[0],XmNallowShellResize,True);
     dialog = XtCreatePopupShell("ident_dialog",overrideShellWidgetClass,
                                 menu_top,args,1);

     rc=XmCreateRowColumn(dialog,"ident_rc",NULL,0);  XtManageChild(rc);

     /* scale */
     xms = XmStringCreateLtoR("Ident Column Ratio",
                              XmSTRING_DEFAULT_CHARSET);
     XtSetArg(args[0], XmNtitleString, xms);
     XtSetArg(args[1], XmNmaximum,   100);
     XtSetArg(args[2], XmNshowValue, True);
     scale = XtCreateManagedWidget("ident_scale",xmScaleWidgetClass, rc,
                                    args,3);
     XtAddCallback(scale,XmNdragCallback,scaleCB,NULL);
     XtAddCallback(scale,XmNvalueChangedCallback,scaleCB,NULL);
     XmStringFree(xms);
     ok=XmCreatePushButton(rc,"          OK",NULL,0); XtManageChild(ok);
     XtAddCallback(ok,XmNactivateCallback,cancelCB,dialog);
  }
  XtVaSetValues(scale, XmNvalue,IdenticalRatio, NULL);
  XtVaSetValues(dialog,XmNx,ev->x_root,XmNy,ev->y_root,NULL);
  XtPopup(dialog,XtGrabNone); 
}



static void param_scaleCB(w,param,call_data)
Widget   w;
int      param;
XmScaleCallbackStruct  *call_data;
{
  if(param==0)              UU = call_data->value;
  else if(param==1)     VV = call_data->value;
  else if(param==2)     WW = call_data->value;
  else if(param==3)     PP = call_data->value;
  else if(param==4)     QQ = call_data->value;
  else if(param==5)     SS = call_data->value;

  fprintf(stderr, "UU,VV,WW=%d,%d,%d\n",UU,VV,WW);
  UUVV = UU+VV;
  disp_cost(True);
}


static void
costparam_cancel_cb(widget, clientdata, calldata)
Widget	widget;
Widget	clientdata;
caddr_t	calldata;
{
  UU = costparam_uu_old;
  VV = costparam_vv_old;
  WW = costparam_ww_old;
  PP = costparam_pp_old;
  QQ = costparam_qq_old;
  SS = costparam_ss_old;

  fprintf(stderr, "UU,VV,WW=%d,%d,%d\n",UU,VV,WW);
  UUVV = UU+VV;
  disp_cost(True);

  XtPopdown(clientdata);
}


static void dp_param(w,client_data,cbs)
Widget   w;
int     client_data;  /* not used */
XmAnyCallbackStruct *cbs;
{
  int i;
  static Widget dialog=NULL;
  static Widget scale[6], rc, rc1,rc2,ok,cancel;
  Arg    args[10];
  XButtonEvent *ev;
  XmString  xms;
  static char *label[] = { "UU", "VV", "WW", "PP", "QQ", "SS"};
  void	costparam_cancel_cb();

  ev = (XButtonEvent *)cbs->event;
  if(!dialog) {
     UU_s = UU; VV_s = VV; SS_s = SS;
     XtSetArg(args[0],XmNallowShellResize,True);
     dialog = XtCreatePopupShell("param_dialog",overrideShellWidgetClass,
                                 menu_top,args,1);

     rc =XmCreateRowColumn(dialog,"param_rc",NULL,0);  XtManageChild(rc);
     rc1=XmCreateRowColumn(rc,"param_rc1",NULL,0);  XtManageChild(rc1);

     for(i=0; i<6; ++i)  {
        xms = XmStringCreateLtoR(label[i],
                                 XmSTRING_DEFAULT_CHARSET);
        XtSetArg(args[0], XmNtitleString, xms);
        XtSetArg(args[1], XmNmaximum,   50);
        XtSetArg(args[2], XmNminimum,  -10);
        XtSetArg(args[3], XmNshowValue, True);
        XtSetArg(args[4], XmNscaleMultiple, 1);
	XtSetArg(args[5], XmNorientation, XmHORIZONTAL);
        scale[i] = XtCreateManagedWidget("param_scale",xmScaleWidgetClass, rc1,
                                          args,6);
/*
        XtAddCallback(scale[i],XmNdragCallback,param_scaleCB,i);
*/
        XtAddCallback(scale[i],XmNvalueChangedCallback,param_scaleCB,i);
        XmStringFree(xms);
     }

     XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
     rc2=XmCreateRowColumn(rc,"param_rc2",args,1);  XtManageChild(rc2);
     ok=XmCreatePushButton(rc2,"   OK   ",NULL,0); XtManageChild(ok);
     XtAddCallback(ok,XmNactivateCallback,cancelCB,dialog);
     cancel=XmCreatePushButton(rc2," Cancel ",NULL,0); XtManageChild(cancel);
     XtAddCallback(cancel,XmNactivateCallback,costparam_cancel_cb,dialog);
  }

  costparam_uu_old = UU;
  costparam_vv_old = VV;
  costparam_ww_old = WW;
  costparam_pp_old = PP;
  costparam_qq_old = QQ;
  costparam_ss_old = SS;

  XtVaSetValues(scale[0], XmNvalue, UU, NULL);
  XtVaSetValues(scale[1], XmNvalue, VV, NULL);
  XtVaSetValues(scale[2], XmNvalue, WW, NULL);
  XtVaSetValues(scale[3], XmNvalue, PP, NULL);
  XtVaSetValues(scale[4], XmNvalue, QQ, NULL);
  XtVaSetValues(scale[5], XmNvalue, SS, NULL);

  XtVaSetValues(dialog,XmNx,ev->x_root,XmNy,ev->y_root,NULL);
  XtPopup(dialog,XtGrabNone); 
}


static void toggle1(w,flag,call_data)
Widget   w;
int      flag;  
caddr_t  call_data;
{
  int i;
  extern MENUITEM options_sub_menu1[];

  CalcColumnCost = flag;
  fprintf(stderr,"CalcColumnCost=%d\n",CalcColumnCost);

  if(CalcColumnCost) {
     XtVaSetValues(options_sub_menu1[1].w, XmNset, False, NULL);
     XtVaSetValues(options_sub_menu1[0].w, XmNset, True, NULL);
  }
  else {
     XtVaSetValues(options_sub_menu1[1].w, XmNset, True, NULL);
     XtVaSetValues(options_sub_menu1[0].w, XmNset, False, NULL);
  }     
}



static void toggle2(w,flag,call_data)
Widget   w;
int      flag;    /* True if upper case */
caddr_t  call_data;
{
  int i;
  extern MENUITEM options_sub_menu2[];
  
  if(flag==UPPER) {  /* Upper Case */
     for(i=0; i<26; ++i)  Char1[i] = i+'A';
     XtVaSetValues(options_sub_menu2[0].w, XmNset, True, NULL);
     XtVaSetValues(options_sub_menu2[1].w, XmNset, False, NULL);
  }
  else {
     for(i=0; i<26; ++i)  Char1[i] = i+'a';
     XtVaSetValues(options_sub_menu2[0].w, XmNset, False, NULL);
     XtVaSetValues(options_sub_menu2[1].w, XmNset, True, NULL);
  }     
  if(flag == AminoTextCase) return;

  disp(TRUE);   /* display alignment, column#,identical column */
 
 AminoTextCase = flag;
}


static void sort_scaleCB(w,param,call_data)
Widget   w;
int      param;
XmScaleCallbackStruct  *call_data;
{
  if(param==0)              UU_s = call_data->value;
  else if(param==1)     VV_s = call_data->value;
  else if(param==2)     SS_s = call_data->value;
  else if(param==3)     Cut_s = call_data->value;

}


void
setCB(w,client_data,cbs)
Widget    w;
int client_data;
XmAnyCallbackStruct *cbs;
{
    int i;
    static Widget dialog = NULL;
    static Widget scale[4], rc, rc1, rc2, ok, cancel;
    Arg args[10];
    XButtonEvent *ev;
    XmString xms;
    static char *label[] = { "UU ", "VV ", "SS ", "Cut" };
    extern MENUITEM options_sub_menu3[];


    method = client_data;
    XtVaSetValues(options_sub_menu3[method-1].w, XmNset, False, NULL);
    /*printf("sort method:%d\n", method);*/

    ev = (XButtonEvent *)cbs->event;
    if (!dialog){
        UU_s = UU, VV_s = VV, SS_s = SS;
        if (NA_flag){ UU_s = 30, VV_s = 5, SS_s = 50; }
        XtSetArg(args[0], XmNallowShellResize, True);
        dialog = XtCreatePopupShell("param_dialog", overrideShellWidgetClass,
                                    menu_top, args, 1);

        rc = XmCreateRowColumn(dialog, "param_rc", NULL, 0); XtManageChild(rc);
        rc1 = XmCreateRowColumn(rc, "param_rc1", NULL, 0); XtManageChild(rc1);

        for (i=0; i<4; i++){
            xms = XmStringCreateLtoR(label[i], XmSTRING_DEFAULT_CHARSET);
            XtSetArg(args[0], XmNtitleString, xms);
            XtSetArg(args[1], XmNmaximum, 11);
            XtSetArg(args[2], XmNminimum, -10);
            if (NA_flag){
                XtSetArg(args[1], XmNmaximum, 51);
                XtSetArg(args[2], XmNminimum, -10);
	    }
            if (i == 3){
                XtSetArg(args[1], XmNmaximum, 100);
                XtSetArg(args[2], XmNminimum, 0);
            }
            XtSetArg(args[3], XmNshowValue, True);
            scale[i] = XtCreateManagedWidget("sort_scale", xmScaleWidgetClass,
                                             rc1, args, 4);
            XtAddCallback(scale[i], XmNdragCallback, sort_scaleCB, i);
            XtAddCallback(scale[i], XmNvalueChangedCallback, sort_scaleCB, i);
            XmStringFree(xms);
        }

        rc2 = XmCreateRowColumn(rc, "param_rc2", NULL, 0); XtManageChild(rc2);
        ok = XmCreatePushButton(rc2, "   OK", NULL, 0); XtManageChild(ok);
        XtAddCallback(ok, XmNactivateCallback, toggle3, dialog);
        cancel = XmCreatePushButton(rc2, " Cancel", NULL, 0); XtManageChild(cancel);
        XtAddCallback(cancel, XmNactivateCallback, cancelCB, dialog);
    }

    XtVaSetValues(scale[0], XmNvalue, UU_s, NULL);
    XtVaSetValues(scale[1], XmNvalue, VV_s, NULL);
    XtVaSetValues(scale[2], XmNvalue, SS_s, NULL);
    XtVaSetValues(scale[3], XmNvalue, Cut_s, NULL);

    XtVaSetValues(dialog, XmNx, ev->x_root, XmNy, ev->y_root, NULL);
    XtPopup(dialog, XtGrabNone);
}

void toggle3(w,client_data,call_data)
Widget   w;
caddr_t  client_data, call_data;
{
  extern MENUITEM options_sub_menu3[];
  int i, sort_num[MAX_ALIGN], align;
  char temp_codeAlign[MAX_ALIGN][MAX_ALIGN_LENG];
  char temp_alignname[MAX_ALIGN][MAX_ALIGN_NAME_LENG+1];

  XtPopdown((Widget)client_data);
  
  if(method == 1) {  /* Sort Init */
     XtVaSetValues(options_sub_menu3[0].w, XmNset, True, NULL);
     XtVaSetValues(options_sub_menu3[1].w, XmNset, False, NULL);
     sorter_init(sort_num);
  }
  else {       /* Sort Now */
     XtVaSetValues(options_sub_menu3[0].w, XmNset, False, NULL);
     XtVaSetValues(options_sub_menu3[1].w, XmNset, True, NULL);
     sorter_now(sort_num);
  }     

  fprintf(stderr, "UU:%d  VV:%d  SS:%d\nUU_s:%d  VV_s:%d  SS_s :%d  Cut_s:%d\n",
         UU, VV, SS, UU_s, VV_s, SS_s, Cut_s);
  for(i=0; i<Info.alignnum; i++){fprintf(stderr, "%d:%d ", i, sort_num[i]);};fprintf(stderr, "\n");

  for (align=0; align<Info.alignnum; align++){
      for (i=Info.dataStartIndex; i<=Info.dataEndIndex; i++){
	  temp_codeAlign[align][i] = Info.codeAlign[align][i];
      }
      for (i=0; i<MAX_ALIGN_NAME_LENG+1; i++){
          temp_alignname[align][i] = Info.alignname[align][i];
      }
  }
  for (align=0; align<Info.alignnum; align++){
      for (i=Info.dataStartIndex; i<=Info.dataEndIndex; i++){
	  Info.codeAlign[align][i] = temp_codeAlign[sort_num[align]][i];
      }
      for (i=0; i<MAX_ALIGN_NAME_LENG+1; i++){
          Info.alignname[align][i] = temp_alignname[sort_num[align]][i];
      }
  }
  disp(True);
}


static void bar_chart_scaleCB(w,flag,call_data)
Widget   w;
int      flag;
XmScaleCallbackStruct  *call_data;
{
  if(flag==1)    BouMaxValue = call_data->value;
  else           BouMaxRatio = call_data->value;

  if (Result_draw){
      disp_cost_graph(send_left, New_calc_leng);
  }else{
      disp_cost_graph(Info.dispStartIndex,PerLine);
  }
/*  printf("BouMaxValue, BouMaxRatio=%d,%d\n",BouMaxValue,BouMaxRatio); */
}


static void bar_chart(w,client_data,cbs)
Widget   w;
int     client_data;  /* not used */
XmAnyCallbackStruct *cbs;
{
  int i;
  static Widget dialog=NULL;
  static Widget scale1, scale2, rc, rc1,rc2,ok;
  Arg    args[10];
  XButtonEvent *ev;
  XmString  xms;

  ev = (XButtonEvent *)cbs->event;
  if(!dialog) {
     XtSetArg(args[0],XmNallowShellResize,True);
     dialog = XtCreatePopupShell("bar_chart_dialog",overrideShellWidgetClass,
                                 menu_top,args,1);

     rc =XmCreateRowColumn(dialog,"bar_chart_rc",NULL,0);  XtManageChild(rc);

     XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
     rc1=XmCreateRowColumn(rc,"bar_chart_rc1",args,1);  XtManageChild(rc1);

     /* scale for MaxValue */
     xms = XmStringCreateLtoR("Max Value",
                                 XmSTRING_DEFAULT_CHARSET);
     XtSetArg(args[0], XmNtitleString, xms);
     XtSetArg(args[1], XmNmaximum,   10000);
     XtSetArg(args[2], XmNminimum,    100);
     XtSetArg(args[3], XmNshowValue, True);
     scale1 = XtCreateManagedWidget("bar_chart_scale",xmScaleWidgetClass, rc1,
                                     args,4);
     XtAddCallback(scale1,XmNdragCallback,bar_chart_scaleCB,1);
     XtAddCallback(scale1,XmNvalueChangedCallback,bar_chart_scaleCB,1);
     XmStringFree(xms);


     /* scale for Ratio */
     xms = XmStringCreateLtoR("Motif Ratio",
                                 XmSTRING_DEFAULT_CHARSET);
     XtSetArg(args[0], XmNtitleString, xms);
     XtSetArg(args[1], XmNmaximum,    100);
     XtSetArg(args[2], XmNminimum,      0);
     XtSetArg(args[3], XmNshowValue, True);
     scale2 = XtCreateManagedWidget("bar_chart_scale",xmScaleWidgetClass, rc1,
                                     args,4);
     XtAddCallback(scale2,XmNdragCallback,bar_chart_scaleCB,2);
     XtAddCallback(scale2,XmNvalueChangedCallback,bar_chart_scaleCB,2);
     XmStringFree(xms);

     rc2=XmCreateRowColumn(rc,"bar_chart_rc2",NULL,0);  XtManageChild(rc2);
     ok=XmCreatePushButton(rc2,"               OK",NULL,0);  XtManageChild(ok);
     XtAddCallback(ok,XmNactivateCallback,cancelCB,dialog);
  }

  XtVaSetValues(scale1, XmNvalue, BouMaxValue, NULL);
  XtVaSetValues(scale2, XmNvalue, BouMaxRatio, NULL);
  XtVaSetValues(dialog,XmNx,ev->x_root,XmNy,ev->y_root,NULL);
  XtPopup(dialog,XtGrabNone); 
}

/*--------------------------------------------------------------------*/

/* append (begin) */

/*ARGSUSED*/
static void	alarm_clock_scale_cb(wd, client_data, call_data)
Widget			wd;
int			client_data;
XmScaleCallbackStruct	*call_data;
{
/*
	alarm_clock_interval = call_data->value;
*/
	alarm_clock_interval = call_data->value * 60;

#if	0
	(void)printf("alarm_clock_scale_cb --- client_data = %d\n", client_data);
	(void)printf("alarm_clock_scale_cb --- call_data->value = %d\n",
		     call_data->value);
#endif
}

/*ARGSUSED*/
static void alarm_clock_ok_cb(wd, dialog, call_data)
Widget	wd, dialog;
caddr_t	*call_data;
{
	tmpaedfile_asd_interval = alarm_clock_interval;

#if	0
	(void)printf("alarm_clock_ok_cb --- tmpaedfile_asd_interval = %d\n",
		     tmpaedfile_asd_interval);
#endif

	(void)alarm(tmpaedfile_asd_interval);

	XtPopdown(dialog);
}

/*ARGSUSED*/
static void alarm_clock_cancel_cb(wd, dialog, call_data)
Widget	wd, dialog;
caddr_t	*call_data;
{
	XtPopdown(dialog);
}

/*AARGSUSED*/
static void	alarm_clock_cb(wd, client_data, cbs)
Widget			wd;
int			client_data;
XmAnyCallbackStruct	*cbs;
{
	static Widget	alarm_clock_dialog = NULL;
	static Widget	scale, rc, rc1, rc2, alarm_clock_ok, alarm_clock_cancel;
	Arg		args[10];
	XButtonEvent	*ev;
	XmString	xms;
	int		interval;

	ev = (XButtonEvent *)cbs->event;
	if (alarm_clock_dialog == NULL) {
		XtSetArg(args[0],XmNallowShellResize,True);
		alarm_clock_dialog = XtCreatePopupShell("alarm_clock_dialog",
/*
							overrideShellWidgetClass,
*/
							transientShellWidgetClass,
							menu_top, args, 1);

		rc = XmCreateRowColumn(alarm_clock_dialog, "alarm_clock_rc", NULL, 0);
		XtManageChild(rc);
		rc1 = XmCreateRowColumn(rc, "alarm_clock_rc1", NULL, 0);
		XtManageChild(rc1);
		xms = XmStringCreateLtoR("Alarm Clock (minute)", XmSTRING_DEFAULT_CHARSET);
		XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
		XtSetArg(args[1], XmNtitleString, xms);
		XtSetArg(args[2], XmNmaximum, 60);
		XtSetArg(args[3], XmNminimum, 0);
		XtSetArg(args[4], XmNshowValue, True);
		scale = XtCreateManagedWidget("alarm_clock_scale",
					      xmScaleWidgetClass, rc1, args,5);
		XtAddCallback(scale, XmNdragCallback,alarm_clock_scale_cb,NULL);
		XtAddCallback(scale, XmNvalueChangedCallback,alarm_clock_scale_cb,NULL);
		XmStringFree(xms);
		XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
		rc2 = XmCreateRowColumn(rc, "alarm_clock_rc2", args, 1);
		XtManageChild(rc2);
		alarm_clock_ok = XmCreatePushButton(rc2, "    OK    ", NULL, 0);
		XtManageChild(alarm_clock_ok);
		XtAddCallback(alarm_clock_ok, XmNactivateCallback,
			      alarm_clock_ok_cb, alarm_clock_dialog);
		alarm_clock_cancel = XmCreatePushButton(rc2, "  Cancel  ", NULL, 0);
		XtManageChild(alarm_clock_cancel);
		XtAddCallback(alarm_clock_cancel, XmNactivateCallback,
			      alarm_clock_cancel_cb, alarm_clock_dialog);
	}

	alarm_clock_interval = tmpaedfile_asd_interval;
/*
	interval = alarm_clock_interval;
*/
	interval = (int)((float)alarm_clock_interval / 60.0 + 0.5);
	XtVaSetValues(scale, XmNvalue, interval, NULL);
	XtVaSetValues(alarm_clock_dialog, XmNx, ev->x_root, XmNy, ev->y_root, NULL);
	XtPopup(alarm_clock_dialog, XtGrabNone); 
}

/* append (end) */

/*--------------------------------------------------------------------*/

MENUITEM  options_sub_menu1[] = {
   { "Calc. Each Time", &xmToggleButtonGadgetClass, 'E', NULL, NULL,
      toggle1, (caddr_t)True, NULL, 
      True, True, XmONE_OF_MANY},

   { "Calc. When Refresh", &xmToggleButtonGadgetClass, 'W', NULL, NULL,
      toggle1, (caddr_t)False, NULL, 
      True, False, XmONE_OF_MANY},

   {NULL},
};


MENUITEM  options_sub_menu2[] = {
   { "Upper Case", &xmToggleButtonGadgetClass, 'U', NULL, NULL,
      toggle2, (caddr_t)UPPER, NULL, 
      True, True,  XmONE_OF_MANY},

   { "Lower Case", &xmToggleButtonGadgetClass, 'L', NULL, NULL,
      toggle2, (caddr_t)LOWER, NULL, 
      True, False, XmONE_OF_MANY},

   {NULL},
};


MENUITEM  options_sub_menu3[] = {
   { "Sort Init", &xmToggleButtonGadgetClass, 'I', NULL, NULL,
      setCB, (caddr_t)1, NULL, 
      True, True,  XmONE_OF_MANY},

   { "Sort Now", &xmToggleButtonGadgetClass, 'N', NULL, NULL,
      setCB, (caddr_t)2, NULL, 
      True, False, XmONE_OF_MANY},

   {NULL},
};


MENUITEM options_menu[] = {
   { "Calc. Score Timing", &xmCascadeButtonWidgetClass, 'C', NULL, NULL,
      NULL, (caddr_t)NULL, options_sub_menu1, True},

   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},

   { "Amino Text Case", &xmCascadeButtonWidgetClass, 'A', NULL, NULL,
      NULL, (caddr_t)NULL, options_sub_menu2, True},

   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},

   { "Sorting", &xmCascadeButtonWidgetClass, 'S', NULL, NULL,
      NULL, (caddr_t)NULL, options_sub_menu3, True},

   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},

   { "Identical Column...", &xmPushButtonGadgetClass, 'I', NULL, NULL,
      ident_column, (caddr_t)NULL, NULL, True},

   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},

   { "Cost Parameters...", &xmPushButtonGadgetClass, 'P', NULL, NULL,
      dp_param, (caddr_t)NULL, NULL, True},

   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},

   { "Bar Chart...", &xmPushButtonGadgetClass, 'B', NULL, NULL,
      bar_chart, (caddr_t)NULL, NULL, True},

   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},

   { "Alarm Clock...", &xmPushButtonGadgetClass, 'A', NULL, NULL,
      alarm_clock_cb, (caddr_t)NULL, NULL, True},

   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},

   { "Font", &xmPushButtonGadgetClass, 'F', NULL, NULL,
      english_cb, (caddr_t)NULL, NULL, True},

   { "", &xmSeparatorGadgetClass, NULL, NULL, NULL,
      NULL, (caddr_t)NULL, NULL, True},

   { "Color", &xmCascadeButtonGadgetClass, 'F', NULL, NULL,
      NULL, (caddr_t)NULL, color_menu, True},

   {NULL}
};

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
