/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	main.c
----------------------------------------------------------------------*/

#include  <stdio.h>
#include  <math.h>
#include  <X11/Xlib.h>
#include  <X11/Xutil.h>
#include  <X11/cursorfont.h>
#include  <X11/Intrinsic.h>
#include  <X11/Xatom.h>
#include  <X11/StringDefs.h>
#include  <X11/Shell.h>
#include  <X11/keysym.h>
#include  <Xm/DrawingA.h>
#include  <Xm/MessageB.h>
#include  <Xm/PushB.h>
#include  <Xm/PushBG.h>
#include  <Xm/RowColumn.h>
#include  <Xm/Text.h>
#include  <Xm/CascadeBG.h>
#include  <Xm/ToggleBG.h>
#include  <Xm/ToggleB.h>
#include  <Xm/SeparatoG.h>
#include  <Xm/Scale.h>
#include  <Xm/ScrollBar.h>
#include  <Xm/ScrolledW.h>
#include  <Xm/SelectioB.h>
#include  <Xm/MainW.h>
#include  <varargs.h>
#include  <signal.h>
#include  <setjmp.h>
#include  <ctype.h>
#include  <unistd.h>
#include  "aedit.h"
#include  "menu.h"

#define EV_MASK  (ButtonPressMask  | \
                  ButtonReleaseMask  | \
                  PointerMotionMask  | \
                  KeyReleaseMask     | \
                  KeyPressMask     | \
                  ExposureMask     | \
                  EnterWindowMask     | \
                  LeaveWindowMask     | \
                  VisibilityChangeMask     | \
                  SubstructureNotifyMask     | \
                  ColormapChangeMask     | \
                  PropertyChangeMask     | \
                  ResizeRedirectMask     | \
                  SubstructureRedirectMask     | \
                  FocusChangeMask     | \
                  StructureNotifyMask)

void processEvent();
extern net_okCB();
extern net_cancelCB();

extern MENUITEM  file_menu[], edit_menu[], edit_mode_menu[], font_menu[],
                 logfile_menu[], options_menu[], color_menu[], network_menu[];

XtAppContext  app1, app2, app3;

Widget  menu_top, aedit_top, pd_edit, pdm_edmode, da, da2, w2, result;
Widget  sw, net_ok, net_cancel, pd_net;
Display  *dpy1, *dpy2, *dpy3;

extern XtAppContext  apc_gltrupg, apc_gltrnj;
extern Display  *dsp_gltrupg, *dsp_gltrnj;
extern Widget  da_gltrupg, da_gltrnj;
extern Boolean  draw_gltrupg, draw_gltrnj;

jmp_buf  JumpEnv;

extern MENUITEM	 menubar_submenu_gltree[];
extern MENUITEM	 menubar_submenu_motif[];
extern MENUITEM	 menubar_submenu_stemfinder[];

#ifdef	MACHINE_IRIS
static int
#else
static void
#endif
sig_hand(sig)
int	sig;
{
  void	exit();

  socketClose();
  exit(0);
}
  
   
refresh(w,client_data,call_data)
Widget  w;
caddr_t  client_data, call_data;
{
  extern void  display_aedit_win_2();
  
  display_aedit_win_2();
}


process_OK_button(w,client_data,call_data)
Widget  w;
caddr_t  client_data, call_data;
{
  process_OK();
}

select_da(w)
Window  w;
{
  if (w == XtWindow(da)){
    TheDisplay = dpy2;
    TheWindow = XtWindow(da);
    Result_draw = False;
    draw_gltrupg = False;
    draw_gltrnj = False;
  }
  if (w == XtWindow(da2)){
    TheDisplay = dpy3;
    TheWindow = XtWindow(da2);
    Result_draw = True;
    draw_gltrupg = False;
    draw_gltrnj = False;
  }
  /* append (begin) */
  if (w == XtWindow(da_gltrupg)){
    TheDisplay = dsp_gltrupg;
    TheWindow = XtWindow(da_gltrupg);
    Result_draw = False;
    draw_gltrupg = True;
    draw_gltrnj = False;
  }
  if (w == XtWindow(da_gltrnj)){
    TheDisplay = dsp_gltrnj;
    TheWindow = XtWindow(da_gltrnj);
    Result_draw = False;
    draw_gltrupg = False;
    draw_gltrnj = True;
  }
  /* append (end) */
}


int
main(argc,argv)
int  argc;
char  *argv[];
{
  extern char  motif_dir[BUFSIZ];
  extern char  *usage_format;
  extern Pixel  pixel_black;
  extern Pixel  pixel_wheat;
  extern Pixel  pixel_navajowhite;
  Widget  rowcol, w, menubar;
  Widget  wtmp;
  Arg  args[10];
  XSetWindowAttributes  att, att2;
  FILE  *fp, *openRcFile(), *openFile();
  XGCValues  gcv;
  Cursor  cs;
  int  i, dummy, code, fg, bg, c;
  XWMHints  wmh, wmh2;
  char  str[20];
  char  *p;
  XFontStruct  *fs;

  extern XtAppContext  ac_aal;
  Arg  argsmb[4], argspm[4], argspb[5], argscb[4], argstb[5];
  int  acmb, acpm, acpb, accb, actb;
  char  aedfile[BUFSIZ], mfile[BUFSIZ];
  int  mflag;
  char  msg[BUFSIZ];
  char  *md;
  extern void  create_window_aal();
  void  argument_proc();
  void  error();
  void  exit();
  void  set_submenu_resource();
  char  *getenv();
  void  set_colorcell_type();
  void  main_loop();
  
  /* append (begin) */
  extern void  set_nmatrix();
  extern void  set_dmatrix();
  void  set_xenv();
  void  set_visualtype();
  void  set_tmpaedfile_alarm();
  /* append (end) */

  for (i=0; i<3; i++) Button_flag[i] = False; /* gcc Ѥ˶ʤդä */
  
  /* ɸϡɸ२顼ϤΥХåե̤ѤȤ */
  setbuf(stdout, NULL);
  setbuf(stderr, NULL);
  
  /* إɥĶѿ */
  set_xenv();
  
  /* Хѿ˥ǥեȤͤꤹ */
  setGlobalDefault();
  
  if ((md = getenv("AEDIT_MOTIF_DIR")) == (char *)NULL)
    *motif_dir = '\0';
  else
    (void)strcpy(motif_dir, md);
  
  /* νʣ */
  argument_proc(&argc, argv, aedfile, &mflag, mfile);
  
  if (mflag == 1) {
    /* Nmatrix */
    if (mfile[0] != '\0') set_nmatrix(mfile);
    NA_flag =True;
  }
  else if (mflag == 2) {
    /* Dmatrix */
    if (mfile[0] != '\0') set_dmatrix(mfile);
  }
  
  if (NA_flag){
    UU = 40; VV = 5; SS = 5;
    UUVV = UU + VV;
    fprintf(stderr, "*****  Nucleic Acid Mode  *****\n");
  }
  
  /* append (begin) */
  /* ƥݥեʥ饤ȡǥեˤ */
  set_tmpaedfile_alarm();
  /* append (end) */
  
  signal(SIGINT,sig_hand);
  signal(SIGQUIT,sig_hand);
  signal(SIGTERM,sig_hand);
  signal(SIGHUP,sig_hand);
  
  XtToolkitInitialize();
  app1 = XtCreateApplicationContext();
  dpy1 = XtOpenDisplay(app1,NULL,"menu_top","Menutop",NULL,0,&argc,argv);
  XtSetArg(args[0],XmNx,  0);
  XtSetArg(args[1],XmNy,  1);
  XtSetArg(args[2],XmNallowShellResize,  True);
  fprintf(stderr, "PASS1\n");
  
  menu_top = XtAppCreateShell("Top Menu","Menutop",applicationShellWidgetClass,
			      dpy1,args,3);
  fprintf(stderr, "PASS2\n");
  
  app2= XtCreateApplicationContext();
  dpy2 = XtOpenDisplay(app2,NULL,"aedit_top","Aedit",NULL,0,&argc,argv);
  fprintf(stderr, "PASS3\n");
  
  XtSetArg(args[0],XmNx,   0);
  XtSetArg(args[1],XmNy,   100);
  XtSetArg(args[2],XmNwidth, 1050);
  XtSetArg(args[3],XmNheight, 850);
  XtSetArg(args[4],XmNallowShellResize,  True);
  XtSetArg(args[5],XmNminWidth, 800);
  XtSetArg(args[6],XmNminHeight, 600);
  aedit_top = XtAppCreateShell("aedit_top","Aedit",applicationShellWidgetClass,
			       dpy2,args,7);
  fprintf(stderr, "PASS4\n");
  
  TheDisplay = dpy2;
  
  /* append (begin) */
  create_window_gltrupg_1(&argc, argv);
  create_window_gltrnj_1(&argc, argv);
  /* append (end) */
  
  app3 = XtCreateApplicationContext();
  dpy3 = XtOpenDisplay(app3,NULL,"result","Result",NULL,0,&argc,argv);
  fprintf(stderr, "PASS5\n");
  
  XtSetArg(args[0],XmNx,   1);
  XtSetArg(args[1],XmNy,   500);
  XtSetArg(args[2],XmNwidth, 1000);
  XtSetArg(args[3],XmNheight, 850);
  XtSetArg(args[4],XmNallowShellResize,  True);
  XtSetArg(args[5],XmNminWidth, 800);
  XtSetArg(args[6],XmNminHeight, 200);
  /* XtSetArg(args[7],XmNmappedWhenManaged,  False); */
  result = XtAppCreateShell("Result","Result",applicationShellWidgetClass,
			    dpy3,args,7);
  fprintf(stderr, "PASS6\n");
  
  /* νʣ */
  if (*aedfile != '\0') {
    (void)strcpy(FileName, aedfile);
    if ((fp = fopen(FileName, "r")) == NULL) {
      (void)fprintf(stderr, "%s can't open\n", FileName);
      exit(1);
    }
    readSeq(fp);
    fclose(fp);
  }
  else {
    initSeq();
    *FileName = '\0';  /* mark of no file specified currently */
  }
  
  if (argc != 1) {
    (void)sprintf(msg, usage_format, *argv);
    error(msg);
  }
  
  rowcol = XtVaCreateManagedWidget("rowcol",
				   xmRowColumnWidgetClass, menu_top,
				   XmNorientation, XmHORIZONTAL,
				   XmNwidth,  800,
				   XmNheight, 28,
				   /* XmNforeground, pixel_black,
				      XmNbackground, pixel_wheat, */
				   NULL);
  
  /* Load initial fonts */
  fs = XLoadQueryFont(TheDisplay,"a16");
  if(!fs) fs = XLoadQueryFont(TheDisplay,"9x13");
  if(!fs) fs = XLoadQueryFont(TheDisplay,"a14");
  if(!fs) fs = XLoadQueryFont(TheDisplay,"k16");
  if(!fs) fs = XLoadQueryFont(TheDisplay,"r16");
  if(!fs) fs = XLoadQueryFont(TheDisplay,"variable");
  if(!fs) fs = XLoadQueryFont(TheDisplay,"fixed");
  if(!fs) fs = XLoadQueryFont(TheDisplay,"6x13");
  if(!fs) {
    fprintf(stderr,"Can't find font for menu\n");
    exit(1);
  }
  
  menubar = XmCreateMenuBar(rowcol, "menubar", (Arg *)NULL, 0);
  
  wtmp = BuildMenu(fs, menubar, XmMENU_PULLDOWN, "File", 'F', file_menu);
  pd_edit = BuildMenu(fs,menubar,XmMENU_PULLDOWN,"Edit",'E',edit_menu);
  pdm_edmode = BuildMenu(fs,menubar,XmMENU_PULLDOWN,"EditMode",'M',edit_mode_menu);
  wtmp = BuildMenu(fs,menubar,XmMENU_PULLDOWN,"TreeDrawer",'T',menubar_submenu_gltree); 
  if (NA_flag) 
    wtmp = BuildMenu(fs,menubar,XmMENU_PULLDOWN,"StemFinder",'S',menubar_submenu_stemfinder); 
  else
    wtmp = BuildMenu(fs,menubar,XmMENU_PULLDOWN,"MotifSearch",'S',menubar_submenu_motif); 
  pd_net =  BuildMenu(fs,menubar,XmMENU_PULLDOWN,"Alignment",'A',network_menu);  
  wtmp = BuildMenu(fs,menubar,XmMENU_PULLDOWN,"Options",'O',options_menu);
  
  /* Initial state is View(VIEW) mode */
  XtSetSensitive(pd_edit,False);
  XtSetSensitive(pd_net,False);
  XtManageChild(menubar);
  
  w = XmCreatePushButton(rowcol,"Refresh", (Arg *)NULL, 0);
  XtAddCallback(w,XmNactivateCallback,refresh,NULL);
  XtManageChild(w);
  w2 = XmCreatePushButton(rowcol,"  Set  ", (Arg *)NULL, 0);
  XtAddCallback(w2,XmNactivateCallback,process_OK_button,NULL);
  XtManageChild(w2);
  XtSetSensitive(w2, False);
  
  /* drawing area */
  da = XtVaCreateManagedWidget("da",
			       xmDrawingAreaWidgetClass, aedit_top,
			       XmNwidth,  1000,
			       XmNheight,  850,
			       NULL);
  
  /* append (begin) */
  create_window_gltrupg_2();
  create_window_gltrnj_2();
  /* append (end) */
  
  /* drawing area for result data */
  XtSetArg(args[0], XmNscrollingPolicy, XmAUTOMATIC);
  XtSetArg(args[1], XmNscrollBarDisplayPolicy, XmSTATIC);
  XtSetArg(args[2], XmNscrollBarPlacement, XmTOP_LEFT);
  XtSetArg(args[3], XmNwidth, 1000);
  XtSetArg(args[4], XmNheight, 850);
  sw = XmCreateScrolledWindow(result, "sw", args, 5); XtManageChild(sw);
  XtSetArg(args[0], XmNx, 12);
  net_ok = XmCreatePushButton(sw, "Embed", args,1); 
  XtManageChild(net_ok); 
  XtAddCallback(net_ok, XmNactivateCallback, net_okCB, NULL);
  XtSetArg(args[0], XmNx, 65);
  net_cancel = XmCreatePushButton(sw, "Cancel", args, 1); 
  XtManageChild(net_cancel);
  XtAddCallback(net_cancel, XmNactivateCallback, net_cancelCB, NULL);
  da2 = XmCreateDrawingArea(sw, "da2", NULL, NULL); XtManageChild(da2); 
  XmScrolledWindowSetAreas(sw, NULL, NULL, da2);
  
  XtRealizeWidget(aedit_top);
  /* XtRealizeWidget(result); */
  
  XtAddEventHandler(da,EV_MASK,False,processEvent,NULL);
  XtAddEventHandler(da2,EV_MASK,False,processEvent,NULL);
  /* append (begin) */
  XtAddEventHandler(da_gltrupg,EV_MASK,False,processEvent,NULL);
  XtAddEventHandler(da_gltrnj,EV_MASK,False,processEvent,NULL);
  /* append (end) */
  initial_common_dialog(menu_top);
  
  TheWindow = XtWindow(da);
  TheScreen = DefaultScreen(TheDisplay);
  TheDepth = DefaultDepth(TheDisplay,TheScreen);
  TheBlackPixel = BlackPixel(TheDisplay,TheScreen);
  TheWhitePixel = WhitePixel(TheDisplay,TheScreen);
  TheRoot = RootWindow(TheDisplay,TheScreen);
  TheColormap = DefaultColormap(TheDisplay,TheScreen);
  
  set_colorcell_type(TheDisplay, TheScreen);
  
  /* Set WinW, WinH */
  XGetGeometry(TheDisplay,TheWindow,&dummy,&dummy,&dummy,
	       &WinW,&WinH,&dummy,&dummy);
  fprintf(stderr, "WinW,WinH=%d,%d\n",WinW,WinH);
  
  initOurColors();   
  
  /* Big Text fonts */
  FontStruct = XLoadQueryFont(TheDisplay,"a24");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"k24");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"rk24");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"k16");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"a16");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"9x15");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"variable");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"fixed");
  XSetFont(TheDisplay,BigTextGC,FontStruct->fid);
  
  /* Middle Text fonts */
  FontStruct = XLoadQueryFont(TheDisplay,"fg-20");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"a16");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"9x15");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"9x13");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"variable");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"k16");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"fixed");
  XSetFont(TheDisplay,MiddleTextGC,FontStruct->fid);
  
  /* Normal Text fonts */
  FontStruct = XLoadQueryFont(TheDisplay,"a14");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"rk14");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"fg-16");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"fixed");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"k14");
  if(!FontStruct) FontStruct = XLoadQueryFont(TheDisplay,"variable");
  if (NA_flag) FontStruct = XLoadQueryFont(TheDisplay,"5x8");
  
  for(code=0; code<MAXCODE; ++code)
    XSetFont(TheDisplay,AminoCharGC[code],FontStruct->fid);
  
  XSetFont(TheDisplay,TextGC,FontStruct->fid);
  XSetFont(TheDisplay,BlackGC,FontStruct->fid);
  XSetFont(TheDisplay,WhiteGC,FontStruct->fid);
  XSetFont(TheDisplay,FixedColumnGC,FontStruct->fid);
  
  fontParams();
  
  /* set initial cursor position */
  ActiveCol = 0;
  ActiveIndex = INITIAL_DATA_START_INDEX;
  ActiveAlign = 0;
  ActiveYo = TopMargin + 2*BoxH;   /* 2*BoxH for display column lines */
  ActiveXo = LeftMargin;
  
  att.backing_store = WhenMapped;
  XChangeWindowAttributes(TheDisplay, XtWindow(da),
			  CWBackingStore,&att);
  wmh.input = False;
  wmh.flags = InputHint;
  XSetWMHints(TheDisplay,XtWindow(aedit_top),&wmh);
  
  XStoreName(TheDisplay, XtWindow(aedit_top),
	     "Alignment Editor  Ver. 1.80                 (c)ICOT , 1995");
  
  XtRealizeWidget(menu_top);
  
  adjustMenuItems();
  
  for (i=0; i<MAX_ALIGN_LENG; i++){
    Region_divide[i] = False;
    Region_flag[i] = False;
  }
  for (i=0; i<3; i++) Button_flag[i] = False;
  
  
  /* append (begin) */
  create_window_aal(&argc, argv);
  /* append (end) */
  
  main_loop();
  
  return 0;
}

void
main_loop()
{
  extern  XtAppContext	ac_aal;
  XEvent  event1, event2, event3, event4, event5, eventaal;
  
  for ( ; ; ) {
    if (XtAppPending(app1)) {
      XtAppNextEvent(app1, &event1);
      if(event1.type == MappingNotify) {
	XRefreshKeyboardMapping(&event1);
	fprintf(stderr,"MappingNotify event occured in top_menu\n"); 
      }
      else XtDispatchEvent(&event1);
    }
    if (XtAppPending(app2)) {
      XtAppNextEvent(app2, &event2);
      if(event2.type == MappingNotify) {
	XRefreshKeyboardMapping(&event2);
	fprintf(stderr,"MappingNotify event occured in aedit\n"); 
      }
      else XtDispatchEvent(&event2);
    }
    if (XtAppPending(app3)) {
      XtAppNextEvent(app3, &event3);
      if(event3.type == MappingNotify) {
	XRefreshKeyboardMapping(&event3);
	fprintf(stderr,"MappingNotify event occured in aedit\n"); 
      }
      else XtDispatchEvent(&event3);
    }
    if (XtAppPending(apc_gltrupg)) {
      XtAppNextEvent(apc_gltrupg, &event4);
      if(event4.type == MappingNotify) {
	XRefreshKeyboardMapping(&event4);
	fprintf(stderr,"MappingNotify event occured in aedit\n"); 
      }
      else XtDispatchEvent(&event4);
    }
    if(XtAppPending(apc_gltrnj)) {
      XtAppNextEvent(apc_gltrnj, &event5);
      if(event5.type == MappingNotify) {
	XRefreshKeyboardMapping(&event5);
	fprintf(stderr,"MappingNotify event occured in aedit\n"); 
      }
      else XtDispatchEvent(&event5);
    }
    if (XtAppPending(ac_aal)) {
      XtAppNextEvent(ac_aal, &eventaal);
      if (eventaal.type == MappingNotify) {
	XRefreshKeyboardMapping(&eventaal);
	fprintf(stderr,"MappingNotify event occured in top_menu\n"); 
      }
      else XtDispatchEvent(&eventaal);
    }
  }
}

void
set_submenu_resource(menu, argspb, acpb, argscb, accb, argstb, actb)
MENUITEM  *menu;
Arg  *argspb;
int  acpb;
Arg  *argscb;
int  accb;
Arg  *argstb;
int  actb;
{
  int  i;
  extern void  fatal_error();
  
  for (i = 0; (*(menu+i)).label != (char *)NULL; i++) {
    if ((*(menu+i)).class == &xmPushButtonGadgetClass) {
      XtSetValues((*(menu+i)).w, argspb, acpb);
      /* (void)printf("Push Button\n"); */
    }
    else if ((*(menu+i)).class == &xmCascadeButtonGadgetClass) {
      XtSetValues((*(menu+i)).w, argscb, accb);
      /* (void)printf("Cascade Button\n"); */
    }
    else if ((*(menu+i)).class == &xmToggleButtonGadgetClass) {
      XtSetValues((*(menu+i)).w, argstb, actb);
      /* (void)printf("Toggle Button\n"); */
    }
    else if ((*(menu+i)).class == &xmSeparatorGadgetClass) {
      /* (void)printf("Separator\n"); */
    }
    else {
      /* fatal_error("set_submenu_resource", "illegal class\n"); */
    }
    if ((*(menu+i)).subitems != (MENUITEM *)NULL)
      set_submenu_resource((*(menu+i)).subitems,
			   argspb, acpb,
			   argscb, accb,
			   argstb, actb);
  }
}


void	set_colorcell_type(display, screen)
Display	 *display;
int  screen;
{
  extern int  colorcell_type;
  int  depth;
  Visual  *visual;
  extern void  fatal_error();
  
  depth = DisplayPlanes(display, screen);
  if (depth <= 1) fatal_error("set_visualtype", "not color display\n");
  visual = DefaultVisual(display, screen);
  switch (visual->class) {
  case PseudoColor :
    (void)printf("visual class = PseudoColor\n");
    colorcell_type = COLORCELL_TYPE_RW;
    break;
  case StaticColor :
    (void)printf("visual class = StaticColor\n");
    colorcell_type = COLORCELL_TYPE_RO;
    break;
  case DirectColor :
    (void)printf("visual class = DirectColor\n");
    colorcell_type = COLORCELL_TYPE_RW;
    break;
  case TrueColor :
    (void)printf("visual class = TrueColor\n");
    colorcell_type = COLORCELL_TYPE_RO;
    break;
    /* case GrayScale :
       (void)printf("visual class = GrayScale\n");
       colorcell_type = COLORCELL_TYPE_RW;
       break;
       case StaticGray :
       (void)printf("visual class = StaticGray\n");
       colorcell_type = COLORCELL_TYPE_RO;
       break; */
  default :
    fatal_error("set_colorcell_type", "illegal visual class\n");
  }
}


void processEvent(w,client_data,event)
Widget  w;
caddr_t  client_data;
XEvent  *event;
{
  int  i,count,status;
  XEvent  ahead;
  static unsigned long  serial_bak=0;
  
  select_da(event->xany.window);
  /* fprintf(stderr, "drawing:%d  type:%d\n", Result_draw, event->type); */
  
  switch(event->type) {

  case Expose:
    if(event->xexpose.count==0) {
      /* fprintf(stderr, "new:%d\n", event->xany.serial); */
      /* fprintf(stderr, "bak:%d\n", serial_bak); */
      if (!(Result_draw && (serial_bak == event->xany.serial))){
	/* printf("ExposureNotify event occur \n"); */
	disp(TRUE);
	serial_bak = event->xany.serial;
      }
    }
    break;

  case MappingNotify:
    XRefreshKeyboardMapping(event);
    break;

  case ConfigureNotify:
    if (!Result_draw && !draw_gltrupg && !draw_gltrnj) {
      WinW = event->xconfigure.width;
      WinH = event->xconfigure.height;
      fontParams();
    }
    count=XEventsQueued(TheDisplay,QueuedAfterReading);
    for(i=0; i<count; ++i) {
      XPeekEvent(TheDisplay,&ahead);
      if(ahead.type == Expose)  return;
    }
    if (!Result_draw) {
      disp(TRUE);
    }
    break;

  case EnterNotify:
#ifdef	TWM
    XSetInputFocus(TheDisplay,TheWindow,RevertToParent,event->xcrossing.time);
    status=XGrabKeyboard(TheDisplay,TheWindow,True,
			 GrabModeAsync,GrabModeAsync,event->xcrossing.time+1);
    printGrabStatus("EnterNotify",status); 
    XFlush(TheDisplay);
#endif
    break;

  case LeaveNotify:
    XAllowEvents(TheDisplay,AsyncKeyboard,event->xcrossing.time);
    XUngrabKeyboard(TheDisplay,event->xcrossing.time);
    XFlush(TheDisplay);
    break;

  case ButtonRelease:
    if (!Result_draw && !draw_gltrupg && !draw_gltrnj) {
      if (EditMode == MOVE_ALIGNMENT) {
	if (event->xbutton.button == Button1) {
	  Button_flag[event->xbutton.button - 1] = False;
	  processRelease_scroll(w,event);
	  button_release_mval(w, event);
	}
      }
      else if (EditMode == DELETE_ALIGNMENT) {
	if (event->xbutton.button == Button1) {
	  Button_flag[event->xbutton.button - 1] = False;
	  processRelease_scroll(w,event);
	  button_release_dlal(w, event);
	}
      }
      else if (EditMode == ALIGNMENT_MANUAL) {
	if (event->xbutton.button == Button1 ||
	    event->xbutton.button == Button3   ) {
	  Button_flag[event->xbutton.button - 1] = False;
	  processRelease_scroll(w,event);
	  button_release_almn(w, event);
	}
      }
      else {
	Button_flag[event->xbutton.button - 1] = False;
	processRelease_scroll(w,event);
	processRelease(w,event);
      }
    }
    break;

  case ButtonPress:
    if (!Result_draw && !draw_gltrupg && !draw_gltrnj) {
      if (EditMode == MOVE_ALIGNMENT) {
	if (event->xbutton.button == Button1) {
	  Button_flag[event->xbutton.button - 1] = True;
	  processPress_scroll(w,event);
	  button_press_mval(w, event);
	}
      }
      else if (EditMode == DELETE_ALIGNMENT) {
	if (event->xbutton.button == Button1) {
	  Button_flag[event->xbutton.button - 1] = True;
	  processPress_scroll(w,event);
	  button_press_dlal(w, event);
	}
      }
      else if (EditMode == ALIGNMENT_MANUAL) {
	if (event->xbutton.button == Button1 ||
	    event->xbutton.button == Button3   ) {
	  Button_flag[event->xbutton.button - 1] = True;
	  processPress_scroll(w,event);
	  button_press_almn(w, event);
	}
      }
      else {
	Button_flag[event->xbutton.button - 1] = True;
	processPress_scroll(w,event);
	processPress(w,event);
      }
    }
    break;

  case MotionNotify:
    if ((Button_flag[0] || Button_flag[1] || Button_flag[2]) &&
	!Result_draw &&	!draw_gltrupg && !draw_gltrnj){
      if (EditMode == MOVE_ALIGNMENT)
	pointer_motion_mval(w, event);
      else if (EditMode == DELETE_ALIGNMENT)
	/* pointer_motion_dlal(w, event); */
	;
      else if (EditMode == ALIGNMENT_MANUAL)
	pointer_motion_almn(w, event);
      else
	processMotion(w, event);
    }
    break;

  case KeyPress:
    set_Shift_flag(w, event);
    /* fprintf(stderr, "%d %d %d\n", event->xkey.state, event->xkey.keycode, XK_Shift_L); */
    /* if(EditMode == VIEW || EditMode == NORMAL) {
       if(processKeyPress2(w,event) && 
       CalcColumnCost) 
       disp_cost(True);
       } */
    if (EditMode == INSERT || EditMode == OVER_WRITE){
      if(processKeyPress1(w,event) &&   /* if modified */
	 CalcColumnCost) 
	disp_cost(True);
    }
    break;

  case KeyRelease:
    reset_Shift_flag(w, event);
    break;

  case VisibilityNotify:
    break;

  case FocusIn:
    if (Result_flag && !Result_draw){
      Result_flag = False;
      disp_cost(True);
      disp(True);
    }
    break;

  case FocusOut:
    break;

  default :
    break;
  }
}


/* HYOUSI KANNKEI NO Global variables */
/* This must be called when fonts/window size/alignment strings  has changed */
fontParams()
{
  int  i;
  INFO  *cp;
  XChar2b  theChar;
  XCharStruct  metrics;
  int  direction, fontascent, fontdescent, xoff, yoff;
  
  BoxW = FontStruct->max_bounds.width + FONT_PAD*2;
  BoxH = FontStruct->descent + FontStruct->ascent + FONT_PAD*2;
  LeftMargin = MaxAlignName*BoxW+20;
  
  Info.rowH = (Info.alignnum+YobiN)*BoxH;
  
  if(FontStruct->min_byte1 != 0) Kanji=True;
  else Kanji=False;
  
  if(Kanji) {
    for(i=0; ; ++i) {
      if(XChar2[i].byte1==0)  break;
      XTextExtents16(FontStruct,&XChar2[i],1,&direction,
		     &fontascent,&fontdescent,&metrics);
      
      if(FontStruct->per_char==NULL ||
	 FontStruct->min_bounds.width == FontStruct->max_bounds.width) {
	/* Fixed size fonts */
	XOffset[i] = FONT_PAD;
	YOffset[i] = BoxH- (FONT_PAD + metrics.descent);
      }
      else {
	XOffset[i] = (BoxW - (metrics.rbearing - metrics.lbearing))/2
	  - FONT_PAD - metrics.lbearing;
	YOffset[i] = BoxH - (BoxH-(metrics.descent + metrics.ascent))/2
	  + FONT_PAD + FontStruct->ascent - metrics.ascent;
      }
    }
  }
  else {
    for(i=0; ; ++i) {
      if(Char1[i]==0)  break;
      XTextExtents(FontStruct,&Char1[i],1,&direction,
		   &fontascent,&fontdescent,&metrics);
      
      if(FontStruct->per_char==NULL ||
	 FontStruct->min_bounds.width == FontStruct->max_bounds.width) {
	/* Fixed size fonts */
	XOffset[i] = FONT_PAD;
	YOffset[i] = BoxH- (FONT_PAD + metrics.descent);
      }
      else {
	XOffset[i] = (BoxW - (metrics.rbearing - metrics.lbearing))/2
	  - FONT_PAD - metrics.lbearing;
	YOffset[i] = BoxH - (BoxH-(metrics.descent + metrics.ascent))/2
	  + FONT_PAD + FontStruct->ascent - metrics.ascent;
      }
    }
  }
  
  /* adjust YOffset for '-' */
  YOffset[GAP_INNER_CODE] -= BoxH/3;
  YOffset['-'] -= BoxH/3;
  
  PerLine = (WinW - LeftMargin - RightMargin)/BoxW;
}




whoGetKeyboard()
{
  Window  win=0;
  int  revert_to;
  char  *str;
  
  XGetInputFocus(TheDisplay,&win,&revert_to);
  if(revert_to==RevertToParent)  str="ReverToParent";
  else if(revert_to==RevertToPointerRoot)  str="ReverToPointerRooot";
  else if(revert_to==RevertToNone)  str="ReverToNone";
  fprintf(stderr, "window = %d(0x%x), revert_to = %s\n",win,win,str);   
}

printGrabStatus(msg,status)
char  *msg;
int  status;
{
  /* printf("%s\n",msg); */
  if(status==GrabSuccess)          /* printf("Grabsuccess\n") */;
  else if(status==AlreadyGrabbed)  fprintf(stderr, "AlreadyGrabbed\n");
  else if(status==GrabNotViewable) fprintf(stderr, "GrabNotViewable\n");
  else if(status==GrabInvalidTime) fprintf(stderr, "GrabInvalidTime\n");
  else if(status==GrabFrozen)      fprintf(stderr, "GrabFrozen\n");
}



/* Global Value WO Menu HYOUJI NI HAN'EI SASERU */
adjustMenuItems()
{
  /*
     if(EditMode==VIEW) 
     XtCallCallbacks(edit_mode_menu[0].w,
     XmNvalueChangedCallback,True);
     else if(EditMode==NORMAL) 
     XtCallCallbacks(edit_mode_menu[1].w,
     XmNvalueChangedCallback,True);
     else if(EditMode==INSERT) 
     XtCallCallbacks(edit_mode_menu[2].w,
     XmNvalueChangedCallback,True);
     else if(EditMode==OVER_WRITE) 
     XtCallCallbacks(edit_mode_menu[3].w,
     XmNvalueChangedCallback,True);
     
     if(CalcColumnCost==0)
     XtCallCallbacks(options_sub_menu1[0].w,
     XmNvalueChangedCallback,True);
     else
     XtCallCallbacks(options_sub_menu1[1].w,
     XmNvalueChangedCallback,True);
     
     if(AminoTextCase==UPPER)
     XtCallCallbacks(options_sub_menu2[0].w,
     XmNvalueChangedCallback,True);
     else
     XtCallCallbacks(options_sub_menu2[1].w,
     XmNvalueChangedCallback,True);
     */
}


/* ---> file_menu.c */
static void	set_tmpaedfile_alarm()
{
#ifdef	MACHINE_IRIS
  int  output_tmpaedfile();
#else
  void  output_tmpaedfile();
#endif
  
  (void)alarm(tmpaedfile_asd_interval);
  (void)signal(SIGALRM, output_tmpaedfile);
}

#ifdef	MACHINE_IRIS
static int
#else
static void
#endif
output_tmpaedfile(sig)
int  sig;
{
  extern void	save_tmpaedfile_asd();
  
  (void)alarm(0);
  
  if (tmpaedfile_asd_proc == TMPAEDFILE_ASD_PROC_NONE) {
    tmpaedfile_asd_proc = TMPAEDFILE_ASD_PROC_SAVE;
    save_tmpaedfile_asd();
    tmpaedfile_asd_proc = TMPAEDFILE_ASD_PROC_NONE;
  }
  
  (void)alarm(tmpaedfile_asd_interval);
  
  (void)signal(SIGALRM, output_tmpaedfile);
}


static void	argument_proc(argc, argv, aedfile, mflag, mfile)
int  *argc;
char  *argv[];
char  *aedfile;
int  *mflag;
char  *mfile;
{
  extern char  *usage_format;
  char  msg[BUFSIZ];
  char  **head;
  int  i, j;
  void  error();
  void  exit();
  
  *aedfile = '\0';
  *mflag = 0;
  *mfile = '\0';
  
  (void)sprintf(msg, usage_format, *argv);
  
  head = argv;
  i = j = 1;
  
  while (*++argv != (char *)NULL) {
    if (**argv == '-') {
      switch (*(*argv+1)) {
      case 'a' :
	if (*(*argv+2) != '\0')
	  error(msg);
	if (*aedfile != '\0')
	  error(msg);
	if (*(argv+1) == (char *)NULL || **(argv+1) == '-')
	  error(msg);
	(void)strcpy(aedfile, *++argv);
	(*argc) -= 2;
	j += 2;
	break;
      case 'n':
	if (*(*argv+2) != '\0')
	  error(msg);
	if (*mflag != 0)
	  error(msg);
	(*argc)--;
	j++;
	if (*(argv+1) != (char *)NULL && **(argv+1) != '-') {
	  (void)strcpy(mfile, *++argv);
	  (*argc)--;
	  j++;
	}
	*mflag = 1;
	break;
      case 'd' :
	if (*(*argv+2) != '\0')
	  error(msg);
	if (*mflag != 0)
	  error(msg);
	(*argc)--;
	j++;
	if (*(argv+1) != (char *)NULL && **(argv+1) != '-') {
	  (void)strcpy(mfile, *++argv);
	  (*argc)--;
	  j++;
	}
	*mflag = 2;
	break;
      default :
	if (i < j)
	  *(head+i) = *argv;
	i++;
	j++;
	break;
      }
    }
    else {
      if (i < j)
	*(head+i) = *argv;
      i++;
      j++;
    }
  }
  
}


static void  error(msg)
char  *msg;
{
  void	exit();
  
  (void)fprintf(stderr, "%s", msg);
  exit(1);
}


/* إɥĶѿԤ */
static void
set_xenv()
{
  extern char  *resource_file;
  char  abspathname[BUFSIZ];
  static char  xenv[BUFSIZ];
  extern int  search_regfile_pathvar();
  extern void  fatal_error();
  
  if (!search_regfile_pathvar(resource_file, R_OK, abspathname))
    fatal_error("set_xenv","resource file (%s) not found.\n",resource_file);
  
  (void)sprintf(xenv, "XENVIRONMENT=%s", abspathname);
  
  if (putenv(xenv) != 0)
    fatal_error("set_xenv","putenv error return\n");
}

/*----------------------------------------------------------------------
  eof
  ----------------------------------------------------------------------*/
