/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* logfile_menu.c 
 * treat logfile menu items commands.
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/Shell.h>
#include <Xm/Text.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/DialogS.h>

#include "menu.h"
#include "aedit.h"

extern MENUITEM logfile_menu[];

static Widget openlog_text, writelog_text;
static FILE  *LogFp;   /* logging file */

void editEH(w,client_data,event)
Widget w;
int    client_data;
XEvent  *event;
{
   int status;

   switch(event->type) {
   case EnterNotify:
      fprintf(stderr, "EnterNotify event occur \n");
      XSetInputFocus(TheDisplay,XtWindow(w),RevertToParent,
                     event->xcrossing.time);
      XFlush(TheDisplay);
      break;
   case LeaveNotify:
      XAllowEvents(TheDisplay,AsyncKeyboard,event->xcrossing.time);
      XFlush(TheDisplay);
      break;
   }
}


void cancelCB(w,dialog,call_data)
Widget   w, dialog;
caddr_t  call_data;
{
  XtPopdown(dialog);
}


/* called when ok button of openlog dialog is pushed */
void  openlog_okCB(w,dialog,call_data)
Widget   w, dialog;
caddr_t  call_data;
{
  char *fname;

  fprintf(stderr, "at HERE\n"); 
  fname = XmTextGetString(openlog_text);
  fprintf(stderr, "fname=%s, strlen(fname)=%d, fname[0]=%d\n",fname,strlen(fname),fname[0]); 
  if(strlen(fname) == 0  ||  fname[0]==0)  
     popUpWarnDialog("You must specify a logging file");
  else {
     LogFp = fopen(fname,"w");
     if(LogFp==NULL) 
         popUpWarnDialog("file %s fails to open for writing.",fname);
     else {  /* open success */
         XtSetSensitive(logfile_menu[0].w,False);
         XtSetSensitive(logfile_menu[1].w,True);
         XtSetSensitive(logfile_menu[2].w,True);  
     }
  }
  XtFree(fname);
  XtPopdown(dialog); 
}


/* called when open item of logfile menu is selected */
static void open_logfile(w,client_data,cbs)
Widget   w;
int     client_data;  /* not used */
XmAnyCallbackStruct *cbs;
{
  int i,x,y,dummy;
  static Widget dialog=NULL;
  Widget bb,label,ok,cancel;
  extern Widget  menu_top;
  Arg    args[10];
  XButtonEvent *ev;

  ev = (XButtonEvent *)cbs->event;
  if(!dialog) {
     XtSetArg(args[0],XmNx, cbs->event->xbutton.x_root-30);
     XtSetArg(args[1],XmNy, cbs->event->xbutton.y_root-30);
     XtSetArg(args[2],XmNautoUnmanage, False);
     dialog = XtCreatePopupShell("openlog_dialog",xmDialogShellWidgetClass, menu_top,
                                  args,3);

     XtSetArg(args[0],XmNautoUnmanage, False);
     bb=XmCreateBulletinBoard(dialog,"openlog_bb",args,1);  
     label=XmCreateLabel(bb,"openlog_label",NULL,0);  XtManageChild(label);

     openlog_text=XmCreateText(bb,"openlog_text",NULL,0); 
/***
     XtAddEventHandler(openlog_text,EnterWindowMask|LeaveWindowMask,False,editEH,NULL); 
***/
     XtManageChild(openlog_text);

     ok=XmCreatePushButton(bb,"openlog_ok",NULL,0);  XtManageChild(ok);
     XtAddCallback(ok,XmNactivateCallback,openlog_okCB,dialog);
     cancel=XmCreatePushButton(bb,"openlog_cancel",NULL,0); XtManageChild(cancel);
     XtAddCallback(cancel,XmNactivateCallback,cancelCB,dialog);

     XtVaSetValues(bb, XmNdefaultButton,ok,NULL);
     XtManageChild(bb);
  }
  XtVaSetValues(dialog,
                XmNx, cbs->event->xbutton.x_root-30,
                XmNy, cbs->event->xbutton.y_root-30,
                NULL);
  XtPopup(dialog,XtGrabNone); 
  XFlush(TheDisplay);
}


/* called when ok button of openlog dialog is pushed */
void  writelog_okCB(w,dialog,call_data)
Widget   w, dialog;
caddr_t  call_data;
{
  char *comment;
  int  i, j, count, leng, out_num, code;
  static char *columnNumStr[100]= {
"----+----1----+----2----+----3----+----4----+----5----+----6----+----7",
"----+----8----+----9----+---10----+---11----+---12----+---13----+---14",
"----+---15----+---16----+---17----+---18----+---19----+---20----+---21",
"----+---22----+---23----+---24----+---25----+---26----+---27----+---28",
"----+---29----+---30----+---31----+---32----+---33----+---34----+---35",
"----+---36----+---37----+---38----+---39----+---40----+---41----+---42",
};

#define LINE_CHAR 70

  calcCost(Info.dataStartIndex, Info.dataEndIndex);

  comment = XmTextGetString(writelog_text);
/*  printf("comment=%s\n",comment); */
  if(LogFp==NULL)  {
     fprintf(stderr,"logic error in ok_write_logCB\n");
     return;
  }
  fprintf(LogFp,
"\n=======================================================================================\n");
  fprintf(LogFp,"UU=%d, VV=%d, WW=%d, PP=%d, QQ=%d, SS=%d\n",
          UU, VV, WW, PP, QQ, SS);
  fprintf(LogFp,"cost=%d, comment=%s\n\n",Info.cost,comment);

  leng = Info.dataEndIndex - Info.dataStartIndex + 1;
  count=0;
  for(;;) {
     out_num = count*LINE_CHAR;     /* num of outputted char */
     if(leng <= out_num )  break;
     fprintf(LogFp,"%s\n",columnNumStr[count]); 

     for(i=0; i<Info.alignnum; ++i) {
        for(j=0; j<LINE_CHAR; ++j) {
           code = Info.codeAlign[i][Info.dataStartIndex+out_num+j];
           if(out_num+j >= leng  || code == -1) break;
           fputc(Char1[code],LogFp);
        }
        fputc('\n',LogFp);
     }
     ++count;
  }
  XtFree(comment);
  XtPopdown(dialog); 
}


/* called when write item of logfile menu is selected */
static void write_logfile(w,client_data,cbs)
Widget   w;
int     client_data;  /* not used */
XmAnyCallbackStruct *cbs;
{
  int i,x,y,dummy;
  static Widget dialog=NULL;
  Widget bb,label,ok,cancel;
  extern Widget  menu_top;
  Arg    args[10];
  XButtonEvent *ev;

  ev = (XButtonEvent *)cbs->event;
  if(!dialog) {
     XtSetArg(args[0],XmNx, cbs->event->xbutton.x_root-30);
     XtSetArg(args[1],XmNy, cbs->event->xbutton.y_root-30);
     XtSetArg(args[2],XmNautoUnmanage, False);
     dialog = XtCreatePopupShell("writelog_dialog",xmDialogShellWidgetClass, menu_top,
                                  args,3);
     XtSetArg(args[0],XmNautoUnmanage, False);

     bb=XmCreateBulletinBoard(dialog,"writelog_bb",args,1);
     label=XmCreateLabel(bb,"writelog_label",NULL,0); XtManageChild(label);
     writelog_text=XmCreateText(bb,"writelog_text",NULL,0); 
     XtManageChild(writelog_text);
     ok=XmCreatePushButton(bb,"writelog_ok",NULL,0);  XtManageChild(ok);
     XtAddCallback(ok,XmNactivateCallback,writelog_okCB,dialog);
     cancel=XmCreatePushButton(bb,"writelog_cancel",NULL,0); XtManageChild(cancel);
     XtAddCallback(cancel,XmNactivateCallback,cancelCB,dialog);

     XtVaSetValues(bb, XmNdefaultButton,ok,NULL);
     XtManageChild(bb);
  }
  XtVaSetValues(dialog,
                XmNx, cbs->event->xbutton.x_root-30,
                XmNy, cbs->event->xbutton.y_root-30,
                NULL);
  XtPopup(dialog,XtGrabNone); 
  XFlush(TheDisplay);
}


static void confirm_close(w,client_data,call_data)
Widget w;
caddr_t  client_data;
XmAnyCallbackStruct  *call_data;
{
   if(call_data->reason == XmCR_OK)  {
       fclose(LogFp);
       XtSetSensitive(logfile_menu[0].w,True);
       XtSetSensitive(logfile_menu[1].w,False);
       XtSetSensitive(logfile_menu[2].w,False);  
   }
   else if(call_data->reason == XmCR_CANCEL)  {
   }
}


/* called when  button of openlog dialog is pushed */
static void close_logfile(w,client_data,call_data)
Widget   w;
caddr_t client_data,call_data;
{
  popUpConfirmDialog(confirm_close,NULL,True,"Are you sure ?");
}


MENUITEM logfile_menu[] = {
   { "Open", &xmPushButtonGadgetClass, 'O', NULL, NULL,
      open_logfile, (caddr_t)NULL, NULL, True},
   { "Write", &xmPushButtonGadgetClass, 'W', NULL, NULL,
      write_logfile, (caddr_t)NULL, NULL, False},
   { "Close", &xmPushButtonGadgetClass, 'C', NULL, NULL,
      close_logfile, (caddr_t)NULL, NULL, False},
   {NULL},
};

