/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"

generateD_00(d0)
struct DATA0 *d0;
{
  int CutVolume;

  if(d0->X <= d0->Y){
    CutVolume = (d0->Cut*d0->X)/100;
    if(CutVolume == 0){
      d0->LimX = d0->X+1;
      d0->LimY = d0->Y;
    }
    else{
      d0->LimX = d0->X - CutVolume;
      d0->LimY = d0->Y - CutVolume;
    }
  }
  else{
    CutVolume = (d0->Cut*d0->Y)/100;
    if(CutVolume == 0){
      d0->LimX = d0->X+1;
      d0->LimY = d0->Y;
    }
    else{
      d0->LimX = d0->X - CutVolume;
      d0->LimY = d0->Y - CutVolume;
    }
  }
/*  printf("LimX = %d,LimY = %d\n",d0->LimX,d0->LimY); */

  d0->I = 0;
  d0->J = 0;

  if(d0->LimX > 0 && d0->LimY > 0){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_00(d0);
    d0->I++;
    generateD_I0(d0);
  }
  else if(d0->LimX > 0){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_00_Cut_2(d0);
    d0->I++;
    generateD_I0(d0);
  }
  else if(d0->LimY > 0){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_00_Cut_1(d0);
    d0->J++;
    d0->LimX++;
    generateD_0J(d0);
  }
  else{
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_00_II(d0);
    d0->I++;
    d0->J++;
    generateD_II(d0);
  }
}


generateD_II(d0)
struct DATA0 *d0;
{
  while(d0->I<d0->X){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_II(d0);
    d0->I++;
    d0->J++;
  }

  /* printf("I = %d,J = %d\n",d0->I,d0->J); */
  dist_XX(d0);
}


generateD_I0(d0)
struct DATA0 *d0;
{
  while(d0->I < d0->LimX && d0->I < d0->X){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_I0(d0);
    d0->I++;
  }

  if(d0->I == d0->LimX && d0->LimX < d0->X && d0->LimY == 0){
    /* printf("I = %d,J = %d\n",I,J); */
    dist_I0_Cut(d0);
    d0->I = 1;
    d0->J++;
    d0->LimX++;
    generateD_IJ_Cut(d0);
  }
  else if(d0->I == d0->LimX && d0->LimX < d0->X){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_I0_Cut(d0);
    d0->I = 0;
    d0->J++;
    d0->LimX++;
    generateD_0J(d0);
  }
  else if(d0->I == d0->X){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_X0(d0);
    d0->I = 0;
    d0->J++;
    generateD_0J(d0);
  }
  else {
    printf("generateD error\n");
    exit(1);
  }
}


generateD_0J(d0)
struct DATA0 *d0;
{
  if(d0->J < d0->LimY){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_0J(d0);
    d0->I++;
    generateD_IJ(d0);
  }
  else if(d0->J == d0->LimY && d0->LimY < d0->Y){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_0J_Cut(d0);
    d0->I++;
    generateD_IJ(d0);
  }
  else if(d0->J == d0->Y){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_0Y(d0);
    d0->I++;
    generateD_IJ(d0);
  }
  else {
    printf("generateD error\n");
    exit(1);
  }
}


generateD_IJ_Cut(d0)
struct DATA0 *d0;
{
  if(d0->I < d0->X && d0->J < d0->Y){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_IJ_2(d0);
    d0->I++;
    generateD_IJ(d0);
  }
  else if(d0->I < d0->X && d0->J == d0->Y){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_IY_2(d0);
    d0->I++;
    generateD_IJ(d0);
  }
  else if(d0->I == d0->X && d0->J == d0->Y){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_XY_2(d0);
  }
  else {
    printf("generateD error\n");
    exit(1);
  }
}


generateD_IJ(d0)
struct DATA0 *d0;
{
  while(d0->I < d0->LimX && d0->I < d0->X && d0->J < d0->Y){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_IJ(d0);
    d0->I++;
  }

  while(d0->I < d0->LimX && d0->I < d0->X && d0->J == d0->Y){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_IY(d0);
    d0->I++;
  }

  if(d0->I == d0->LimX && d0->LimX < d0->X && d0->J < d0->LimY){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_IJ_1(d0);
    d0->I = 0;
    d0->J++;
    d0->LimX++;
    generateD_0J(d0);
  }
  else if(d0->I == d0->LimX && d0->LimX < d0->X && d0->J < d0->Y){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_IJ_1(d0);
    d0->I = d0->J - d0->LimY + 1;
    d0->J++;
    d0->LimX++;
    generateD_IJ_Cut(d0);
  }
  else if(d0->I == d0->LimX && d0->LimX == d0->X && d0->J < d0->LimY){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_XJ_1(d0);
    d0->I = 0;
    d0->J++;
    d0->LimX++;
    generateD_0J(d0);
  }
  else if(d0->I == d0->LimX && d0->LimX == d0->X && d0->J < d0->Y){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_XJ_1(d0);
    d0->I = d0->J - d0->LimY + 1;
    d0->J++;
    d0->LimX++;
    generateD_IJ_Cut(d0);
  }
  else if(d0->I == d0->LimX && d0->LimX == d0->X && d0->J == d0->Y){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_XY_1(d0);
  }
  else if(d0->I == d0->X && d0->X < d0->LimX && d0->J < d0->LimY){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_XJ(d0);
    d0->I = 0;
    d0->J++;
    generateD_0J(d0);
  }
  else if(d0->I == d0->X && d0->X < d0->LimX && d0->J < d0->Y){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */
    dist_XJ(d0);
    d0->I = d0->J - d0->LimY + 1;
    d0->J++;
    generateD_IJ_Cut(d0);
  }
  else if(d0->I == d0->X && d0->X < d0->LimX && d0->J == d0->Y){
    /* printf("I = %d,J = %d\n",d0->I,d0->J); */      
    dist_XY(d0);
  }
  else {
    printf("generateD error\n");
    exit(1);
  }
}



