/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*  cost.c */

#include <stdio.h>
#include "aedit.h"

extern int send_left;

int calcCost(start,end)
int start, end;
{
  int i,j,k,cost, totalcost;

  Info.columnCostMax = -100000000;
  Info.columnCostMin =  100000000;

  for(i=0; i<Info.alignnum; ++i)  {
     for(j=i+1; j<Info.alignnum; ++j)  {
         Info.firstP[i][j] = TRUE;   /* FirstGap? about seq1 vs seq2 */
         Info.firstP[j][i] = TRUE;   /*                 seq2 vs seq1 */
/*          printf("i=%d,j=%d\n",i,j); */
     }
  }

  for(i=0; i<Info.alignnum; ++i)  {
     Info.outGapP[i] = TRUE;      /* OutGap? about seq i */
  }

  setOutGapPoints(start, end);

  totalcost=0;
  for(i=0; i<end - start + 1; ++i) {      
    for(j=0; j<Info.alignnum; ++j) {
      if(i>Info.endPos[j])          Info.outGapP[j] = TRUE;
      else if(i>=Info.startPos[j])  Info.outGapP[j] = FALSE;
    }
    for(j=0; j<Info.alignnum; ++j) {      
      for(k=j+1; k<Info.alignnum; ++k) {      
	cost = pairCost((int)Info.codeAlign[j][start+i],
			(int)Info.codeAlign[k][start+i],
			&Info.firstP[j][k], &Info.firstP[k][j],
			Info.outGapP[j],Info.outGapP[k]);
	totalcost += cost;
/*	printf("%d\n",cost);*/
      }
    }
/*    printf("T=%d\n",totalcost);*/
  }
  calc_column_cost(start,end);
  return totalcost;
}


static int pairCost(char1,char2,firstFlag1,firstFlag2,outgapFlag1,outgapFlag2)
int   char1, char2;
int  *firstFlag1, *firstFlag2;
int  outgapFlag1, outgapFlag2;
{
  int  cost;

#if	0
	(void)printf("UU, VV, SS , UUVV = %d %d %d %d\n",
		     UU, VV, SS , UUVV);
#endif

  if(isAmino(char1)  &&  isAmino(char2)) {
    if (NA_flag){
     cost = Nmatrix[char1][char2];
    }else{
     cost = Dmatrix[char1][char2];
    }
     *firstFlag1 = TRUE;
     *firstFlag2 = TRUE;
  }
  else if(isAmino(char1))  {  /* alignment2 is '-' or '#' etc */
     if(outgapFlag2)  cost = SS;  /* outgap - amino */
     else if(*firstFlag2)  {      /* first ingap - amino */
        cost = UUVV;  
        *firstFlag2 = FALSE;
     }
     else  cost = VV;           /* second ingap - amino */
     *firstFlag1 = TRUE;
  }
  else if(isAmino(char2))  { /* alignment1 is '-' or '#' etc */
     if(outgapFlag1)  cost = SS;  /* outgap - amino */
     else if(*firstFlag1)  {      /* first ingap - amino */
        cost = UUVV;  
        *firstFlag1 = FALSE;
     }
     else  cost = VV;           /* second ingap - amino */
     *firstFlag2 = TRUE;
  }
  else { /* both are '-' and/or '#' */
     if(outgapFlag1 && outgapFlag2)  cost = QQ;  /* outgap - outgap */
     else if(outgapFlag1)  { /* outgap - ingap */
        cost = PP;
     }
     else if(outgapFlag2)  { /* outgap - ingap */
        cost = PP;
     }
     else { /* ingap - ingap */
        cost = WW;
     }       
  }

  return cost;
}


static setOutGapPoints(start, end)
int start, end;
{
  int  i,j;
  
  for(i=0; i<Info.alignnum; ++i) {
    for(j=0; j<end - start + 1; ++j) {
      if(isAmino(Info.codeAlign[i][start+j]))   {
	Info.startPos[i] = j;
	break;
      }
    }
    
/*    for(j=Info.dataEndIndex - Info.dataStartIndex + 1; j>=0; --j) {*/
    for(j=end - start; j>=0; --j) {
/*      printf("%d",j);*/
      if(isAmino(Info.codeAlign[i][start+j]))   {
	Info.endPos[i] = j;
	break;
      }
    }
  }

/***
  for(i=0; i<Info.alignnum; ++i) {
      printf("Info.startPos[%d]=%d, Info.endPos[%d]=%d\n",
              i,Info.startPos[i], i, Info.endPos[i]);
  }
***/
}


/* calculate each column cost from start index to end index */
int calc_column_cost(start,end)
int start;   /* start index of array */
int end;     /* end   index of array */
{
  int i,j,k,index,cost;

  for(i=0, index=start; i<end-start+1; ++i,++index) {
     if (Result_draw){
         Calc_columnCost[start+i] = 0;
     }else{
         Info.columnCost[start+i] = 0;
     }
     for(j=0; j<Info.alignnum; ++j) {      
        for(k=j+1; k<Info.alignnum; ++k) {      
          if (Result_draw){
               cost = pairCostColumn(Calc_codeAlign[j][start+i],
                                     Calc_codeAlign[k][start+i]);
               Calc_columnCost[start+i] += cost; 
	  }else{
               cost = pairCostColumn(Info.codeAlign[j][start+i],
                                     Info.codeAlign[k][start+i]);
               Info.columnCost[start+i] += cost;
	  }
/*
           printf("in calc_cloumn_cost(),index=%d, index-Info.dispStartIndex=%d,cost=%d\n",
                   index, index-Info.dispStartIndex,cost);
*/
        }
     }
  }
}


static int pairCostColumn(char1,char2)
int   char1, char2;
{
  int  cost;

  if(isAmino(char1)  &&  isAmino(char2)) {
    if (NA_flag){
     cost = Nmatrix[char1][char2];
    }else{
     cost = Dmatrix[char1][char2];
    }
  }
  else
     cost = 0;

  return cost;
}


int calcCost_result()
{
  int i,j,k,cost, totalcost;

  Calc_columnCostMax = -100000000;
  Calc_columnCostMin =  100000000;

  for(i=0; i<Info.alignnum; ++i)  {
     for(j=i+1; j<Info.alignnum; ++j)  {
         Calc_firstP[i][j] = TRUE;   /* FirstGap? about seq1 vs seq2 */
         Calc_firstP[j][i] = TRUE;   /*                 seq2 vs seq1 */
/*          printf("i=%d,j=%d\n",i,j); */
     }
  }

  for(i=0; i<Info.alignnum; ++i)  {
     Calc_outGapP[i] = TRUE;      /* OutGap? about seq i */
  }

  setOutGapPoints_result();

  totalcost=0;
  for(i=0; i<New_calc_leng; ++i) {      
    for(j=0; j<Info.alignnum; ++j) {
      if(i>Calc_endPos[j])          Calc_outGapP[j] = TRUE;
      else if(i>=Calc_startPos[j])  Calc_outGapP[j] = FALSE;
    }
    for(j=0; j<Info.alignnum; ++j) {      
      for(k=j+1; k<Info.alignnum; ++k) {      
	cost = pairCost((int)Calc_codeAlign[j][send_left+i],
			(int)Calc_codeAlign[k][send_left+i],
			&Calc_firstP[j][k], &Calc_firstP[k][j],
			Calc_outGapP[j],Calc_outGapP[k]);
	totalcost += cost;
/*	printf("%d\n",cost);*/
      }
    }
/*    printf("T=%d\n",totalcost);*/
  }
  calc_column_cost_result(send_left,send_left+New_calc_leng-1);
  return totalcost;
}


static setOutGapPoints_result()
{
  int  i,j;
  
  for(i=0; i<Info.alignnum; ++i) {
    for(j=0; j<New_calc_leng; ++j) {
      if(isAmino(Calc_codeAlign[i][send_left+j]))   {
	Calc_startPos[i] = j;
	break;
      }
    }
    
/*    for(j=Info.dataEndIndex - Info.dataStartIndex + 1; j>=0; --j) {*/
    for(j=New_calc_leng-1; j>=0; --j) {
/*      printf("%d",j);*/
      if(isAmino(Calc_codeAlign[i][send_left+j]))   {
	Calc_endPos[i] = j;
	break;
      }
    }
  }

/***
  for(i=0; i<Info.alignnum; ++i) {
      printf("Info.startPos[%d]=%d, Info.endPos[%d]=%d\n",
              i,Info.startPos[i], i, Info.endPos[i]);
  }
***/
}

/* Calculate each column cost from start index to end index */
int calc_column_cost_result(start,end)
int start;   /* start index of array */
int end;     /* end   index of array */
{
  int i,j,k,index,cost;

  for(i=0, index=start; i<end-start+1; ++i,++index) {
     Calc_columnCost[start+i] = 0;
     for(j=0; j<Info.alignnum; ++j) {      
        for(k=j+1; k<Info.alignnum; ++k) {      
           cost = pairCostColumn(Calc_codeAlign[j][start+i],
                                 Calc_codeAlign[k][start+i]);
           Calc_columnCost[start+i] += cost; 
/*
           printf("in calc_cloumn_cost(),index=%d, index-Info.dispStartIndex=%d,cost=%d\n",
                   index, index-Info.dispStartIndex,cost);
*/
        }
     }
  }
}




