/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/* from Motif Manual */
#include <Xm/CascadeBG.h>
#include <Xm/CascadeB.h>
#include <Xm/PushBG.h>
#include <Xm/PushB.h>
#include <Xm/ToggleBG.h>
#include <Xm/ToggleB.h>

#include "menu.h"
#define  MENU_CHARSET "menuchset"

Widget XtAppInitialize();
Widget XtVaCreateManagedWidget();

Widget BuildMenu(fs,parent,menu_type,menu_title,menu_mnemonic,items)
XFontStruct  *fs;
Widget  parent;
int     menu_type;
char    *menu_title, menu_mnemonic;
MENUITEM *items;
{
	extern Pixel	pixel_black, pixel_wheat;
  Widget menu, cascade, widget;
  int    i;
  XmString xms;
  XmFontList  flist;
  Arg  args[2];

  flist = XmFontListCreate(fs,MENU_CHARSET);

  if(menu_type == XmMENU_PULLDOWN) {
     menu = (Widget)XmCreatePulldownMenu(parent,"_pulldown",NULL,0);
     xms = XmStringCreateLtoR(menu_title,MENU_CHARSET);
     cascade = XtVaCreateManagedWidget(menu_title,
                   xmCascadeButtonWidgetClass, parent,
                   XmNsubMenuId, menu,
                   XmNlabelString, xms,
                   XmNmnemonic, menu_mnemonic,
#if	0
		   XmNforeground, pixel_black,
		   XmNbackground, pixel_wheat,
		   XmNborderColor, pixel_wheat,
#endif
                   NULL);
     XmStringFree(xms);
  }
  else if(menu_type == XmMENU_OPTION) {
     /* Option menus are a special case, but not hard to handle */
     menu = (Widget)XmCreatePulldownMenu(parent,"_pulldown",NULL,0);
     xms = XmStringCreateLtoR(menu_title,MENU_CHARSET);
     XtSetArg(args[0],XmNsubMenuId, menu);
     XtSetArg(args[1],XmNlabelString, xms);
     /* This really isn't a cascade, but this is the widget handle
      * we're going to return at the end of the function.
      */
     cascade = (Widget)XmCreateOptionMenu(parent,menu_title,args,2);
     XmStringFree(xms);
  }
  else if(menu_type == XmMENU_POPUP) {
     menu = (Widget)XmCreatePopupMenu(parent,"_popup",NULL,0);
  }
  else {
     XtWarning("Invalid menu type passed to BuildMenu()");
     exit(1);
  }

  /* Now Add the menu items */
  for(i=0; items[i].label != NULL; ++i) {
     /* If subitems exist, create the pull-right menu by calling this
      * function recursively. Since the function returns a cascade
      * button, the widget returned is used.
      */
     if(items[i].subitems)
        widget = BuildMenu(fs,menu,XmMENU_PULLDOWN,
                   items[i].label, items[i].mnemonic, items[i].subitems);
     else {
	if (items[i].class == &xmPushButtonWidgetClass ||
	    items[i].class == &xmPushButtonGadgetClass   )
          widget = XtVaCreateManagedWidget(items[i].label, *items[i].class, menu, 
                     XmNfontList, flist,
#if	0
		     XmNforeground, pixel_black,
		     XmNbackground, pixel_wheat,
		     XmNarmColor, pixel_wheat,
#endif
                     NULL);
        else
          widget = XtVaCreateManagedWidget(items[i].label, *items[i].class, menu, 
                     XmNfontList, flist,
#if	0
		     XmNforeground, pixel_black,
		     XmNbackground, pixel_wheat,
#endif
                     NULL);
     }
     items[i].w = widget;

     if(items[i].mnemonic) {
        XtVaSetValues(widget,XmNmnemonic,items[i].mnemonic,NULL);
     }

     if(items[i].accelerator) {     
        xms = XmStringCreateLtoR(items[i].accel_text,MENU_CHARSET);
        XtVaSetValues(widget,
               XmNaccelerator, items[i].accelerator,
               XmNacceleratorText, xms,
               NULL);
        XmStringFree(xms);
     }
  
     if(items[i].callback)
        XtAddCallback(widget,
           (items[i].class==&xmToggleButtonWidgetClass ||
            items[i].class==&xmToggleButtonGadgetClass ) ?
            XmNvalueChangedCallback :   /* ToggleButton class */
            XmNactivateCallback,        /* PushButton class */
            items[i].callback, items[i].client_data );

     XtSetSensitive(widget,items[i].sensitive);

    if(items[i].class==&xmToggleButtonWidgetClass ||
       items[i].class==&xmToggleButtonGadgetClass )
       XtVaSetValues(widget,XmNset,items[i].set,
                            XmNindicatorType,items[i].indicatorType,
                            NULL);
  }


  /* popup menus     : return the menu; 
   * pulldown menu   : return the cascade button; 
   * option menu     : return the things returned from XmCreateOptionMenu().
   *                   This isn't a menu, or a cascade button.
   */
  XmFontListFree(flist);

  return (menu_type == XmMENU_POPUP? menu : cascade);
}


