/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	aep_mval.c
----------------------------------------------------------------------*/

#include	"aedit.h"

/*--------------------------------------------------------------------*/

#if	1
#define	CHECK
#endif

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

int
move_align_mval(alansrc, alandst)
int	alansrc, alandst;
{
	extern INFO	Info;
	int		i;
	char		*codealign;
	char		alname[MAX_ALIGN_NAME_LENG+1];
	int		mflag;
#ifdef	CHECK
	extern void	fatal_error();
#endif

#ifdef	DEBUG
	(void)printf("move_align_mval --- alansrc, alandst = %d %d\n", alansrc, alandst);
#endif

#ifdef	CHECK
	if ((alansrc < 0 || alansrc >= Info.alignnum) ||
	    (alandst < 0 || alandst >= Info.alignnum)   )
		fatal_error("move_align_mval",
			    "illegal data (alignnum, alansrc, alandst = %d %d %d)\n",
			    Info.alignnum, alansrc, alandst);
#endif

	if (alansrc < alandst) {
		(void)strncpy(alname,
			      (char *)(Info.alignname+alansrc),
			      MAX_ALIGN_NAME_LENG + 1);
		codealign = *(Info.codeAlign+alansrc);
		for (i = alansrc; i < alandst; i++) {
			(void)strncpy((char *)(Info.alignname+i),
				      (char *)(Info.alignname+i+1),
				      MAX_ALIGN_NAME_LENG + 1);
			*(Info.codeAlign+i) = *(Info.codeAlign+i+1);
		}
		(void)strncpy((char *)(Info.alignname+alandst),
			      alname,
			      MAX_ALIGN_NAME_LENG + 1);
		*(Info.codeAlign+alandst) = codealign;
		mflag = 1;
	}
	else if (alansrc > alandst) {
		(void)strncpy(alname,
			      (char *)(Info.alignname+alansrc),
			      MAX_ALIGN_NAME_LENG + 1);
		codealign = *(Info.codeAlign+alansrc);
		for (i = alansrc; i > alandst; i--) {
			(void)strncpy((char *)(Info.alignname+i),
				      (char *)(Info.alignname+i-1),
				      MAX_ALIGN_NAME_LENG + 1);
			*(Info.codeAlign+i) = *(Info.codeAlign+i-1);
		}
		(void)strncpy((char *)(Info.alignname+alandst),
			      alname,
			      MAX_ALIGN_NAME_LENG + 1);
		*(Info.codeAlign+alandst) = codealign;
		mflag = 1;
	}
	else
		mflag = 0;

	return mflag;
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
