/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	aep_motif.c
----------------------------------------------------------------------*/

#include	<string.h>
#include	<malloc.h>
#include	<sys/types.h>
#include	<sys/stat.h>

#include	"aedit.h"
#include	"ae_motif.h"

/*--------------------------------------------------------------------*/

static char	now_title[MAX_BUFF_MOTIF];	/* оݤȤƤ
						   դΥȥ
						   ʥ̡ */
static char	now_pattern[MAX_BUFF_MOTIF];	/* оݤȤƤ
						   դΥѥ
						   ʥ̡ */
static char	now_amino[MAX_NUM_PATTERN][MAX_NUM_PATTERN];
						/* оݤȤƤ
						   դΥ
						   ߥλ̾ */
static Bool	now_forbidden[MAX_NUM_PATTERN];	/* оݤȤƤ
						   դΥ
						   §ե饰 */
static Bool	now_others[MAX_NUM_PATTERN];	/* оݤȤƤ
						   դΥ
						   Ǥեե饰 */
static int	now_min[MAX_NUM_PATTERN];	/* оݤȤƤ
						   դΥ
						   Ǿ */
static int	now_max[MAX_NUM_PATTERN];	/* оݤȤƤ
						   դΥ
						   祵 */
static int	now_index[MAX_NUM_PATTERN];	/* оݤȤƤ
						   դƬΥ
						   ̥饤
						   ǥå */
static int	now_tail[MAX_NUM_PATTERN];	/* оݤȤƤ
						   դ    Υ
						   ̥饤
						   ǥå */
static int	now_repeat[MAX_NUM_PATTERN];	/* оݤȤƤ
						   դΥ
						   ֤ */
static Bool	now_alrpflag[MAX_ALIGN];	/* 饤ȹ
						   󡦥ե饰
						   ʳ) */

/*--------------------------------------------------------------------*/

#if	1
#define	CHECK
#endif

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

void
set_mtfptrn_file(dictpathname)
char	*dictpathname;
{
	extern int	dict_mode;
	char		command[BUFSIZ];
	struct stat	mtfdict, mtfptrn;
	char		*tmpfilename;
	int		r;
	extern void	fatal_error();
	void		create_mtfptrn_file();

	if (stat(dictpathname, &mtfdict))
		fatal_error("set_mtfptrn_file", "stat error (%s)\n", dictpathname);

	if (dict_mode == DICT_MODE_PROSITE) {
		tmpfilename = "ae_prosite.tmp";
		r = stat("ae_prosite.mtf", &mtfptrn);
	}
	else if (dict_mode == DICT_MODE_USER) {
		tmpfilename = "ae_user.tmp";
		r = stat("ae_user.mtf", &mtfptrn);
	}
	else
		fatal_error("set_mtfptrn_file", "illegal dict_mode (%d)\n", dict_mode);

	if (r || mtfdict.st_mtime > mtfptrn.st_mtime){
		(void)sprintf(command,
			      "egrep '^//$|^DE   |^PA   ' %s > %s",
			      dictpathname, tmpfilename);
		system(command);
		create_mtfptrn_file();
	}
}

/*
  ae_prosite.tmp  ae_prosite.mtf κ
ޤ ae_user.tmp  ae_user.mtf κ
*/

void
create_mtfptrn_file()
{
	extern int	dict_mode;
	FILE		*fpt, *fpm;
	char		str[MAX_BUFF_MOTIF];
	char		strde[MAX_BUFF_MOTIF];
	char		strpa[MAX_BUFF_MOTIF];
	extern void	fatal_error();
	void		put_mtfptrn_file();

	int previous = '/';

	if (dict_mode == DICT_MODE_PROSITE) {
		if ((fpt = fopen("ae_prosite.tmp", "r")) == (FILE *)NULL)
			fatal_error("create_mtfptrn_file",
				    "fopen error (ae_prosite.tmp)\n");
		if ((fpm = fopen("ae_prosite.mtf", "w")) == (FILE *)NULL)
			fatal_error("create_mtfptrn_file",
				    "fopen error (ae_prosite.mtf)\n");
	}
	else if (dict_mode == DICT_MODE_USER) {
		if ((fpt = fopen("ae_user.tmp", "r")) == (FILE *)NULL)
			fatal_error("create_mtfptrn_file",
				    "fopen error (ae_user.tmp)\n");
		if ((fpm = fopen("ae_user.mtf", "w")) == (FILE *)NULL)
			fatal_error("create_mtfptrn_file",
				    "fopen error (ae_user.mtf)\n");
	}
	else
		fatal_error("create_mtfptrn_file",
			    "illegal dict_mode (%d)\n",
			    dict_mode);

	strde[0] = strpa[0] = '\0';
	while (fgets(str, MAX_BUFF_MOTIF, fpt) != NULL) {
		if (!strncmp(str, "//", 2)) {
			if (strde[0] != '\0' && strpa[0] != '\0') {
				(void)fprintf(fpm, strde);
				(void)fprintf(fpm, strpa);
				put_mtfptrn_file(fpm, strpa);
				(void)fprintf(fpm, "//\n");
			}
			strde[0] = strpa[0] = '\0';
			previous = '/';
		}
		else if (!strncmp(str, "DE", 2)) {
			if (previous == 'D') {
				sprintf(strchr(strde, '\n'), &str[5]);
			}
			else {
				sprintf(strde, &str[5]);
			}
			previous = 'D';
		}
		else if (!strncmp(str, "PA", 2)) {
			if (previous == 'P') {
				sprintf(strchr(strpa,'\n'), &str[5]);	        
			}
			else {
				sprintf(strpa, &str[5]);
			}
			previous = 'P';
		}
	}

	if (fclose(fpt) == EOF)
		fatal_error("create_mtfptrn_file", "fclose error (fpt)\n");
	if (fclose(fpm) == EOF)
		fatal_error("create_mtfptrn_file", "fclose error (fpm)\n");
}

/*
  ae_prosite.mtf ޤ ae_user.mtf κ
*/

void
put_mtfptrn_file(fpm, strpa)
FILE	*fpm;
char	*strpa;
{
	char	*p;
	char	amino[MAX_BUFF_MOTIF];
	char	num[MAX_BUFF_MOTIF];
	int	min, max;
	Bool	fbflag, otflag;

	p = strpa;

	amino[0] = num[0] = '\0';
	min = max = -1;
	fbflag = False;
	otflag = False;

	while(*p != '.') {
		switch (*p) {
		    case '{':
			fbflag = True;
			break;
		    case 'x':
			otflag = True;
/*
			(void)strcpy(amino, "x");
*/
			break;
		    case '(':
			num[0] = '\0';
			break;
		    case ')':
			max = atoi(num);
			if (min < 0)
				min = max;
			break;
		    case ',':
			min = atoi(num);
			num[0] = '\0';
			break;
		    case '-':
			if (min < 0 && max < 0)
				min = max = 1;
			else if (min >= 0 && max >=0)
				;
			else
				fatal_error("put_mtfptrn_file",
					    "illegal minimum or maximum (%d %d)\n",
					    min, max);
			(void)fprintf(fpm,
				      "%s\n%d\n%d\n%d\n%d\n",
				      amino, fbflag, otflag, min, max);
			amino[0] = num[0] = '\0';
			min = max = -1;
			fbflag = False;
			otflag = False;
			break;
		    default:
			if (*p >= '0' && *p <= '9')
				strncat(num, p, 1);
			else if (*p >= 'A' && *p <= 'Z')
				strncat(amino, p, 1);
			else if (*p == '[' || *p == ']' ||
				 *p == '}' ||
				 *p == '<' || *p == '>' ||
				 *p == '.'                )
				;
			else
				fatal_error("put_mtfptrn_file",
					    "illegal pattern data (%c %d)\n",
					    *p, *p);
		}
		p++;
	}

	if (min < 0 && max < 0)
		min = max = 1;
	else if (min >= 0 && max >=0)
		;
	else
		fatal_error("put_mtfptrn_file",
			    "illegal minimum or maximum (%d %d)\n",
			    min, max);
	(void)fprintf(fpm,
		      "%s\n%d\n%d\n%d\n%d\n",
		      amino, fbflag, otflag, min, max);
}

/*--------------------------------------------------------------------*/

void
set_mtfcol_flag()
{
	extern int	search_mode;
	extern INFO	Info;
	extern Bool	mtfcol_flag[MAX_ALIGN_LENG];
	extern char	Char1[128];
	extern int	motif_cut;
	int		i, j;
	int		nacnt;
	char		c;
	extern void	fatal_error();

	if (search_mode == SEARCH_MODE_1) {
		for (i = Info.dataStartIndex; i <= Info.dataEndIndex; i++)
			*(mtfcol_flag+i) = True;
	}
	else if (search_mode == SEARCH_MODE_2) {
		for (i = Info.dataStartIndex; i <= Info.dataEndIndex; i++) {
			nacnt = 0;
			for (j = 0; j < Info.alignnum; j++) {
				c = *(Char1+*(*(Info.codeAlign+j)+i));
				if (c >= 'A' && c <= 'Z')
					nacnt++;
			}
#if	0
			(void)printf("i, nacnt = %d %d\n", i, nacnt);
#endif
			if (nacnt > 0 &&
			    100.0 * (float)nacnt / Info.alignnum >= (float)motif_cut)
				*(mtfcol_flag+i) = True;
			else
				*(mtfcol_flag+i) = False;
#if	0
			(void)printf("set_mtfcol_flag --- mtfcol_flag[%d] = %d\n", i, *(mtfcol_flag+i));
#endif
		}
	}
	else
		fatal_error("set_mtfcol_flag", "illegal search mode (%d)\n",
			    search_mode);
}

static int
get_nth_mtfcol_order(start, nth, end)
int	start;
int	nth;
int	*end;
{
	extern INFO	Info;
	extern Bool	mtfcol_flag[MAX_ALIGN_LENG];
	int		flag;
	int		mtfcolcnt;
	int		i;

#ifdef	CHECK
	if ((start < Info.dataStartIndex ||
	     start > Info.dataEndIndex     ) ||
	    nth <= 0                           )
		fatal_error("get_nth_mtfcol_order",
			    "illegal start and nth (%d, %d)\n",
			    start, nth);
#endif

	*end = 0;
	flag = 0;

	for (mtfcolcnt = 0, i = start; i <= Info.dataEndIndex; i++) {
		if (*(mtfcol_flag+i) == True) {
			mtfcolcnt++;
			if (mtfcolcnt >= nth) {
				*end = i;
				flag = 1;
				break;
			}
		}
	}

/*
(void)printf("get_nth_mtfcol_order --- start, nth, *end, flag = %d %d %d %d\n",
	     start, nth, *end, flag);
*/

	return flag;
}

static int
get_nth_mtfcol_reverse(start, nth, end)
int	start;
int	nth;
int	*end;
{
	extern INFO	Info;
	extern Bool	mtfcol_flag[MAX_ALIGN_LENG];
	int		flag;
	int		mtfcolcnt;
	int		i;

#ifdef	CHECK
	if ((start < Info.dataStartIndex ||
	     start > Info.dataEndIndex     ) ||
	    nth <= 0                           )
		fatal_error("get_nth_mtfcol_reverse",
			    "illegal start and nth (%d, %d)\n",
			    start, nth);
#endif

	*end = 0;
	flag = 0;

	for (mtfcolcnt = 0, i = start; i >= Info.dataStartIndex; i--) {
		if (*(mtfcol_flag+i) == True) {
			mtfcolcnt++;
			if (mtfcolcnt >= nth) {
				*end = i;
				flag = 1;
				break;
			}
		}
	}

/*
(void)printf("get_nth_mtfcol_reverse --- start, nth, *end, flag = %d %d %d %d\n",
	     start, nth, *end, flag);
*/

	return flag;
}

/*--------------------------------------------------------------------*/

void
create_mtfptrn_data()
{
	extern int	dict_mode;
	FILE		*fp;
	Bool		hdflag = True;
	int		datanum, segcnt;
	char		*p;
	char		readbuff[MAX_BUFF_MOTIF];
	extern void	fatal_error();
	void		search_mtfptrn_data();
#if	0
	void		output_motif_root_l();
#endif

	segcnt = 0;
	if (dict_mode == DICT_MODE_PROSITE) {
		if ((fp = fopen("ae_prosite.mtf", "r")) == (FILE *)NULL)
			fatal_error("create_mtfptrn_data",
				    "fopen error (ae_prosite.mtf)\n");
	}
	else if (DICT_MODE_USER) {
		if ((fp = fopen("ae_user.mtf", "r")) == (FILE*)NULL)
			fatal_error("create_mtfptrn_data",
				    "fopen error (ae_user.mtf)\n");
	}
	else
		fatal_error("create_mtfptrn_data",
			    "illegal dict_mode (%d)\n",
			    dict_mode);

	datanum = 0;
	segcnt= 0;
	while (fgets(readbuff, MAX_BUFF_MOTIF, fp) != NULL) { 
		datanum++;
		if (!strncmp(readbuff, "//", 2)) {
			search_mtfptrn_data(segcnt);
			hdflag = True;
			datanum = 0;
			segcnt = 0;
		}
		if (hdflag) {
		    switch (datanum) {
			case 0:
			    break;
			case 1:
			    if ((p = strrchr(readbuff, '\n'))!= (char *)NULL)
				*p = '\0';
			    (void)strcpy(now_title, readbuff);
			    break;
			case 2:
			    if ((p = strrchr(readbuff, '\n'))!= (char *)NULL)
				*p = '\0';
			    (void)strcpy(now_pattern, readbuff);
			    hdflag = False;
			    datanum = 0;
			    break;
			default:
			    fatal_error("create_mtfptrn_data",
					"illegal datanum (head) (%d)\n",
					datanum);
		    }
		}
		else {
		    switch (datanum) {
			case 1:
			    (void)strcpy(&now_amino[segcnt][0], readbuff);
			    break;
			case 2:
			    now_forbidden[segcnt] = (Bool)atoi(readbuff);
			    break;
			case 3:
			    now_others[segcnt] = (Bool)atoi(readbuff);
			    break;
			case 4:
			    now_min[segcnt] = atoi(readbuff);
			    break;
			case 5:
			    now_max[segcnt] = atoi(readbuff);
			    datanum = 0;
			    segcnt++;
			    break;
			default:
			    fatal_error("create_mtfptrn_data",
					"illegal datanum (not head) (%d)/n",
					datanum);
		    }
		}
	}

	if (fclose(fp) == EOF)
		fatal_error("create_mtfptrn_data", "fclose error (fp)\n");

#if	0
	output_motif_root_l();
#endif
}

/*--------------------------------------------------------------------*/

/*
  դθ
*/

void
search_mtfptrn_data(sgcnt)
int sgcnt;	/* I:ѥΥȿ */
{
	extern void	fatal_error();
	void		search_mtfptrn_r_data();

#ifdef	DEBUG
	(void)printf("search_mtfptrn_data --- in\n");
	(void)printf("search_mtfptrn_data --- segcnt = %d\n", sgcnt);
#endif

#ifdef	CHECK
	if (sgcnt <=  0)
		fatal_error("search_mtfptrn_data",
			    "illegal sgcnt (%d)\n",
			    sgcnt);
#endif

	search_mtfptrn_r_data(sgcnt, 0);
}

/*
  աѥηʺƵ
*/

static void
search_mtfptrn_r_data(sgcnt, sgaid)
int	sgcnt;	/* I:ѥΥȿ */
int	sgaid;	/* I:ѥ󡦥Υǥå */
{
	extern Bool	mtfcol_flag[MAX_ALIGN_LENG];
	int		end;
	int		i, j;
	int		tail;
	int		deflag;
	extern void	fatal_error();
	int		check_mtfptrn_data();
	int		get_nth_mtfcol_reverse();
	int		get_nth_mtfcol_order();
	void		add_motif_data();

#ifdef	DEBUG
	(void)printf("search_mtfptrn_r_data --- sgcnt, sgaid = %d %d\n", sgcnt, sgaid);
#endif

	if (sgaid < sgcnt) {
	    for (i = *(now_min+sgaid); i <= *(now_max+sgaid); i++) {
		*(now_repeat+sgaid) = i;
		search_mtfptrn_r_data(sgcnt, sgaid + 1);
	    }
	}
	else if (sgaid == sgcnt) {
	    (void)get_nth_mtfcol_reverse(Info.dataEndIndex, 1, &end);
#ifdef	DEBUG
(void)printf("end = %d\n", end);
#endif
	    for (i = Info.dataStartIndex; i <= Info.dataEndIndex; i++) {
		if (*(mtfcol_flag+i) != True)
		    continue;
		tail = i - 1;
		deflag = 0;
		for (j = 0; j < sgcnt; j++) {
#ifdef	DEBUG
(void)printf("i, j = %d %d\n", i, j);
(void)printf("tail = %d\n", tail);
#endif
/*
		    if (tail >= Info.dataEndIndex) {
*/
		    if (tail >= end) {
#ifdef	DEBUG
(void)printf("pass 1\n");
#endif
			if (*(now_repeat+j) <= 0) {
#ifdef	DEBUG
(void)printf("pass 11\n");
#endif
			    *(now_index+j) = Info.dataEndIndex;
			    *(now_tail+j) = Info.dataEndIndex;
			}
			else {
#ifdef	DEBUG
(void)printf("pass 12\n");
#endif
			    deflag = 1;
			    break;
			}
		    }
		    else {
#ifdef	DEBUG
(void)printf("pass 2\n");
#endif
			if (!get_nth_mtfcol_order(tail + 1,
						  1,
						  now_index + j)) {
#ifdef	DEBUG
(void)printf("pass 21\n");
#endif
			    deflag = 1;
			    break;
			}
			if (*(now_repeat+j) <= 0) {
#ifdef	DEBUG
(void)printf("pass 221\n");
#endif
			    *(now_tail+j) = *(now_index+j);
			}
			else {
#ifdef	DEBUG
(void)printf("pass 222\n");
#endif
			    if (!get_nth_mtfcol_order(*(now_index+j),
						      *(now_repeat+j),
						      now_tail + j)) {
#ifdef	DEBUG
(void)printf("pass 2221\n");
#endif
				deflag = 1;
				break;
			    }
			    tail = *(now_tail+j);
			}
		    }
		}
#ifdef	DEBUG
(void)printf("deflag = %d\n", deflag);
#endif
		if (deflag)
		    break;
		for (j = 0; j < Info.alignnum; j++)
		    *(now_alrpflag+j) = True;
		if (check_mtfptrn_data(sgcnt)) {
#ifdef	DEBUG
(void)printf("pass 3\n");
#endif
		    add_motif_data(sgcnt);
		}
	    }
	}
	else
		fatal_error("search_mtfptrn_r_data", "sgcnt, sgaid = %d %d\n",
			    sgcnt, sgaid);
}

/*
  ѥΥåʸ
*/

static int
check_mtfptrn_data(sgcnt)
int	sgcnt;		/* I:ѥΥȿ */
{
	extern INFO	Info;
	int		pflag;
	int		i;
	extern void	fatal_error();
	int		check_mtfptrn_f_data();
	int		check_mtfptrn_o_data();
	int		check_mtfptrn_m_data();
#if	0
	void		output_now_segment();

	output_now_segment(sgcnt);
#endif

#ifdef	DEBUG
	(void)printf("check_mtfptrn_data --- in (sgcnt = %d)\n", sgcnt);
#endif

	for (pflag = 1, i = 0; i < sgcnt; i++) {
#ifdef	CHECK
	    if (*(now_index+i) + *(now_repeat+i) - 1 > Info.dataEndIndex)
		fatal_error("check_mtfptrn_data",
			    "pattern out of Info.dataEndIndex\n");
#endif
	    if (*(now_forbidden+i) == True &&
		*(now_others+i) == False     ) {
		if (*(now_repeat+i) > 0) {
		    if (!check_mtfptrn_f_data(*(now_index+i), *(now_tail+i), i)) {
			pflag = 0;
			break;
		    }
		}
	    }
	    else if (*(now_forbidden+i) == False &&
		     *(now_others+i) == True       ) {
		if (*(now_repeat+i) > 0) {
		    if (!check_mtfptrn_o_data(*(now_index+i), *(now_tail+i), i)) {
			pflag = 0;
			break;
		    }
		}
	    }
	    else if (*(now_forbidden+i) == False &&
		     *(now_others+i) == False      ) {
		if (*(now_repeat+i) > 0) {
		    if (!check_mtfptrn_m_data(*(now_index+i), *(now_tail+i), i)) {
			pflag = 0;
			break;
		    }
		}
	    }
	    else
		fatal_error("check_mtfptrn_data",
			    "now_forbidden and now_others illegal i = %d\n",
			    i);
	}

	return pflag;
}

/*
  §ѥΥåʸ
*/

static int
check_mtfptrn_f_data(head, tail, sgaid)
int	head;	/* I:饤ƬΥǥå */
int	tail;	/* I:饤Υǥå */
int	sgaid;	/* I:ѥ󡦥Υǥå */
{
	extern INFO	Info;
	extern Bool	mtfcol_flag[MAX_ALIGN_LENG];
	extern char	Char1[128];
	extern int	motif_cut;
	int		pcount;
	int		pflag;
	int		i, j;

#if	0
(void)printf("check_mtfptrn_f_data --- (forbidden) head, tail = %d %d\n", head, tail);
#endif

	for (pcount = 0, i = 0; i < Info.alignnum; i++) {
		if (*(now_alrpflag+i) != True)
			continue;
		for (pflag = 1, j = head; j <= tail; j++) {
			if (*(mtfcol_flag+j) != True)
				continue;
#if	0
(void)printf("check_mtfptrn_f_data --- *(Char1+*(*(Info.codeAlign+i)+j)) = %c\n",
	     Char1[*(*(Info.codeAlign+i)+j)]);
#endif
			if (strchr((char *)(now_amino+sgaid),
				   *(Char1+*(*(Info.codeAlign+i)+j)))
				!= (char *)NULL) {
				pflag = 0;
				break;
			}
		}
		if (pflag)
			pcount++;
		else
			*(now_alrpflag+i) = False;
	}

#if	0
	(void)printf("check_mtfptrn_f_data --- pcount = %d\n", pcount);
#endif

	if (pcount > 0							    &&
	    100.0 * (float)pcount / (float)Info.alignnum >= (float)motif_cut  )
		pflag = 1;
	else
		pflag = 0;

	return pflag;
}

/*
  ǤեѥΥåʸ
*/

/*ARGSUSED*/
static int
check_mtfptrn_o_data(head, tail, sgaid)
int	head;	/* I:饤ƬΥǥå */
int	tail;	/* I:饤Υǥå */
int	sgaid;	/* I:ѥ󡦥Υǥå */
{
	return 1;
}

/*
  աѥΥåʸ
*/

static int
check_mtfptrn_m_data(head, tail, sgaid)
int	head;	/* I:饤ƬΥǥå */
int	tail;	/* I:饤Υǥå */
int	sgaid;	/* I:ѥ󡦥Υǥå */
{
	extern INFO	Info;
	extern Bool	mtfcol_flag[MAX_ALIGN_LENG];
	extern char	Char1[128];
	extern int	motif_cut;
	int		pcount;
	int		pflag;
	int		i, j;

#if	0
(void)printf("check_mtfptrn_m_data --- (motif) head, tail = %d %d\n", head, tail);
#endif

	for (pcount = 0, i = 0; i < Info.alignnum; i++) {
		if (*(now_alrpflag+i) != True)
			continue;
		for (pflag = 1, j = head; j <= tail; j++) {
			if (*(mtfcol_flag+j) != True)
				continue;
#if	0
(void)printf("check_mtfptrn_m_data --- *(Char1+*(*(Info.codeAlign+i)+j)) = %c\n",
	     *(Char1+*(*(Info.codeAlign+i)+j)));
#endif
			if (strchr((char *)(now_amino+sgaid),
				   *(Char1+*(*(Info.codeAlign+i)+j)))
				== (char *)NULL) {
				pflag = 0;
				break;
			}
		}
		if (pflag)
			pcount++;
		else
			*(now_alrpflag+i) = False;
	}

#if	0
	(void)printf("check_mtfptrn_m_data --- pcount = %d\n", pcount);
#endif

	if (pcount > 0							    &&
	    100.0 * (float)pcount / (float)Info.alignnum >= (float)motif_cut  )
		pflag = 1;
	else
		pflag = 0;

	return pflag;
}

/*--------------------------------------------------------------------*/

/*
  ʣդθ
*/

Bool
check_overlap_mtfptrn_data()
{
	extern Motif	*Motif_root;
	extern Motif	*p_motif;
	extern Motif	*p_ovl[MAX_NUM_PATTERN];
	extern	int	ovl_cnt;
	int		head, tail;
	Motif		*pm;

	head = p_motif->head;
	tail = p_motif->tail;

#if	0
	(void)printf("check_overlap_mtfptrn_data --- head, tail = %d %d\n",
		     head, tail);
#endif

	pm = Motif_root;
	ovl_cnt = 0;
	while (pm != (Motif *)NULL) {
		if (pm == p_motif) {
			pm = pm->p_next;
			continue;
		}
#if	0
	(void)printf("check_overlap_mtfptrn_data --- pm->head, pm->tail = %d %d\n",
		     pm->head, pm->tail);
#endif
		if (pm->head <= tail && pm->tail >= head) {
			p_ovl[ovl_cnt] = pm;
			ovl_cnt++;
#if	0
	(void)printf("check_overlap_mtfptrn_data --- ovl_cnt = %d\n", ovl_cnt);
#endif
		}
		pm = pm->p_next;
	}

	if (ovl_cnt > 0)
		return True;
	else
		return False;
}

/*--------------------------------------------------------------------*/

/*
  աǡ˥դϿ
  pending	recursive
*/

void
add_motif_data(segcnt)
int	segcnt;	/* ȿ */
{
	extern Motif	*Motif_root;
	Motif		*pmn, *pmo;
	Segment		*psn, *pso;
	Bool		fflag = True;
	int		i;
	int		count;

	pmn = Motif_root;
	pmo = Motif_root;

	count = 0;

	while (pmn != NULL) {
		count++;
		pmo = pmn;
		pmn = pmn->p_next;
	}

	if((pmn = (Motif *)calloc(1, sizeof(Motif))) == NULL)
		fatal_error("add_motif", "calloc error (Motif)\n");

	if (count == 0)
		Motif_root = pmn;
	else
		pmo->p_next = pmn;

	pmn->p_next = NULL;

	(void)strcpy(pmn->title, now_title);
	(void)strcpy(pmn->pattern, now_pattern);

	for (i = 0; i < Info.alignnum; i++)
		pmn->alrpflag[i] = now_alrpflag[i];

	pmn->segment_count = segcnt; 

	pso = (Segment *)NULL;
	for (i = 0; i < segcnt; i++) {
		if((psn = (Segment *)calloc(1, sizeof(Segment))) == (Segment *)NULL)
			fatal_error("add_motif", "calloc error (Segment)\n");
		if (fflag) {
			pmn->p_head_seg = psn;
			fflag = False;
		}
		else
			pso->p_next_seg = psn;
		psn->p_next_seg = NULL;
		(void)strcpy(psn->amino, &now_amino[i][0]);
		psn->forbidden = now_forbidden[i];
		psn->others = now_others[i];
		psn->min = now_min[i];
		psn->max = now_max[i];
		psn->repeat = now_repeat[i];
		psn->index = now_index[i];
		psn->tail = now_tail[i];
		pso = psn;
		if (i == 0)
			pmn->head = psn->index;
		else if (i == segcnt - 1)
			pmn->tail = psn->tail;
	}
}

/*--------------------------------------------------------------------*/

/*
  աǡդ
*/

void
delete_motif_data()
{
	extern Motif	*p_motif;
	extern Motif	*Motif_root;
	Motif		*pmn, *pmo;
	Segment		*psn, *pso;

	pmn = Motif_root;
	pmo = Motif_root;

	while (pmn != (Motif *)NULL) {
		pmo = pmn;
		psn = pmn->p_head_seg;
		while (psn != (Segment *)NULL){
			pso = psn;
			psn = psn->p_next_seg;
			free((char *)pso);
		}
		pmn = pmn->p_next;
		free((char *)pmo);
	}
	Motif_root = (Motif *)NULL;
	p_motif = (Motif *)NULL;
}

/*--------------------------------------------------------------------*/

/*
  ߤΥѥ󡦥ν
*/

void
output_now_segment(sgcnt)
int	sgcnt;	/* I:ѥΥȿ */
{
	extern INFO	Info;
	char		buf[MAX_BUFF_MOTIF];
	char		*p;
	int		i;
	extern void	fatal_error();

	(void)printf("***** now_segment (start) *****\n");

	(void)strncpy(buf, now_title, MAX_BUFF_MOTIF);
	p = strchr(buf, '\n');
	if (p == (char *)NULL)
		fatal_error("output_now_segment", "p == (char *)NULL (title)");
	*p = '\0';
	(void)printf("now_title = %s\n", buf);
	(void)strncpy(buf, now_pattern, MAX_BUFF_MOTIF);
	p = strchr(buf, '\n');
	if (p == (char *)NULL)
		fatal_error("output_now_segment", "p == (char *)NULL (pattern)");
	*p = '\0';
	(void)printf("now_pattern = %s\n", buf);

	for (i = 0; i < Info.alignnum; i++)
		(void)printf("now_alrpflag[%d] = %d\n", i, *(now_alrpflag+i));

	for (i = 0; i < sgcnt; i++) {
		(void)strncpy(buf, (char *)(now_amino+i), MAX_NUM_PATTERN);
		p = strchr(buf, '\n');
		if (p == (char *)NULL)
			fatal_error("output_now_segment", "p == (char *)NULL (amino)");
		*p = '\0';
		(void)printf("now_amino[%d] = %s\n", i, buf);
		(void)printf("now_forbidden[%d] = %d\n", i, *(now_forbidden+i));
		(void)printf("now_others[%d] = %d\n", i, *(now_others+i));
		(void)printf("now_min[%d] = %d\n", i, *(now_min+i));
		(void)printf("now_max[%d] = %d\n", i, *(now_max+i));
		(void)printf("now_repeat[%d] = %d\n", i, *(now_repeat+i));
		(void)printf("now_index[%d] = %d\n", i, *(now_index+i));
		(void)printf("now_tail[%d] = %d\n", i, *(now_tail+i));
	}

	(void)printf("***** now_segment (end) *****\n");
}

/*
  աꥹȤΥ롼Ȥν
*/

void
output_motif_root_l()
{
	extern Motif	*Motif_root;
	void		output_motif_l();

	(void)printf("***** Motif_root (start) *****\n");

	output_motif_l(Motif_root);

	(void)printf("***** Motif_root (end) *****\n");
}

/*
  աꥹȤν
*/

void
output_motif_l(motif)
Motif	*motif;	/* I: */
{
	extern INFO	info;
	char		buf[MAX_BUFF_MOTIF];
	char		*p;
	int		i;
	extern void	fatal_error();
	void		output_segment_l();

	if (motif != (Motif *)NULL) {
		(void)printf("p_next = %u\n", motif->p_next);
		(void)strncpy(buf, motif->title, MAX_BUFF_MOTIF);
		p = strchr(buf, '\n');
		if (p == (char *)NULL)
			fatal_error("output_motif_l", "p == (char *)NULL (title)");
		*p = '\0';
		(void)printf("title = %s\n", buf);
		(void)strncpy(buf, motif->pattern, MAX_BUFF_MOTIF);
		p = strchr(buf, '\n');
		if (p == (char *)NULL)
			fatal_error("output_motif_l", "p == (char *)NULL (pattern)");
		*p = '\0';
		(void)printf("pattern = %s\n", buf);
		for (i = 0; i < Info.alignnum; i++)
			(void)printf("alrpflag[%d] = %d\n",
				     i, motif->alrpflag[i]);
		(void)printf("segment_count = %d\n", motif->segment_count);
		(void)printf("p_head_seg = %u\n", motif->p_head_seg);
		output_segment_l(motif->p_head_seg);
		(void)printf("head = %d\n", motif->head);
		(void)printf("tail = %d\n", motif->tail);
		output_motif_l(motif->p_next);
	}
}

/*
  ѥ󡦥ȡꥹȤν
*/

void
output_segment_l(segment)
Segment	*segment;	/* I:ѥ󡦥 */
{
	char		buf[MAX_NUM_PATTERN];
	char		*p;
	extern void	fatal_error();

	if (segment != (Segment *)NULL) {
		(void)printf("p_next_seg = %u\n", segment->p_next_seg);
		(void)strncpy(buf, segment->amino, MAX_NUM_PATTERN);
		p = strchr(buf, '\n');
		if (p == (char *)NULL)
			fatal_error("output_segment_l", "p == (char *)NULL (amino)");
		*p = '\0';
		(void)printf("amino = %s\n", buf);
		(void)printf("forbidden = %d\n", segment->forbidden);
		(void)printf("others = %d\n", segment->others);
		(void)printf("min = %d\n", segment->min);
		(void)printf("max = %d\n", segment->max);
		(void)printf("repeat = %d\n", segment->repeat);
		(void)printf("index = %d\n", segment->index);
		(void)printf("tail = %d\n", segment->tail);
		output_segment_l(segment->p_next_seg);
	}
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
