/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	aeg_mval.c
----------------------------------------------------------------------*/

#include	<X11/Xlib.h>
#include	<X11/Xutil.h>
#include	<X11/Intrinsic.h>

#include	"aedit.h"
#include	"aeg_comdef.h"

/*--------------------------------------------------------------------*/

#define	COLOR_BS	"skyblue"
#define	COLOR_MV	"yellow"

/*--------------------------------------------------------------------*/

static int		proc_mode = 0;

static int		first_flag = 0;

static int		alan_src, alan_dst;	/* array number */
static int		x_src, y_src, x_dst, y_dst;
static unsigned int	width_src, height_src, width_dst, height_dst;

static GC		gc_src, gc_dst;

static Pixel		pixel_src, pixel_dst;

/*--------------------------------------------------------------------*/

#if	1
#define	CHECK
#endif

#if	0
#define	SLEEP
#endif

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
void
button_press_mval(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	extern int	data_exist;
	extern Widget	da;
	extern GC	DrawBackGC;
	int		x, y;
	unsigned int	width, height;
	int		get_align();
	extern Pixel	get_default_color_pixel();
	void		display_alname_mval();

	if (!data_exist)
		return;

	if (get_align(event->x, event->y,
		      &alan_src, &x, &y, &width, &height)) {
		alan_dst = alan_src;
		x_src = x_dst = x;
		y_src = y_dst = y;
		width_src = width_dst = width;
		height_src = height_dst = height;

		if (!first_flag) {
			gc_src = XCreateGC(XtDisplay(da), XtWindow(da), 0, 0);
			pixel_src = get_default_color_pixel(XtDisplay(da), COLOR_BS);
			XSetForeground(XtDisplay(da), gc_src, pixel_src);
			gc_dst = XCreateGC(XtDisplay(da), XtWindow(da), 0, 0);
			pixel_dst = get_default_color_pixel(XtDisplay(da), COLOR_MV);
			XSetForeground(XtDisplay(da), gc_dst, pixel_dst);
			first_flag = 1;
		}

		XFillRectangle(XtDisplay(da), XtWindow(da), gc_src,
			       x_src, y_src, width_src, height_src);
		display_alname_mval(XtDisplay(da), XtWindow(da), alan_src);
		XDrawRectangle(XtDisplay(da), XtWindow(da), gc_dst,
			       x_dst, y_dst, width_dst, height_dst);
		XFlush(XtDisplay(da));

		proc_mode = 1;

	}
}

/*ARGSUSED*/
void
pointer_motion_mval(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	extern Widget	da;
	extern GC	DrawBackGC;
	int		alan;
	int		x, y;
	unsigned int	width, height;
	int		get_align();

	if (!proc_mode)
		return;

	if (get_align(event->x, event->y,
		      &alan, &x, &y, &width, &height) &&
	    alan != alan_dst                            ) {
		XDrawRectangle(XtDisplay(da), XtWindow(da), DrawBackGC,
			       x_dst, y_dst, width_dst, height_dst);
		alan_dst = alan;
		x_dst = x;
		y_dst = y;
		width_dst = width;
		height_dst = height;
		XDrawRectangle(XtDisplay(da), XtWindow(da), gc_dst,
			       x_dst, y_dst, width_dst, height_dst);
		XFlush(XtDisplay(da));
	}
}

/*ARGSUSED*/
void
button_release_mval(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	extern Widget	da;
	extern GC	DrawBackGC;
	int		idmy1, idmy2;
	unsigned int	uidmy1, uidmy2;
	extern int	move_align_mval();
	void		display_alname_mval();
	int		get_align();
	void		redisplay_newal_mval();

	if (!proc_mode)
		return;

	XDrawRectangle(XtDisplay(da), XtWindow(da), DrawBackGC,
		       x_dst, y_dst, width_dst, height_dst);
	XFillRectangle(XtDisplay(da), XtWindow(da), DrawBackGC,
		       x_src, y_src, width_src, height_src);
	display_alname_mval(XtDisplay(da), XtWindow(da), alan_src);
	XFlush(XtDisplay(da));

/*
	XFreeGC(XtDisplay(da), gc_src);
	XFreeGC(XtDisplay(da), gc_dst);
*/

	proc_mode = 0;

	if (get_align(event->x, event->y,
		      &alan_dst, &idmy1, &idmy2, &uidmy1, &uidmy2))  {
		if (move_align_mval(alan_src, alan_dst)) {
#ifdef	DEBUG
			(void)printf("button_release_mval --- move\n");
#endif
			redisplay_newal_mval(XtDisplay(da), XtWindow(da),
					     alan_src, alan_dst);
		}
	}
}

/*--------------------------------------------------------------------*/

static int
get_align(ex, ey, alan, x, y, width, height)
int		ex, ey;
int		*alan;
int		*x, *y;
unsigned int	*width, *height;
{
	extern INFO	Info;
	extern int	LeftMargin, TopMargin;
	extern int	AnMargin;
	extern int	BoxW, BoxH;
	extern int	PerLine;
	int		flag;
	int		x1, x2, y1, y2;
	int		alddxc, alddx;
#ifdef	DEBUG
	extern void	output_info();

	(void)printf("get_align --- Info.dataStartIndex = %d\n", Info.dataStartIndex);
	(void)printf("get_align --- Info.dataEndIndex = %d\n", Info.dataEndIndex);
	(void)printf("get_align --- Info.dispStartIndex = %d\n", Info.dispStartIndex);
	(void)printf("get_align --- BoxW, BoxH, PerLine = %d\n",
		     BoxW, BoxH, PerLine);
#endif

	alddxc = MIN(Info.dispStartIndex + PerLine - 1, Info.dataEndIndex);
	alddx = (alddxc - Info.dispStartIndex + 1) * BoxW;
#ifdef	DEBUG
	(void)printf("get_align --- alddxc1, alddxc2, alddxc, alddx = %d %d %d %d\n",
		     alddxc1, alddxc2, alddxc, alddx);
#endif

	x1 = AnMargin;
	x2 = LeftMargin + alddx;
	y1 = TopMargin + 2 * BoxH;
	y2 = y1 + Info.alignnum * BoxH;

	if (ex >= x1 && ex <= x2 && ey >= y1 && ey <= y2) {
		*alan = (ey - y1) / BoxH;
		if (*alan >= Info.alignnum)
			*alan = Info.alignnum - 1;
		flag = 1;
		*x = x1;
		*y = y1 + *alan * BoxH;
		*width = LeftMargin - AnMargin - BoxW;
		*height = BoxH;
	}
	else
		flag = 0;

	return flag;
}

/*--------------------------------------------------------------------*/

static void
display_alname_mval(display, window, alan)
Display	*display;
Window	window;
int	alan;
{
	extern INFO	Info;
	extern int	AnMargin;
	extern int	BoxW;
	extern GC	TextGC;
	int		len;
	int		code;
	int		x, y;
	int		i;
	extern void	draw_string_2();

	len = strlen((char *)(Info.alignname+alan));

	y = TopMargin + 2 * BoxH + alan * BoxH;

	for(x = AnMargin, i = 0; i < len; x += BoxW, i++) {
		code = *((char *)(Info.alignname+alan)+i);
		draw_string_2(display, window, False, x, y, code, TextGC);
	}
}

/*--------------------------------------------------------------------*/

static void
redisplay_newal_mval(display, window, alansrc, alandst)
Display	*display;
Window	window;
int	alansrc, alandst;
{
	int		i;
	extern void	display_one_alignment();
	extern void	erase_one_alignment();
#ifdef	CHECK
	void		fatal_error();
#endif

#ifdef	DEBUG
	(void)printf("redisplay_newal_mval --- alansrc, alandst = %d %d\n", alansrc, alandst);
#endif


	if (alansrc < alandst) {
		erase_one_alignment(display, window, alansrc);
#ifdef	SLEEP
		sleep(1);
#endif
		for (i = alansrc; i < alandst; i++) {
			erase_one_alignment(display, window, i + 1);
#ifdef	SLEEP
			sleep(1);
#endif
			display_one_alignment(display, window, i);
#ifdef	SLEEP
			sleep(1);
#endif
#ifdef	DEBUG
			(void)printf("(1) i = %d\n", i);
#endif
		}
		display_one_alignment(display, window, alandst);
#ifdef	SLEEP
		sleep(1);
#endif
	}
	else if (alansrc > alandst) {
		erase_one_alignment(display, window, alansrc);
#ifdef	SLEEP
		sleep(1);
#endif
		for (i = alansrc; i > alandst; i--) {
#ifdef	DEBUG
			(void)printf("(2) i = %d\n", i);
#endif
			erase_one_alignment(display, window, i - 1);
#ifdef	SLEEP
			sleep(1);
#endif
			display_one_alignment(display, window, i);
#ifdef	SLEEP
			sleep(1);
#endif
		}
		display_one_alignment(display, window, alandst);
#ifdef	SLEEP
		sleep(1);
#endif
	}
	else
		fatal_error("redisplay_newal_mval",
			    "alansrc, alandst, i = %d %d %d\n",
			    alansrc, alandst, i);
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
