/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	aeg_motif.c
----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<unistd.h>

#include	<Xm/Xm.h>
#include	<Xm/BulletinB.h>
#include	<Xm/RowColumn.h>
#include	<Xm/Label.h>
#include	<Xm/PushB.h>
#include	<Xm/PushBG.h>
#include	<Xm/ToggleB.h>
#include	<Xm/Scale.h>

#include	"aedit.h"
#include	"menu.h"
#include	"ae_motif.h"

/*--------------------------------------------------------------------*/

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

Motif	*Motif_root = NULL;

int	motif_cut = 80;			/* աѥ
					   饤ȹԿФ
					   չԿγ */

Motif	*p_ovl[MAX_NUM_PATTERN];	/* դΥ֡ꥹ */

int	ovl_cnt = 0;

/*--------------------------------------------------------------------*/

int	search_mode = SEARCH_MODE_1;	/* ⡼ */

int	dict_mode;			/* ⡼ */

/*--------------------------------------------------------------------*/

static int	motif_win_exist = 0;
static int	motif_win_display = 0;

static Widget	dialog_motif_main;	/* ᥤ󡦥 */
static Widget	l_dict;			/* ٥ */
static Widget	pb_start;		/* Startܥ
					   ʥᥤ󡦥 */
static Widget	pb_undisp;		/* Undispܥ
					   ʥᥤ󡦥 */
static Widget	rc_searchmode;
static Widget	pm_searchmode;
static Widget	pb_searchmode1;		/* SearchMode1ܥ
					   ʥᥤ󡦥 */
static Widget	pb_searchmode2;		/* SearchMode2ܥ
					   ʥᥤ󡦥 */
static Widget	om_searchmode;
static Widget	list_main;		/* աᥤ󡦥ꥹ
					   ʥᥤ󡦥 */
static Widget	dialog_motif_ovl;	/* ֡ */
static Widget	list_ovl;		/* ա֡ꥹ
					   ʥ֡ */
static int	main_cnt = 0;

static Widget	bb_main;	/* ֥ƥ󡦥ܡ
				   (ᥤ󡦥 */
static Widget	s_mtfcut;	/* աåȡ
				   ʥᥤ󡦥 */
static Widget	pb_exit;	/* Exitܥ
				   ʥᥤ󡦥 */
static Widget	bb_ovl;		/* ֥ƥ󡦥ܡ
				   ʥ֡ */

/*--------------------------------------------------------------------*/

void	motif_search_cb();

MENUITEM  menubar_submenu_motif[] = {
	{"Prosite", &xmPushButtonGadgetClass, 'P', NULL, NULL,
	 motif_search_cb, (caddr_t)DICT_MODE_PROSITE, NULL, True},
	{"User", &xmPushButtonGadgetClass, 'U', NULL, NULL,
	 motif_search_cb, (caddr_t)DICT_MODE_USER, NULL, True},
	{NULL}
};

/*--------------------------------------------------------------------*/

/*
  ոܥ򤵤줿˸ƤФ륳Хåؿ
*/

/*ARGSUSED*/
static void
motif_search_cb(widget, clientdata, calldata)
Widget	widget;
caddr_t  clientdata, calldata;
{
	extern int	data_exist;
	extern int	EditMode;
	extern char	motif_dir[BUFSIZ];
	int		dictmode;
	char		pathname[BUFSIZ];
	struct stat	buf;
	extern void	fatal_error();
	void		display_motif_window();

	if (!data_exist)
		return;

	if (EditMode != VIEW)
		return;

	if (motif_win_display)
		return;

#ifdef	DEBUG
	(void)printf("motif_search_cb --- clientdata = %d\n", (int)clientdata);
#endif

	dictmode = (int)clientdata;

	if (dictmode == DICT_MODE_PROSITE) {
	    if (stat("prosite.dat", &buf) == 0 &&
		S_ISREG(buf.st_mode) &&
		access("prosite.dat", R_OK) == 0)
		display_motif_window(dictmode, "prosite.dat");
	    else {
		if (*motif_dir == '\0')
		    popUpWarnDialog(
			"Readable file 'prosite.dat' not found in current directory.");
		else {
		    (void)strcpy(pathname, motif_dir);
		    (void)strcat(pathname, "/prosite.dat");
		    if (stat(pathname, &buf) == 0 &&
			S_ISREG(buf.st_mode) &&
			access(pathname, R_OK) == 0)
			display_motif_window(dictmode, pathname);
		    else
			popUpWarnDialog(
			  "Readable file 'prosite.dat' not found in current directory and %s.",
			  motif_dir);
		}
	    }
	}
	else if (dictmode == DICT_MODE_USER) {
	    if (stat("user.dat", &buf) == 0 &&
		S_ISREG(buf.st_mode) &&
		access("user.dat", R_OK) == 0)
		display_motif_window(dictmode, "user.dat");
	    else {
		if (*motif_dir == '\0')
		    popUpWarnDialog("Readable file 'user.dat' not found in current directory.");
		else {
		    (void)strcpy(pathname, motif_dir);
		    (void)strcat(pathname, "/user.dat");
		    if (stat(pathname, &buf) == 0 &&
			S_ISREG(buf.st_mode) &&
			access(pathname, R_OK) == 0)
			display_motif_window(dictmode, pathname);
		    else
			popUpWarnDialog(
			  "Readable file 'user.dat' not found in current directory and %s.",
			  motif_dir);
		}
	    }
	}
}

/*--------------------------------------------------------------------*/

/*
  ոɥɽ
*/

static void
display_motif_window(dictmode, dictpathname)
int	dictmode;
char	*dictpathname;
{
	extern Widget	pdm_edmode;
	Arg		args[1];
	XmString	xms;
	extern void	set_mtfptrn_file();
	void		create_motif_window();

	dict_mode = dictmode;

#ifdef	DEBUG
	(void)printf("display_motif_window --- search_mode, dict_mode = %d %d\n",
		     search_mode, dict_mode);
	(void)printf("display_motif_window --- dictpathname = %s\n", dictpathname);
#endif

	if (!motif_win_exist) {
		create_motif_window();
		motif_win_exist = 1;
	}

	set_mtfptrn_file(dictpathname);

	if (dict_mode == DICT_MODE_PROSITE) {
		xms = XmStringCreateLtoR("Dictionary : prosite.dat",
					 XmSTRING_DEFAULT_CHARSET);
		XtSetArg(args[0], XmNlabelString, xms);
	}
	else if (DICT_MODE_USER) {
		xms = XmStringCreateLtoR("Dictionary : user.dat",
					 XmSTRING_DEFAULT_CHARSET);
		XtSetArg(args[0], XmNlabelString, xms);
	}
	else
		fatal_error("display_motif_window",
			    "illegal dict_mode (%d)\n",
			    dict_mode);
	XtSetValues(l_dict, args, 1);
	XmStringFree(xms);

	if (search_mode == SEARCH_MODE_1)
		XtSetArg(args[0], XmNmenuHistory, pb_searchmode1);
	else if (search_mode == SEARCH_MODE_2)
		XtSetArg(args[0], XmNmenuHistory, pb_searchmode2);
	else
		fatal_error("display_motif_window",
			    "illegal search_mode (%d)\n",
			    search_mode);
	XtSetValues(om_searchmode, args, 1);

	XtVaSetValues(s_mtfcut, XmNvalue, motif_cut, NULL);

	XtVaSetValues(list_main, XmNvisibleItemCount, 1, NULL);
	XtPopup(dialog_motif_main, XtGrabNone); 

	motif_win_display = 1;

	XtSetSensitive(pdm_edmode, False);

	XFlush(XtDisplay(dialog_motif_main));
}

/*--------------------------------------------------------------------*/

/*
  ոɥ
*/

static void
create_motif_window()
{
	extern Widget	menu_top;
	Arg		args[10];
	XmString	xms;
	void		searchmode_cb();
	void		mtfcut_cb();
	void		start_cb();
	void		undisp_cb();
	void		exit_cb();
	void		list_main_cb();
	void		list_ovl_cb();

	/* ᥤ󡦥 */
	XtSetArg(args[0], XmNallowShellResize, True);
	dialog_motif_main = XtCreatePopupShell((char *)NULL,
					       transientShellWidgetClass,
					       menu_top,
					       args, 1);

	/* ֥ƥ󡦥ܡɡʥᥤ󡦥 */
	bb_main = XmCreateBulletinBoard(dialog_motif_main, "bb_main", (Arg *)NULL, 0);
	XtManageChild(bb_main);

	/* ٥ */
	xms = XmStringCreateLtoR("Dictionary", XmSTRING_DEFAULT_CHARSET);
	XtSetArg(args[0], XmNx, 0);
	XtSetArg(args[1], XmNy, 0);
	XtSetArg(args[2], XmNlabelString, xms);
	l_dict = XmCreateLabel(bb_main, "l_dict", args, 3);
	XtManageChild(l_dict);
	XmStringFree(xms);

	/* SearchModeʥᥤ󡦥 */
	XtSetArg(args[0], XmNx, 0);
	XtSetArg(args[1], XmNy, 30);
	rc_searchmode = XmCreateRowColumn(bb_main, "rc_searchmode", args, 2);
	XtManageChild(rc_searchmode);
	pm_searchmode = XmCreatePulldownMenu(rc_searchmode, "pm_searchmode", (Arg *)NULL, 0);
	pb_searchmode1 = XmCreatePushButton(pm_searchmode, "Mode 1", (Arg *)NULL, 0);
	XtManageChild(pb_searchmode1);
	XtAddCallback(pb_searchmode1,
		      XmNactivateCallback, searchmode_cb, (caddr_t)SEARCH_MODE_1);
	pb_searchmode2 = XmCreatePushButton(pm_searchmode, "Mode 2", (Arg *)NULL, 0);
	XtManageChild(pb_searchmode2);
	XtAddCallback(pb_searchmode2,
		      XmNactivateCallback, searchmode_cb, (caddr_t)SEARCH_MODE_2);
	xms = XmStringCreateLtoR("Search Mode", XmSTRING_DEFAULT_CHARSET);
	XtSetArg(args[0], XmNsubMenuId, pm_searchmode);
	XtSetArg(args[1], XmNlabelString, xms);
	om_searchmode = XmCreateOptionMenu(rc_searchmode, "om_searchmode", args, 2);
	XtManageChild(om_searchmode);
	XmStringFree(xms);

	/* աåȡʥᥤ󡦥 */
	xms = XmStringCreateLtoR("Motif Cut", XmSTRING_DEFAULT_CHARSET);
	XtSetArg(args[0], XmNorientation, XmHORIZONTAL);
	XtSetArg(args[1], XmNprocessingDirection, XmMAX_ON_RIGHT);
	XtSetArg(args[2], XmNminimum, 0);
	XtSetArg(args[3], XmNmaximum, 100);
	XtSetArg(args[4], XmNshowValue, True);
	XtSetArg(args[5], XmNx, 0);
	XtSetArg(args[6], XmNy, 65);
	XtSetArg(args[7], XmNwidth, 200);
	XtSetArg(args[8], XmNtitleString, xms);
	s_mtfcut = XmCreateScale(bb_main, "s_mtfcut", args, 9);
	XtManageChild(s_mtfcut);
	XtAddCallback(s_mtfcut, XmNdragCallback, mtfcut_cb, (caddr_t)NULL);
	XtAddCallback(s_mtfcut, XmNvalueChangedCallback, mtfcut_cb, (caddr_t)NULL);
	XmStringFree(xms);

	/* Startܥʥᥤ󡦥 */
	XtSetArg(args[0], XmNx, 250);
	XtSetArg(args[1], XmNy, 35);
	pb_start = XmCreatePushButton(bb_main, "Start", args, 2);
	XtManageChild(pb_start); 
	XtAddCallback(pb_start, XmNactivateCallback, start_cb, (caddr_t)NULL);

	/* Undispܥʥᥤ󡦥 */
	XtSetArg(args[0], XmNx, 300);
	XtSetArg(args[1], XmNy, 35);
	pb_undisp = XmCreatePushButton(bb_main, "Undisp", args, 2);
	XtManageChild(pb_undisp);
	XtAddCallback(pb_undisp, XmNactivateCallback, undisp_cb, (caddr_t)NULL);

	/* Exitܥʥᥤ󡦥 */
	XtSetArg(args[0], XmNx, 370);
	XtSetArg(args[1], XmNy, 35);
	pb_exit = XmCreatePushButton(bb_main, "Exit", args, 2);
	XtManageChild(pb_exit);
	XtAddCallback(pb_exit, XmNactivateCallback, exit_cb, (caddr_t)NULL);

	/* աᥤ󡦥ꥹȡʥᥤ󡦥 */
	XtSetArg(args[0], XmNx, 0);
	XtSetArg(args[1], XmNy, 125);
	XtSetArg(args[2], XmNwidth, 400);
	XtSetArg(args[3], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE);
	list_main = (Widget)XmCreateScrolledList(bb_main, "list_main", args, 4);
	XtManageChild(list_main);
	XtAddCallback(list_main, XmNbrowseSelectionCallback, list_main_cb, (caddr_t)NULL);

	/* ֡ */
	XtSetArg(args[0], XmNallowShellResize, True);
	XtSetArg(args[1], XmNx, 450);
	dialog_motif_ovl = XtCreatePopupShell("Overlap",
					      transientShellWidgetClass,
					      menu_top,
					      args, 2);
	/* ֥ƥ󡦥ܡɡʥ֡ */
	bb_ovl = XmCreateBulletinBoard(dialog_motif_ovl, "bb_ovl", (Arg *)NULL, 0);
	XtManageChild(bb_ovl);

	/* ա֡ꥹȡʥ֡ */
	XtSetArg(args[0], XmNheight, 0);
	XtSetArg(args[1], XmNx, 0);
	XtSetArg(args[2], XmNy, 0);
	XtSetArg(args[3], XmNlistSizePolicy, XmRESIZE_IF_POSSIBLE);
	list_ovl = (Widget)XmCreateScrolledList(bb_ovl, "list_ovl", args, 4);
	XtManageChild(list_ovl);
	XtAddCallback(list_ovl, XmNbrowseSelectionCallback, list_ovl_cb, (caddr_t)NULL);

	XtSetSensitive(pb_undisp, False);
}

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
static void
searchmode_cb(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata;
caddr_t	*calldata;
{
	int		sm;
	extern void	fatal_error();

	sm = (int)clientdata;

	if (sm == SEARCH_MODE_1)
		search_mode = SEARCH_MODE_1;
	else if (SEARCH_MODE_2)
		search_mode = SEARCH_MODE_2;
	else
		fatal_error("searchmode_cb", "illegal sm (%d)\n", sm);
}

/*--------------------------------------------------------------------*/

/*
  աѥ楹ΥХåؿ
*/

/*ARGSUSED*/
static void
mtfcut_cb(widget, clientdata, calldata)
Widget			widget;
caddr_t			clientdata;
XmScaleCallbackStruct	*calldata;
{
	motif_cut = calldata->value;
}

/*--------------------------------------------------------------------*/

/*
  Search ܥ򤵤줿˸ƤФ륳Хåؿ
  ae_prosite.dat ޤ ae_user.dat ɤ߹
*/

/*ARGSUSED*/
static void
start_cb(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata, calldata;
{
	extern Widget	menu_top;
	extern Widget	aedit_top;
	Cursor		cursormt, cursorat, cursordmm;
	extern void	delete_motif_data();
	extern void	set_mtfcol_flag();
	extern void	create_mtfptrn_data();
	extern void	set_cursor_watch();
	extern void	reset_cursor_watch();
	void		delete_motif_list_main();
	void		delete_motif_list_ovl();
	void		add_motif_list_main();

	set_cursor_watch(menu_top, &cursormt);
	set_cursor_watch(aedit_top, &cursorat);
	set_cursor_watch(dialog_motif_main, &cursordmm);

	delete_motif_list_ovl();
	delete_motif_list_main();
	delete_motif_data();

	set_mtfcol_flag();

	create_mtfptrn_data();

	add_motif_list_main();

	reset_cursor_watch(menu_top, cursormt);
	reset_cursor_watch(aedit_top, cursorat);
	reset_cursor_watch(dialog_motif_main, cursordmm);
}

/*--------------------------------------------------------------------*/

/*
  Undisp ܥ򤵤줿˸ƤФ륳Хåؿ
  оݤȤƤĤΥդõ
*/

/*ARGSUSED*/
static void
undisp_cb(widget, clientdata, calldata)
Widget   widget;
caddr_t  clientdata, calldata;
{
	extern Widget	da;
	extern Motif	*p_motif;
	int		i;
	char		motifname[MAX_BUFF_MOTIF];

	XtSetSensitive(pb_undisp, False);
	XtSetSensitive(pb_start, True);
	XmListDeselectAllItems(list_main);
	XmListDeselectAllItems(list_ovl);
	for (i = 0; i < ovl_cnt; i++) {
		(void)strcpy(motifname, p_ovl[i]->title);
		(void)strcat(motifname, "   ");
		(void)strcat(motifname, p_ovl[i]->pattern);
		if (XmListItemExists(
			list_ovl,
			XmStringCreateLtoR(motifname, XmSTRING_DEFAULT_CHARSET)))
			XmListDeleteItem(
				list_ovl,
				XmStringCreateLtoR(motifname, XmSTRING_DEFAULT_CHARSET));
	}
	undisp_one_motif_2(XtDisplay(da), XtWindow(da));
	XtPopdown(dialog_motif_ovl);
	ovl_cnt = 0;
	p_motif = NULL;
}

/*--------------------------------------------------------------------*/

/*
  Exit ܥ򤵤줿˸ƤФ륳Хåؿ
*/

/*ARGSUSED*/
static void
exit_cb(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata, calldata;
{
	extern Motif	*p_motif;
	extern Widget	da;
	extern Widget	pdm_edmode;

	if (p_motif != (Motif *)NULL) {
		undisp_one_motif_2(XtDisplay(da), XtWindow(da));
		p_motif = (Motif *)NULL;
	}

	delete_motif_list_ovl();
	delete_motif_list_main();

	delete_motif_data();

	XtSetSensitive(pb_start, True);
	XtSetSensitive(pb_undisp, False);

	XtPopdown(dialog_motif_ovl);
	XtPopdown(dialog_motif_main);

	motif_win_display = 0;

	XtSetSensitive(pdm_edmode, True);
}

/*--------------------------------------------------------------------*/

/*
  աꥹȡʥåȡˤΥդ򤵤줿˸ƤФ륳
Хåؿ
*/

/*ARGSUSED*/
static void
list_main_cb(widget, clientdata, calldata)
Widget			widget;
caddr_t			clientdata;
XmListCallbackStruct	*calldata;
{
	extern Motif	*p_motif;
	extern Widget	da;
	Motif		*pm;
	Segment		*ps;
	char		motifname[MAX_BUFF_MOTIF];
	int		i;
	int		count;
	extern void	display_aedit_win_2();
	extern int	check_overlap_mtfptrn_data();
	void		add_motif_list_ovl();

	if (p_motif) {
		undisp_one_motif_2(XtDisplay(da), XtWindow(da));
		(void)strcpy(motifname, p_motif->title);
		(void)strcat(motifname, "   ");
		(void)strcat(motifname, p_motif->pattern);
		if (XmListItemExists(
			list_ovl,
			XmStringCreateLtoR(motifname, XmSTRING_DEFAULT_CHARSET)))
			XmListDeselectItem(
				list_ovl,
				XmStringCreateLtoR(motifname, XmSTRING_DEFAULT_CHARSET));
	}
	XtSetSensitive(pb_undisp, True);
	XtSetSensitive(pb_start, False);

	if (calldata->item_position > main_cnt) {
		if (ovl_cnt > 0)
			XtPopdown(dialog_motif_ovl);
		return;
	}
	
	count = 0;
	pm = Motif_root;
	while (pm != (Motif *)NULL) {
		count++;
		if (calldata->item_position == count) {
		/*xms = XmStringCreateLtoR(motif[i].comment, XmSTRING_DEFAULT_CHARSET);*/
			p_motif = pm;
			break;
		}
		pm = pm->p_next;
	}
	/* դɽ褦˥饤ɽ֤ */
	ps = p_motif->p_head_seg;
	while (ps->forbidden || ps->others)
		ps = ps->p_next_seg;
	if (ps->index > Info.dispStartIndex + PerLine - 1 ||
	    ps->index < Info.dispStartIndex              ) {
		Info.dispStartIndex = ps->index - (int)(PerLine / 2);
		if (Info.dispStartIndex < Info.dataStartIndex)
			Info.dispStartIndex = Info.dataStartIndex;
		display_aedit_win_2();
	}
	disp_one_motif_2(XtDisplay(da), XtWindow(da));

	for (i = 0; i < ovl_cnt; i++) {
		(void)strcpy(motifname, p_ovl[i]->title);
		(void)strcat(motifname, "   ");
		(void)strcat(motifname, p_ovl[i]->pattern);
		if (XmListItemExists(
			list_ovl,
			XmStringCreateLtoR(motifname, XmSTRING_DEFAULT_CHARSET)))
			XmListDeleteItem(
				list_ovl,
				XmStringCreateLtoR(motifname, XmSTRING_DEFAULT_CHARSET));
	}

	if (check_overlap_mtfptrn_data()) {
		add_motif_list_ovl();
	}
	else {
		XtPopdown(dialog_motif_ovl);
	}
}

/*--------------------------------------------------------------------*/

/*
  ա֥ꥹȡʥåȡˤΥդ򤵤줿˸ƤФ
Хåؿ
*/

/*ARGSUSED*/
static void
list_ovl_cb(widget, clientdata, calldata)
Widget			widget;
caddr_t			clientdata;
XmListCallbackStruct	*calldata;
{
	extern Motif	*p_motif;
	extern Widget	da;
	Segment		*ps;
	int		i;
	extern void	display_aedit_win_2();

#if	1
	(void)printf("select no:%d\n", calldata->item_position);
#endif

	if (p_motif)
		undisp_one_motif_2(XtDisplay(da), XtWindow(da));
	if (calldata->item_position > ovl_cnt)
		return;
	for (i = 0; i < ovl_cnt; i++) {
		if (calldata->item_position == i + 1) {
			p_motif = p_ovl[i];
			break;
		}
	}
	/* դɽ褦˥饤ɽ֤ */
	ps = p_motif->p_head_seg;
	while (ps->forbidden || ps->others)
		ps = ps->p_next_seg;
	if (ps->index > Info.dispStartIndex + PerLine - 1 ||
	    ps->index < Info.dispStartIndex                 ) {
		Info.dispStartIndex = ps->index - (int)(PerLine / 2);
		if (Info.dispStartIndex<Info.dataStartIndex)
			Info.dispStartIndex = Info.dataStartIndex;
		display_aedit_win_2();
	}
	disp_one_motif_2(XtDisplay(da), XtWindow(da));
}

/*--------------------------------------------------------------------*/

/*
  աᥤ󡦥ꥹȤ˥դϿ
*/

static void
add_motif_list_main()
{
	Arg	args[10];      
	Motif	*pm;
	char	motifname[MAX_BUFF_MOTIF];
	int	i;

	main_cnt = 0;
	pm = Motif_root;
	while (pm != (Motif *)NULL) {
		(void)strcpy(motifname, pm->title);
		(void)strcat(motifname, "   ");
		(void)strcat(motifname, pm->pattern);
		main_cnt++;
		XmListAddItem(
			list_main,
			XmStringCreateLtoR(motifname, XmSTRING_DEFAULT_CHARSET), main_cnt);
		pm = pm->p_next;
	}

#if	1
	(void)printf("motif exist  %d\n", main_cnt);
#endif

	if (main_cnt <= 0)
		XtSetArg(args[0], XmNvisibleItemCount, 1);
	else if (main_cnt <= DISP_MOTIF_COUNT)
		XtSetArg(args[0], XmNvisibleItemCount, main_cnt);
	else
		XtSetArg(args[0], XmNvisibleItemCount, DISP_MOTIF_COUNT);
	XtSetValues(list_main, args, 1);

	XFlush(XtDisplay(dialog_motif_main));
}

/*
  աᥤ󡦥ꥹȤդ
*/

static void
delete_motif_list_main()
{
	Motif	*pm;
	char	motifname[MAX_BUFF_MOTIF];

	pm = Motif_root;
	while (pm != (Motif *)NULL) {
		(void)strcpy(motifname, pm->title);
		(void)strcat(motifname, "   ");
		(void)strcat(motifname, pm->pattern);
		if (XmListItemExists(
			list_main,
			XmStringCreateLtoR(motifname, XmSTRING_DEFAULT_CHARSET)))
			XmListDeleteItem(
				list_main,
				XmStringCreateLtoR(motifname, XmSTRING_DEFAULT_CHARSET));
		pm = pm->p_next;
	}

	XtVaSetValues(list_main, XmNvisibleItemCount, 1, NULL);

	XFlush(XtDisplay(dialog_motif_main));
}

/*--------------------------------------------------------------------*/

/*
  ա֡ꥹȤ˥դϿ
*/

static void
add_motif_list_ovl()
{
	Arg	args[10];     
	char	motifname[MAX_BUFF_MOTIF];
	int	i;

#if	1
	(void)printf("overlap motif exist  %d\n", ovl_cnt);
#endif

	for (i = 0; i < ovl_cnt; i++){
		(void)strcpy(motifname, p_ovl[i]->title);
		(void)strcat(motifname, "   ");
		(void)strcat(motifname, p_ovl[i]->pattern);
		XmListAddItem(list_ovl,
			      XmStringCreateLtoR(motifname, XmSTRING_DEFAULT_CHARSET),
			      i + 1);
	}

	if (ovl_cnt <= 0)
		XtSetArg(args[0], XmNvisibleItemCount, 1);
	else if (ovl_cnt <= DISP_MOTIF_COUNT)
		XtSetArg(args[0], XmNvisibleItemCount, ovl_cnt);
	else
		XtSetArg(args[0], XmNvisibleItemCount, DISP_MOTIF_COUNT);
	XtSetValues(list_ovl, args, 1);

	XtPopup(dialog_motif_ovl, XtGrabNone);

	XFlush(XtDisplay(dialog_motif_ovl));
}

/*
  ա֡ꥹȤդ
*/

static void
delete_motif_list_ovl()
{
	int	i;
	char	motifname[MAX_BUFF_MOTIF];

	if (ovl_cnt <= 0)
		return;

	for (i = 0; i < ovl_cnt; i++) {
		(void)strcpy(motifname, p_ovl[i]->title);
		(void)strcat(motifname, "   ");
		(void)strcat(motifname, p_ovl[i]->pattern);
		if (XmListItemExists(
			list_ovl,
			XmStringCreateLtoR(motifname, XmSTRING_DEFAULT_CHARSET)))
			XmListDeleteItem(
				list_ovl,
				XmStringCreateLtoR(motifname, XmSTRING_DEFAULT_CHARSET));
	}

	ovl_cnt = 0;

	XtPopdown(dialog_motif_ovl);

	XFlush(XtDisplay(dialog_motif_ovl));
}

/*--------------------------------------------------------------------*/

void
reset_motif()
{
	extern Motif	*p_motif;
	extern Widget	da;
	extern Widget	pdm_edmode;
	extern void	delete_motif_data();
	void		delete_motif_list_ovl();
	void		delete_motif_list_main();

	if (motif_win_display) {
		if (p_motif != (Motif *)NULL) {
			undisp_one_motif_2(XtDisplay(da), XtWindow(da));
			p_motif = (Motif *)NULL;
		}
		delete_motif_list_ovl();
		delete_motif_list_main();
		delete_motif_data();
		XtSetSensitive(pb_start, True);
		XtSetSensitive(pb_undisp, False);
		XtPopdown(dialog_motif_ovl);
		XtPopdown(dialog_motif_main);
		motif_win_display = 0;
		XtSetSensitive(pdm_edmode, True);
	}
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
