/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	aeg_dlal.c
----------------------------------------------------------------------*/

#include	<X11/Xlib.h>
#include	<X11/Xutil.h>
#include	<X11/Intrinsic.h>

#include	"aedit.h"
#include	"aeg_comdef.h"

/*--------------------------------------------------------------------*/

#define	COLOR_BS	"skyblue"

/*--------------------------------------------------------------------*/

static int		proc_mode = 0;

static int		first_flag = 0;

static int		alan_trgt;	/* array number */
static int		x_trgt, y_trgt;
static unsigned int	width_trgt, height_trgt;

static GC		gc_trgt;

static Pixel		pixel_trgt;

/*--------------------------------------------------------------------*/

#if	0
#define	SLEEP
#endif

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
void
button_press_dlal(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	extern int	data_exist;
	extern Widget	da;
	extern GC	DrawBackGC;
	int		x, y;
	unsigned int	width, height;
	int		get_align();
	extern Pixel	get_default_color_pixel();
	void		display_alname_dlal();

	if (!data_exist)
		return;

	if (get_align(event->x, event->y,
		      &alan_trgt, &x, &y, &width, &height)) {
		x_trgt = x;
		y_trgt = y;
		width_trgt = width;
		height_trgt = height;

		if (!first_flag) {
			gc_trgt = XCreateGC(XtDisplay(da), XtWindow(da), 0, 0);
			pixel_trgt = get_default_color_pixel(XtDisplay(da), COLOR_BS);
			XSetForeground(XtDisplay(da), gc_trgt, pixel_trgt);
			first_flag = 1;
		}

		XFillRectangle(XtDisplay(da), XtWindow(da), gc_trgt,
			       x_trgt, y_trgt, width_trgt, height_trgt);
		display_alname_dlal(XtDisplay(da), XtWindow(da), alan_trgt);
		XFlush(XtDisplay(da));

		proc_mode = 1;

	}
}

#if	0

/*ARGSUSED*/
void
pointer_motion_dlal(widget, event)
Widget		widget;
XButtonEvent	*event;
{
}

#endif

/*ARGSUSED*/
void
button_release_dlal(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	extern Widget	da;
	extern GC	DrawBackGC;
	extern INFO	Info;
	int		alantrgt;
	int		idmy1, idmy2;
	unsigned int	uidmy1, uidmy2;
	int		alnumold;
	extern void	erase_identical_column();
	extern void	erase_cost_graph();
	extern void	display_identical_column();
	extern void	display_cost_graph();
	extern int	delete_align_dlal();
	void		display_alname_dlal();
	int		get_align();
	void		redisplay_newal_dlal();

	if (!proc_mode)
		return;

	XFillRectangle(XtDisplay(da), XtWindow(da), DrawBackGC,
		       x_trgt, y_trgt, width_trgt, height_trgt);
	display_alname_dlal(XtDisplay(da), XtWindow(da), alan_trgt);
	XFlush(XtDisplay(da));

/*
	XFreeGC(XtDisplay(da), gc_trgt);
*/

	proc_mode = 0;

	if (get_align(event->x, event->y,
		      &alantrgt, &idmy1, &idmy2, &uidmy1, &uidmy2) &&
	    alantrgt == alan_trgt                                    )  {
#ifdef	DEBUG
		(void)printf("button_release_dlal --- (delete) alan_trgt = %d\n",
			     alan_trgt);
#endif
		erase_identical_column(XtDisplay(da), XtWindow(da));
		erase_cost_graph(XtDisplay(da), XtWindow(da));
		alnumold = Info.alignnum;
		delete_align_dlal(alan_trgt);
		redisplay_newal_dlal(XtDisplay(da), XtWindow(da),
				     alan_trgt, alnumold);
		display_identical_column(XtDisplay(da), XtWindow(da));
		display_cost_graph(XtDisplay(da), XtWindow(da));
	}
}

/*--------------------------------------------------------------------*/

static int
get_align(ex, ey, alan, x, y, width, height)
int		ex, ey;
int		*alan;
int		*x, *y;
unsigned int	*width, *height;
{
	extern INFO	Info;
	extern int	LeftMargin, TopMargin;
	extern int	AnMargin;
	extern int	BoxW, BoxH;
	extern int	PerLine;
	int		flag;
	int		x1, x2, y1, y2;
	int		alddec, aldddx;
#ifdef	DEBUG
	extern void	output_info();

	(void)printf("get_align --- Info.dataStartIndex = %d\n", Info.dataStartIndex);
	(void)printf("get_align --- Info.dataEndIndex = %d\n", Info.dataEndIndex);
	(void)printf("get_align --- Info.dispStartIndex = %d\n", Info.dispStartIndex);
	(void)printf("get_align --- BoxW, BoxH, PerLine = %d\n",
		     BoxW, BoxH, PerLine);
#endif

	alddec = MIN(Info.dispStartIndex + PerLine - 1, Info.dataEndIndex);
	aldddx = (alddec - Info.dispStartIndex + 1) * BoxW;
#ifdef	DEBUG
	(void)printf("get_align --- alddec1, alddec2, alddec, aldddx = %d %d %d %d\n",
		     alddec1, alddec2, alddec, aldddx);
#endif

	x1 = AnMargin;
	x2 = LeftMargin + aldddx;
	y1 = TopMargin + 2 * BoxH;
	y2 = y1 + Info.alignnum * BoxH;

	if (ex >= x1 && ex <= x2 && ey >= y1 && ey <= y2) {
		*alan = (ey - y1) / BoxH;
		if (*alan >= Info.alignnum)
			*alan = Info.alignnum - 1;
		flag = 1;
		*x = x1;
		*y = y1 + *alan * BoxH;
		*width = LeftMargin - AnMargin - BoxW;
		*height = BoxH;
	}
	else
		flag = 0;

	return flag;
}

/*--------------------------------------------------------------------*/

static void
display_alname_dlal(display, window, alan)
Display	*display;
Window	window;
int	alan;
{
	extern INFO	Info;
	extern int	AnMargin;
	extern int	BoxW;
	extern GC	TextGC;
	int		len;
	int		code;
	int		x, y;
	int		i;
	extern void	draw_string_2();

	len = strlen((char *)(Info.alignname+alan));

	y = TopMargin + 2 * BoxH + alan * BoxH;

	for(x = AnMargin, i = 0; i < len; x += BoxW, i++) {
		code = *((char *)(Info.alignname+alan)+i);
		draw_string_2(display, window, False, x, y, code, TextGC);
	}
}

/*--------------------------------------------------------------------*/

static void
redisplay_newal_dlal(display, window, alantrgt, alignnum)
Display	*display;
Window	window;
int	alantrgt;
int	alignnum;
{
	int		end;
	int		i;
	extern void	display_one_alignment();
	extern void	erase_one_alignment();

#ifdef	DEBUG
	(void)printf("redisplay_newal_dlal --- alantrgt, alignnum = %d\n",
		     alantrgt, alignnum);
#endif

	erase_one_alignment(display, window, alantrgt);
#ifdef	SLEEP
	sleep(1);
#endif
	end = alignnum - 2;
	for (i = alantrgt; i <= end; i++) {
#ifdef	DEBUG
		(void)printf("redisplay_newal_dlal --- i = %d\n", i);
#endif
		erase_one_alignment(display, window, i + 1);
#ifdef	SLEEP
		sleep(1);
#endif
		display_one_alignment(display, window, i);
#ifdef	SLEEP
		sleep(1);
#endif
	}
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
