/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	aeg_bscnt.c
----------------------------------------------------------------------*/

#include	<stdio.h>

#include	<X11/Xlib.h>
#include	<X11/Xutil.h>
#include	<X11/Intrinsic.h>

#include	"aedit.h"

/*--------------------------------------------------------------------*/

static int	proc_mode = 0;

static int	alindex_c, alindex_l = -1;
static int	column_c, column_l = -1;
static int	value_c, value_l = -1;

/*--------------------------------------------------------------------*/

#if	1
#define	CHECK
#endif

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
void	button_press_bscnt(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	extern int	data_exist;
	extern INFO	Info;
	int		alindex, column;
	int		get_active_point();

	if (!data_exist)
		return;

	if (get_active_point(&Info, event->x, event->y, &alindex, &column)) {
		alindex_c = alindex;
		column_c = column;
		proc_mode = 1;
	}
}

/*ARGSUSED*/
void	pointer_motion_bscnt(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	if (!proc_mode)
		return;
}

/*ARGSUSED*/
void	button_release_bscnt(widget, event)
Widget		widget;
XButtonEvent	*event;
{
	extern INFO	Info;
	extern Widget	da;
	extern GC	WhiteGC, DrawBackGC, TextGC;
	char		valuestr[BUFSIZ];
	int		alindex, column;
	int		get_active_point();
	int		get_bscnt();
	void		display_one_base_t1();
	void		display_one_base_t2();
	void		display_base_value();
	void		erase_base_value();

	if (!proc_mode)
		return;


	proc_mode = 0;

	if (get_active_point(&Info, event->x, event->y, &alindex, &column) &&
	    (alindex == alindex_c && column == column_c)                     ) {
#ifdef	DEBUG
		(void)printf("button_release_bscnt --- alindex_c = %d\n", alindex_c);
		(void)printf("button_release_bscnt --- column_c = %d\n", column_c);
#endif
		if ((value_c = get_bscnt(*(Info.codeAlign+alindex_c),
					 Info.dataStartIndex,
					 column_c))
		    >= 0) {
#ifdef	DEBUG
			(void)printf("button_release_bscnt --- value_c = %d\n", value_c);
#endif
			if (alindex_l >= 0 && column_l >= 0) {
				if (column_l - Info.dispStartIndex >= 0     &&
				    column_l - Info.dispStartIndex < PerLine  ) {
					display_one_base_t1(XtDisplay(da), XtWindow(da),
							    alindex_l, column_l);
					(void)sprintf(valuestr, "%d", value_l);
					erase_base_value(XtDisplay(da), XtWindow(da), DrawBackGC,
							 column_l - Info.dispStartIndex, valuestr);
				}
			}
			display_one_base_t2(XtDisplay(da), XtWindow(da), WhiteGC,
					    alindex_c, column_c);
			(void)sprintf(valuestr, "%d", value_c);
			display_base_value(XtDisplay(da), XtWindow(da), TextGC,
					   column_c - Info.dispStartIndex, valuestr);
			alindex_l = alindex_c;
			column_l = column_c;
			value_l = value_c;
		}
	}
}

/*--------------------------------------------------------------------*/

/* ---> another position or file */

int	get_active_point(info, dvx, dvy, alindex, column)
INFO	*info;
int	dvx, dvy;
int	*alindex, *column;
{
	int		idmy;
	int		flag;
	extern int	calc_active_point();

	if (calc_active_point(dvx, dvy, alindex, column, &idmy)) {
		if ((*alindex >= 0 && *alindex < info->alignnum) &&
		    *column >= 0                                  ) {
			*column += info->dispStartIndex;
			if (*column >= info->dataStartIndex &&
			    *column <= info->dataEndIndex     )
				flag = 1;
			else
				flag = 0;
		}
		else
			flag = 0;
	}
	else
		flag = 0;

	return flag;
}

/*--------------------------------------------------------------------*/

static int	get_bscnt(codealign, startindex, endindex)
char	*codealign;
int	startindex, endindex;
{
	int	value;
	int	i;

	if (*(codealign+endindex) == GAP_INNER_CODE)
		value = -1;
	else {
		for (value = 0, i = startindex; i <= endindex; i++) {
			if (*(codealign+i) != GAP_INNER_CODE)
				++value;
		}
	}

	return value;
}

/*--------------------------------------------------------------------*/

static void	display_base_value(display, window, gc, dspcolumn, valuestr)
Display	*display;
Window	window;
GC	gc;
int	dspcolumn;
char	*valuestr;
{
	extern int	TopMargin, LeftMargin;

	XDrawString(display, window, gc, 
		    LeftMargin + dspcolumn * BoxW, TopMargin,
		    valuestr, strlen(valuestr));

	XFlush(display);
}

static void	erase_base_value(display, window, gc, dspcolumn, valuestr)
Display	*display;
Window	window;
GC	gc;
int	dspcolumn;
char	*valuestr;
{
	extern int	TopMargin, LeftMargin;

	XFillRectangle(display, window, gc,
		       LeftMargin + dspcolumn * BoxW, TopMargin - BoxH,
		       strlen(valuestr) * BoxW, BoxH); 

	XFlush(display);
}

/*--------------------------------------------------------------------*/

void	display_base_count()
{
	extern		EditMode;
	extern INFO	Info;
	extern int	PerLine;
	extern Widget	da;
	char		valuestr[BUFSIZ];
	void		display_one_base_t2();
	void		display_base_value();

	if (EditMode != VIEW)
		return;

	if (alindex_l >= 0 && column_l >= 0) {
		if (column_l - Info.dispStartIndex >= 0     &&
		    column_l - Info.dispStartIndex < PerLine  ) {
			display_one_base_t2(XtDisplay(da), XtWindow(da), WhiteGC,
					    alindex_l, column_l);
			(void)sprintf(valuestr, "%d", value_l);
			display_base_value(XtDisplay(da), XtWindow(da), TextGC,
					   column_l - Info.dispStartIndex, valuestr);
		}
	}
}

void	erase_base_count()
{
	extern		EditMode;
	extern INFO	Info;
	extern int	PerLine;
	extern Widget	da;
	char		valuestr[BUFSIZ];
	void		display_one_base_t1();
	void		erase_base_value();

	if (alindex_l >= 0 && column_l >= 0) {
		if (column_l - Info.dispStartIndex >= 0     &&
		    column_l - Info.dispStartIndex < PerLine  ) {
			display_one_base_t1(XtDisplay(da), XtWindow(da),
					    alindex_l, column_l);
			(void)sprintf(valuestr, "%d", value_l);
			erase_base_value(XtDisplay(da), XtWindow(da), DrawBackGC,
					 column_l - Info.dispStartIndex, valuestr);
		}
	}
}

void	reset_base_count()
{
	extern		EditMode;
	extern INFO	Info;
	extern int	PerLine;
	extern Widget	da;
	char		valuestr[BUFSIZ];
	void		display_one_base_t1();
	void		erase_base_value();

	if (alindex_l >= 0 && column_l >= 0) {
		if (column_l - Info.dispStartIndex >= 0     &&
		    column_l - Info.dispStartIndex < PerLine  ) {
			display_one_base_t1(XtDisplay(da), XtWindow(da),
					    alindex_l, column_l);
			(void)sprintf(valuestr, "%d", value_l);
			erase_base_value(XtDisplay(da), XtWindow(da), DrawBackGC,
					 column_l - Info.dispStartIndex, valuestr);
		}
		alindex_l = -1;
		column_l = -1;
		value_l = -1;
	}
}

/*--------------------------------------------------------------------*/

void	display_one_base_t1(display, window, alindex, column)
Display	*display;
Window	window;
int	alindex, column;
{
	extern INFO	Info;
	extern int	PerLine;
	extern int	LeftMargin, TopMargin;
	int		x, y;
	int		code;
	void		exit();

#ifdef	CHECK
	if (column < Info.dispStartIndex           ||
	    column > Info.dispStartIndex + PerLine ||
	    column > Info.dataEndIndex               ) {
		(void)fprintf(stderr, "display_one_base_t1 --- illegal input data\n");
		(void)fprintf(stderr, "column = %d\n", column);
		(void)fprintf(stderr, "PerLine = %d\n", PerLine);
		(void)fprintf(stderr, "dispStartIndex = %d\n", Info.dispStartIndex);
		(void)fprintf(stderr, "dataEndIndex = %d\n", Info.dataEndIndex);
		exit(1);
	}
#endif

	x = LeftMargin + (column - Info.dispStartIndex) * BoxW;
	y = TopMargin + (alindex + 2) * BoxH;

	code = Info.codeAlign[alindex][column];
	XFillRectangle(display, window, CodeGC[code],
		       x, y, BoxW, BoxH); 

	if (Kanji)
		XDrawString16(display, window, AminoCharGC[code], 
			      x + XOffset[code], y + YOffset[code],
			      &XChar2[code], 1);
	else 
		XDrawString(display, window, AminoCharGC[code], 
			    x + XOffset[code], y + YOffset[code],
			    &Char1[code], 1);

	XFlush(display);
}

void	display_one_base_t2(display, window, gc, alindex, column)
Display	*display;
Window	window;
GC	gc;
int	alindex, column;
{
	extern INFO	Info;
	extern int	PerLine;
	extern int	LeftMargin, TopMargin;
	extern int	BoxW, BoxH;
	extern GC	WhiteGC, BlackGC;
	int		x, y;
	int		code;
	GC		gcstr;
	void		draw_string_2();
	void		exit();

#ifdef	CHECK
	if (column < Info.dispStartIndex           ||
	    column > Info.dispStartIndex + PerLine ||
	    column > Info.dataEndIndex               ) {
		(void)fprintf(stderr, "display_one_base_t2 --- illegal input data\n");
		(void)fprintf(stderr, "column = %d\n", column);
		(void)fprintf(stderr, "PerLine = %d\n", PerLine);
		(void)fprintf(stderr, "dispStartIndex = %d\n", Info.dispStartIndex);
		(void)fprintf(stderr, "dataEndIndex = %d\n", Info.dataEndIndex);
		exit(1);
	}
#endif

	if (gc == WhiteGC)
		gcstr = BlackGC;
	else
		gcstr = WhiteGC;

	x = LeftMargin + (column - Info.dispStartIndex) * BoxW;
	y = TopMargin + (alindex + 2) * BoxH;

	XFillRectangle(display, window, gc, x, y, BoxW, BoxH);

	code = Info.codeAlign[alindex][column];

	draw_string_2(display, window, False, x, y, code, gcstr);

	XFlush(display);
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
