/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	ե̾	aeg_aalda.c
			ɥ󥰡ꥢʼư饤ȡ

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<string.h>
#include	<math.h>

#include	"aedit.h"

#include	"aeg_aaldef.h"

/*--------------------------------------------------------------------*/

#if	1
#define	CHECK
#endif

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

void
draw_diff_proc_aal()
{
	extern int	procnum_aal;
	void		draw_information_diff_aal();
	void		draw_scale_diff_aal();
	void		draw_alignment_aacid_diff_aal();
	void		draw_alignment_nacid_diff_aal();
	void		draw_idcol_diff_aal();
	void		draw_costgraph_diff_aal();

#ifdef	DEBUG
	(void)printf("draw_diff_proc_aal --- in\n");
#endif

	if (procnum_aal <= 1)
		return;

	draw_information_diff_aal();

	draw_scale_diff_aal();

	if (NA_flag)
		draw_alignment_nacid_diff_aal();
	else
		draw_alignment_aacid_diff_aal();

	draw_idcol_diff_aal();

	draw_costgraph_diff_aal();
}

/*--------------------------------------------------------------------*/

static void
draw_information_diff_aal()
{
	extern AALDPMgr		aaldpmgr_aal;
	extern XFontStruct	*font15_aal;
	extern Widget		da_aal;
	extern GC		gc_bg_aal;
	extern int		procnum_aal;
	extern GC		gc_inf15_aal;
	extern int		Calc_cost;
	extern int		tcost_last_aal;
	int			x, y;
	Dimension		width, height;
	char			buffer[BUFSIZ];

	x = aaldpmgr_aal.marginvwleft
	    + 5 * aaldpmgr_aal.fontwidth;
	y = aaldpmgr_aal.marginvwtop;
	width = (19 + 1 + 3 + 1) * font15_aal->max_bounds.width;
	height = font15_aal->ascent + font15_aal->descent;
	XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
		       x, y, width, height);
	y += font15_aal->ascent;
	(void)sprintf(buffer, "MULTIPLE ALIGNMENT (%d)", procnum_aal);
	XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_inf15_aal,
		    x, y, buffer, strlen(buffer));

	Calc_cost = calcCost_result();
	if (Calc_cost != tcost_last_aal) {
		x = x
		    + (19 + 1 + 3 + 1) * font15_aal->max_bounds.width
		    + 5 * aaldpmgr_aal.fontwidth
		    + 19 * font15_aal->max_bounds.width;
		y = aaldpmgr_aal.marginvwtop;
		width = (1 + 10) * font15_aal->max_bounds.width;
		height = font15_aal->ascent + font15_aal->descent;
		XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
			       x, y, width, height);
		y += font15_aal->ascent;
		(void)sprintf(buffer, "%d", - Calc_cost);
		XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_inf15_aal,
			    x, y, buffer, strlen(buffer));
	}

	XFlush(XtDisplay(da_aal));
}

/*--------------------------------*/

void
blink_information_title_aal()
{
	extern Display	*dp_aal;
	int		i;
	void		erase_information_title_aal();
	void		draw_information_title_aal();

	for (i = 0; i < BLINK_CNT_AAL; i++) {
		erase_information_title_aal();
		draw_information_title_aal();
/*
		XBell(dp_aal, -50);
*/
#ifdef	MACHINE_HP
		sleep(1);
#elif	MACHINE_IRIS
		sleep(1);
#else
		usleep(10000);
#endif
	}
}

static void
draw_information_title_aal()
{
	extern int		procnum_aal;
	extern AALDPMgr		aaldpmgr_aal;
	extern XFontStruct	*font15_aal;
	extern Widget		da_aal;
	extern GC		gc_inf15_hl_aal;
	int			x, y;
	char			buffer[BUFSIZ];
	int			length;

	x = aaldpmgr_aal.marginvwleft
	    + 5 * aaldpmgr_aal.fontwidth;
	y = aaldpmgr_aal.marginvwtop
	    + font15_aal->ascent;

	(void)sprintf(buffer, "MULTIPLE ALIGNMENT (%d)", procnum_aal);
	length = strlen(buffer);

	XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_inf15_hl_aal,
		    x, y, buffer, length);

	XFlush(XtDisplay(da_aal));
}

static void
erase_information_title_aal()
{
	extern AALDPMgr		aaldpmgr_aal;
	extern int		procnum_aal;
	extern XFontStruct	*font15_aal;
	extern GC		gc_bg_aal;
	extern Widget		da_aal;
	int			x, y;
	int			length;
	Dimension		width, height;

	x = aaldpmgr_aal.marginvwleft
	    + 5 * aaldpmgr_aal.fontwidth;
	y = aaldpmgr_aal.marginvwtop;

	length = 21 + ((int)log10((double)procnum_aal) + 1);

	width = (Dimension)(length * font15_aal->max_bounds.width);
	height = (Dimension)(font15_aal->ascent + font15_aal->descent);

	XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
		       x, y, width, height);

	XFlush(XtDisplay(da_aal));
}

/*--------------------------------------------------------------------*/

static void
draw_scale_diff_aal()
{
	extern ANATextDataMgr	anatdm_aal;
	extern AALDPMgr		aaldpmgr_aal;
	extern INFO		Info;
	extern int		send_left;
	extern int		New_calc_leng;
	extern int		startcol_last_aal;
	extern int		allength_last_aal;
	extern Widget		da_aal;
	extern GC		gc_scale_aal;
	extern GC		gc_bg_aal;
	extern int		New_calc_leng;
	int			i, j;
	int			start, end;
	int			startlast, endlast;
	int			adjx;
	int			xo, yov, yol;
	int			dx;
	int			x;
	char			buffer[BUFSIZ];
	int			length;
	int			xbg, ybg;
	Dimension		widthbg, heightbg;
	int			xxo;
	int			dxx;
	int			xx;

	adjx = abs(anatdm_aal.bw - aaldpmgr_aal.fontwidth) / 2;
	xo = aaldpmgr_aal.marginvwleft
	     + aaldpmgr_aal.alnamewidth
	     + aaldpmgr_aal.algap
	     + adjx;
	yov = aaldpmgr_aal.marginvwtop
	      + aaldpmgr_aal.alinformation
	      + aaldpmgr_aal.fontascent;
	yol = yov + aaldpmgr_aal.fontheight;
	dx = MAX(anatdm_aal.bw, aaldpmgr_aal.fontwidth);

	start = send_left - Info.dataStartIndex + 1;
	end = start + New_calc_leng - 1;
	startlast = startcol_last_aal - Info.dataStartIndex + 1;
	endlast = startlast + allength_last_aal - 1;

	if (end > endlast) {
	    for (x = xo + (endlast - startlast + 1) * dx, i = endlast + 1;
		     i <= end;
		     x += dx, i++) {
		if (i % 10 == 0) {
			(void)sprintf(buffer, "%d", i);
			length = strlen(buffer);
			xxo = x + (1 - length) * aaldpmgr_aal.fontwidth / 2;
			dxx = aaldpmgr_aal.fontwidth;
			for (xx = xxo, j = 0; j < length; xx += dxx, j++) {
			    XDrawString(XtDisplay(da_aal),
					XtWindow(da_aal),
					gc_scale_aal,
					xx,
					yov,
					buffer + j,
					1);
			}
			XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_scale_aal,
				    x, yol,
				    "|", 1);
		}
		else
			XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_scale_aal,
				    x, yol,
				    "-", 1);
	    }
	}
	else if (end < endlast) {
		for (x = xo + (end - start + 1) * dx, i = end + 1;
		     i <= endlast;
		     x += dx, i++) {
		    if (i % 10 == 0) {
			(void)sprintf(buffer, "%d", i);
			length = strlen(buffer);
			xbg = x + (1 - length) * aaldpmgr_aal.fontwidth / 2;
			ybg = yov - aaldpmgr_aal.fontascent;
			widthbg = length * aaldpmgr_aal.fontwidth;
			heightbg = aaldpmgr_aal.fontheight; 
			XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
				       xbg, ybg, widthbg, heightbg);
		    }
		    xbg = x;
		    ybg = yol - aaldpmgr_aal.fontascent;
		    widthbg = (Dimension)aaldpmgr_aal.fontwidth;
		    heightbg = (Dimension)aaldpmgr_aal.fontheight; 
		    XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
				   xbg, ybg, widthbg, heightbg);
		}
	}

	XFlush(XtDisplay(da_aal));
}

/*--------------------------------------------------------------------*/

static void
draw_alignment_aacid_diff_aal()
{
	extern AALDPMgr		aaldpmgr_aal;
	extern ANATextDataMgr	anatdm_aal;
	extern Widget		da_aal;
	extern INFO		Info;
	extern int		left_flag, right_flag;
	extern int		send_left;
	extern int		New_calc_leng;
	extern int		endcol_last_aal;
	extern char		Calc_codeAlign[MAX_ALIGN][MAX_ALIGN_LENG];
	extern char		Calc_constraint[MAX_ALIGN][MAX_ALIGN_LENG];
	extern char		alignment_last_aal[MAX_ALIGN][MAX_ALIGN_LENG];
	extern char		constraint_last_aal[MAX_ALIGN][MAX_ALIGN_LENG];
	extern GC		Gray8GC[8];
	extern GC		WhiteGC, BlackGC;
	extern GC		gc_bg_aal;
	int			i, j;
	int			xo, yo;
	int			dx, dy;
	int			x, y;
	int			endcol;
	int			code;
	GC			gct;
	
	xo = aaldpmgr_aal.marginvwleft
	     + aaldpmgr_aal.alnamewidth
	     + aaldpmgr_aal.algap;
	yo = aaldpmgr_aal.marginvwtop
	     + aaldpmgr_aal.alinformation
	     + aaldpmgr_aal.alscale;

	dx = MAX(anatdm_aal.bw, aaldpmgr_aal.fontwidth);
	dy = MAX(anatdm_aal.bh, aaldpmgr_aal.fontheight);

#if	0
	(void)printf("draw_alignment_aacid_diff_aal --- Info.alignnum = %d\n",
		     Info.alignnum);
	(void)printf("draw_alignment_aacid_diff_aal --- send_left, New_calc_leng = %d %d\n",
		     send_left, New_calc_leng);
#endif
	endcol = send_left + New_calc_leng - 1;

	if (Gray8GC[CONST_GRAY] == WhiteGC)
	    gct = BlackGC;
	else
	    gct = WhiteGC;

	for (y = yo, i = 0; i < Info.alignnum; y += dy, i++) {
	    for (x = xo, j = send_left; j <= endcol; x += dx, j++) {
/*
		if (Calc_codeAlign[i][j] == alignment_last_aal[i][j] &&
		    Calc_constraint[i][j] == constraint_last_aal[i][j] )
		    continue;
*/
		code = Calc_codeAlign[i][j];
		if ((left_flag && j == send_left) ||
		    (right_flag && j == endcol)     ) {
		    XFillRectangle(XtDisplay(da_aal),
				   XtWindow(da_aal),
				   Gray8GC[CONST_GRAY],
				   x,
				   y,
				   (Dimension)anatdm_aal.bw,
				   (Dimension)anatdm_aal.bh);
		    XDrawString(XtDisplay(da_aal),
				XtWindow(da_aal),
				gct,
				x + (anatdm_aal.td+code)->tosx,
				y + (anatdm_aal.td+code)->tosy,
				(anatdm_aal.td+code)->text,
				strlen((anatdm_aal.td+code)->text));
		}
		else {
		    if (Calc_codeAlign[i][j] == alignment_last_aal[i][j] &&
		        Calc_constraint[i][j] == constraint_last_aal[i][j] )
			continue;
		    if ((int)Calc_constraint[i][j] <= 96) {
			XFillRectangle(XtDisplay(da_aal),
				       XtWindow(da_aal),
				       (anatdm_aal.td+code)->gcaabg,
				       x,
				       y,
				       (Dimension)anatdm_aal.bw,
				       (Dimension)anatdm_aal.bh);
			XDrawString(XtDisplay(da_aal),
				    XtWindow(da_aal),
				    (anatdm_aal.td+code)->gct,
				    x + (anatdm_aal.td+code)->tosx,
				    y + (anatdm_aal.td+code)->tosy,
				    (anatdm_aal.td+code)->text,
				    strlen((anatdm_aal.td+code)->text));
		    }
		    else {
			XFillRectangle(XtDisplay(da_aal),
				       XtWindow(da_aal),
				       Gray8GC[CONST_GRAY],
				       x,
				       y,
				       (Dimension)anatdm_aal.bw,
				       (Dimension)anatdm_aal.bh);
			XDrawString(XtDisplay(da_aal),
				    XtWindow(da_aal),
				    gct,
				    x + (anatdm_aal.td+code)->tosx,
				    y + (anatdm_aal.td+code)->tosy,
				    (anatdm_aal.td+code)->text,
				    strlen((anatdm_aal.td+code)->text));
		    }
		}
	    }
	    for (x = xo + (endcol - send_left + 1) * dx, j = endcol + 1;
		 j <= endcol_last_aal;
		 x += dx, j++) {
		    XFillRectangle(XtDisplay(da_aal),
				   XtWindow(da_aal),
				   gc_bg_aal,
				   x,
				   y,
				   (Dimension)anatdm_aal.bw,
				   (Dimension)anatdm_aal.bh);
	    }
	}

/*
	for (y = yo, i = 0; i < Info.alignnum; y += dy, i++) {
	    for (x = xo + (endcol - send_left + 1) * dx, j = endcol + 1;
		 j <= endcol_last_aal;
		 x += dx, j++) {
		    XFillRectangle(XtDisplay(da_aal),
				   XtWindow(da_aal),
				   gc_bg_aal,
				   x,
				   y,
				   (Dimension)anatdm_aal.bw,
				   (Dimension)anatdm_aal.bh);
	    }
	}
*/

	XFlush(XtDisplay(da_aal));
}

static void
draw_alignment_nacid_diff_aal()
{
	extern AALDPMgr		aaldpmgr_aal;
	extern ANATextDataMgr	anatdm_aal;
	extern Widget		da_aal;
	extern INFO		Info;
	extern int		left_flag, right_flag;
	extern int		send_left;
	extern int		New_calc_leng;
	extern int		endcol_last_aal;
	extern char		Calc_codeAlign[MAX_ALIGN][MAX_ALIGN_LENG];
	extern char		Calc_constraint[MAX_ALIGN][MAX_ALIGN_LENG];
	extern char		alignment_last_aal[MAX_ALIGN][MAX_ALIGN_LENG];
	extern char		constraint_last_aal[MAX_ALIGN][MAX_ALIGN_LENG];
	extern GC		Gray8GC[8];
	extern GC		WhiteGC, BlackGC;
	extern GC		gc_bg_aal;
	int			i, j;
	int			xo, yo;
	int			dx, dy;
	int			x, y;
	int			endcol;
	int			code;
	GC			gct;
	
	xo = aaldpmgr_aal.marginvwleft
	     + aaldpmgr_aal.alnamewidth
	     + aaldpmgr_aal.algap;
	yo = aaldpmgr_aal.marginvwtop
	     + aaldpmgr_aal.alinformation
	     + aaldpmgr_aal.alscale;

	dx = MAX(anatdm_aal.bw, aaldpmgr_aal.fontwidth);
	dy = MAX(anatdm_aal.bh, aaldpmgr_aal.fontheight);

	endcol = send_left + New_calc_leng - 1;

	if (Gray8GC[CONST_GRAY] == WhiteGC)
	    gct = BlackGC;
	else
	    gct = WhiteGC;

	for (y = yo, i = 0; i < Info.alignnum; y += dy, i++) {
	    for (x = xo, j = send_left; j <= endcol; x += dx, j++) {
/*
		if (Calc_codeAlign[i][j] == alignment_last_aal[i][j] &&
		    Calc_constraint[i][j] == constraint_last_aal[i][j] )
		    continue;
*/
		code = Calc_codeAlign[i][j];
		if ((left_flag && j == send_left) ||
		    (right_flag && j == endcol)     ) {
		    XFillRectangle(XtDisplay(da_aal),
				   XtWindow(da_aal),
				   Gray8GC[CONST_GRAY],
				   x,
				   y,
				   (Dimension)anatdm_aal.bw,
				   (Dimension)anatdm_aal.bh);
		    XDrawString(XtDisplay(da_aal),
				XtWindow(da_aal),
				gct,
				x + (anatdm_aal.td+code)->tosx,
				y + (anatdm_aal.td+code)->tosy,
				(anatdm_aal.td+code)->text,
				strlen((anatdm_aal.td+code)->text));
		}
		else {
		    if (Calc_codeAlign[i][j] == alignment_last_aal[i][j] &&
		        Calc_constraint[i][j] == constraint_last_aal[i][j] )
			continue;
		    if ((int)Calc_constraint[i][j] <= 96) {
			XFillRectangle(XtDisplay(da_aal),
				       XtWindow(da_aal),
				       (anatdm_aal.td+code)->gcnabg,
				       x,
				       y,
				       (Dimension)anatdm_aal.bw,
				       (Dimension)anatdm_aal.bh);
			XDrawString(XtDisplay(da_aal),
				    XtWindow(da_aal),
				    (anatdm_aal.td+code)->gct,
				    x + (anatdm_aal.td+code)->tosx,
				    y + (anatdm_aal.td+code)->tosy,
				    (anatdm_aal.td+code)->text,
				    strlen((anatdm_aal.td+code)->text));
		    }
		    else {
			XFillRectangle(XtDisplay(da_aal),
				       XtWindow(da_aal),
				       Gray8GC[CONST_GRAY],
				       x,
				       y,
				       (Dimension)anatdm_aal.bw,
				       (Dimension)anatdm_aal.bh);
			XDrawString(XtDisplay(da_aal),
				    XtWindow(da_aal),
				    gct,
				    x + (anatdm_aal.td+code)->tosx,
				    y + (anatdm_aal.td+code)->tosy,
				    (anatdm_aal.td+code)->text,
				    strlen((anatdm_aal.td+code)->text));
		    }
		}
	    }
	    for (x = xo + (endcol - send_left + 1) * dx, j = endcol + 1;
		 j <= endcol_last_aal;
		 x += dx, j++) {
		    XFillRectangle(XtDisplay(da_aal),
				   XtWindow(da_aal),
				   gc_bg_aal,
				   x,
				   y,
				   (Dimension)anatdm_aal.bw,
				   (Dimension)anatdm_aal.bh);
	    }
	}

	XFlush(XtDisplay(da_aal));
}

/*--------------------------------------------------------------------*/

static void
draw_idcol_diff_aal()
{
	extern ANATextDataMgr	anatdm_aal;
	extern AALDPMgr		aaldpmgr_aal;
	extern int		Calc_idColumn[MAX_ALIGN_LENG];
	extern int		idcol_last_aal[MAX_ALIGN_LENG];
	extern Widget		da_aal;
	extern GC		gc_identity_aal;
	extern GC		gc_bg_aal;
	extern char		anacode_itoc_aal[ANACID_COUNT_AAL];
	extern int		send_left;
	extern int		New_calc_leng;
	extern int		endcol_last_aal;
	extern int		IdenticalRatio;
	extern int		get_identity_aal();
	int			i;
	int			adjx;
	int			xo, yo, ybg;
	int			dx;
	int			x;
	Dimension		widthbg, heightbg;
	int			endcol;

	adjx = abs(anatdm_aal.bw - aaldpmgr_aal.fontwidth) / 2;
	xo = aaldpmgr_aal.marginvwleft
	     + aaldpmgr_aal.alnamewidth
	     + aaldpmgr_aal.algap
	     + adjx;
	ybg = aaldpmgr_aal.marginvwtop
	      + aaldpmgr_aal.alinformation
	      + aaldpmgr_aal.alscale
	      + aaldpmgr_aal.aldataheight;
	yo = ybg + aaldpmgr_aal.fontascent;
	dx = MAX(anatdm_aal.bw, aaldpmgr_aal.fontwidth);

	widthbg = (Dimension)dx;
	heightbg = (Dimension)aaldpmgr_aal.fontheight;

	endcol = send_left + New_calc_leng - 1;

	for (x = xo, i = send_left; i <= endcol; x += dx, i++) {
		Calc_idColumn[i] = get_identity_aal(i, IdenticalRatio);
		if (Calc_idColumn[i] == idcol_last_aal[i])
			continue;
		XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
			       x, ybg, widthbg, heightbg);
		if (Calc_idColumn[i] >= ANACID_CODE_MIN_AAL &&
		    Calc_idColumn[i] <= ANACID_CODE_MAX_AAL   )
			XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_identity_aal,
				    x, yo,
				    anacode_itoc_aal + Calc_idColumn[i], 1);
	}

	for (x = xo + (endcol - send_left + 1) * dx, i = endcol + 1;
	     i <= endcol_last_aal;
	     x += dx, i++) {
		XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
			       x, ybg, widthbg, heightbg);
	}

	XFlush(XtDisplay(da_aal));
}

/*--------------------------------------------------------------------*/

static void
draw_costgraph_diff_aal()
{
	extern ANATextDataMgr	anatdm_aal;
	extern AALDPMgr		aaldpmgr_aal;
	extern int		send_left;
	extern int		New_calc_leng;
	extern int		endcol_last_aal;
	extern int		Calc_columnCost[MAX_ALIGN_LENG];
	extern int		ccost_last_aal[MAX_ALIGN_LENG];
	extern int		BouMaxValue;
	extern int		BouMaxRatio;
	extern Widget		da_aal;
	extern GC		gc_cost_plus_aal;
	extern GC		gc_cost_motif_aal;
	extern GC		gc_cost_minus_aal;
	extern GC		gc_bg_aal;
	int			i;
	int			adjx;
	int			xo, yo, ybg;
	int			dx;
	int			x, y;
	float			mcplus, mcminus;
	int			endcol;
	int			cost;
	Dimension		widthbg, heightbg;
	Dimension		width, height;
	Dimension		mrheight;
	GC			gc;

	adjx = abs(anatdm_aal.bw - aaldpmgr_aal.fontwidth) / 2;
	xo = aaldpmgr_aal.marginvwleft
	     + aaldpmgr_aal.alnamewidth
	     + aaldpmgr_aal.algap
	     + adjx;
	ybg = aaldpmgr_aal.marginvwtop
	      + aaldpmgr_aal.alinformation
	      + aaldpmgr_aal.alscale
	      + aaldpmgr_aal.aldataheight
	      + aaldpmgr_aal.alidentity;
	yo = ybg + aaldpmgr_aal.alcgplus;
	dx = MAX(anatdm_aal.bw, aaldpmgr_aal.fontwidth);

	widthbg = (Dimension)dx;
	heightbg = (Dimension)aaldpmgr_aal.alcostgraph;

	mcplus = (float)aaldpmgr_aal.alcgplus / (float)BouMaxValue;
	mcminus = (float)aaldpmgr_aal.alcgminus / (float)BouMaxValue;

	endcol = send_left + New_calc_leng - 1;

	calc_column_cost_result(send_left, endcol);

	for (x = xo, i = send_left; i <= endcol; x += dx, i++) {
		if (Calc_columnCost[i] == ccost_last_aal[i])
			continue;
		XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
			       x, ybg, widthbg, heightbg);
		cost = - Calc_columnCost[i];
		if (cost == 0)
			continue;
		else if (cost > 0) {
			height = (Dimension)(mcplus * (float)cost + 0.5);
/*
			if (height == 0)
				height = 1;
*/
			if (height > aaldpmgr_aal.alcgplus)
				height = aaldpmgr_aal.alcgplus;
			y = yo - height;
			mrheight = (int)((float)aaldpmgr_aal.alcgplus
					 * (float)BouMaxRatio
					 / 100.0);
			if (height >= mrheight)
				gc = gc_cost_motif_aal;
			else
				gc = gc_cost_plus_aal;
		}
		else if (cost < 0) {
			height = (Dimension)(mcminus * (float)(- cost) + 0.5);
/*
			if (height == 0)
				height = 1;
*/
			if (height > aaldpmgr_aal.alcgminus)
				height = aaldpmgr_aal.alcgminus;
			y = yo;
			gc = gc_cost_minus_aal;
		}
		width = (Dimension)dx;
		if (width > 1)
			width--;
		XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc,
			       x, y, width, height);
	}

	for (x = xo + (endcol - send_left + 1) * dx, i = endcol + 1;
	     i <= endcol_last_aal;
	     x += dx, i++) {
		XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
			       x, ybg, widthbg, heightbg);
	}

	XFlush(XtDisplay(da_aal));
}

/*--------------------------------------------------------------------*/

void
display_alignment_monitor(fflag, value)
int	fflag;
int	value;
{
	extern Widget		da_aal;
	extern GC		gc_monitor_aal;
	extern GC		gc_inf15_hl_aal;
	extern GC		gc_bg_aal;
	static int		fullvalue;
	static int		lastvalue;
	static Dimension	lastwidth;
	int			x = 100;
	int			y = 100;
	Dimension		width = 400;
	Dimension		height = 50;
	char			scale[BUFSIZ];
	Dimension		currentwidth;
	extern void		draw_background_aal();
	extern void		fatal_error();

#ifdef	DEBUG
	(void)printf("display_alignment_monitor --- fflag, value = %d %d\n",
		     fflag, value);
#endif

	if (fflag) {
#ifdef	CHECK
		if (value <= 0)
			fatal_error("display_alignment_monitor",
				    "illegal value (%d)",
				    value);
#endif
		draw_background_aal();
		XDrawRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_monitor_aal,
			       x, y, width, height);
		(void)sprintf(scale, "( %d / %d )", 0, value);
		XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_inf15_hl_aal,
			    x + (int)width / 3, y * 2 / 3, scale, strlen(scale));
		fullvalue = value;
		lastvalue = 0;
		lastwidth = 0;
	}
	else {
#ifdef	CHECK
		if (value < lastvalue || value > fullvalue)
			fatal_error("display_alignment_monitor",
				    "illegal value (%d<=%d<=%d)\n",
				    lastvalue, value, fullvalue);
#endif
		currentwidth = (Dimension)((float)width * (float)value / (float)fullvalue);
		if (currentwidth > lastwidth)
			XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_monitor_aal,
				       x + (int)lastwidth, y, currentwidth - lastwidth, height);
		if (value > lastvalue) {
			XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
				       x, 0, width, (Dimension)y - 1);
			(void)sprintf(scale, "( %d / %d )", value, fullvalue);
			XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_inf15_hl_aal,
				    x + (int)width / 3, y * 2 / 3, scale, strlen(scale));
		}
		lastwidth = currentwidth;
		lastvalue = value;
	}

	XFlush(XtDisplay(da_aal));
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
