/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	ե̾	aeg_aalda.c
			ɥ󥰡ꥢʼư饤ȡ

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<string.h>
#include	<math.h>

#include	"aedit.h"

#include	"aeg_aaldef.h"

/*--------------------------------------------------------------------*/

#if	1
#define	CHECK
#endif

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

void
draw_proc_aal()
{
	extern int	procnum_aal;
	void		draw_background_aal();
	void		draw_information_aal();
	void		draw_alname_aal();
	void		draw_scale_aal();
	void		draw_alignment_aacid_aal();
	void		draw_alignment_nacid_aal();
/*
	void		draw_const_aal();
*/
	void		draw_idcol_aal();
	void		draw_costgraph_aal();

#ifdef	DEBUG
	(void)printf("draw_proc_aal --- in\n");
#endif

	if (procnum_aal <= 0)
		return;

	draw_background_aal();

	draw_information_aal();

	draw_alname_aal();

	draw_scale_aal();

	if (NA_flag)
		draw_alignment_nacid_aal();
	else
		draw_alignment_aacid_aal();

/*
	draw_const_aal();
*/

	draw_idcol_aal();

	draw_costgraph_aal();
}

/*--------------------------------------------------------------------*/

void
draw_background_aal()
{
	extern Widget	da_aal;
	extern GC	gc_bg_aal;
	int		i;
	Arg		args[2];
	Dimension	width, height;

	i = 0;
	XtSetArg(args[i], XmNwidth, &width);
	i++;
	XtSetArg(args[i], XmNheight, &height);
	i++;
	XtGetValues(da_aal, args, i);

	XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
		       0, 0, width, height);

	XFlush(XtDisplay(da_aal));
}

/*--------------------------------------------------------------------*/

static void
draw_information_aal()
{
	extern int		procnum_aal;
	extern AALDPMgr		aaldpmgr_aal;
	extern XFontStruct	*font15_aal;
	extern GC		gc_inf15_aal;
	extern Widget		da_aal;
	extern int		send_left, send_right;
	extern int		Calc_cost;
	int			x, y;
	char			buffer[BUFSIZ];
	int			cost;

	x = aaldpmgr_aal.marginvwleft
	    + 5 * aaldpmgr_aal.fontwidth;
	y = aaldpmgr_aal.marginvwtop
	    + font15_aal->ascent;

	(void)sprintf(buffer, "MULTIPLE ALIGNMENT (%d)", procnum_aal);

	XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_inf15_aal,
		    x, y, buffer, strlen(buffer));

	x = x
	    + (19 + 1 + 3 + 1) * font15_aal->max_bounds.width
	    + 5 * aaldpmgr_aal.fontwidth;
	y = aaldpmgr_aal.marginvwtop
	    + font15_aal->ascent;

	Calc_cost = calcCost_result();
	(void)sprintf(buffer, "After  Calculate = %d", - Calc_cost);

	XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_inf15_aal,
		    x, y, buffer, strlen(buffer));

	y += (font15_aal->ascent + font15_aal->descent);

	cost = calcCost(send_left, send_right);
	(void)sprintf(buffer, "Before Calculate = %d", - cost);

	XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_inf15_aal,
		    x, y, buffer, strlen(buffer));

	XFlush(XtDisplay(da_aal));
}

static void
erase_information_aal()
{
	extern AALDPMgr	aaldpmgr_aal;
	extern GC	gc_bg_aal;
	extern Widget	da_aal;
	int		x, y;
	int		i;
	Arg		args[1];
	Dimension	width, height;

	x = aaldpmgr_aal.marginvwleft;
	y = aaldpmgr_aal.marginvwtop;

	i = 0;
	XtSetArg(args[i], XmNwidth, &width);
	i++;
	XtGetValues(da_aal, args, i);
	height = (Dimension)aaldpmgr_aal.alinformation;

	XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
		       x, y, width, height);

	XFlush(XtDisplay(da_aal));
}

/*--------------------------------------------------------------------*/

static void
draw_scale_aal()
{
	extern ANATextDataMgr	anatdm_aal;
	extern AALDPMgr		aaldpmgr_aal;
	extern Widget		da_aal;
	extern GC		gc_scale_aal;
	extern int		send_left;
	extern int		New_calc_leng;
	int			i, j;
	int			startcol, endcol;
	int			adjx;
	int			xo, yov, yol;
	int			dx;
	int			x;
	char			buffer[BUFSIZ];
	int			length;
	int			xxo;
	int			dxx;
	int			xx;

	adjx = abs(anatdm_aal.bw - aaldpmgr_aal.fontwidth) / 2;
	xo = aaldpmgr_aal.marginvwleft
	     + aaldpmgr_aal.alnamewidth
	     + aaldpmgr_aal.algap
	     + adjx;;
	yov = aaldpmgr_aal.marginvwtop
	      + aaldpmgr_aal.alinformation
	      + aaldpmgr_aal.fontascent;
	yol = yov + aaldpmgr_aal.fontheight;
	dx = MAX(anatdm_aal.bw, aaldpmgr_aal.fontwidth);

	startcol = send_left - Info.dataStartIndex + 1;
	endcol = startcol + New_calc_leng - 1;

	for (x = xo, i = startcol; i <= endcol; x += dx, i++) {
		if (i % 10 == 0) {
			(void)sprintf(buffer, "%d", i);
			length = strlen(buffer);
			xxo = x + (1 - length) * aaldpmgr_aal.fontwidth / 2;
			dxx = aaldpmgr_aal.fontwidth;
			for (xx = xxo, j = 0; j < length; xx += dxx, j++) {
				XDrawString(XtDisplay(da_aal),
					    XtWindow(da_aal),
					    gc_scale_aal,
					    xx,
					    yov,
					    buffer + j,
					    1);
			}
			XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_scale_aal,
				    x, yol,
				    "|", 1);
		}
		else
			XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_scale_aal,
				    x, yol,
				    "-", 1);
	}

	XFlush(XtDisplay(da_aal));
}

/*--------------------------------------------------------------------*/

static void
draw_alname_aal()
{
	extern AALDPMgr		aaldpmgr_aal;
	extern ANATextDataMgr	anatdm_aal;
	extern INFO		Info;
	extern Widget		da_aal;
	extern GC		gc_alname_aal;
	int			i, j;
	int			xo, yo;
	int			dx, dy;
	int			x, y;
	int			length;

	xo = aaldpmgr_aal.marginvwleft;
	yo = aaldpmgr_aal.marginvwtop
	     + aaldpmgr_aal.alinformation
	     + aaldpmgr_aal.alscale
	     + aaldpmgr_aal.fontascent;

/*
	dx = aaldpmgr_aal.fontwidth;
*/
	dx = MAX(aaldpmgr_aal.fontwidth, anatdm_aal.bw);
	dy = MAX(aaldpmgr_aal.fontheight, anatdm_aal.bh);

	for (y = yo, i = 0; i < Info.alignnum; y += dy, i++) {
		length = strlen(Info.alignname[i]);
		for (x = xo, j = 0; j < length; x += dx, j++)
			XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_alname_aal,
				    x, y, &Info.alignname[i][j], 1);
	}

	XFlush(XtDisplay(da_aal));
}

/*--------------------------------------------------------------------*/

static void
draw_alignment_aacid_aal()
{
	extern AALDPMgr		aaldpmgr_aal;
	extern ANATextDataMgr	anatdm_aal;
	extern Widget		da_aal;
	extern INFO		Info;
	extern int		left_flag, right_flag;
	extern int		send_left;
	extern int		New_calc_leng;
	extern char		Calc_codeAlign[MAX_ALIGN][MAX_ALIGN_LENG];
	extern char		Calc_constraint[MAX_ALIGN][MAX_ALIGN_LENG];
	extern GC		Gray8GC[8];
	extern GC		WhiteGC, BlackGC;
	int			i, j;
	int			xo, yo;
	int			dx, dy;
	int			x, y;
	int			endcol;
	int			code;
	GC			gct;
	
	xo = aaldpmgr_aal.marginvwleft
	     + aaldpmgr_aal.alnamewidth
	     + aaldpmgr_aal.algap;
	yo = aaldpmgr_aal.marginvwtop
	     + aaldpmgr_aal.alinformation
	     + aaldpmgr_aal.alscale;

	dx = MAX(anatdm_aal.bw, aaldpmgr_aal.fontwidth);
	dy = MAX(anatdm_aal.bh, aaldpmgr_aal.fontheight);

#if	0
	(void)printf("draw_alignment_aacid_aal --- Info.alignnum = %d\n",
		     Info.alignnum);
	(void)printf("draw_alignment_aacid_aal --- send_left, New_calc_leng = %d %d\n",
		     send_left, New_calc_leng);
#endif
	endcol = send_left + New_calc_leng - 1;

	if (Gray8GC[CONST_GRAY] == WhiteGC)
	    gct = BlackGC;
	else
	    gct = WhiteGC;

	for (y = yo, i = 0; i < Info.alignnum; y += dy, i++) {
	    for (x = xo, j = send_left; j <= endcol; x += dx, j++) {
		code = Calc_codeAlign[i][j];
		if ((left_flag && j == send_left) ||
		    (right_flag && j == endcol)     ) {
		    XFillRectangle(XtDisplay(da_aal),
				   XtWindow(da_aal),
				   Gray8GC[CONST_GRAY],
				   x,
				   y,
				   (Dimension)anatdm_aal.bw,
				   (Dimension)anatdm_aal.bh);
		    XDrawString(XtDisplay(da_aal),
				XtWindow(da_aal),
				gct,
				x + (anatdm_aal.td+code)->tosx,
				y + (anatdm_aal.td+code)->tosy,
				(anatdm_aal.td+code)->text,
				strlen((anatdm_aal.td+code)->text));
		}
		else {
		    if ((int)Calc_constraint[i][j] <= 96) {
			XFillRectangle(XtDisplay(da_aal),
				       XtWindow(da_aal),
				       (anatdm_aal.td+code)->gcaabg,
				       x,
				       y,
				       (Dimension)anatdm_aal.bw,
				       (Dimension)anatdm_aal.bh);
			XDrawString(XtDisplay(da_aal),
				    XtWindow(da_aal),
				    (anatdm_aal.td+code)->gct,
				    x + (anatdm_aal.td+code)->tosx,
				    y + (anatdm_aal.td+code)->tosy,
				    (anatdm_aal.td+code)->text,
				    strlen((anatdm_aal.td+code)->text));
		    }
		    else {
			XFillRectangle(XtDisplay(da_aal),
				       XtWindow(da_aal),
				       Gray8GC[CONST_GRAY],
				       x,
				       y,
				       (Dimension)anatdm_aal.bw,
				       (Dimension)anatdm_aal.bh);
			XDrawString(XtDisplay(da_aal),
				    XtWindow(da_aal),
				    gct,
				    x + (anatdm_aal.td+code)->tosx,
				    y + (anatdm_aal.td+code)->tosy,
				    (anatdm_aal.td+code)->text,
				    strlen((anatdm_aal.td+code)->text));
		    }
		}
	    }
	}

	XFlush(XtDisplay(da_aal));
}

static void
draw_alignment_nacid_aal()
{
	extern AALDPMgr		aaldpmgr_aal;
	extern ANATextDataMgr	anatdm_aal;
	extern Widget		da_aal;
	extern INFO		Info;
	extern int		left_flag, right_flag;
	extern int		send_left;
	extern int		New_calc_leng;
	extern char		Calc_codeAlign[MAX_ALIGN][MAX_ALIGN_LENG];
	extern char		Calc_constraint[MAX_ALIGN][MAX_ALIGN_LENG];
	extern GC		Gray8GC[8];
	extern GC		WhiteGC, BlackGC;
	int			i, j;
	int			xo, yo;
	int			dx, dy;
	int			x, y;
	int			endcol;
	int			code;
	GC			gct;
	
	xo = aaldpmgr_aal.marginvwleft
	     + aaldpmgr_aal.alnamewidth
	     + aaldpmgr_aal.algap;
	yo = aaldpmgr_aal.marginvwtop
	     + aaldpmgr_aal.alinformation
	     + aaldpmgr_aal.alscale;

	dx = MAX(anatdm_aal.bw, aaldpmgr_aal.fontwidth);
	dy = MAX(anatdm_aal.bh, aaldpmgr_aal.fontheight);

	endcol = send_left + New_calc_leng - 1;

	if (Gray8GC[CONST_GRAY] == WhiteGC)
	    gct = BlackGC;
	else
	    gct = WhiteGC;

	for (y = yo, i = 0; i < Info.alignnum; y += dy, i++) {
	    for (x = xo, j = send_left; j <= endcol; x += dx, j++) {
		code = Calc_codeAlign[i][j];
		if ((left_flag && j == send_left) ||
		    (right_flag && j == endcol)     ) {
		    XFillRectangle(XtDisplay(da_aal),
				   XtWindow(da_aal),
				   Gray8GC[CONST_GRAY],
				   x,
				   y,
				   (Dimension)anatdm_aal.bw,
				   (Dimension)anatdm_aal.bh);
		    XDrawString(XtDisplay(da_aal),
				XtWindow(da_aal),
				gct,
				x + (anatdm_aal.td+code)->tosx,
				y + (anatdm_aal.td+code)->tosy,
				(anatdm_aal.td+code)->text,
				strlen((anatdm_aal.td+code)->text));
		}
		else {
		    if ((int)Calc_constraint[i][j] <= 96) {
			XFillRectangle(XtDisplay(da_aal),
				       XtWindow(da_aal),
				       (anatdm_aal.td+code)->gcnabg,
				       x,
				       y,
				       (Dimension)anatdm_aal.bw,
				       (Dimension)anatdm_aal.bh);
			XDrawString(XtDisplay(da_aal),
				    XtWindow(da_aal),
				    (anatdm_aal.td+code)->gct,
				    x + (anatdm_aal.td+code)->tosx,
				    y + (anatdm_aal.td+code)->tosy,
				    (anatdm_aal.td+code)->text,
				    strlen((anatdm_aal.td+code)->text));
		    }
		    else {
			XFillRectangle(XtDisplay(da_aal),
				       XtWindow(da_aal),
				       Gray8GC[CONST_GRAY],
				       x,
				       y,
				       (Dimension)anatdm_aal.bw,
				       (Dimension)anatdm_aal.bh);
			XDrawString(XtDisplay(da_aal),
				    XtWindow(da_aal),
				    gct,
				    x + (anatdm_aal.td+code)->tosx,
				    y + (anatdm_aal.td+code)->tosy,
				    (anatdm_aal.td+code)->text,
				    strlen((anatdm_aal.td+code)->text));
		    }
		}
	    }
	}

	XFlush(XtDisplay(da_aal));
}

/*--------------------------------------------------------------------*/

static void
draw_const_aal()
{
	extern int	send_left;
	extern int	New_calc_leng;
	extern int	left_flag, right_flag;
	extern INFO	Info;
	extern GC	Gray8GC[8];
	extern char	Calc_constraint[MAX_ALIGN][MAX_ALIGN_LENG];
	int		endcol;
	int		i, j;
	void		draw_oneconst_aal();

	endcol = send_left + New_calc_leng - 1;

	if (left_flag) {
		for (i = 0; i < Info.alignnum; i++)
			draw_oneconst_aal(i, send_left, Gray8GC[CONST_GRAY]);
	}

	if (right_flag) {
		for (i = 0; i < Info.alignnum; i++)
			draw_oneconst_aal(i, endcol, Gray8GC[CONST_GRAY]);
	}

	for (i = 0; i < Info.alignnum; i++) {
		for (j = send_left; j <= endcol; j++) {
			if ((int)Calc_constraint[i][j] > 96)
				draw_oneconst_aal(i, j, Gray8GC[CONST_GRAY]);
		}
	}
}

static void
draw_oneconst_aal(alignnum, column, gcbg)
int	alignnum;
int	column;
GC	gcbg;
{
	extern AALDPMgr		aaldpmgr_aal;
	extern ANATextDataMgr	anatdm_aal;
	extern int		send_left;
	extern GC		WhiteGC, BlackGC;
	extern Widget		da_aal;
	int			xo, yo;
	int			dx, dy;
	int			x, y;
	GC			gct;
	int			code;

#if	0
	(void)printf("draw_oneconst_aal --- alignnum, column = %d %d\n",
		     alignnum, column);
#endif

	xo = aaldpmgr_aal.marginvwleft
	     + aaldpmgr_aal.alnamewidth
	     + aaldpmgr_aal.algap;
	yo = aaldpmgr_aal.marginvwtop
	     + aaldpmgr_aal.alinformation
	     + aaldpmgr_aal.alscale;

	dx = MAX(anatdm_aal.bw, aaldpmgr_aal.fontwidth);
	dy = MAX(anatdm_aal.bh, aaldpmgr_aal.fontheight);

	x = xo + (column - send_left) * dx;
	y = yo + alignnum * dy;

	if (gcbg == WhiteGC)
		gct = BlackGC;
	else
		gct = WhiteGC;

	code = Calc_codeAlign[alignnum][column];

	XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gcbg,
		       x, y, (Dimension)anatdm_aal.bw, (Dimension)anatdm_aal.bh);
	XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gct,
		    x + (anatdm_aal.td+code)->tosx, y + (anatdm_aal.td+code)->tosy,
		    (anatdm_aal.td+code)->text, strlen((anatdm_aal.td+code)->text));

	XFlush(XtDisplay(da_aal));
}

/*--------------------------------------------------------------------*/

static void
draw_idcol_aal()
{
	extern ANATextDataMgr	anatdm_aal;
	extern AALDPMgr		aaldpmgr_aal;
	extern int		Calc_idColumn[MAX_ALIGN_LENG];
	extern Widget		da_aal;
	extern GC		gc_identity_aal;
	extern char		anacode_itoc_aal[ANACID_COUNT_AAL];
	extern int		send_left;
	extern int		New_calc_leng;
	extern int		IdenticalRatio;
	extern int		get_identity_aal();
	int			i;
	int			adjx;
	int			xo, yo;
	int			dx;
	int			x;
	int			endcol;

	adjx = abs(anatdm_aal.bw - aaldpmgr_aal.fontwidth) / 2;
	xo = aaldpmgr_aal.marginvwleft
	     + aaldpmgr_aal.alnamewidth
	     + aaldpmgr_aal.algap
	     + adjx;
	yo = aaldpmgr_aal.marginvwtop
	     + aaldpmgr_aal.alinformation
	     + aaldpmgr_aal.alscale
	     + aaldpmgr_aal.aldataheight
	     + aaldpmgr_aal.fontascent;
	dx = MAX(anatdm_aal.bw, aaldpmgr_aal.fontwidth);

	endcol = send_left + New_calc_leng - 1;

	for (x = xo, i = send_left; i <= endcol; x += dx, i++) {
/*
		if (!identical(i, IdenticalRatio, &code))
			continue; 
*/
		Calc_idColumn[i] = get_identity_aal(i, IdenticalRatio);
#if	0
		(void)printf("IdenticalRatio, Calc_idColumn[i] = %d %d %d\n",
			     IdenticalRatio, Calc_idColumn[i], i);
#endif
		if (Calc_idColumn[i] >= ANACID_CODE_MIN_AAL &&
		    Calc_idColumn[i] <= ANACID_CODE_MAX_AAL   )
			XDrawString(XtDisplay(da_aal), XtWindow(da_aal), gc_identity_aal,
				    x, yo,
				    anacode_itoc_aal + Calc_idColumn[i], 1);
	}

	XFlush(XtDisplay(da_aal));
}

static void
erase_idcol_aal()
{
	extern ANATextDataMgr	anatdm_aal;
	extern AALDPMgr		aaldpmgr_aal;
	extern Widget		da_aal;
	extern GC		gc_bg_aal;
	extern int		New_calc_leng;
	int			adjx;
	int			xo, yo;
	int			w, h;
	Dimension		width, height;

	adjx = abs(anatdm_aal.bw - aaldpmgr_aal.fontwidth) / 2;
	xo = aaldpmgr_aal.marginvwleft
	     + aaldpmgr_aal.alnamewidth
	     + aaldpmgr_aal.algap
	     + adjx;
	yo = aaldpmgr_aal.marginvwtop
	     + aaldpmgr_aal.alinformation
	     + aaldpmgr_aal.alscale
	     + aaldpmgr_aal.aldataheight;
	w = MAX(anatdm_aal.bw, aaldpmgr_aal.fontwidth);
	h = MAX(anatdm_aal.bh, aaldpmgr_aal.fontheight);
	width = New_calc_leng * w;
	height = h;

	XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
		       xo, yo, width, height);

	XFlush(XtDisplay(da_aal));
}

/*--------------------------------------------------------------------*/

static void
draw_costgraph_aal()
{
	extern ANATextDataMgr	anatdm_aal;
	extern AALDPMgr		aaldpmgr_aal;
	extern int		send_left;
	extern int		New_calc_leng;
	extern int		Calc_columnCost[MAX_ALIGN_LENG];
	extern int		BouMaxValue;
	extern int		BouMaxRatio;
	extern Widget		da_aal;
	extern GC		gc_cost_plus_aal;
	extern GC		gc_cost_motif_aal;
	extern GC		gc_cost_minus_aal;
	int			i;
	int			adjx;
	int			xo, yo;
	int			dx;
	int			x, y;
	float			mcplus, mcminus;
	int			endcol;
	int			cost;
	Dimension		width, height;
	Dimension		mrheight;
	GC			gc;

	adjx = abs(anatdm_aal.bw - aaldpmgr_aal.fontwidth) / 2;
	xo = aaldpmgr_aal.marginvwleft
	     + aaldpmgr_aal.alnamewidth
	     + aaldpmgr_aal.algap
	     + adjx;
	yo = aaldpmgr_aal.marginvwtop
	     + aaldpmgr_aal.alinformation
	     + aaldpmgr_aal.alscale
	     + aaldpmgr_aal.aldataheight
	     + aaldpmgr_aal.alidentity
	     + aaldpmgr_aal.alcgplus;
	dx = MAX(anatdm_aal.bw, aaldpmgr_aal.fontwidth);

	mcplus = (float)aaldpmgr_aal.alcgplus / (float)BouMaxValue;
	mcminus = (float)aaldpmgr_aal.alcgminus / (float)BouMaxValue;

	endcol = send_left + New_calc_leng - 1;

	calc_column_cost_result(send_left, endcol);

	for (x = xo, i = send_left; i <= endcol; x += dx, i++) {
		cost = - Calc_columnCost[i];
#if	0
		(void)printf("draw_costgraph_aal --- i, cost = %d %d\n", i, cost);
#endif
		if (cost == 0)
			continue;
		else if (cost > 0) {
			height = (Dimension)(mcplus * (float)cost + 0.5);
/*
			if (height == 0)
				height = 1;
*/
			if (height > aaldpmgr_aal.alcgplus)
				height = aaldpmgr_aal.alcgplus;
			y = yo - height;
			mrheight = (int)((float)aaldpmgr_aal.alcgplus
					 * (float)BouMaxRatio
					 / 100.0);
			if (height >= mrheight)
				gc = gc_cost_motif_aal;
			else
				gc = gc_cost_plus_aal;
		}
		else if (cost < 0) {
			height = (Dimension)(mcminus * (float)(- cost) + 0.5);
/*
			if (height == 0)
				height = 1;
*/
			if (height > aaldpmgr_aal.alcgminus)
				height = aaldpmgr_aal.alcgminus;
			y = yo;
			gc = gc_cost_minus_aal;
		}
		width = (Dimension)dx;
		if (width > 1)
			width--;
		XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc,
			       x, y, width, height);
	}

	XFlush(XtDisplay(da_aal));
}

static void
erase_costgraph_aal()
{
	extern ANATextDataMgr	anatdm_aal;
	extern AALDPMgr		aaldpmgr_aal;
	extern int		New_calc_leng;
	extern Widget		da_aal;
	extern GC		gc_bg_aal;
	int			adjx;
	int			xo, yo;
	int			w;
	Dimension		width, height;

	adjx = abs(anatdm_aal.bw - aaldpmgr_aal.fontwidth) / 2;
	xo = aaldpmgr_aal.marginvwleft
	     + aaldpmgr_aal.alnamewidth
	     + aaldpmgr_aal.algap
	     + adjx;
	yo = aaldpmgr_aal.marginvwtop
	     + aaldpmgr_aal.alinformation
	     + aaldpmgr_aal.alscale
	     + aaldpmgr_aal.aldataheight
	     + aaldpmgr_aal.alidentity;
	w = MAX(anatdm_aal.bw, aaldpmgr_aal.fontwidth);
	width = New_calc_leng * w;
	height = aaldpmgr_aal.alcostgraph;

	XFillRectangle(XtDisplay(da_aal), XtWindow(da_aal), gc_bg_aal,
		       xo, yo, width, height);

	XFlush(XtDisplay(da_aal));
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
