/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------

	ե̾	aeg_aalda.c
			ɥ󥰡ꥢʼư饤ȡ

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<string.h>
#include	<math.h>

#include	<Xm/ScrolledW.h>
#include	<Xm/DrawingA.h>

#include	"aedit.h"

#include	"aeg_aaldef.h"

/*--------------------------------------------------------------------*/

#define	SW_RATIO_WIDTH_AAL	1.0
#define	SW_RATIO_HEIGHT_AAL	0.8

/*
#define	DA_RATIO_WIDTH_AAL	1.0
#define	DA_RATIO_HEIGHT_AAL	1.0
*/

#define	DA_WIDTH_ADJ_AAL	31
#define	DA_HEIGHT_ADJ_AAL	4

/*--------------------------------------------------------------------*/

#if	1
#define	CHECK
#endif

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

void
create_drawingarea_aal()
{
	extern Dimension	da_width_aal, da_height_aal;
	extern Widget		da_aal;
	extern Widget		sw_aal;
	int			i;
	Arg			args[6];
	extern void		event_process_aal();
	extern void		create_scrolledwindow_aal();
	void			set_scrolledwindow_aal();

	create_scrolledwindow_aal();

	i = 0;
	XtSetArg(args[i], XmNwidth, &da_width_aal);
	i++;
	XtSetArg(args[i], XmNheight, &da_height_aal);
	i++;
	XtGetValues(sw_aal, args, 2);
/*
	da_width_aal = (Dimension)((float)da_width_aal * DA_RATIO_WIDTH_AAL);
	da_height_aal = (Dimension)((float)da_height_aal * DA_RATIO_HEIGHT_AAL);
*/

#if	1
	da_width_aal -= DA_WIDTH_ADJ_AAL;
	da_height_aal -= DA_HEIGHT_ADJ_AAL;
#endif

#if	0
	(void)printf("create_drawingarea_aal --- da_width_aal, da_height_aal = %d %d\n",
		     da_width_aal, da_height_aal);
#endif

	i = 0;
	XtSetArg(args[i], XmNwidth, da_width_aal);
	i++;
	XtSetArg(args[i], XmNheight, da_height_aal);
	i++;
	da_aal = XmCreateDrawingArea(sw_aal, "da_aal", args, i);
	XtManageChild(da_aal); 
	XtAddEventHandler(da_aal, EV_MASK_AAL,
			  False, event_process_aal, (caddr_t)NULL);

	set_scrolledwindow_aal();
}

void
set_drawingarea_size_aal()
{
	extern Dimension	da_width_aal, da_height_aal;
	extern Widget		da_aal;
	int			i;
	Arg			args[2];

	i = 0;
	XtSetArg(args[i], XmNwidth, da_width_aal);
	i++;
	XtSetArg(args[i], XmNheight, da_height_aal);
	i++;
	XtSetValues(da_aal, args, i);
}

static void
create_scrolledwindow_aal()
{
	extern Dimension	scr_width_aal, scr_height_aal;
	extern Widget		fm_sw_aal;
	extern Widget		sw_aal;
	Dimension		width, height;
	int			i;
	Arg			args[7];

	width = (Dimension)((float)scr_width_aal * SW_RATIO_WIDTH_AAL);
	height = (Dimension)((float)scr_height_aal * SW_RATIO_HEIGHT_AAL);

#if	0
	(void)printf("create_scrolledwindow_aal --- width, height = %d %d\n",
		     width, height);
#endif

	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNwidth, width);
	i++;
	XtSetArg(args[i], XmNheight, height);
	i++;
	XtSetArg(args[i], XmNscrollingPolicy, XmAUTOMATIC);
	i++;
	sw_aal = XmCreateScrolledWindow(fm_sw_aal, "sw_aal", args, i);
	XtManageChild(sw_aal); 
}

static void
set_scrolledwindow_aal()
{
	extern Widget	sw_aal;
	extern Widget	da_aal;

	XmScrolledWindowSetAreas(sw_aal, (Widget)NULL, (Widget)NULL, da_aal);
}

/*--------------------------------------------------------------------*/

void
set_eventmask_tmp_aal()
{
	extern Widget	da_aal;
	extern void	event_process_aal();

	XtRemoveEventHandler(da_aal, EV_MASK_RMTMP_AAL,
			     False, event_process_aal, (caddr_t)NULL);
}

void
reset_eventmask_tmp_aal()
{
	extern Widget	da_aal;
	extern void	event_process_aal();

	XtAddEventHandler(da_aal, EV_MASK_RMTMP_AAL,
			  False, event_process_aal, (caddr_t)NULL);
}

/*--------------------------------------------------------------------*/

int
get_identity_aal(index, ratio)
int	index;
int	ratio;
{
	extern INFO	Info;
	extern char	Calc_codeAlign[MAX_ALIGN][MAX_ALIGN_LENG];
	int		i;
	int		code;
	int		count[ANACID_COUNT_AAL];
	int		maxcnt;
	int		maxcode;
	double		dlimit;
	int		ilimit;
	int		rcode;

	for (i = 0; i < ANACID_COUNT_AAL; i++)
		*(count+i) = 0;

	for (i = 0; i < Info.alignnum; i++) {
		code = Calc_codeAlign[i][index];
#ifdef	CHECK
		if (code < 0 || code >= ANACID_COUNT_AAL)
			fatal_error("get_identity_aldatamgr",
				    "illegal code (%d)\n",
				    code);
#endif
		(*(count+code))++;
	}

	maxcnt = *count;
	maxcode = 0;
	for (i = 1; i < ANACID_COUNT_AAL; i++) {
		if (*(count+i) > maxcnt) {
			maxcnt = *(count+i);
			maxcode = i;
		}
	}

	dlimit = (double)Info.alignnum * (double)ratio / 100.0;
	ilimit = (int)ceil(dlimit);

	if (maxcnt >= ilimit) {
		if (maxcode != GAP_INNERCODE_AAL)
			rcode = maxcode;
		else
			rcode = OTHER_INNERCODE_AAL;
	}
	else
		rcode = OTHER_INNERCODE_AAL;

	return rcode;
}

/*--------------------------------------------------------------------*/

void
init_drawdata_aal()
{
	extern INFO	Info;
	extern int	procnum_aal;
	extern int	left_flag;
	extern int	right_flag;
	extern int	send_left;
	extern int	New_calc_leng;
	extern char	Calc_codeAlign[MAX_ALIGN][MAX_ALIGN_LENG];
	extern char	Calc_constraint[MAX_ALIGN][MAX_ALIGN_LENG];
	extern int	Calc_columnCost[MAX_ALIGN_LENG];
	extern int	Calc_idColumn[MAX_ALIGN_LENG];
	extern int	Calc_cost;
	extern int	leftflag_last_aal;
	extern int	rightflag_last_aal;
	extern int	startcol_last_aal;
	extern int	endcol_last_aal;
	extern int	allength_last_aal;
	extern char	alignment_last_aal[MAX_ALIGN][MAX_ALIGN_LENG];
	extern char	constraint_last_aal[MAX_ALIGN][MAX_ALIGN_LENG];
	extern int	idcol_last_aal[MAX_ALIGN_LENG];
	extern int	ccost_last_aal[MAX_ALIGN_LENG];
	extern int	tcost_last_aal;
	int		i, j;

	leftflag_last_aal = 0;
	rightflag_last_aal = 0;
	startcol_last_aal = 0;
	endcol_last_aal = 0;
	allength_last_aal = 0;

	for (i = 0; i < Info.alignnum; i++) {
		for (j = 0; j < MAX_ALIGN_LENG; j++) {
			alignment_last_aal[i][j] = (char)0;
			constraint_last_aal[i][j] = (char)0;
		}
	}

	for (i = 0; i < MAX_ALIGN_LENG; i++) {
		idcol_last_aal[i] = 0;
		ccost_last_aal[i] = 0;
	}

	tcost_last_aal = 0;
}

void
save_drawdata_aal()
{
	extern INFO	Info;
	extern int	procnum_aal;
	extern int	left_flag;
	extern int	right_flag;
	extern int	send_left;
	extern int	New_calc_leng;
	extern char	Calc_codeAlign[MAX_ALIGN][MAX_ALIGN_LENG];
	extern char	Calc_constraint[MAX_ALIGN][MAX_ALIGN_LENG];
	extern int	Calc_columnCost[MAX_ALIGN_LENG];
	extern int	Calc_idColumn[MAX_ALIGN_LENG];
	extern int	Calc_cost;
	extern int	leftflag_last_aal;
	extern int	rightflag_last_aal;
	extern int	startcol_last_aal;
	extern int	endcol_last_aal;
	extern int	allength_last_aal;
	extern char	alignment_last_aal[MAX_ALIGN][MAX_ALIGN_LENG];
	extern char	constraint_last_aal[MAX_ALIGN][MAX_ALIGN_LENG];
	extern int	idcol_last_aal[MAX_ALIGN_LENG];
	extern int	ccost_last_aal[MAX_ALIGN_LENG];
	extern int	tcost_last_aal;
	int		endcol;
	int		i, j;

	endcol = send_left + New_calc_leng - 1;

	leftflag_last_aal = left_flag;
	rightflag_last_aal = right_flag;
	startcol_last_aal = send_left;
	endcol_last_aal = endcol;
	allength_last_aal = New_calc_leng;

	for (i = 0; i < Info.alignnum; i++) {
		for (j = send_left; j <= endcol; j++) {
			alignment_last_aal[i][j] = Calc_codeAlign[i][j];
			constraint_last_aal[i][j] = Calc_constraint[i][j];
		}
	}

	for (i = send_left; i <= endcol; i++) {
		idcol_last_aal[i] = Calc_idColumn[i];
		ccost_last_aal[i] = Calc_columnCost[i];
	}

	tcost_last_aal = Calc_cost;
}

/*--------------------------------------------------------------------*/
#if	0
/*--------------------------------------------------------------------*/

void
redraw_information_proc_aal()
{
	void	erase_information_aal();
	void	draw_information_aal();

	erase_information_aal();

	draw_information_aal();
}

void
redraw_idcol_proc_aal()
{
	void	erase_idcol_aal();
	void	draw_idcol_aal();

	erase_idcol_aal();

	draw_idcol_aal();
}

void
redraw_costgraph_proc_aal()
{
	void	erase_costgraph_aal();
	void	draw_costgraph_aal();

	erase_costgraph_aal();

	draw_costgraph_aal();
}

/*--------------------------------------------------------------------*/
#endif
/*--------------------------------------------------------------------*/

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
