/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
/*----------------------------------------------------------------------
	aeditColor.c
----------------------------------------------------------------------*/

#include  <X11/Xlib.h>
#include  <X11/Xutil.h>
#include  <stdio.h>
#include  "aedit.h"

/*--------------------------------------------------------------------*/

#if	0
#define	DEBUG
#endif

/*--------------------------------------------------------------------*/

extern Display       *TheDisplay;     /*  which display  */
extern Colormap       TheColormap;    /*  Default System Colormap */
extern int            TheDepth;       /*  Number of color planes  */


#define FLAG  (DoRed | DoGreen | DoBlue)
#define FULL  65535


GC   DrawBackGC,            /* back ground */
     WhiteGC, BlackGC,      /* amino char */
     FixedColumnGC,         /* fixed column */
     TextGC,                /* normal text */
     BigTextGC,             /* big text(Cost and CYCLE COUNT) */
     MiddleTextGC,          /* big text(Cost and CYCLE COUNT) */
     CodeGC[MAXCODE],       /* amino rectangle */
     AminoCharGC[MAXCODE],  /* amino char */
     BouPlusGC, BouMinusGC, BouMotifGC,  /* BOU Graph Color */
     Gray8GC[8], Red8GC[8], 
     FrameGC;               /* dragging frame */

/* default color of back ground */
XColor back_color = { 0, 0,0,0, FLAG };

/* default color of fixed column ground */
XColor fixed_column_color = {0, 38000, 41000, 38000, FLAG};

/* default color of normal text */
XColor text_color = { 0, FULL, FULL, FULL, FLAG};

/* default color of BOU Graph plus part */
XColor bou_plus_color = {0, FULL, FULL/2, 0, FLAG};

/* default color of BOU Graph plus part */
XColor bou_minus_color = {0, FULL/8, FULL/10, FULL, FLAG};

/* default color of BOU Graph plus part */
XColor bou_motif_color = {0, 65535, 47662, 2979, FLAG};

/* default color of dragging frame */
XColor frame_color = {0, 65535, 65535, 65535, FLAG};


/* default color of amino */
XColor amino_color[MAXCODE] = {
   {0, 65535, 44683,     0, FLAG},    /* A */
   {0,  4608, 55808,  5888, FLAG},    /* B,D,E,Z */
   {0, 65280, 61696,  6400, FLAG},    /* C */
   {0,  4608, 55808,  5888, FLAG},    /* B,D,E,Z */
   {0,  4608, 55808,  5888, FLAG},    /* B,D,E,Z */
   {0, 47104,  1792, 47360, FLAG},    /* F */
   {0, 63744, 37120,  1024, FLAG},    /* G */
   {0,     0,   256, 65280, FLAG},    /* H,K,R */
   {0, 65280,  8960,  9728, FLAG},    /* I,L,M,V */
   {0,     0,     0,     0, FLAG},    /* J, not amino */
   {0,     0,   256, 65280, FLAG},    /* H,K,R */
   {0, 65280,  8960,  9728, FLAG},    /* I, L,M, V */
   {0, 65280,  8960,  9728, FLAG},    /* I, L,M, V */
   {0,  8192, 65280, 27136, FLAG},    /* N,Q */
   {0,     0,     0,     0, FLAG},    /* O, not amino */
   {0, 63744, 46336, 27904, FLAG},    /* P */
   {0,  8192, 65280, 27136, FLAG},    /* N,Q */
   {0,     0,   256, 65280, FLAG},    /* H,K,R */
   {0,  3584, 60928, 60672, FLAG},    /* S,T */
   {0,  3584, 60928, 60672, FLAG},    /* S,T */
   {0,     0,     0,     0, FLAG},    /* U, not amino */
   {0, 65280,  8960,  9728, FLAG},    /* I,L,M,V */
   {0, 31744,  1024, 47872, FLAG},    /* W */
   {0,     0,     0,     0, FLAG},    /* X, not amino */
   {0, 48655,     0, 43690, FLAG},    /* Y */
   {0,     0,     0,     0, FLAG},    /* Z, not amino */
   {0,   100,   100,  100, FLAG},     /* - gap */
   {0,   100,   100,  100, FLAG},     /* ? other */
};


/* default color of nucleic acid */
XColor na_color[MAXCODE] = {
   {0, 65535, 18866,  9930, FLAG},    /* A */
   {0,  4608, 55808,  5888, FLAG},    /* B */
   {0,     0, 65535, 44683, FLAG},    /* C */
   {0,  4608, 55808,  5888, FLAG},    /* D */
   {0,  4608, 55808,  5888, FLAG},    /* E */
   {0, 47104,  1792, 47360, FLAG},    /* F */
   {0,     0, 37732, 65535, FLAG},    /* G */
   {0,     0,   256, 65280, FLAG},    /* H */
   {0, 65280,  8960,  9728, FLAG},    /* I */
   {0,     0,     0,     0, FLAG},    /* J */
   {0,     0,   256, 65280, FLAG},    /* K */
   {0, 65280,  8960,  9728, FLAG},    /* L */
   {0, 65280,  8960,  9728, FLAG},    /* M */
   {0, 65535, 65535, 65535, FLAG},    /* N */
   {0,     0,     0,     0, FLAG},    /* O */
   {0, 63744, 46336, 27904, FLAG},    /* P */
   {0,  8192, 65280, 27136, FLAG},    /* Q */
   {0,     0,   256, 65280, FLAG},    /* R */
   {0,  3584, 60928, 60672, FLAG},    /* S */
   {0, 65535, 37732, 12908, FLAG},    /* T */
#if	0
   {0,     0,     0,     0, FLAG},    /* U */
#else
   {0, 65535, 37732, 12908, FLAG},    /* U */
#endif
   {0, 65280,  8960,  9728, FLAG},    /* V */
   {0, 31744,  1024, 47872, FLAG},    /* W */
   {0,     0,     0,     0, FLAG},    /* X */
   {0, 48655,     0, 43690, FLAG},    /* Y */
   {0,     0,     0,     0, FLAG},    /* Z */
   {0,   100,   100,  100, FLAG},     /* - gap */
   {0,   100,   100,  100, FLAG},     /* ? other */
};

#if	1

short aminoCharWorB[MAXCODE];

#else

short aminoCharWorB[MAXCODE] = {   /* set 1 if amino char color is black */
   1,    /* A */
   1,    /* B,D,E,Z */
   1,    /* C */
   1,    /* B,D,E,Z */
   1,    /* B,D,E,Z */
   0,    /* F */
   1,    /* G */
   0,    /* H,K,R */
   1,    /* I,L,V */
   0,    /* J, not amino */
   0,    /* H,K,R */
   1,    /* I,L,V */
   0,    /* M */
   1,    /* N,Q */
   0,    /* O, not amino */
   1,    /* P */
   1,    /* N,Q */
   0,    /* H,K,R */
   1,    /* S */
   1,    /* T */
   0,    /* U, not amino */
   1,    /* I,L,V */
   0,    /* W */
   0,    /* X, not amino */
   0,    /* Y */
   0,    /* Z, not amino */
   0,    /* - gap */
   0,    /* ? other */
};

#endif

short aminoCharWorBA[MAXCODE] = {   /* set 1 if amino char color is black */
   1,    /* A */
   1,    /* B,D,E,Z */
   1,    /* C */
   1,    /* B,D,E,Z */
   1,    /* B,D,E,Z */
   0,    /* F */
   1,    /* G */
   0,    /* H,K,R */
   1,    /* I,L,V */
   0,    /* J, not amino */
   0,    /* H,K,R */
   1,    /* I,L,V */
   0,    /* M */
   1,    /* N,Q */
   0,    /* O, not amino */
   1,    /* P */
   1,    /* N,Q */
   0,    /* H,K,R */
   1,    /* S */
   1,    /* T */
   0,    /* U, not amino */
   1,    /* I,L,V */
   0,    /* W */
   0,    /* X, not amino */
   0,    /* Y */
   0,    /* Z, not amino */
   0,    /* - gap */
   0,    /* ? other */
   0,
   0
};

short aminoCharWorBN[MAXCODE] = {   /* set 1 if amino char color is black */
   1,    /* A */
   1,    /* B,D,E,Z */
   1,    /* C */
   1,    /* B,D,E,Z */
   1,    /* B,D,E,Z */
   0,    /* F */
   1,    /* G */
   0,    /* H,K,R */
   1,    /* I,L,V */
   0,    /* J, not amino */
   0,    /* H,K,R */
   1,    /* I,L,V */
   0,    /* M */
   1,    /* N,Q */
   0,    /* O, not amino */
   1,    /* P */
   1,    /* N,Q */
   0,    /* H,K,R */
   1,    /* S */
   1,    /* T */
   1,    /* U, not amino */
   1,    /* I,L,V */
   0,    /* W */
   0,    /* X, not amino */
   0,    /* Y */
   0,    /* Z, not amino */
   0,    /* - gap */
   0,    /* ? other */
   0,
   0
};

/*--------------------------------------------------------------------*/

initOurColors()
{
   extern int	colorcell_type;
   extern void	fatal_error();
   void		make_green8_ro();
   void		make_red8_ro();

   if(TheDepth <= 1 )   {
      fprintf(stderr,
              "Sorry, We support only on color display\n");
      exit(1);
   }

   make_amino_color();

   if (colorcell_type == COLORCELL_TYPE_RO) {
      make_green8_ro();
      make_red8_ro();
   }
   else if (colorcell_type == COLORCELL_TYPE_RW) {
      make_green8();
      make_red8();
   }
   else
      fatal_error("initOurColors", "illegal colorcell_type (%d)\n", colorcell_type);

   others();
}


make_amino_color()
{
   extern int	colorcell_type;
   XGCValues   gcv;
   GC  gc;
   int  i, ret;
   int  shift;
   Pixel   pixel;
   extern void fatal_error();

#ifdef	DEBUG
   (void)printf("make_amino_color --- colorcell_type = %d\n", colorcell_type);
#endif

   for(i=0; i<MAXCODE; ++i) {

      if (colorcell_type == COLORCELL_TYPE_RO) {
         if (NA_flag)
	    *(amino_color+i) = *(na_color+i);
         if (!XAllocColor(TheDisplay, TheColormap, amino_color + i))
	    fatal_error("make_amino_color", "XAllocColor error return\n");
      }
      else if (colorcell_type == COLORCELL_TYPE_RW) {
         if (!XAllocColorCells(TheDisplay,TheColormap,False, (unsigned long *)NULL,0, &pixel,1))
	    fatal_error("make_amino_color", "XAllocColorCells error return\n");
         if (NA_flag)
	    amino_color[i] = na_color[i];
         amino_color[i].pixel = pixel;
         XStoreColor(TheDisplay,TheColormap,&amino_color[i]);
      }
      else
	 fatal_error("make_amino_color", "illegal colorcell_type (%d)\n", colorcell_type);

      gc = XCreateGC(TheDisplay, TheRoot, 0, &gcv);
      if(gc == 0 ) {  /* Can not create GC */
          fprintf(stderr,"Can not create GC in createFrontGCs \n");
          exit(1);
      }
      else { 
          XSetForeground(TheDisplay, gc, amino_color[i].pixel);  
      }
      CodeGC[i] = gc;
   }
}

#if	0

termOurColors()
{

/*   XFreeColors(TheDisplay,TheColormap,
                   &rgb_pixel,1, rgb_plane_masks);
*/
}

#endif

static void
make_green8_ro() 
{
	XGCValues	gcv;
	XColor		color;
	GC		gc;
	int		i;
	extern void	fatal_error();

	/* green 8 level colors for constraint */
	for (i = 0; i < 8; i++) {
		color.red =  0;
		color.green = FULL*i/7;
		color.blue = 0;
		if (!XAllocColor(TheDisplay, TheColormap, &color))
			fatal_error("make_green8_ro", "XAllocColor error return\n");
		gc = XCreateGC(TheDisplay, TheRoot, 0, &gcv);
		XSetForeground(TheDisplay, gc, color.pixel);  
		*(Gray8GC+i) = gc;
	}
}

make_green8() 
{
   XGCValues   gcv;
   XColor  colorList[8];
   GC   gc;
   int  i, ret;
   unsigned long  plane_masks[3], pixel;
   int  shift;

  /* green 8 level colors for positive column's cost color */
   ret = XAllocColorCells(TheDisplay,TheColormap,True,
                          plane_masks,3,&pixel,1);
   if(ret==0) {
      fprintf(stderr,
             "Sorry, Fail to XAllocColorCells() for green colors\n");
      exit(1);
   }

   fprintf(stderr, "pixel=%d\n",pixel);
   for(i=0; i<3; ++i) fprintf(stderr, "plane_masks[%d]=%x\n",i,plane_masks[i]);

   /* compute bit position */
   for(shift=0; plane_masks[0] != (1<<shift) ; shift++) ;

   fprintf(stderr, "shift=%d, (0<<shift)|pixel)=%d\n",
           shift, (0<<shift)|pixel);

   for(i=0; i<8; ++i) {
       /* compute pixel value */
       colorList[i].pixel = (i<<shift)|pixel;  
       colorList[i].flags = FLAG;
       colorList[i].red =  0;
       colorList[i].green = FULL*i/7;
       colorList[i].blue = 0;
   }
   XStoreColors(TheDisplay,TheColormap,colorList,8);

   /* create GC as all default value */
   for(i=0; i<8; ++i) {
       gc = XCreateGC(TheDisplay, TheRoot, 0, &gcv);
       if(gc == 0 ) {  /* Can not create GC */
          fprintf(stderr,"Can not create GC in createFrontGCs \n");
          exit(1);
       }
       else { 
          XSetForeground(TheDisplay, gc, (i<<shift)|pixel);  
       }
       Gray8GC[i] = gc;
   }
}

static void
make_red8_ro() 
{
	XGCValues	gcv;
	XColor		color;
	GC		gc;
	int		i;

	/* red 8 level colors */
	for (i = 0; i < 8; i++) {
		color.red = FULL*i/7;
		color.green = 0;
		color.blue = 0;
		if (!XAllocColor(TheDisplay, TheColormap, &color))
			fatal_error("make_red8_ro", "XAllocColor error return\n");
		gc = XCreateGC(TheDisplay, TheRoot, 0, &gcv);
		XSetForeground(TheDisplay, gc, color.pixel);  
		*(Red8GC+i) = gc;
	}
}

make_red8()                    
{
   XGCValues   gcv;
   XColor  colorList[8];
   GC   gc;
   int  i, ret;
   unsigned long  plane_masks[3], pixel;
   int  shift;

   ret = XAllocColorCells(TheDisplay,TheColormap,True,
                          plane_masks,3,&pixel,1);
   if(ret==0) {
      fprintf(stderr,
             "Sorry, Fail to XAllocColorCells() for red colors\n");
      exit(1);
   }

/*   printf("pixel=%d\n",pixel); */
   for(i=0; i<3; ++i) fprintf(stderr, "plane_masks[%d]=%x\n",i,plane_masks[i]);

   /* compute bit position */
   for(shift=0; plane_masks[0] != (1<<shift) ; shift++) ;

   fprintf(stderr, "shift=%d, (0<<shift)|pixel)=%d\n",
           shift, (0<<shift)|pixel);

   for(i=0; i<8; ++i) {
      /* compute pixel value */
      colorList[i].pixel = (i<<shift)|pixel;  
      colorList[i].flags = FLAG;
      colorList[i].red =  FULL*i/7;
      colorList[i].green = 0;
      colorList[i].blue = 0;
   }
   XStoreColors(TheDisplay,TheColormap,colorList,8);

   /* create GC as all default value */
   for(i=0; i<8; ++i) {
       gc = XCreateGC(TheDisplay, TheRoot, 0, &gcv);
       if(gc == 0 ) {  /* Can not create GC */
          fprintf(stderr,"Can not create GC in createFrontGCs \n");
          exit(1);
       }
       else { 
          XSetForeground(TheDisplay, gc, (i<<shift)|pixel);  
       }
       Red8GC[i] = gc;
   }
}

others()
{
   extern   NA_flag;
   extern int   colorcell_type;
   XGCValues   gcv;
   int    i;
   GC   gc;
   Pixel   pixel;
   extern void fatal_error();

#ifdef	DEBUGU
   (void)printf("oyhers --- colorcell_type = %d\n", colorcell_type);
#endif

   BlackGC = XCreateGC(TheDisplay, TheWindow, 0, &gcv );
   XSetForeground(TheDisplay, BlackGC, TheBlackPixel);

   WhiteGC = XCreateGC(TheDisplay, TheWindow, 0, &gcv );
   XSetForeground(TheDisplay, WhiteGC, TheWhitePixel);

   /* back ground color */
   if (colorcell_type == COLORCELL_TYPE_RO) {
      if (!XAllocColor(TheDisplay, TheColormap, &back_color))
	 fatal_error("others", "XAllocColor error return\n");
   }
   else if (colorcell_type == COLORCELL_TYPE_RW) {
      if (!XAllocColorCells(TheDisplay,TheColormap,False,
                            (unsigned long *)NULL,0, &pixel,1))
	 fatal_error("others", "XAllocColorCells error return\n");
      back_color.pixel = pixel;
      XStoreColor(TheDisplay,TheColormap,&back_color);
   }
   else
      fatal_error("others",
		  "illegal colorcell_type (%d)\n",
		  colorcell_type);
   DrawBackGC = XCreateGC(TheDisplay, TheWindow, 0, &gcv );
   XSetForeground(TheDisplay, DrawBackGC, back_color.pixel);  

   /* normal textcolor */
   if (colorcell_type == COLORCELL_TYPE_RO) {
      if (!XAllocColor(TheDisplay, TheColormap, &text_color))
	    fatal_error("others", "XAllocColor error return\n");
   }
   else if (colorcell_type == COLORCELL_TYPE_RW) {
      if (!XAllocColorCells(TheDisplay,TheColormap,False,
                            (unsigned long *)NULL,0, &pixel,1))
	    fatal_error("others", "XAllocColorCells error return\n");
      text_color.pixel = pixel;
      XStoreColor(TheDisplay,TheColormap,&text_color);
   }
   else
      fatal_error("others",
		  "illegal colorcell_type (%d)\n",
		  colorcell_type);
   TextGC = XCreateGC(TheDisplay, TheWindow, 0, &gcv );
   XSetForeground(TheDisplay, TextGC, text_color.pixel);  

   BigTextGC = XCreateGC(TheDisplay, TheWindow, 0, &gcv );
   XSetForeground(TheDisplay, BigTextGC, text_color.pixel);  

   MiddleTextGC = XCreateGC(TheDisplay, TheWindow, 0, &gcv );
   XSetForeground(TheDisplay, MiddleTextGC, text_color.pixel);  

   /* fixed column color */
   if (colorcell_type == COLORCELL_TYPE_RO) {
      if (!XAllocColor(TheDisplay, TheColormap, &fixed_column_color))
	    fatal_error("others", "XAllocColor error return\n");
   }
   else if (colorcell_type == COLORCELL_TYPE_RW) {
      if (!XAllocColorCells(TheDisplay,TheColormap,False,
                            (unsigned long *)NULL,0, &pixel,1))
	    fatal_error("others", "XAllocColorCells error return\n");
      fixed_column_color.pixel = pixel;
      XStoreColor(TheDisplay,TheColormap,&fixed_column_color);
   }
   else
      fatal_error("others",
		  "illegal colorcell_type (%d)\n",
		  colorcell_type);
   FixedColumnGC = XCreateGC(TheDisplay, TheWindow, 0, &gcv );
   XSetForeground(TheDisplay, FixedColumnGC, fixed_column_color.pixel);  

   /* BOU Graph plus part color */
   if (colorcell_type == COLORCELL_TYPE_RO) {
      if (!XAllocColor(TheDisplay, TheColormap, &bou_plus_color))
	    fatal_error("others", "XAllocColor error return\n");
   }
   else if (colorcell_type == COLORCELL_TYPE_RW) {
      if (!XAllocColorCells(TheDisplay,TheColormap,False,
                            (unsigned long *)NULL,0, &pixel,1))
	    fatal_error("others", "XAllocColorCells error return\n");
      bou_plus_color.pixel = pixel;
      XStoreColor(TheDisplay,TheColormap,&bou_plus_color);
   }
   else
      fatal_error("others",
		  "illegal colorcell_type (%d)\n",
		  colorcell_type);
   BouPlusGC = XCreateGC(TheDisplay, TheWindow, 0, &gcv );
   XSetForeground(TheDisplay, BouPlusGC, bou_plus_color.pixel);  

   /* BOU Graph minus part color */
   if (colorcell_type == COLORCELL_TYPE_RO) {
      if (!XAllocColor(TheDisplay, TheColormap, &bou_minus_color))
	    fatal_error("others", "XAllocColor error return\n");
   }
   else if (colorcell_type == COLORCELL_TYPE_RW) {
      if (!XAllocColorCells(TheDisplay,TheColormap,False,
                            (unsigned long *)NULL,0, &pixel,1))
	    fatal_error("others", "XAllocColorCells error return\n");
      bou_minus_color.pixel = pixel;
      XStoreColor(TheDisplay,TheColormap,&bou_minus_color);
   }
   else
      fatal_error("others",
		  "illegal colorcell_type (%d)\n",
		  colorcell_type);
   BouMinusGC = XCreateGC(TheDisplay, TheWindow, 0, &gcv );
   XSetForeground(TheDisplay, BouMinusGC, bou_minus_color.pixel);  


   /* BOU Graph motif color(KYOUTYOU HYOUJI) */
   if (colorcell_type == COLORCELL_TYPE_RO) {
      if (!XAllocColor(TheDisplay, TheColormap, &bou_motif_color))
	    fatal_error("others", "XAllocColor error return\n");
   }
   else if (colorcell_type == COLORCELL_TYPE_RW) {
      if (!XAllocColorCells(TheDisplay,TheColormap,False,
                            (unsigned long *)NULL,0, &pixel,1))
	    fatal_error("others", "XAllocColorCells error return\n");
      bou_motif_color.pixel = pixel;
      XStoreColor(TheDisplay,TheColormap,&bou_motif_color);
   }
   else
      fatal_error("others",
		  "illegal colorcell_type (%d)\n",
		  colorcell_type);
   BouMotifGC = XCreateGC(TheDisplay, TheWindow, 0, &gcv );
   XSetForeground(TheDisplay, BouMotifGC, bou_motif_color.pixel);  

   /* dragging frame color */
   if (colorcell_type == COLORCELL_TYPE_RO) {
      if (!XAllocColor(TheDisplay, TheColormap, &frame_color))
   	 fatal_error("others", "XAllocColor error return\n");
   }
   else if (colorcell_type == COLORCELL_TYPE_RW) {
      if (!XAllocColorCells(TheDisplay,TheColormap,False,
                            (unsigned long *)NULL,0, &pixel,1))
   	 fatal_error("others", "XAllocColorCells error return\n");
      frame_color.pixel = pixel;
      XStoreColor(TheDisplay,TheColormap,&frame_color);
   }
   else
      fatal_error("others",
		  "illegal colorcell_type (%d)\n",
		  colorcell_type);
   FrameGC = XCreateGC(TheDisplay, TheWindow, 0, &gcv );
   XSetForeground(TheDisplay, FrameGC, frame_color.pixel);  

	/* amino char color */
	if (NA_flag) {
		for(i = 0; i < MAXCODE; i++) {
			aminoCharWorB[i] = aminoCharWorBN[i];
			AminoCharGC[i] = ((aminoCharWorB[i]==1) ? BlackGC : WhiteGC);
		}
	}
	else {
		for(i = 0; i < MAXCODE; i++) {
			aminoCharWorB[i] = aminoCharWorBA[i];
			AminoCharGC[i] = ((aminoCharWorB[i]==1) ? BlackGC : WhiteGC);
		}
	}
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
