/* ---------------------------------------------------------- 
%(C)1994,1995 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new_klic.h"

long *amigapI,*amigapJ,*gapI,*gapJ;
extern long Dmatrix[26][26];

long
gdp_s_c2(pa1,pa2,ostring,oleng,n,num,leng,nstring,nleng)
PARAM1 *pa1;
PARAM2 *pa2;
char *ostring;
long oleng;
long  n,num,*leng;
char *nstring;
long *nleng;
{
  long i,j,I,J,buffx,buffy;
  long k,energy,cost;
  char p;

  VEC *Vec0;     /* Vec0[MAXBUFF]; */
  VEC *Vec1;     /* Vec1[MAXBUFF]; */

  PATH_s **Path;  /* Path[MAXBUFF*MAXBUFF]; */

  char **Seq1;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2;           /* Seq2[SEQNUM*MAXBUFF]; */
  char **Seq;

  extern void remove_allgap();
  extern void generateD_00_s();
  extern void makeAlignmentString_s_c2();
  extern long calc_energy();
  extern void keep_memory_s();
  extern void free_memory_s();

  extern char *calloc();

/*  fprintf(stdout,"(Cut,U,V,S)=(%d,%d,%d,%d)\n",pa1->Cut,pa1->U,pa1->V,pa1->S);*/

  if( ( Seq1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq1\n"); exit();
  }
  for(k=0;k<pa2->NumX;k++){
    if( ( Seq1[k] = calloc( pa2->X, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq1\n"); exit();
    }
  }
  
  if( ( Seq2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq2\n"); exit();
  }
  for(k=0;k<pa2->NumY;k++){
    if( ( Seq2[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2\n"); exit();
    }
  }
  
  if( ( Seq = (char **)calloc( num, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq1\n"); exit();
  }
  for(k=0;k<num;k++){
    if( ( Seq[k] = calloc( pa2->X + pa2->Y, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq1\n"); exit();
    }
  }
  
  k = 0;
  for(i=0;i<n;i++){
    for(j=0;j<*leng;j++){
      p = ostring[k];
/*      fprintf(stdout,"%c",p);*/
      if(p >= 'a' && p <= 'z')  p -= 'a';
      if(p >= 'A' && p <= 'Z')  p -= 'A';
      Seq1[i][j] = p;
      k++;
    }
/*    fprintf(stdout,"\n");*/
  }
  for(j=0;j<*leng;j++){
    p = ostring[k];
/*    fprintf(stdout,"%c",p);*/
    if(p >= 'a' && p <= 'z')  p -= 'a';
    if(p >= 'A' && p <= 'Z')  p -= 'A';
    Seq2[0][j] = p;
    k++;
  }
/*  fprintf(stdout,"\n");*/
  for(i=n+1;i<num;i++){
    for(j=0;j<*leng;j++){
      p = ostring[k];
/*      fprintf(stdout,"%c",p);*/
      if(p >= 'a' && p <= 'z')  p -= 'a';
      if(p >= 'A' && p <= 'Z')  p -= 'A';
      Seq1[i-1][j] = p;
      k++;
    }
/*    fprintf(stdout,"\n");*/
  }
/*  fflush(stdout);*/

  if(k != oleng){
    fprintf(stderr,"k != oleng\n");
    exit();
  }

  free(ostring);

/*  fprintf(stdout,"PASSs0\n");
  fflush(stdout);*/
  remove_allgap(Seq1,Seq2,&(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);

  buffx = pa2->X + 1;
  buffy = pa2->Y + 1;

/*  fprintf(stdout,"PASSs1\n");
  fflush(stdout);*/
  keep_memory_s(&Vec0,&Vec1,&Path,buffx,buffy);

/*  fprintf(stdout,"PASSs2\n");
  fflush(stdout);*/
  generateD_00_s(Vec0,Vec1,Path,Seq1,Seq2,pa1->U,pa1->V,pa1->S,pa1->Cut,
		 pa2->X,pa2->Y,pa2->NumX,pa2->NumY,&I,&J);
/*
  if(J % 2 == 0) cost = Vec0[I].xy;
  if(J % 2 == 1) cost = Vec1[I].xy;
  fprintf(stdout,"cost = %d\n",cost);
*/
/*  fprintf(stdout,"PASSs3\n");
  fflush(stdout);*/
  makeAlignmentString_s_c2(Path,Seq1,Seq2,Seq,pa2->NumX,pa2->NumY,I,J,n,leng);

/*  fprintf(stdout,"PASSs4\n");
  fflush(stdout);*/
  k = 0;
  for(i=0;i<num;i++){
    for(j=0;j<*leng;j++){
      nstring[k] = Seq[i][*leng-1-j];
      k++;
    }
  }
  *nleng = k;

/*  fprintf(stdout,"PASSs5\n");
  fflush(stdout);*/
  energy = calc_energy(nstring,num,*leng,pa1->U,pa1->V,pa1->S);

  for(k=0;k<pa2->NumX;k++) free(Seq1[k]);
  free(Seq1);

  for(k=0;k<pa2->NumY;k++) free(Seq2[k]);
  free(Seq2);

  for(k=0;k<num;k++) free(Seq[k]);
  free(Seq);

/*  fprintf(stdout,"PASSs6\n");
  fflush(stdout);*/
  free_memory_s(Vec0,Vec1,Path,buffy);

/*  fprintf(stdout,"PASSs7\n");
  fflush(stdout);*/
/*  fprintf(stdout,"energy = %d\n",energy);
  fflush(stdout);*/
  return energy;
}


long
gdp_b_c2(pa1,pa2,ostring,oleng,n,num,leng,nstring,nleng)
PARAM1 *pa1;
PARAM2 *pa2;
char *ostring;
long oleng;
long  n,num,*leng;
char *nstring;
long *nleng;
{
  long i,j,I,J,buffx,buffy;
  long k,energy,cost;

  VEC *Vec0;     /* Vec0[MAXBUFF]; */
  VEC *Vec1;     /* Vec1[MAXBUFF]; */

  PATH_b *Path0;   /* Path0[MAXBUFF]; */
  PATH_b *Path1;   /* Path1[MAXBUFF]; */

  PROF *ProfI;   /* ProfI[MAXBUFF]; */
  PROF *ProfJ;   /* ProfJ[MAXBUFF]; */

  char **Seq1;           /* Seq1[SEQNUM*MAXBUFF]; */
  char **Seq2;           /* Seq2[SEQNUM*MAXBUFF]; */
  char **Seq;

  extern void remove_allgap();
  extern void makeProf();
  extern void generateD_00_b();
  extern void makeAlignmentString_b_c2();
  extern long calc_energy();
  extern void keep_memory_b();
  extern void free_memory_b();

  extern char *calloc();

/*  fprintf(stdout,"(Cut,U,V,S)=(%d,%d,%d,%d)\n",pa1->Cut,pa1->U,pa1->V,pa1->S);*/

  if( ( Seq1 = (char **)calloc( pa2->NumX, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq1\n"); exit();
  }
  for(k=0;k<pa2->NumX;k++){
    if( ( Seq1[k] = calloc( pa2->X, sizeof(char) ) ) == NULL){
      fprintf(stderr,"calloc failed for Seq1\n"); exit();
    }
  }
  
  if( ( Seq2 = (char **)calloc( pa2->NumY, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq2\n"); exit();
  }
  for(k=0;k<pa2->NumY;k++){
    if( ( Seq2[k] = calloc( pa2->Y, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq2\n"); exit();
    }
  }
  
  if( ( Seq = (char **)calloc( num, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq1\n"); exit();
  }
  for(k=0;k<num;k++){
    if( ( Seq[k] = calloc( pa2->X + pa2->Y, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq1\n"); exit();
    }
  }
  
  if( ( amigapI = (long *)calloc( num, sizeof(long) ) ) == NULL ){
    fprintf(stderr,"calloc failed for amigapI\n"); exit();
  }

  if( ( amigapJ = (long *)calloc( num, sizeof(long) ) ) == NULL ){
    fprintf(stderr,"calloc failed for amigapJ\n"); exit();
  }

  if( ( gapI = (long *)calloc( num, sizeof(long) ) ) == NULL ){
    fprintf(stderr,"calloc failed for gapI\n"); exit();
  }

  if( ( gapJ = (long *)calloc( num, sizeof(long) ) ) == NULL ){
    fprintf(stderr,"calloc failed for gapJ\n"); exit();
  }

  k = 0;
  for(i=0;i<n;i++){
    for(j=0;j<*leng;j++){
      Seq1[i][j] = ostring[k];
/*      fprintf(stdout,"%c",ostring[k]);*/
      k++;
    }
/*    fprintf(stdout,"\n");*/
  }
  for(j=0;j<*leng;j++){
    Seq2[0][j] = ostring[k];
/*    fprintf(stdout,"%c",ostring[k]);*/
    k++;
  }
/*  fprintf(stdout,"\n");*/
  for(i=n+1;i<num;i++){
    for(j=0;j<*leng;j++){
      Seq1[i-1][j] = ostring[k];
/*      fprintf(stdout,"%c",ostring[k]);*/
      k++;
    }
/*    fprintf(stdout,"\n");*/
  }
/*  fflush(stdout);*/

  if(k != oleng){
    fprintf(stderr,"k != oleng\n");
    exit();
  }

/*  fprintf(stdout,"PASSb0\n");
  fflush(stdout);*/
  free(ostring);

/*  fprintf(stdout,"PASSb1\n");
  fflush(stdout);*/
  remove_allgap(Seq1,Seq2,&(pa2->X),&(pa2->Y),pa2->NumX,pa2->NumY);

  buffx = pa2->X + 1;
  buffy = pa2->Y + 1;

/*  fprintf(stdout,"PASSb2\n");
  fflush(stdout);*/
  keep_memory_b(&Vec0,&Vec1,&Path0,&Path1,&ProfI,&ProfJ,buffx,buffy,pa2->NumX,pa2->NumY);

/*  fprintf(stdout,"PASSb3\n");
  fflush(stdout);*/
  makeProf(ProfI,Seq1,pa2->X,pa2->NumX);
  makeProf(ProfJ,Seq2,pa2->Y,pa2->NumY);
/*
  fprintf(stdout,"ProfI=\n");
  printProf(ProfI,*X);
  fprintf(stdout,"ProfJ=\n");
  printProf(ProfJ,*Y);
*/
/*  fprintf(stdout,"PASSb4\n");
  fflush(stdout);*/
  generateD_00_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,
		 pa1->U,pa1->V,pa1->S,pa1->Cut,pa2->X,pa2->Y,&I,&J);
/*
  if(J % 2 == 0) cost = Vec0[I].xy;
  if(J % 2 == 1) cost = Vec1[I].xy;
  fprintf(stdout,"cost = %d\n",cost);
*/
/*  fprintf(stdout,"PASSb5\n");
  fflush(stdout);*/
  if(J % 2 == 0) makeAlignmentString_b_c2(Path0,Seq1,Seq2,Seq,pa2->NumX,pa2->NumY,pa2->X,pa2->Y,I,n,leng);
  if(J % 2 == 1) makeAlignmentString_b_c2(Path1,Seq1,Seq2,Seq,pa2->NumX,pa2->NumY,pa2->X,pa2->Y,I,n,leng);

/*  fprintf(stdout,"PASSb6\n");
  fflush(stdout);*/
  k = 0;
  for(i=0;i<num;i++){
    for(j=0;j<*leng;j++){
      nstring[k] = Seq[i][j];
      k++;
    }
  }
  *nleng = k;

/*  fprintf(stdout,"PASSb7\n");
  fflush(stdout);*/
/*  energy = calc_energy(nstring,*nleng,num,*leng,pa1.U,pa1.V,pa1.S);*/
  energy = calc_energy(nstring,num,*leng,pa1->U,pa1->V,pa1->S);

/*  fprintf(stdout,"PASSb8\n");
  fflush(stdout);*/
  for(k=0;k<pa2->NumX;k++) free(Seq1[k]);
  free(Seq1);

  for(k=0;k<pa2->NumY;k++) free(Seq2[k]);
  free(Seq2);

  for(k=0;k<num;k++) free(Seq[k]);
  free(Seq);

/*  fprintf(stdout,"PASSb9\n");
  fflush(stdout);*/
  free_memory_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,buffx,buffy);

/*  fprintf(stdout,"PASSb10\n");
  fflush(stdout);*/
/*  fprintf(stdout,"energy = %d\n",energy);
  fflush(stdout);*/
  return energy;
}
