/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"

#define NAME_BUFF 30

int CutP;
int flag;

char Seq[SEQNUM][MAXBUFF];
char CSeq[SEQNUM][MAXBUFF];

int Leng[SEQNUM];
int Num[SEQNUM];
int NumVec[SEQNUM][SEQNUM];
int SeqNum;
int R1,R2;

int M;

char Name[SEQNUM][NAME_BUFF];
int nameleng;
int MFlag;
int Matrix[SEQNUM][SEQNUM];

double atof();
char *read_num_end();

int makeEnergy();
int readDisMatrix();
int readSeq();

int check_flag();

struct DATA0 d0;

main(argc,argv)
int argc;
char *argv[];
{
  FILE *fopen(),*fp_r;
  char Buff[261];
  int i;
  char *p;
/*
  d0.U = 7; 
  d0.V = 1; 
  d0.S = 0; 
  CutP = 80; 
*/  
  flag = 0;

  if(argc == 1) {
    fprintf(stderr,
	    "usage : tree_based [-a|-s]  [matrix file]  < apdp output file\n");
    exit(-1);
  }
  if(argc == 2) {
    if(*argv[1] == '-') {
      flag = check_flag(argv[1]);
      if(flag == -1) {
	fprintf(stderr,"option must be -a or -s\n");
	exit(-1);
      }
    }
    else {
      fp_r = fopen(argv[1],"r");
      if(fp_r == NULL) {
	fprintf(stderr,"matrix file open error \n");
	exit(-1);
      }
      for(i=0;i<26;i++){
	if(fgets(Buff,260,fp_r) == NULL){
	  fprintf(stderr,"matrix has only %d lines \n",i);
	  exit(-1);
	}
	readMatrix(&Buff[0],260,i);
      }
      fclose(fp_r);
    }
  }
  if(argc == 3) {
    if(*argv[1] == '-') {
      flag = check_flag(argv[1]);
      if(flag == -1) {
	fprintf(stderr,"option must be -a or -s\n");
	exit(-1);
      }
      fp_r = fopen(argv[2],"r");
      if(fp_r == NULL) {
	fprintf(stderr,"matrix file open error \n");
	exit(-1);
      }
      for(i=0;i<26;i++){
	if(fgets(Buff,260,fp_r) == NULL){
	  fprintf(stderr,"matrix has only %d lines \n",i);
	  exit(-1);
	}
	readMatrix(&Buff[0],260,i);
      }
      fclose(fp_r);
    }
    else {
      fp_r = fopen(argv[1],"r");
      if(fp_r == NULL) {
	fprintf(stderr,"matrix file open error \n");
	exit(-1);
      }
      for(i=0;i<26;i++){
	if(fgets(Buff,260,fp_r) == NULL){
	  fprintf(stderr,"matrix has only %d lines \n",i);
	  exit(-1);
	}
	readMatrix(&Buff[0],260,i);
      }
      fclose(fp_r);
      flag = check_flag(argv[2]);
      if(flag == -1) {
	fprintf(stderr,"option must be -a or -s\n");
	exit(-1);
      }
    }
  }

  readFile();
  dp();
  
}


int check_flag(p)
char *p;
{
  int a=0;

/*  fprintf(stderr,"%c",*p); */
  p++;
/*  fprintf(stderr,"%c",*p); */
  if(*p == 's') a = 1;
  else if(*p == 'a') a = 2;
  else a= -1;

  return a;
}


readFile()
{
  int i,j,num;
  char Buff[MAXBUFF+1];

  for(;;){
    fgets(Buff,MAXBUFF,stdin);
    if(strncmp(Buff,"End of readSeq",14) == 0) break;
    else if(strncmp(Buff,"U,V,S=",6) == 0) readGapCost(&Buff[6],MAXBUFF-6,&d0);
    else if(strncmp(Buff,"CutP=",5) == 0) readCutRatioP(&Buff[5],MAXBUFF-5);
    else if(strncmp(Buff,"MFlag=",6) == 0) readMFlag(&Buff[6],MAXBUFF-6);
    else if(strncmp(Buff,"Seq=",4) == 0) {
      num = 0;
      nameleng=0;
      for(;;){
	fgets(Buff,MAXBUFF,stdin);
	if( readSeq(&Buff[0],&num) == 0 ) break;
      }
      SeqNum = num;
      fprintf(stderr,"\nEnd readSeq\n");
    }
    else {}
  }
  fprintf(stderr,"\nEnd readFile\n\n");
}


int readSeq(p,num)
char *p;
int *num;
{
  int  i,a=1;

  i=0;
  for(;;){
    if(*p == '\n' || *p == '\0') {
      a = 0;
      break;
    }
    else if(*p == ':') {
      if(nameleng < i) nameleng = i;
      
      while(i<NAME_BUFF){
	Name[*num][i] = ' ';
	i++;
      }

      p++;
      i = 0;
      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  CSeq[*num][i] = *p;
	  if(*p >= 'a' && *p <= 'z')  *p -= 'a';
	  else  *p -= 'A';
	  Seq[*num][i] = *p;
	  p++;
	  i++;
	}
      }
      
      Leng[*num] = i;
      Num[*num] = 1;
      NumVec[*num][0] = *num;
      
      (*num)++;
      
      a = 1;
      break;
    } 
    else {
      Name[*num][i] = *p;
      i++;
      p++;
    }
  }
  return a;
}


readCutRatioP(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   cut,fg=0;

  rp = read_num_end('\n',p,leng,&cut,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readCutRatio\n");
    exit(1);
  }

  CutP = cut;
}


readMFlag(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   cut,fg=0;

  rp = read_num_end('\n',p,leng,&cut,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readCutRatio\n");
    exit(1);
  }

  MFlag = cut;
}


dp()
{
  int i,j,k,energy;
  int **Matrix;
  fprintf(stdout,"Seq=\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng[i];j++){
      fprintf(stdout,"%c",CSeq[i][j]);
    }
    fprintf(stdout,"\n");
  }
  fflush(stdout);
    
  fprintf(stdout,"\nCutP=%d\n",CutP);
  fprintf(stdout,"U,V,S=%d,%d,%d\n",d0.U,d0.V,d0.S);
  fprintf(stdout,"MFlag=%d\n\n",MFlag);
  fprintf(stderr,"MFlag=%d\n",MFlag);
  fprintf(stderr,"SeqNum=%d\n\n",SeqNum);
  fflush(stdout);
  fflush(stderr);
  
  putMatrix();

  d0.Cut = CutP;
  for(i=0;i<SeqNum-1;i++){
    fprintf(stderr,"STEP %d\n",i);
    fprintf(stdout,"STEP %d\n",i);
    minimumCost();
    fflush(stderr);
    fflush(stdout);
  }

  makeAlignmentString();
  energy = makeEnergy();
  fprintf(stderr,"\nEnergy = %d\n",energy);
  fflush(stderr);

  fprintf(stdout,"\nEnergy = %d\n",energy);
  fflush(stdout);
}


putMatrix()
{
  int i,j;
  char Buff[MAXBUFF+1];

  for(;;){
    fgets(Buff,MAXBUFF,stdin);
    if(strncmp(Buff,"END",3) == 0) break;
    else if(strncmp(Buff,"ID1",3) == 0) {
      for(i=0;i<SeqNum;i++) {
	for(j=i+1;j<SeqNum;j++) {
	  fgets(Buff,MAXBUFF,stdin);
	  switch(MFlag)
	    {
	    case 1:Matrix[j][i] = readDisMatrix(&Buff[23],7);break;
	    case 2:Matrix[j][i] = -readDisMatrix(&Buff[30],4);break;
	    case 3:Matrix[j][i] = readDisMatrix(&Buff[34],4);break;
	    case 4:Matrix[j][i] = -readDisMatrix(&Buff[38],8);break;
	    default: printf("MFlag Error\n"); exit(1);
	    }
	}
      }
      break;
    }
    else continue;
  }
}


int readDisMatrix(p,leng)
char *p;
int leng;
{
  int  i,k = 0;
  char dest[10];
  int num;

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else{
      fprintf(stderr,"Illegal Format in readDisMatrix\n");
      exit(1);
    }
  }

  dest[k] = 0;
  num = (int)atof(dest);

/*  fprintf(stderr,"%d\n",num);*/

  return  num;
}


minimumCost()
{
  int i,j,k,m,cost=1000000000;
  int newcost,oldcost;

  for(j=0;j<SeqNum;j++){
    for(i=j+1;i<SeqNum;i++){
      newcost = Matrix[i][j];
      if(newcost < cost){
	cost = newcost;
	R1 = j;
	R2 = i;
      }
    }
  }

  fprintf(stderr,"R1=%d,R2=%d\n",R1,R2);
  fprintf(stdout,"R1=%d,R2=%d\n",R1,R2);

  d0.X = Leng[R2];
  d0.Y = Leng[R1];
  fprintf(stderr,"X=%d,Y=%d\n",d0.X,d0.Y);
  fprintf(stdout,"X=%d,Y=%d\n",d0.X,d0.Y);
  
  d0.NumX = Num[R2];
  d0.NumY = Num[R1];
  fprintf(stderr,"NumX=%d,NumY=%d\n",d0.NumX,d0.NumY);
  fprintf(stdout,"NumX=%d,NumY=%d\n",d0.NumX,d0.NumY);

/*  keep_memory1(); */

  fprintf(stderr,"Seq1 = ");
  fprintf(stdout,"Seq1 = ");
  for(i=0;i<d0.NumX;i++){
    m = NumVec[R2][i];
    fprintf(stderr,"%d,",m);
    fprintf(stdout,"%d,",m);
    k = 0;
    while(CSeq[m][k] == '-'){
      d0.CSeq1[i][k] = '#';
      d0.Seq1[i][k] = Seq[m][k];
      k++;
    }
    while(k<d0.X){
      d0.CSeq1[i][k] = CSeq[m][k];
      d0.Seq1[i][k] = Seq[m][k];
      k++;
    }
    k--;
    while(CSeq[m][k] == '-'){
      d0.CSeq1[i][k] = '#';
      k--;
    }
  }
  fprintf(stderr,"\n");
  fprintf(stdout,"\n");
  fprintf(stderr,"Seq2 = ");
  fprintf(stdout,"Seq2 = ");
  for(i=0;i<d0.NumY;i++){
    m = NumVec[R1][i];
    fprintf(stderr,"%d,",m);
    fprintf(stdout,"%d,",m);
    k = 0;
    while(CSeq[m][k] == '-'){
      d0.CSeq2[i][k] = '#';
      d0.Seq2[i][k] = Seq[m][k];
      k++;
    }
    while(k<d0.Y){
      d0.CSeq2[i][k] = CSeq[m][k];
      d0.Seq2[i][k] = Seq[m][k];
      k++;
    }
    k--;
    while(CSeq[m][k] == '-'){
      d0.CSeq2[i][k] = '#';
      k--;
    }
  }
  fprintf(stderr,"\n");
  fprintf(stdout,"\n");
  fflush(stderr);
  fflush(stdout);

  fprintf(stderr,"PASS0\n");
  fprintf(stdout,"PASS0\n");
  generateD_00(&d0);
  fprintf(stderr,"PASS1\n");
  fprintf(stdout,"PASS1\n");
  makeAlignmentString1();
  fprintf(stderr,"PASS2\n\n");
  fprintf(stdout,"PASS2\n\n");

/*  free_memory1(); */

  for(j=0;j<R1;j++){
    oldcost = Matrix[R1][j];
    Matrix[R1][j] = ( Matrix[R2][j] + oldcost ) / 2;
  }
  for(i=R1+1;i<R2;i++){
    oldcost = Matrix[i][R1];
    Matrix[i][R1] = ( Matrix[R2][i] + oldcost ) / 2;
  }
  for(i=R2+1;i<SeqNum;i++){
    oldcost = Matrix[i][R1];
    Matrix[i][R1] = ( Matrix[i][R2] + oldcost ) / 2;
  }

  for(i=0;i<R2;i++){
    Matrix[R2][i] = 1000000000;
  }

  for(i=R2+1;i<SeqNum;i++){
    Matrix[i][R2] = 1000000000;
  }

  Num[R1] = d0.NumX + d0.NumY;
  Num[R2] = 0;

  j = d0.NumY;
  for(i=0;i<d0.NumX;i++){
    NumVec[R1][j] = NumVec[R2][i];
    j++;
  }
}



int makeEnergy()
{
  int i,j,k,K;
  int energy=0;

  for(i=0;i<SeqNum;i++){
    j = 0;
    while(CSeq[i][j] == '-'){
      CSeq[i][j] = '#';
      j++;
    }
    j = Leng[0]-1;
    while(CSeq[i][j] == '-'){
      CSeq[i][j] = '#';
      j--;
    }
  }

  for(i=0;i<SeqNum;i++){
    for(j=i+1;j<SeqNum;j++){
      for(k=0;k<Leng[0];k++){
	if((CSeq[i][k] == '-' || CSeq[i][k] == '#') 
	   && (CSeq[j][k] == '-' || CSeq[j][k] == '#')) {}
	else if(CSeq[i][k] == '#' || CSeq[j][k] == '#') energy += d0.S;
	else if(CSeq[i][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(CSeq[i][K] != '-'){
	      energy += d0.U + d0.V;
	      break;
	    }
	    else if(CSeq[j][K] != '-'){
	      energy += d0.V;
	      break;
	    }
	    else {}
	  }
	}
	else if(CSeq[j][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(CSeq[j][K] != '-'){
	      energy += d0.U + d0.V;
	      break;
	    }
	    else if(CSeq[i][K] != '-'){
	      energy += d0.V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += Dmatrix[Seq[i][k]][Seq[j][k]];
	}
      }
    }
  }
  return energy;
}


makeAlignmentString1()
{
  int i,j,k,a,mx,my,lim;
  char NextPath,c;

  i = 0;

  NextPath = d0.Path[d0.J][d0.I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<d0.NumX;k++){
	mx = NumVec[R2][k];
	if(d0.CSeq1[k][d0.I-1] == '#' || d0.CSeq1[k][d0.I-1] == '-'){
	  CSeq[mx][i] = '-';
	  Seq[mx][i] = 100;
	}
	else{
	  CSeq[mx][i] = d0.CSeq1[k][d0.I-1];
	  Seq[mx][i] = d0.Seq1[k][d0.I-1];
	}
      }
      for(k=0;k<d0.NumY;k++){
	my = NumVec[R1][k];
	if(d0.CSeq2[k][d0.J-1] == '#' || d0.CSeq2[k][d0.J-1] == '-'){
	  CSeq[my][i] = '-';
	  Seq[my][i] = 100;
	}
	else{
	  CSeq[my][i] = d0.CSeq2[k][d0.J-1];
	  Seq[my][i] = d0.Seq2[k][d0.J-1];
	}
      }
      d0.I--;
      d0.J--;
      NextPath = d0.Path[d0.J][d0.I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<d0.NumX;k++){ 
	mx = NumVec[R2][k];
	if(d0.CSeq1[k][d0.I-1] == '#' || d0.CSeq1[k][d0.I-1] == '-'){
	  CSeq[mx][i] = '-';
	  Seq[mx][i] = 100;
	}
	else{
	  CSeq[mx][i] = d0.CSeq1[k][d0.I-1];
	  Seq[mx][i] = d0.Seq1[k][d0.I-1];
	}
      }
      for(k=0;k<d0.NumY;k++) {
	my = NumVec[R1][k];
	CSeq[my][i] = '-';
	Seq[my][i] = 100;
      }
      d0.I--;
      NextPath = d0.Path[d0.J][d0.I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<d0.NumX;k++){ 
	mx = NumVec[R2][k];
	CSeq[mx][i] = '-';
	Seq[mx][i] = 100;
      }
      for(k=0;k<d0.NumY;k++){
	my = NumVec[R1][k];
	if(d0.CSeq2[k][d0.J-1] == '#' || d0.CSeq2[k][d0.J-1] == '-'){
	  CSeq[my][i] = '-';
	  Seq[my][i] = 100;
	}
	else{
	  CSeq[my][i] = d0.CSeq2[k][d0.J-1];
	  Seq[my][i] = d0.Seq2[k][d0.J-1];
	}
      }
      d0.J--;
      NextPath = d0.Path[d0.J][d0.I].y;
    }
    else {
      printf("makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(d0.I == 0 && d0.J == 0) break;

  }
  Leng[R1] = i;
  Leng[R2] = 0;

  lim = Leng[R1] / 2;
  if(flag == 1 || flag == 2) fprintf(stdout,"\n");
  for(k=0;k<d0.NumX;k++){
    mx = NumVec[R2][k];
    j = 0;
    i = Leng[R1] - 1;
    for(a=0;a<lim;a++){
      c = CSeq[mx][j];
      CSeq[mx][j] = CSeq[mx][i];
      CSeq[mx][i] = c;
      c = Seq[mx][j];
      Seq[mx][j] = Seq[mx][i];
      Seq[mx][i] = c;
      j++;
      i--;
    }
    if(flag == 1 || flag == 2){
      for(j=0;j<Leng[R1];j++) fprintf(stdout,"%c",CSeq[mx][j]);
      fprintf(stdout,"\n");
    }
  }
  fflush(stdout);
  for(k=0;k<d0.NumY;k++){
    my = NumVec[R1][k];
    j = 0;
    i = Leng[R1] - 1;
    for(a=0;a<lim;a++){
      c = CSeq[my][j];
      CSeq[my][j] = CSeq[my][i];
      CSeq[my][i] = c;
      c = Seq[my][j];
      Seq[my][j] = Seq[my][i];
      Seq[my][i] = c;
      j++;
      i--;
    }
    if(flag == 1 || flag == 2){
      for(j=0;j<Leng[R1];j++) fprintf(stdout,"%c",CSeq[my][j]);
      fprintf(stdout,"\n");
    }
  }
  fflush(stdout);
}


makeAlignmentString()
{
  int i,j;

  fprintf(stderr,"\nAlignmentSequences =\n\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stderr,"%c",Name[i][j]);
    }
    fprintf(stderr,":");
    for(j=0;j<Leng[0];j++){
      fprintf(stderr,"%c",CSeq[i][j]);
    }
    fprintf(stderr,"\n");
  }

  fprintf(stdout,"\nAlignmentSequences =\n\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng[0];j++){
      fprintf(stdout,"%c",CSeq[i][j]);
    }
    fprintf(stdout,"\n");
  }
}


