/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"

#define NAME_BUFF 30
#define SEED 1

int CutM;
int CutP;
int flag;
int Seed;

char OSeq[SEQNUM][MAXBUFF];
char OCSeq[SEQNUM][MAXBUFF];

char Seq[SEQNUM][MAXBUFF];
char CSeq[SEQNUM][MAXBUFF];

char DSeq1[SEQNUM][MAXBUFF];
char DCSeq1[SEQNUM][MAXBUFF];
char DSeq2[SEQNUM][MAXBUFF];
char DCSeq2[SEQNUM][MAXBUFF];

int Leng[SEQNUM];
int Leng1;
int Num[SEQNUM];
int NumVec[SEQNUM][SEQNUM];
int SeqNum;
int R1,R2;
int NVX[SEQNUM],NVY[SEQNUM];

int M;

char Name[SEQNUM][NAME_BUFF];
int nameleng;
int MFlag;
int Matrix[SEQNUM][SEQNUM];
int TMatrix[SEQNUM][SEQNUM];

char *malloc();
double atof();
char *read_num();
char *read_num_end();

int makeEnergy(),makeEnergy1(),makeEnergy2();
int readDisMatrix();
int readSeq();

int check_flag();

struct DATA0 d0;

main(argc,argv)
int argc;
char *argv[];
{
  FILE *fopen(),*fp_r;
  char Buff[261];
  int i;
  char *p;
/*
  d0.U = 7; 
  d0.V = 1; 
  d0.S = 0; 
  CutP = 80; 
  CutM = 97; 
*/  
  flag = 0;

  if(argc == 1) {
    fprintf(stderr,
	    "usage : tbm1as [-a|-s]  [matrix file]  < apdp output file\n");
    exit(-1);
  }  if(argc == 2) {
    if(*argv[1] == '-') {
      flag = check_flag(argv[1]);
      if(flag == -1) {
	fprintf(stderr,"option must be -a or -s\n");
	exit(-1);
      }
    }
    else {
      fp_r = fopen(argv[1],"r");
      if(fp_r == NULL) {
	fprintf(stderr,"matrix file open error \n");
	exit(-1);
      }
      for(i=0;i<26;i++){
	if(fgets(Buff,260,fp_r) == NULL){
	  fprintf(stderr,"matrix has only %d lines \n",i);
	  exit(-1);
	}
	readMatrix(&Buff[0],260,i);
      }
      fclose(fp_r);
    }
  }
  if(argc == 3) {
    if(*argv[1] == '-') {
      flag = check_flag(argv[1]);
      if(flag == -1) {
	fprintf(stderr,"option must be -a or -s\n");
	exit(-1);
      }
      fp_r = fopen(argv[2],"r");
      if(fp_r == NULL) {
	fprintf(stderr,"matrix file open error \n");
	exit(-1);
      }
      for(i=0;i<26;i++){
	if(fgets(Buff,260,fp_r) == NULL){
	  fprintf(stderr,"matrix has only %d lines \n",i);
	  exit(-1);
	}
	readMatrix(&Buff[0],260,i);
      }
      fclose(fp_r);
    }
    else {
      fp_r = fopen(argv[1],"r");
      if(fp_r == NULL) {
	fprintf(stderr,"matrix file open error \n");
	exit(-1);
      }
      for(i=0;i<26;i++){
	if(fgets(Buff,260,fp_r) == NULL){
	  fprintf(stderr,"matrix has only %d lines \n",i);
	  exit(-1);
	}
	readMatrix(&Buff[0],260,i);
      }
      fclose(fp_r);
      flag = check_flag(argv[2]);
      if(flag == -1) {
	fprintf(stderr,"option must be -a or -s\n");
	exit(-1);
      }
    }
  }

  readFile(&d0);
  dp(&d0);
  
}


int check_flag(p)
char *p;
{
  int a=0;

/*  fprintf(stderr,"%c",*p); */
  p++;
/*  fprintf(stderr,"%c",*p); */
  if(*p == 's') a = 1;
  else if(*p == 'a') a = 2;
  else a = -1;

  return a;
}


readFile(d0)
struct DATA0 *d0;
{
  int i,j,num;
  char Buff[MAXBUFF+1];

  for(;;){
    fgets(Buff,MAXBUFF,stdin);
    if(strncmp(Buff,"End of readSeq",14) == 0) break;
    else if(strncmp(Buff,"U,V,S=",6) == 0) readGapCost(&Buff[6],MAXBUFF-6,d0);
    else if(strncmp(Buff,"CutP=",5) == 0) readCutRatioP(&Buff[5],MAXBUFF-5);
    else if(strncmp(Buff,"CutM=",5) == 0) readCutRatioM(&Buff[5],MAXBUFF-5);
    else if(strncmp(Buff,"MFlag=",6) == 0) readMFlag(&Buff[6],MAXBUFF-6);
    else if(strncmp(Buff,"Seq=",4) == 0) {
      num = 0;
      nameleng=0;
      for(;;){
	fgets(Buff,MAXBUFF,stdin);
	if( readSeq(&Buff[0],&num) == 0 ) break;
      }
      SeqNum = num;
      fprintf(stderr,"\nEnd readSeq\n");
    }
    else {}
  }
  fprintf(stderr,"\nEnd readFile\n\n");
}


int readSeq(p,num)
char *p;
int *num;
{
  int  i,a=1;

  i=0;
  for(;;){
    if(*p == '\n' || *p == '\0') {
      a = 0;
      break;
    }
    else if(*p == ':') {
      if(nameleng < i) nameleng = i;
      
      while(i<NAME_BUFF){
	Name[*num][i] = ' ';
	i++;
      }

      p++;
      i = 0;
      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  CSeq[*num][i] = *p;
	  if(*p >= 'a' && *p <= 'z')  *p -= 'a';
	  else  *p -= 'A';
	  Seq[*num][i] = *p;
	  p++;
	  i++;
	}
      }
      
      Leng[*num] = i;
      Num[*num] = 1;
      NumVec[*num][0] = *num;
      
      (*num)++;
      
      a = 1;
      break;
    } 
    else {
      Name[*num][i] = *p;
      i++;
      p++;
    }
  }
  return a;
}


readCutRatioP(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   cut,fg=0;

  rp = read_num_end('\n',p,leng,&cut,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readCutRatio\n");
    exit(1);
  }

  CutP = cut;
}


readCutRatioM(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   cut,fg=0;

  rp = read_num_end('\n',p,leng,&cut,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readCutRatio\n");
    exit(1);
  }

  CutM = cut;
}


readMFlag(p,leng)
char *p;
int  leng;
{
  char  *rp;
  int   cut,fg=0;

  rp = read_num_end('\n',p,leng,&cut,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readCutRatio\n");
    exit(1);
  }

  MFlag = cut;
}


dp(d0)
struct DATA0 *d0;
{
  int i,j,k,energy;
  int **Matrix;
/*
  fprintf(stdout,"Seq=\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng[i];j++){
      fprintf(stdout,"%c",CSeq[i][j]);
    }
    fprintf(stdout,"\n");
  }
  fflush(stdout);
*/    
  fprintf(stdout,"\nCutP=%d\n",CutP);
  fprintf(stdout,"CutM=%d\n",CutM);
  fprintf(stdout,"U,V,S=%d,%d,%d\n",d0->U,d0->V,d0->S);
  fprintf(stdout,"MFlag=%d\n",MFlag);
  fprintf(stderr,"MFlag=%d\n",MFlag);
  fprintf(stderr,"SeqNum=%d\n\n",SeqNum);
  fflush(stdout);
  fflush(stderr);
  
  putMatrix();

  for(i=0;i<SeqNum-1;i++){
    fprintf(stderr,"STEP %d\n",i);
/*    fprintf(stdout,"STEP %d\n",i);*/
    d0->Cut = CutP;
    minimumCost(d0);
/*    fprintf(stdout,"\n");*/
    d0->Cut = CutM;
    munson(d0);
    fprintf(stderr,"\n\n");
    fflush(stderr);
/*    fflush(stdout);*/
  }

  makeAlignmentString();
  energy = makeEnergy(d0);
  fprintf(stderr,"\nEnergy = %d\n",energy);
  fflush(stderr);

  fprintf(stdout,"\nEnergy = %d\n",energy);
  fflush(stdout);
}


putMatrix()
{
  int i,j;
  char Buff[MAXBUFF+1];

  for(;;){
    fgets(Buff,MAXBUFF,stdin);
    if(strncmp(Buff,"END",3) == 0) break;
    else if(strncmp(Buff,"ID1",3) == 0) {
      for(i=0;i<SeqNum;i++) {
	for(j=i+1;j<SeqNum;j++) {
	  fgets(Buff,MAXBUFF,stdin);
	  switch(MFlag)
	    {
	    case 1:Matrix[j][i] = readDisMatrix(&Buff[23],7);break;
	    case 2:Matrix[j][i] = -readDisMatrix(&Buff[30],4);break;
	    case 3:Matrix[j][i] = readDisMatrix(&Buff[34],4);break;
	    case 4:Matrix[j][i] = -readDisMatrix(&Buff[38],8);break;
	    default: printf("MFlag Error\n"); exit(1);
	    }
	}
      }
      break;
    }
    else continue;
  }
}


int readDisMatrix(p,leng)
char *p;
int leng;
{
  int  i,k = 0;
  char dest[10];
  int num;

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else{
      fprintf(stderr,"Illegal Format in readDisMatrix\n");
      exit(1);
    }
  }

  dest[k] = 0;
  num = (int)atof(dest);

/*  fprintf(stderr,"%d\n",num);*/

  return  num;
}


minimumCost(d0)
struct DATA0 *d0;
{
  int i,j,k,m,cost=1000000000;
  int newcost,oldcost;

  for(j=0;j<SeqNum;j++){
    for(i=j+1;i<SeqNum;i++){
      newcost = Matrix[i][j];
      if(newcost < cost){
	cost = newcost;
	R1 = j;
	R2 = i;
      }
    }
  }

  fprintf(stderr,"R1=%d,R2=%d\n",R1,R2);
/*  fprintf(stdout,"R1=%d,R2=%d\n",R1,R2);*/

  d0->X = Leng[R2];
  d0->Y = Leng[R1];
  fprintf(stderr,"X=%d,Y=%d\n",d0->X,d0->Y);
/*  fprintf(stdout,"X=%d,Y=%d\n",d0->X,d0->Y);*/
  
  d0->NumX = Num[R2];
  d0->NumY = Num[R1];
  fprintf(stderr,"NumX=%d,NumY=%d\n",d0->NumX,d0->NumY);
/*  fprintf(stdout,"NumX=%d,NumY=%d\n",d0->NumX,d0->NumY);*/

  fprintf(stderr,"Seq1 = ");
/*  fprintf(stdout,"Seq1 = ");*/
  for(i=0;i<d0->NumX;i++){
    m = NumVec[R2][i];
    fprintf(stderr,"%d,",m);
/*    fprintf(stdout,"%d,",m);*/
    k = 0;
    while(CSeq[m][k] == '-'){
      d0->CSeq1[i][k] = '#';
      d0->Seq1[i][k] = Seq[m][k];
      k++;
    }
    while(k<d0->X){
      d0->CSeq1[i][k] = CSeq[m][k];
      d0->Seq1[i][k] = Seq[m][k];
      k++;
    }
    k--;
    while(CSeq[m][k] == '-'){
      d0->CSeq1[i][k] = '#';
      k--;
    }
  }
  fprintf(stderr,"\n");
/*  fprintf(stdout,"\n");*/
  fprintf(stderr,"Seq2 = ");
/*  fprintf(stdout,"Seq2 = ");*/
  for(i=0;i<d0->NumY;i++){
    m = NumVec[R1][i];
    fprintf(stderr,"%d,",m);
/*    fprintf(stdout,"%d,",m);*/
    k = 0;
    while(CSeq[m][k] == '-'){
      d0->CSeq2[i][k] = '#';
      d0->Seq2[i][k] = Seq[m][k];
      k++;
    }
    while(k<d0->Y){
      d0->CSeq2[i][k] = CSeq[m][k];
      d0->Seq2[i][k] = Seq[m][k];
      k++;
    }
    k--;
    while(CSeq[m][k] == '-'){
      d0->CSeq2[i][k] = '#';
      k--;
    }
  }
  fprintf(stderr,"\n");
/*  fprintf(stdout,"\n");*/

  generateD_00(d0);

  makeAlignmentString1(d0);

  for(j=0;j<R1;j++){
    oldcost = Matrix[R1][j];
    Matrix[R1][j] = ( Matrix[R2][j] + oldcost ) / 2;
  }
  for(i=R1+1;i<R2;i++){
    oldcost = Matrix[i][R1];
    Matrix[i][R1] = ( Matrix[R2][i] + oldcost ) / 2;
  }
  for(i=R2+1;i<SeqNum;i++){
    oldcost = Matrix[i][R1];
    Matrix[i][R1] = ( Matrix[i][R2] + oldcost ) / 2;
  }

  for(i=0;i<R2;i++){
    Matrix[R2][i] = 1000000000;
  }

  for(i=R2+1;i<SeqNum;i++){
    Matrix[i][R2] = 1000000000;
  }

  Num[R1] = d0->NumX + d0->NumY;
  Num[R2] = 0;

  j = d0->NumY;
  for(i=0;i<d0->NumX;i++){
    NumVec[R1][j] = NumVec[R2][i];
    j++;
  }
}



munson(d0)
struct DATA0 *d0;
{
  int i,j,k,m,mx,my,count,Stop,*id,Step,Step1;
  int energy,newenergy;
  int random();

  count = 0;
  Step = 0;
  Step1 = 0;

  Seed = SEED;
  srand(Seed);
  
  Stop = Num[R1]*2 - 3;

  if(NULL == (id = ( int * )malloc(sizeof(int) * Stop))){
    fprintf(stderr,"malloc failed for id\n");
    exit(0);
  }
  for(i=0;i<Stop;i++) id[i] = i;

  energy = makeEnergy1(d0);
  
  while(count < Stop){
    Step++;

    M = random(id,count);
    fprintf(stderr,"\nStep = %d, Rand = %d",Step,M);

    d0->X = Leng[R1];
    d0->Y = Leng[R1];

    if(M < Num[R1]) iterative_1(&newenergy,d0);
    else iterative_tree(&newenergy,d0);

    if(newenergy < energy){
      Step1++;
      energy = newenergy;
      Leng[R1] = Leng1;
      fprintf(stderr,", Energy = %d",energy);
/*      fprintf(stdout,"Step = %d, Rand = %d, Energy = %d\n",Step,M,energy);*/
      for(i=0;i<Num[R1];i++){
	m = NumVec[R1][i];
	for(k=0;k<Leng[R1];k++){
	  CSeq[m][k] = OCSeq[m][k];
/*          fprintf(stdout,"%c",CSeq[i][k]);*/
	  Seq[m][k] = OSeq[m][k];
	}
/*        fprintf(stdout,"\n");*/
      }
/*      fprintf(stdout,"\n");*/
/*      fflush(stdout);*/
      count = 0;
      for(i=0;i<Stop;i++) id[i] = i;
    }
    else {
      count++;
    }
  }
}


iterative_1(newenergy,d0)
int *newenergy;
struct DATA0 *d0;
{
  int i,j,k,m;

  d0->NumX = 1;
  d0->NumY = Num[R1] - 1;

  m = NumVec[R1][M];
  k = 0;
  while(CSeq[m][k] == '-'){
    DCSeq1[0][k] = '#';
    DSeq1[0][k] = Seq[m][k];
    k++;
  }
  while(k<d0->X){
    DCSeq1[0][k] = CSeq[m][k];
    DSeq1[0][k] = Seq[m][k];
    k++;
  }
  k--;
  while(CSeq[m][k] == '-'){
    DCSeq1[0][k] = '#';
    k--;
  }
  
  for(j=0;j<M;j++){
    m = NumVec[R1][j];
    k = 0;
    while(CSeq[m][k] == '-'){
      DCSeq2[j][k] = '#';
      DSeq2[j][k] = Seq[m][k];
      k++;
    }
    while(k<d0->Y){
      DCSeq2[j][k] = CSeq[m][k];
      DSeq2[j][k] = Seq[m][k];
      k++;
    }
    k--;
    while(CSeq[m][k] == '-'){
      DCSeq2[j][k] = '#';
      k--;
    }
  }
  for(j=M+1;j<Num[R1];j++){
    m = NumVec[R1][j];
    k = 0;
    while(CSeq[m][k] == '-'){
      DCSeq2[j-1][k] = '#';
      DSeq2[j-1][k] = Seq[m][k];
      k++;
    }
    while(k<d0->Y){
      DCSeq2[j-1][k] = CSeq[m][k];
      DSeq2[j-1][k] = Seq[m][k];
      k++;
    }
    k--;
    while(CSeq[m][k] == '-'){
      DCSeq2[j-1][k] = '#';
      k--;
    }
  }
  
  remove_allgap(d0);
  
  generateD_00(d0);
  
  makeAlignmentString2(d0);
    
  *newenergy = makeEnergy2(d0);

}


iterative_tree(newenergy,d0)
int *newenergy;
struct DATA0 *d0;
{
  int i,j,i1,j1,m,k,tflag,MT,RR1,RR2,NNumX,NNumY;
  int energy1,newcost,oldcost,cost;
  int NNum[SEQNUM],NNumVec[SEQNUM][SEQNUM];

  energy1 = makeEnergy1(d0);

  for(i=0;i<Num[R1];i++){
    NNum[i] = 1;
    NNumVec[i][0] = i;
  }

/*
  MT = M;
  for(M=MT;M<MT+Num[R1]-2;M++){
*/
/*  for(MT=Num[R1];MT<M;MT++){*/
  for(MT=Num[R1];MT<M+1;MT++){
    cost=1000000000;
    for(j=0;j<Num[R1];j++){
      for(i=j+1;i<Num[R1];i++){
	newcost = TMatrix[i][j];
	if(newcost < cost){
	  cost = newcost;
	  RR1 = j;
	  RR2 = i;
	}
      }
    }
    
    NNumX = NNum[RR2];
    NNumY = NNum[RR1];
    
    for(j=0;j<RR1;j++){
      oldcost = TMatrix[RR1][j];
      TMatrix[RR1][j] = ( TMatrix[RR2][j] + oldcost ) / 2;
    }
    for(i=RR1+1;i<RR2;i++){
      oldcost = TMatrix[i][RR1];
      TMatrix[i][RR1] = ( TMatrix[RR2][i] + oldcost ) / 2;
    }
/*    for(i=RR2+1;i<SeqNum;i++){*/
    for(i=RR2+1;i<Num[R1];i++){
      oldcost = TMatrix[i][RR1];
      TMatrix[i][RR1] = ( TMatrix[i][RR2] + oldcost ) / 2;
    }
    
    for(i=0;i<RR2;i++){
      TMatrix[RR2][i] = 1000000000;
    }
    
/*    for(i=RR2+1;i<SeqNum;i++){*/
    for(i=RR2+1;i<Num[R1];i++){
      TMatrix[i][RR2] = 1000000000;
    }
    
    NNum[RR1] = NNumX + NNumY;
    NNum[RR2] = 0;
    
    j = NNumY;
    for(i=0;i<NNumX;i++){
      NNumVec[RR1][j] = NNumVec[RR2][i];
      j++;
    }

  }

  i1 = 0;
  j1 = 0;
  for(i=0;i<Num[R1];i++){
    tflag = 0;
    for(j=0;j<NNum[RR1];j++){
      if(i == NNumVec[RR1][j]){
	tflag = 1;
	break;
      }
    }
    
    if(tflag == 1){
      m = NumVec[R1][i];
      k = 0;
      while(CSeq[m][k] == '-'){
	DCSeq1[i1][k] = '#';
	DSeq1[i1][k] = Seq[m][k];
	k++;
      }
      while(k<d0->X){
	DCSeq1[i1][k] = CSeq[m][k];
	DSeq1[i1][k] = Seq[m][k];
	k++;
      }
      k--;
      while(CSeq[m][k] == '-'){
	DCSeq1[i1][k] = '#';
	k--;
      }
      NVX[i1] = m;
      i1++;
    }      
    else{
      m = NumVec[R1][i];
      k = 0;
      while(CSeq[m][k] == '-'){
	DCSeq2[j1][k] = '#';
	DSeq2[j1][k] = Seq[m][k];
	k++;
      }
      while(k<d0->Y){
	DCSeq2[j1][k] = CSeq[m][k];
	DSeq2[j1][k] = Seq[m][k];
	k++;
      }
      k--;
      while(CSeq[m][k] == '-'){
	DCSeq2[j1][k] = '#';
	k--;
      }
      NVY[j1] = m;
      j1++;
    }      
  }
  
  d0->NumX = i1;
  d0->NumY = j1;
  
  remove_allgap(d0);
  
  generateD_00(d0);
  
  makeAlignmentString3(d0);
  
  *newenergy = makeEnergy2(d0);

}


remove_allgap(d0)
struct DATA0 *d0;
{
  int i,j,k,k1;

  j = 0;
  for(i=0;i<d0->X;i++){
    for(k=0;k<d0->NumX;k++){
      if(DCSeq1[k][i] != '-' && DCSeq1[k][i] != '#'){
	for(k1=0;k1<d0->NumX;k1++){
	  d0->CSeq1[k1][j] = DCSeq1[k1][i];
	  d0->Seq1[k1][j] = DSeq1[k1][i];
	}
	j++;
	break;
      }
      else {}
    }
  }
  d0->X = j;

  j = 0;
  for(i=0;i<d0->Y;i++){
    for(k=0;k<d0->NumY;k++){
      if(DCSeq2[k][i] != '-' && DCSeq2[k][i] != '#'){
	for(k1=0;k1<d0->NumY;k1++){
	  d0->CSeq2[k1][j] = DCSeq2[k1][i];
	  d0->Seq2[k1][j] = DSeq2[k1][i];
	}
	j++;
	break;
      }
      else {}
    }
  }
  d0->Y = j;
}



int makeEnergy2(d0)
struct DATA0 *d0;
{
  int i,j,k,K,m,mx,my;
  int energy=0;

  for(i=0;i<Num[R1];i++){
    m = NumVec[R1][i];
    j = 0;
    while(OCSeq[m][j] == '-'){
      OCSeq[m][j] = '#';
      j++;
    }
    j = Leng1-1;
    while(OCSeq[m][j] == '-'){
      OCSeq[m][j] = '#';
      j--;
    }
  }

  for(i=0;i<Num[R1];i++){
    mx = NumVec[R1][i];
    for(j=i+1;j<Num[R1];j++){
      my = NumVec[R1][j];
      for(k=0;k<Leng1;k++){
	if((OCSeq[mx][k] == '-' || OCSeq[mx][k] == '#') 
	   && (OCSeq[my][k] == '-' || OCSeq[my][k] == '#')) {}
	else if(OCSeq[mx][k] == '#' || OCSeq[my][k] == '#') energy += d0->S;
	else if(OCSeq[mx][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(OCSeq[mx][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(OCSeq[my][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else if(OCSeq[my][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(OCSeq[my][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(OCSeq[mx][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += Dmatrix[OSeq[mx][k]][OSeq[my][k]];
	}
      }
    }
  }
  for(i=0;i<Num[R1];i++){
    m = NumVec[R1][i];
    j = 0;
    while(OCSeq[m][j] == '#'){
      OCSeq[m][j] = '-';
      j++;
    }
    j = Leng1-1;
    while(OCSeq[m][j] == '#'){
      OCSeq[m][j] = '-';
      j--;
    }
  }

  return energy;
}



int makeEnergy1(d0)
struct DATA0 *d0;
{
  int i,j,k,K,m,mx,my;
  int energy,total=0;

  for(i=0;i<Num[R1];i++){
    m = NumVec[R1][i];
    j = 0;
    while(CSeq[m][j] == '-'){
      CSeq[m][j] = '#';
      j++;
    }
    j = Leng[R1]-1;
    while(CSeq[m][j] == '-'){
      CSeq[m][j] = '#';
      j--;
    }
  }

  for(i=0;i<Num[R1];i++){
    mx = NumVec[R1][i];
    for(j=i+1;j<Num[R1];j++){
      my = NumVec[R1][j];
      energy = 0;
      for(k=0;k<Leng[R1];k++){
	if((CSeq[mx][k] == '-' || CSeq[mx][k] == '#') 
	   && (CSeq[my][k] == '-' || CSeq[my][k] == '#')) {}
	else if(CSeq[mx][k] == '#' || CSeq[my][k] == '#') energy += d0->S;
	else if(CSeq[mx][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(CSeq[mx][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(CSeq[my][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else if(CSeq[my][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(CSeq[my][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(CSeq[mx][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += Dmatrix[Seq[mx][k]][Seq[my][k]];
	}
      }
      TMatrix[j][i] = energy;
      total += energy;
    }
  }
  for(i=0;i<Num[R1];i++){
    m = NumVec[R1][i];
    j = 0;
    while(CSeq[m][j] == '#'){
      CSeq[m][j] = '-';
      j++;
    }
    j = Leng[R1]-1;
    while(CSeq[m][j] == '#'){
      CSeq[m][j] = '-';
      j--;
    }
  }
  return total;
}



int makeEnergy(d0)
struct DATA0 *d0;
{
  int i,j,k,K;
  int energy=0;

  for(i=0;i<SeqNum;i++){
    j = 0;
    while(CSeq[i][j] == '-'){
      CSeq[i][j] = '#';
      j++;
    }
    j = Leng[0]-1;
    while(CSeq[i][j] == '-'){
      CSeq[i][j] = '#';
      j--;
    }
  }

  for(i=0;i<SeqNum;i++){
    for(j=i+1;j<SeqNum;j++){
      for(k=0;k<Leng[0];k++){
	if((CSeq[i][k] == '-' || CSeq[i][k] == '#') 
	   && (CSeq[j][k] == '-' || CSeq[j][k] == '#')) {}
	else if(CSeq[i][k] == '#' || CSeq[j][k] == '#') energy += d0->S;
	else if(CSeq[i][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(CSeq[i][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(CSeq[j][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else if(CSeq[j][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(CSeq[j][K] != '-'){
	      energy += d0->U + d0->V;
	      break;
	    }
	    else if(CSeq[i][K] != '-'){
	      energy += d0->V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += Dmatrix[Seq[i][k]][Seq[j][k]];
	}
      }
    }
  }
  return energy;
}


makeAlignmentString3(d0)
struct DATA0 *d0;
{
  int i,j,k,mx,my;
  char NextPath;
  char ASeq[SEQNUM][MAXBUFF];
  char ACSeq[SEQNUM][MAXBUFF];

  i = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<d0->NumX;k++){
	mx = NVX[k];
	if(d0->CSeq1[k][d0->I-1] == '#' || d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[mx][i] = '-';
	  ASeq[mx][i] = 100;
	}
	else{
	  ACSeq[mx][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[mx][i] = d0->Seq1[k][d0->I-1];
	}
      }
      for(k=0;k<d0->NumY;k++){
	my = NVY[k];
	if(d0->CSeq2[k][d0->J-1] == '#' || d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 100;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	}
      }
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<d0->NumX;k++){ 
	mx = NVX[k];
	if(d0->CSeq1[k][d0->I-1] == '#' || d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[mx][i] = '-';
	  ASeq[mx][i] = 100;
	}
	else{
	  ACSeq[mx][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[mx][i] = d0->Seq1[k][d0->I-1];
	}
      }
      for(k=0;k<d0->NumY;k++) {
	my = NVY[k];
	ACSeq[my][i] = '-';
	ASeq[my][i] = 100;
      }
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<d0->NumX;k++){ 
	mx = NVX[k];
	ACSeq[mx][i] = '-';
	ASeq[mx][i] = 100;
      }
      for(k=0;k<d0->NumY;k++){
	my = NVY[k];
	if(d0->CSeq2[k][d0->J-1] == '#' || d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 100;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	}
      }
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      fprintf(stderr,"makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(d0->I == 0 && d0->J == 0) break;

  }

  Leng1 = i;

  for(k=0;k<d0->NumX;k++){
    mx = NVX[k];
    j = 0;
    for(i=Leng1-1;i>-1;i--){
      OCSeq[mx][j] = ACSeq[mx][i];
      OSeq[mx][j] = ASeq[mx][i];
      j++;
    }
  }
  for(k=0;k<d0->NumY;k++){
    my = NVY[k];
    j = 0;
    for(i=Leng1-1;i>-1;i--){
      OCSeq[my][j] = ACSeq[my][i];
      OSeq[my][j] = ASeq[my][i];
      j++;
    }
  }
}



makeAlignmentString2(d0)
struct DATA0 *d0;
{
  int i,j,k,mx,my;
  char NextPath;
  char ASeq[SEQNUM][MAXBUFF];
  char ACSeq[SEQNUM][MAXBUFF];

  i = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<d0->NumX;k++){
	mx = NumVec[R1][M];
	if(d0->CSeq1[k][d0->I-1] == '#' || d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[mx][i] = '-';
	  ASeq[mx][i] = 100;
	}
	else{
	  ACSeq[mx][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[mx][i] = d0->Seq1[k][d0->I-1];
	}
      }
      for(k=0;k<M;k++){
	my = NumVec[R1][k];
	if(d0->CSeq2[k][d0->J-1] == '#' || d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 100;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	}
      }
      for(k=M+1;k<Num[R1];k++){
	my = NumVec[R1][k];
	if(d0->CSeq2[k-1][d0->J-1] == '#' || d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 100;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k-1][d0->J-1];
	}
      }
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<d0->NumX;k++){ 
	mx = NumVec[R1][M];
	if(d0->CSeq1[k][d0->I-1] == '#' || d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[mx][i] = '-';
	  ASeq[mx][i] = 100;
	}
	else{
	  ACSeq[mx][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[mx][i] = d0->Seq1[k][d0->I-1];
	}
      }
      for(k=0;k<M;k++) {
	my = NumVec[R1][k];
	ACSeq[my][i] = '-';
	ASeq[my][i] = 100;
      }
      for(k=M+1;k<Num[R1];k++) {
	my = NumVec[R1][k];
	ACSeq[my][i] = '-';
	ASeq[my][i] = 100;
      }
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<d0->NumX;k++){ 
	mx = NumVec[R1][M];
	ACSeq[mx][i] = '-';
	ASeq[mx][i] = 100;
      }
      for(k=0;k<M;k++){
	my = NumVec[R1][k];
	if(d0->CSeq2[k][d0->J-1] == '#' || d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 100;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	}
      }
      for(k=M+1;k<Num[R1];k++){
	my = NumVec[R1][k];
	if(d0->CSeq2[k-1][d0->J-1] == '#' || d0->CSeq2[k-1][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 100;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k-1][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k-1][d0->J-1];
	}
      }
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      fprintf(stderr,"makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(d0->I == 0 && d0->J == 0) break;

  }

  Leng1 = i;

  for(k=0;k<d0->NumX;k++){
    mx = NumVec[R1][M];
    j = 0;
    for(i=Leng1-1;i>-1;i--){
      OCSeq[mx][j] = ACSeq[mx][i];
      OSeq[mx][j] = ASeq[mx][i];
      j++;
    }
  }
  for(k=0;k<M;k++){
    my = NumVec[R1][k];
    j = 0;
    for(i=Leng1-1;i>-1;i--){
      OCSeq[my][j] = ACSeq[my][i];
      OSeq[my][j] = ASeq[my][i];
      j++;
    }
  }
  for(k=M+1;k<Num[R1];k++){
    my = NumVec[R1][k];
    j = 0;
    for(i=Leng1-1;i>-1;i--){
      OCSeq[my][j] = ACSeq[my][i];
      OSeq[my][j] = ASeq[my][i];
      j++;
    }
  }
}



makeAlignmentString1(d0)
struct DATA0 *d0;
{
  int i,j,k,mx,my;
  char NextPath;
  char ASeq[SEQNUM][MAXBUFF];
  char ACSeq[SEQNUM][MAXBUFF];

  i = 0;

  NextPath = d0->Path[d0->J][d0->I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<d0->NumX;k++){
	mx = NumVec[R2][k];
	if(d0->CSeq1[k][d0->I-1] == '#' || d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[mx][i] = '-';
	  ASeq[mx][i] = 100;
	}
	else{
	  ACSeq[mx][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[mx][i] = d0->Seq1[k][d0->I-1];
	}
      }
      for(k=0;k<d0->NumY;k++){
	my = NumVec[R1][k];
	if(d0->CSeq2[k][d0->J-1] == '#' || d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 100;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	}
      }
      d0->I--;
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<d0->NumX;k++){ 
	mx = NumVec[R2][k];
	if(d0->CSeq1[k][d0->I-1] == '#' || d0->CSeq1[k][d0->I-1] == '-'){
	  ACSeq[mx][i] = '-';
	  ASeq[mx][i] = 100;
	}
	else{
	  ACSeq[mx][i] = d0->CSeq1[k][d0->I-1];
	  ASeq[mx][i] = d0->Seq1[k][d0->I-1];
	}
      }
      for(k=0;k<d0->NumY;k++) {
	my = NumVec[R1][k];
	ACSeq[my][i] = '-';
	ASeq[my][i] = 100;
      }
      d0->I--;
      NextPath = d0->Path[d0->J][d0->I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<d0->NumX;k++){ 
	mx = NumVec[R2][k];
	ACSeq[mx][i] = '-';
	ASeq[mx][i] = 100;
      }
      for(k=0;k<d0->NumY;k++){
	my = NumVec[R1][k];
	if(d0->CSeq2[k][d0->J-1] == '#' || d0->CSeq2[k][d0->J-1] == '-'){
	  ACSeq[my][i] = '-';
	  ASeq[my][i] = 100;
	}
	else{
	  ACSeq[my][i] = d0->CSeq2[k][d0->J-1];
	  ASeq[my][i] = d0->Seq2[k][d0->J-1];
	}
      }
      d0->J--;
      NextPath = d0->Path[d0->J][d0->I].y;
    }
    else {
      printf("makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(d0->I == 0 && d0->J == 0) break;

  }
  Leng[R1] = i;
  Leng[R2] = 0;

  if(flag == 1 || flag == 2) fprintf(stdout,"\n");
  for(k=0;k<d0->NumX;k++){
    mx = NumVec[R2][k];
    j = 0;
    for(i=Leng[R1]-1;i>-1;i--){
      CSeq[mx][j] = ACSeq[mx][i];
      Seq[mx][j] = ASeq[mx][i];
      if(flag == 1 || flag == 2) fprintf(stdout,"%c",CSeq[mx][j]);
      j++;
    }
    if(flag == 1 || flag == 2) fprintf(stdout,"\n");
  }
  for(k=0;k<d0->NumY;k++){
    my = NumVec[R1][k];
    j = 0;
    for(i=Leng[R1]-1;i>-1;i--){
      CSeq[my][j] = ACSeq[my][i];
      if(flag == 1 || flag == 2) fprintf(stdout,"%c",CSeq[my][j]);
      Seq[my][j] = ASeq[my][i];
      j++;
    }
    if(flag == 1 || flag == 2) fprintf(stdout,"\n");
  }
}


makeAlignmentString()
{
  int i,j;

  fprintf(stderr,"\nAlignmentSequences =\n\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stderr,"%c",Name[i][j]);
    }
    fprintf(stderr,":");
    for(j=0;j<Leng[0];j++){
      fprintf(stderr,"%c",CSeq[i][j]);
    }
    fprintf(stderr,"\n");
  }

  fprintf(stdout,"\nAlignmentSequences =\n\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng[0];j++){
      fprintf(stdout,"%c",CSeq[i][j]);
    }
    fprintf(stdout,"\n");
  }
}


random(id,count)
int *id,count;
{
  int rand();
  int ran,ran1,i;

  ran = rand() % (Num[R1]*2 - 3 - count);

  ran1 = id[ran];

  for(i=ran;i<Num[R1]*2 - 3 - count -1;i++) id[i] = id[i+1];

  return ran1;
}
