/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"

#define NAME_BUFF 30

char OSeq1[SEQNUM][MAXBUFF];
char OCSeq1[SEQNUM][MAXBUFF];

char Seq[SEQNUM][MAXBUFF];
char CSeq[SEQNUM][MAXBUFF];

char DSeq1[MAXBUFF];
char DCSeq1[MAXBUFF];
char DSeq2[SEQNUM][MAXBUFF];
char DCSeq2[SEQNUM][MAXBUFF];
/*
char *DSeq1,*DCSeq1,**DSeq2,**DCSeq2;
*/
int Leng;
int LengMax;
int Leng1[SEQNUM];
int SeqNum;

int makeEnergy1(),makeEnergy2();

int oldenergy,Step,M;

char Name[SEQNUM][NAME_BUFF];
int nameleng;

struct DATA0 d0;

main(argc,argv)
int argc;
char *argv[];
{
  FILE *fopen(),*fp_r;
  char Buff[261];
  int i;
/*
  d0.Cut = 97; 
  d0.U = 7; 
  d0.V = 1; 
  d0.S = 0;
*/  
  if(argc == 2) {
    fp_r = fopen(argv[1],"r");
    if(fp_r == NULL) {
      fprintf(stderr,"matrix file open error \n");
      exit(-1);
    }
    for(i=0;i<26;i++){
      if(fgets(Buff,260,fp_r) == NULL){
	fprintf(stderr,"matrix has only %d lines \n",i);
	exit(-1);
      }
      readMatrix(&Buff[0],260,i);
    }
    fclose(fp_r);
  } else {
    fprintf(stderr,"usage pia_t matrix file  < datafile\n");
    fflush(stderr);
    exit(1);
  }
  
  readFile();
  dp();
}


readFile()
{
  int i,j,num;
  char Buff[MAXBUFF+1];

  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Seq= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"Seq=",4) == 0) break;
    else {}
  }

  num = 0;
  nameleng = 0;
  LengMax = 0;
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\nEnd readSeq\n");
      break;
    }
    else if(readSeq(&Buff[0],&num) == 0) break;
    else {}
  }

  if(num==0){
    fprintf(stderr,"\n!!! Illegal Format. SequenceName: expected !!!\n");
    exit(1);
  }
  else SeqNum = num;

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. U,V,S= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"U,V,S=",6) == 0) {
      readGapCost(&Buff[6],MAXBUFF-6,&d0);
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Cut_ratio= or CutM= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"Cut_ratio=",10) == 0) {
      readCutRatio(&Buff[10],MAXBUFF-10,&d0);
      break;
    }
    else if(strncmp(Buff,"CutM=",5) == 0) {
      readCutRatio(&Buff[5],MAXBUFF-5,&d0);
      break;
    }
    else {}
  }

  fprintf(stderr,"\nEnd readFile\n");
}


readSeq(p,num)
char *p;
int *num;
{
  int  i,flag;

  i=0;
  for(;;){
    if(*p == '\n' || *p == '\0') {
      flag = 0;
      break;
    }
    else if(*p == ':') {
      if(nameleng < i) nameleng = i;
      
      while(i<NAME_BUFF){
	Name[*num][i] = ' ';
	i++;
      }

      p++;
      i = 0;
      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  CSeq[*num][i] = *p;
	  if(*p >= 'a' && *p <= 'z')  *p -= 'a';
	  else  *p -= 'A';
	  Seq[*num][i] = *p;
	  p++;
	  i++;
	}
      }
      
      if(i>LengMax) LengMax = i;

/*      Leng = i;*/
      Leng1[*num] = i;
      (*num)++;

      flag = 1;
      break;
    } 
    else {
      Name[*num][i] = *p;
      i++;
      p++;
    }
  }
  return flag;
}


dp()
{
  int i,j,k;

  for(i=0;i<SeqNum;i++){
    for(j=Leng1[i];j<LengMax;j++){
      CSeq[i][j] = '#';
      Seq[i][j] = '#' - 'A';
    }
  }
  Leng = LengMax;

  oldenergy = makeEnergy1();

  fprintf(stderr,"\nU = %d, V = %d, S = %d\n",d0.U,d0.V,d0.S);
  fprintf(stderr,"CutM = %d\n",d0.Cut);
  fprintf(stderr,"SeqNum = %d\n",SeqNum);
  fprintf(stderr,"Energy = %d\n\n",oldenergy);
  fflush(stderr);

  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng;j++){
      fprintf(stdout,"%c",CSeq[i][j]);
    }
    fprintf(stdout,"\n");
    fflush(stdout);
  }
  fflush(stdout);
  fprintf(stdout,"\nCutM = %d\n",d0.Cut);
  fprintf(stdout,"U = %d, V = %d, S = %d\n",d0.U,d0.V,d0.S);
  fprintf(stdout,"SeqNum = %d\n",SeqNum);
  fprintf(stdout,"Energy = %d\n",oldenergy);
  fprintf(stdout,"\n***** START *****\n\n");
  fflush(stdout);

  munson();
  fflush(stdout);

  makeAlignmentString();
  fprintf(stderr,"\nEnergy = %d\n",oldenergy);
  fprintf(stderr,"Step = %d\n",Step);
  fflush(stdout);

  fprintf(stdout,"\nEnergy = %d\n",oldenergy);
  fprintf(stdout,"Step = %d\n",Step);
  fprintf(stdout,"\n***** END *****\n\n");
  fflush(stdout);
}



munson()
{
  int i,j,k;
  int energy;

  d0.NumX = 1;
  d0.NumY = SeqNum - 1;

  for(i=0;i<SeqNum;i++){
    for(j=0;j<Leng;j++){
      OSeq1[i][j] = Seq[i][j];
      OCSeq1[i][j] = CSeq[i][j];
    }
  }

  d0.X = d0.Y = Leng;

  Step = 0;
  for(;;){
    Step++;
    for(M=0;M<SeqNum;M++){

      fprintf(stderr,"%d,",M+1);
      fflush(stderr);

      k = 0;
      while(OCSeq1[M][k] == '-'){
	DCSeq1[k] = '#';
	DSeq1[k] = OSeq1[M][k];
	k++;
      }
      while(k<d0.X){
	DCSeq1[k] = OCSeq1[M][k];
	DSeq1[k] = OSeq1[M][k];
	k++;
      }
      k--;
      while(OCSeq1[M][k] == '-'){
	DCSeq1[k] = '#';
	k--;
      }
      
      for(j=0;j<M;j++){
	k = 0;
	while(OCSeq1[j][k] == '-'){
	  DCSeq2[j][k] = '#';
	  DSeq2[j][k] = OSeq1[j][k];
	  k++;
	}
	while(k<d0.Y){
	  DCSeq2[j][k] = OCSeq1[j][k];
	  DSeq2[j][k] = OSeq1[j][k];
	  k++;
	}
	k--;
	while(OCSeq1[j][k] == '-'){
	  DCSeq2[j][k] = '#';
	  k--;
	}
      }
      for(j=M+1;j<SeqNum;j++){
	k = 0;
	while(OCSeq1[j][k] == '-'){
	  DCSeq2[j-1][k] = '#';
	  DSeq2[j-1][k] = OSeq1[j][k];
	  k++;
	}
	while(k<d0.Y){
	  DCSeq2[j-1][k] = OCSeq1[j][k];
	  DSeq2[j-1][k] = OSeq1[j][k];
	  k++;
	}
	k--;
	while(OCSeq1[j][k] == '-'){
	  DCSeq2[j-1][k] = '#';
	  k--;
	}
      }

      remove_allgap();
      
      generateD_00(&d0);
      
      makeAlignmentString2();
      
    }
    
    fprintf(stderr,"\n");

    energy = makeEnergy2();
      
    if(energy < oldenergy){
      oldenergy = energy;
      Leng = d0.X;
      fprintf(stderr,"Step = %d,Energy = %d\n",Step,oldenergy);
      fflush(stdout);
      fprintf(stdout,"Step = %d,Energy = %d\n",Step,oldenergy);
      fflush(stdout);
      for(i=0;i<SeqNum;i++){
	for(k=0;k<Leng;k++){
	  CSeq[i][k] = OCSeq1[i][k];
	  fprintf(stdout,"%c",CSeq[i][k]);
	  Seq[i][k] = OSeq1[i][k];
	}
	fprintf(stdout,"\n");
	fflush(stdout);
      }
      fprintf(stdout,"\n");
      fflush(stdout);
    }
    else break;
  }
}


remove_allgap()
{
  int i,j,k,k1;

  j = 0;
  for(i=0;i<d0.X;i++){
    if(DCSeq1[i] != '-' && DCSeq1[i] != '#'){
      d0.CSeq1[0][j] = DCSeq1[i];
      d0.Seq1[0][j] = DSeq1[i];
      j++;
    }
    else {}
  }
  d0.X = j;

  j = 0;
  for(i=0;i<d0.Y;i++){
    for(k=0;k<d0.NumY;k++){
      if(DCSeq2[k][i] != '-' && DCSeq2[k][i] != '#'){
	for(k1=0;k1<d0.NumY;k1++){
	  d0.CSeq2[k1][j] = DCSeq2[k1][i];
	  d0.Seq2[k1][j] = DSeq2[k1][i];
	}
	j++;
	break;
      }
      else {}
    }
  }
  d0.Y = j;
}



int makeEnergy2()
{
  int i,j,k,K;
  int energy=0;

  for(i=0;i<SeqNum;i++){
    j = 0;
    while(OCSeq1[i][j] == '-'){
      OCSeq1[i][j] = '#';
      j++;
    }
/*    j = Leng1[M]-1;*/
/*    j = Leng-1;*/
    j = d0.X - 1;
    while(OCSeq1[i][j] == '-'){
      OCSeq1[i][j] = '#';
      j--;
    }
  }

  for(i=0;i<SeqNum;i++){
    for(j=i+1;j<SeqNum;j++){
      for(k=0;k<d0.X;k++){
	if((OCSeq1[i][k] == '-' || OCSeq1[i][k] == '#') 
	   && (OCSeq1[j][k] == '-' || OCSeq1[j][k] == '#')) {}
	else if(OCSeq1[i][k] == '#' || OCSeq1[j][k] == '#') energy += d0.S;
	else if(OCSeq1[i][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(OCSeq1[i][K] != '-'){
	      energy += d0.U + d0.V;
	      break;
	    }
	    else if(OCSeq1[j][K] != '-'){
	      energy += d0.V;
	      break;
	    }
	    else {}
	  }
	}
	else if(OCSeq1[j][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(OCSeq1[j][K] != '-'){
	      energy += d0.U + d0.V;
	      break;
	    }
	    else if(OCSeq1[i][K] != '-'){
	      energy += d0.V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += Dmatrix[OSeq1[i][k]][OSeq1[j][k]];
	}
      }
    }
  }
  for(i=0;i<SeqNum;i++){
    j = 0;
    while(OCSeq1[i][j] == '#'){
      OCSeq1[i][j] = '-';
      j++;
    }
/*    j = Leng1[M]-1;*/
/*    j = Leng-1;*/
    j = d0.X - 1;
    while(OCSeq1[i][j] == '#'){
      OCSeq1[i][j] = '-';
      j--;
    }
  }

  return energy;
}



int makeEnergy1()
{
  int i,j,k,K;
  int energy=0;

  for(i=0;i<SeqNum;i++){
    j = 0;
    while(CSeq[i][j] == '-'){
      CSeq[i][j] = '#';
      j++;
    }
    j = Leng-1;
    while(CSeq[i][j] == '-'){
      CSeq[i][j] = '#';
      j--;
    }
  }

  for(i=0;i<SeqNum;i++){
    for(j=i+1;j<SeqNum;j++){
      for(k=0;k<Leng;k++){
	if((CSeq[i][k] == '-' || CSeq[i][k] == '#') 
	   && (CSeq[j][k] == '-' || CSeq[j][k] == '#')) {}
	else if(CSeq[i][k] == '#' || CSeq[j][k] == '#') energy += d0.S;
	else if(CSeq[i][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(CSeq[i][K] != '-'){
	      energy += d0.U + d0.V;
	      break;
	    }
	    else if(CSeq[j][K] != '-'){
	      energy += d0.V;
	      break;
	    }
	    else {}
	  }
	}
	else if(CSeq[j][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(CSeq[j][K] != '-'){
	      energy += d0.U + d0.V;
	      break;
	    }
	    else if(CSeq[i][K] != '-'){
	      energy += d0.V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += Dmatrix[Seq[i][k]][Seq[j][k]];
	}
      }
    }
  }
  for(i=0;i<SeqNum;i++){
    j = 0;
    while(CSeq[i][j] == '#'){
      CSeq[i][j] = '-';
      j++;
    }
    j = Leng-1;
    while(CSeq[i][j] == '#'){
      CSeq[i][j] = '-';
      j--;
    }
  }
  return energy;
}



makeAlignmentString2()
{
  int i,j,k,a,lim;
  char NextPath,c;

  i = 0;

  NextPath = d0.Path[d0.J][d0.I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<d0.NumX;k++){
	if(d0.CSeq1[k][d0.I-1] == '#' || d0.CSeq1[k][d0.I-1] == '-'){
	  OCSeq1[M][i] = '-';
	  OSeq1[M][i] = 1000;
	}
	else{
	  OCSeq1[M][i] = d0.CSeq1[k][d0.I-1];
	  OSeq1[M][i] = d0.Seq1[k][d0.I-1];
	}
      }
      for(k=0;k<M;k++){
	if(d0.CSeq2[k][d0.J-1] == '#' || d0.CSeq2[k][d0.J-1] == '-'){
	  OCSeq1[k][i] = '-';
	  OSeq1[k][i] = 1000;
	}
	else{
	  OCSeq1[k][i] = d0.CSeq2[k][d0.J-1];
	  OSeq1[k][i] = d0.Seq2[k][d0.J-1];
	}
      }
      for(k=M+1;k<SeqNum;k++){
	if(d0.CSeq2[k-1][d0.J-1] == '#' || d0.CSeq2[k-1][d0.J-1] == '-'){
	  OCSeq1[k][i] = '-';
	  OSeq1[k][i] = 1000;
	}
	else{
	  OCSeq1[k][i] = d0.CSeq2[k-1][d0.J-1];
	  OSeq1[k][i] = d0.Seq2[k-1][d0.J-1];
	}
      }
      d0.I--;
      d0.J--;
      NextPath = d0.Path[d0.J][d0.I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<d0.NumX;k++){ 
	if(d0.CSeq1[k][d0.I-1] == '#' || d0.CSeq1[k][d0.I-1] == '-'){
	  OCSeq1[M][i] = '-';
	  OSeq1[M][i] = 10000;
	}
	else{
	  OCSeq1[M][i] = d0.CSeq1[k][d0.I-1];
	  OSeq1[M][i] = d0.Seq1[k][d0.I-1];
	}
      }
      for(k=0;k<M;k++) {
	OCSeq1[k][i] = '-';
	OSeq1[k][i] = 10000;
      }
      for(k=M+1;k<SeqNum;k++) {
	OCSeq1[k][i] = '-';
	OSeq1[k][i] = 10000;
      }
      d0.I--;
      NextPath = d0.Path[d0.J][d0.I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<d0.NumX;k++){ 
	OCSeq1[M][i] = '-';
	OSeq1[M][i] = 10000;
      }
      for(k=0;k<M;k++){
	if(d0.CSeq2[k][d0.J-1] == '#' || d0.CSeq2[k][d0.J-1] == '-'){
	  OCSeq1[k][i] = '-';
	  OSeq1[k][i] = 10000;
	}
	else{
	  OCSeq1[k][i] = d0.CSeq2[k][d0.J-1];
	  OSeq1[k][i] = d0.Seq2[k][d0.J-1];
	}
      }
      for(k=M+1;k<SeqNum;k++){
	if(d0.CSeq2[k-1][d0.J-1] == '#' || d0.CSeq2[k-1][d0.J-1] == '-'){
	  OCSeq1[k][i] = '-';
	  OSeq1[k][i] = 10000;
	}
	else{
	  OCSeq1[k][i] = d0.CSeq2[k-1][d0.J-1];
	  OSeq1[k][i] = d0.Seq2[k-1][d0.J-1];
	}
      }
      d0.J--;
      NextPath = d0.Path[d0.J][d0.I].y;
    }
    else {
      fprintf(stderr,"makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(d0.I == 0 && d0.J == 0) break;

  }

/*  Leng1[M] = i;*/
/*  Leng = i;*/
  d0.X = d0.Y = i;

  lim = d0.X / 2;
  for(k=0;k<SeqNum;k++){
    j = 0;
    i = d0.X - 1;
    for(a=0;a<lim;a++){
      c = OCSeq1[k][j];
      OCSeq1[k][j] = OCSeq1[k][i];
      OCSeq1[k][i] = c;
      c = OSeq1[k][j];
      OSeq1[k][j] = OSeq1[k][i];
      OSeq1[k][i] = c;
      j++;
      i--;
    }
  }
}



makeAlignmentString()
{
  int i,j;

  fprintf(stderr,"\nAlignmentSequences =\n\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stderr,"%c",Name[i][j]);
    }
    fprintf(stderr,":");
    for(j=0;j<Leng;j++){
      fprintf(stderr,"%c",CSeq[i][j]);
    }
    fprintf(stderr,"\n");
  }

  fprintf(stdout,"\nAlignmentSequences =\n\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng;j++){
      fprintf(stdout,"%c",CSeq[i][j]);
    }
    fprintf(stdout,"\n");
  }
}
