/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"

#define NAME_BUFF 30

char Name1[SEQNUM][NAME_BUFF];
char Name2[SEQNUM][NAME_BUFF];
int nameleng;

char DSeq1[SEQNUM][MAXBUFF];
char DCSeq1[SEQNUM][MAXBUFF];
char DSeq2[SEQNUM][MAXBUFF];
char DCSeq2[SEQNUM][MAXBUFF];
char ASeq1[SEQNUM][MAXBUFF];
char ASeq2[SEQNUM][MAXBUFF];

struct DATA0 d0;

main(argc,argv)
int argc;
char *argv[];
{
  FILE *fopen(),*fp_r;
  char Buff[261];
  int i;
/*
  d0.Cut = 80; 
  d0.U = 7; 
  d0.V = 1; 
  d0.S = 0;
*/  
  if(argc == 2) {
    fp_r = fopen(argv[1],"r");
    if(fp_r == NULL) {
      fprintf(stderr,"matrix file open error \n");
      exit(-1);
    }
    for(i=0;i<26;i++){
      if(fgets(Buff,260,fp_r) == NULL){
	fprintf(stderr,"matrix has only %d lines \n",i);
	exit(-1);
      }
      readMatrix(&Buff[0],260,i);
    }
    fclose(fp_r);
  }else {
    fprintf(stderr,"usage gdp matrix file  < datafile\n");
    fflush(stderr);
    exit(1);
  }

  readFile();
  dp();
}


readFile()
/* struct DATA0 *d0; */
{
  char Buff[MAXBUFF+1];
  int i,j,num;

  d0.X = 0;
  d0.Y = 0;
/*
  d0->X = 0;
  d0->Y = 0;
*/
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Seq1= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"Seq1=",5) == 0) break;
    else {}
  }

  nameleng=0;
  num = 0;
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\nEnd readSeq1\n"); 
      break;
    }
    else if(readSeq1(&Buff[0],&num) == 0) break;
    else {}
  }

  if(num==0){
    fprintf(stderr,"\n!!! Illegal Format. SequenceName: expected !!!\n");
    exit(1);
  }
  else {
    d0.NumX = num;
/*    d0->NumX = num; */
  }


  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Seq2= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"Seq2=",5) == 0) break;
    else {}
  }

  num = 0;
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\nEnd readSeq2\n");
      break;
    }
    else if(readSeq2(&Buff[0],&num) == 0) break;
    else {}
  }

  if(num==0){
    fprintf(stderr,"\n!!! Illegal Format. SequenceName: expected !!!\n");
    exit(1);
  }
  else {

    d0.NumY = num;

/*    d0->NumY = num; */
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. U,V,S= expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"U,V,S=",6) == 0){
      readGapCost(&Buff[6],MAXBUFF-6,&d0);
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Cut_ratio=  expected !!!\n");
      exit(1);
    }
    else if(strncmp(Buff,"Cut_ratio=",10) == 0){
      readCutRatio(&Buff[10],MAXBUFF-10,&d0);
      break;
    } 
    else {}
  }

  fprintf(stderr,"\nEnd readFile\n");
}


int readSeq1(p,num)
char *p;
int *num;
{
  int  i,flag;

  i=0;
  for(;;){
    if(*p == '\n' || *p == '\0') {
      flag = 0;
      break;
    }
    else if(*p == ':') {
      if(nameleng < i) nameleng = i;
      
      while(i<NAME_BUFF){
	Name1[*num][i] = ' ';
	i++;
      }

      p++;
      i = 0;
      while(*p == ' ' || *p == '\t' || *p == '-'){
	if(*p == ' ' || *p == '\t')  p++;
	else {
	  DCSeq1[*num][i] = '#';
	  DSeq1[*num][i] = '#';
	  p++;
	  i++;
	}
      }

      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  DCSeq1[*num][i] = *p;
	  if(*p >= 'a' && *p <= 'z')  *p -= 'a';
	  else  *p -= 'A';
	  DSeq1[*num][i] = *p;
	  p++;
	  i++;
	}
      }
      
      d0.X = i;
      i--;
      while(DCSeq1[*num][i] == '-'){
	DCSeq1[*num][i] = '#';
	DSeq1[*num][i] = '#';
	i--;
      }

      (*num)++;
      flag = 1;
      break;
    } 
    else {
      Name1[*num][i] = *p;
      i++;
      p++;
    }
  }
  return flag;
}


int readSeq2(p,num)
char *p;
int *num;
{
  int  i,flag;

  i=0;
  for(;;){
    if(*p == '\n' || *p == '\0') {
      flag = 0;
      break;
    }
    else if(*p == ':') {
      if(nameleng < i) nameleng = i;
      
      while(i<NAME_BUFF){
	Name2[*num][i] = ' ';
	i++;
      }

      p++;
      i = 0;
      while(*p == ' ' || *p == '\t' || *p == '-'){
	if(*p == ' ' || *p == '\t')  p++;
	else {
	  DCSeq2[*num][i] = '#';
	  DSeq2[*num][i] = '#';
	  p++;
	  i++;
	}
      }

      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  DCSeq2[*num][i] = *p;
	  if(*p >= 'a' && *p <= 'z')  *p -= 'a';
	  else  *p -= 'A';
	  DSeq2[*num][i] = *p;
	  p++;
	  i++;
	}
      }
      
      d0.Y = i;
      i--;
      while(DCSeq2[*num][i] == '-'){
	DCSeq2[*num][i] = '#';
	DSeq2[*num][i] = '#';
	i--;
      }

      (*num)++;
      flag = 1;
      break;
    } 
    else {
      Name2[*num][i] = *p;
      i++;
      p++;
    }
  }
  return flag;
}


dp()
{
  int i,j;

  remove_allgap();
/*
  for(i=0;i<d0.NumX;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stderr,"%c",Name1[i][j]);
    }
    fprintf(stderr,":");
    for(j=0;j<d0.X;j++){
      fprintf(stderr,"%c",d0.CSeq1[i][j]);
    }
    fprintf(stderr,"\n");
  }
  fprintf(stderr,"\n");
  for(i=0;i<d0.NumY;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stderr,"%c",Name2[i][j]);
    }
    fprintf(stderr,":");
    for(j=0;j<d0.Y;j++){
      fprintf(stderr,"%c",d0.CSeq2[i][j]);
    }
    fprintf(stderr,"\n");
  }
  fprintf(stderr,"\n");
  fflush(stderr);
*/
  for(i=0;i<d0.NumX;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name1[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<d0.X;j++){
      fprintf(stdout,"%c",d0.CSeq1[i][j]);
    }
    fprintf(stdout,"\n");
  }
  fprintf(stdout,"\n");
  for(i=0;i<d0.NumY;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name2[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<d0.Y;j++){
      fprintf(stdout,"%c",d0.CSeq2[i][j]);
    }
    fprintf(stdout,"\n");
  }
  fprintf(stdout,"\n");
  fflush(stdout);


  generateD_00(&d0);
  i = d0.I;
  j = d0.J;

  makeAlignmentString();

  if(j % 2 == 0) fprintf(stderr,"\nBestCost = %d\n",d0.Vec0[i].xy);
  if(j % 2 == 1) fprintf(stderr,"\nBestCost = %d\n",d0.Vec1[i].xy);
  fprintf(stderr,"U,V,S=%d,%d,%d\n",d0.U,d0.V,d0.S);
  fprintf(stderr,"Cut_ratio=%d\n",d0.Cut);
  fflush(stderr);

  if(j % 2 == 0) fprintf(stdout,"BestCost = %d\n",d0.Vec0[i].xy);
  if(j % 2 == 1) fprintf(stdout,"BestCost = %d\n",d0.Vec1[i].xy);
  fprintf(stdout,"U,V,S=%d,%d,%d\n",d0.U,d0.V,d0.S);
  fprintf(stdout,"Cut_ratio=%d\n",d0.Cut);
  fprintf(stdout,"\n***** END *****\n\n");
  fflush(stdout);
}


remove_allgap()
{
  int i,j,k,k1;

  j = 0;
  for(i=0;i<d0.X;i++){
    for(k=0;k<d0.NumX;k++){
      if(DCSeq1[k][i] != '-' && DCSeq1[k][i] != '#'){
	for(k1=0;k1<d0.NumX;k1++){
	  d0.CSeq1[k1][j] = DCSeq1[k1][i];
	  d0.Seq1[k1][j] = DSeq1[k1][i];
	}
	j++;
	break;
      }
      else {}
    }
  }
  d0.X = j;

  j = 0;
  for(i=0;i<d0.Y;i++){
    for(k=0;k<d0.NumY;k++){
      if(DCSeq2[k][i] != '-' && DCSeq2[k][i] != '#'){
	for(k1=0;k1<d0.NumY;k1++){
	  d0.CSeq2[k1][j] = DCSeq2[k1][i];
	  d0.Seq2[k1][j] = DSeq2[k1][i];
	}
	j++;
	break;
      }
      else {}
    }
  }
  d0.Y = j;
}


makeAlignmentString()
{
  int i,j,k;
  int NextPath;

  i = 0;

  NextPath = d0.Path[d0.J][d0.I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<d0.NumX;k++){
	if(d0.CSeq1[k][d0.I-1] == '#') ASeq1[k][i] = '-';
	else ASeq1[k][i] = d0.CSeq1[k][d0.I-1];
      }
      for(k=0;k<d0.NumY;k++){
	if(d0.CSeq2[k][d0.J-1] == '#') ASeq2[k][i] = '-';
	else ASeq2[k][i] = d0.CSeq2[k][d0.J-1];
      }
      d0.I--;
      d0.J--;
      NextPath = d0.Path[d0.J][d0.I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<d0.NumX;k++){ 
	if(d0.CSeq1[k][d0.I-1] == '#') ASeq1[k][i] = '-';
	else ASeq1[k][i] = d0.CSeq1[k][d0.I-1];
      }
      for(k=0;k<d0.NumY;k++) ASeq2[k][i] = '-';
      d0.I--;
      NextPath = d0.Path[d0.J][d0.I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<d0.NumX;k++) ASeq1[k][i] = '-';
      for(k=0;k<d0.NumY;k++){
	if(d0.CSeq2[k][d0.J-1] == '#') ASeq2[k][i] = '-';
	else ASeq2[k][i] = d0.CSeq2[k][d0.J-1];
      }
      d0.J--;
      NextPath = d0.Path[d0.J][d0.I].y;
    }
    else {
      fprintf(stderr,"makeAlignmentString error\n");
      exit(1);
    }

    if(d0.I == 0 && d0.J == 0) break;

    i++;
  }

  fprintf(stderr,"Seq1 =\n");
  for(k=0;k<d0.NumX;k++){
    for(j=0;j<nameleng;j++){
      fprintf(stderr,"%c",Name1[k][j]);
    }
    fprintf(stderr,":");
    for(j = i;j > -1;j--){
      fprintf(stderr,"%c",ASeq1[k][j]);
    }
    fprintf(stderr,"\n");
  }
  
  fprintf(stderr,"Seq2 =\n");
  for(k=0;k<d0.NumY;k++){
    for(j=0;j<nameleng;j++){
      fprintf(stderr,"%c",Name2[k][j]);
    }
    fprintf(stderr,":");
    for(j = i;j > -1;j--){
      fprintf(stderr,"%c",ASeq2[k][j]);
    }
    fprintf(stderr,"\n");
  }

  fprintf(stdout,"Seq1 =\n");
  for(k=0;k<d0.NumX;k++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name1[k][j]);
    }
    fprintf(stdout,":");
    for(j = i;j > -1;j--){
      fprintf(stdout,"%c",ASeq1[k][j]);
    }
    fprintf(stdout,"\n");
  }
  
  fprintf(stdout,"Seq2 =\n");
  for(k=0;k<d0.NumY;k++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name2[k][j]);
    }
    fprintf(stdout,":");
    for(j = i;j > -1;j--){
      fprintf(stdout,"%c",ASeq2[k][j]);
    }
    fprintf(stdout,"\n");
  }
  fprintf(stdout,"\n");
}

