/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"

double atof();
char *read_num();
char *read_num_end();

readGapCost(p,leng,d0)
char *p;
int  leng;
struct DATA0 *d0;
{
  char  *rp;
  int   u,v,s,fg=0;

  rp = read_num(',',p,leng,&u,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readGapCost U\n");
    exit(1);
  }
  leng -= rp - p;  p = rp;
  rp = read_num(',',p,leng,&v,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readGapCost V\n");
    exit(1);
  }
  leng -= rp - p;  p = rp;
  rp = read_num_end('\n',p,leng,&s,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readGapCost S\n");
    exit(1);
  }

  d0->U = u;
  d0->V = v;
  d0->S = s;

}


readCutRatio(p,leng,d0)
char *p;
int  leng;
struct DATA0 *d0;
{
  char  *rp;
  int   cut,fg=0;

  rp = read_num_end('\n',p,leng,&cut,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readCutRatio\n");
    exit(1);
  }

  d0->Cut = cut;

}


readMatrix(p,leng,num)
char *p;
int  leng,num;
{
  char  *rp;
  int   a,i,fg=0;

  for(i=0;i<25;i++){
    rp = read_num(',',p,leng,&a,&fg);
    if(fg == 1){
      fprintf(stderr,"matrix file error at %d line %d colum\n",num,i);
      exit(1);
    }
    leng -= rp - p;  p = rp;
    Dmatrix[num][i] = a;
  }
  rp = read_num_end('\n',p,leng,&a,&fg);
  if(fg == 1){
    fprintf(stderr,"matrix file error at %d line %d colum\n",num,i);
    exit(1);
  }
  leng -= rp - p;  p = rp;
  Dmatrix[num][i] = a;
}


char *read_num(c,p,leng,num,fg)
int c;
char *p;
int leng;
int *num,*fg;
{
  int  i,k = 0;
  char dest[10];

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else if(*p == (char)c && k == 0){
      fprintf(stderr,"Illegal Format. Number is expected\n");
      *fg = 1;
      goto label0;
    }
    else if(*p == (char)c){
      p++;
      break;
    }
    else{
      fprintf(stderr,"Illegal Format. Number or %c expected\n",c);
      *fg = 1;
      goto label0;
    }
  }

    dest[k] = 0;
    *num = (int)atof(dest);

    if(i>=leng){
      fprintf(stderr,"Illegal Format at read_num");
      *fg = 1;
      goto label0;
    }

 label0:
  return  p;
}


char *read_num_end(c,p,leng,num,fg)
int c;
char *p;
int leng;
int *num,*fg;
{
  int  i,k = 0;
  char dest[10];

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else if(*p == (char)c && k == 0){
      fprintf(stderr,"Illegal Format. Number is expected\n");
      *fg = 1;
      goto label0;
    }
    else if(*p == (char)c || *p == '\0'){
      p++;
      break;
    }
    else{
      fprintf(stderr,"Illegal Format. Number or %c expected\n",c);
      *fg = 1;
      goto label0;
    }
  }

    dest[k] = 0;
    *num = (int)atof(dest);

    if(i>=leng){
      fprintf(stderr,"Illegal Format at read_num");
      *fg = 1;
      goto label0;
    }

 label0:
  return  p;
}

