/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp.h"

int  outgapcost_I(),outgapcost_J();
int  paircost_IJ_F(),paircost_IJ_DXY(),paircost_IJ_DX(),paircost_IJ_DY();
int  gapcost_I_DXY(),gapcost_I_DX(),gapcost_I_DY();
int  gapcost_J_DXY(),gapcost_J_DX(),gapcost_J_DY();

int  gapcost_v_I_DXY(),gapcost_v_I_DX(),gapcost_v_I_DY();
int  gapcost_v_J_DXY(),gapcost_v_J_DX(),gapcost_v_J_DY();

int  minimum_X(),minimum_XY(),minimum_Y();
int  minimum1_X(),minimum1_XY(),minimum1_Y();
int  minimum2_X(),minimum2_XY(),minimum2_Y();


/*
 *   dist_00,dist_I0,dist_0J,dist_IJ
 *
 * /

/***** dist_00 *****/
dist_00(d0)
struct DATA0 *d0;
{
  d0->Vec0[d0->I].x = outgapcost_I(d0);
  d0->Vec0[d0->I].xy = paircost_IJ_F(d0);
  d0->Vec0[d0->I].y = outgapcost_J(d0);

  d0->Path[d0->J][d0->I].x = 's'; 
  d0->Path[d0->J][d0->I].xy = 's'; 
  d0->Path[d0->J][d0->I].y = 's'; 

  /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	 d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	 d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
}


dist_00_Cut_1(d0)
struct DATA0 *d0;
{
  d0->Vec0[d0->I].x = 'n';
  d0->Vec0[d0->I].xy = paircost_IJ_F(d0);
  d0->Vec0[d0->I].y = outgapcost_J(d0);

  d0->Path[d0->J][d0->I].x = 'n';
  d0->Path[d0->J][d0->I].xy = 's'; 
  d0->Path[d0->J][d0->I].y = 's'; 

  /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	 d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	 d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
}


dist_00_Cut_2(d0)
struct DATA0 *d0;
{
  d0->Vec0[d0->I].x = outgapcost_I(d0);
  d0->Vec0[d0->I].xy = paircost_IJ_F(d0);
  d0->Vec0[d0->I].y = 'n';

  d0->Path[d0->J][d0->I].x = 's'; 
  d0->Path[d0->J][d0->I].xy = 's'; 
  d0->Path[d0->J][d0->I].y = 'n';

  /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	 d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	 d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
}


dist_00_II(d0)
struct DATA0 *d0;
{
  d0->Vec0[d0->I].x = 'n';
  d0->Vec0[d0->I].xy = paircost_IJ_F(d0);
  d0->Vec0[d0->I].y = 'n';

  d0->Path[d0->J][d0->I].x = 'n'; 
  d0->Path[d0->J][d0->I].xy = 's'; 
  d0->Path[d0->J][d0->I].y = 'n'; 

  /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	 d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	 d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
}


/***** dist_II *****/
dist_II(d0)
struct DATA0 *d0;
{
  int CostXY;

  d0->Path[d0->J][d0->I].x = 'n'; 
  d0->Path[d0->J][d0->I].xy = 'z';
  d0->Path[d0->J][d0->I].y = 'n';

  if( d0->J % 2 == 0 ){
    CostXY = d0->Vec1[d0->I-1].xy;
    d0->Vec0[d0->I].x = 'n';
    d0->Vec0[d0->I].xy = CostXY + paircost_IJ_DXY(d0);
    d0->Vec0[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if( d0->J % 2 == 1 ){
    CostXY = d0->Vec0[d0->I-1].xy;
    d0->Vec1[d0->I].x = 'n';
    d0->Vec1[d0->I].xy = CostXY + paircost_IJ_DXY(d0);
    d0->Vec1[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


dist_XX(d0)
struct DATA0 *d0;
{
  int CostXY;

  d0->Path[d0->J][d0->I].x = 'n';
  d0->Path[d0->J][d0->I].xy = 'z';
  d0->Path[d0->J][d0->I].y = 'n';

  if( d0->J % 2 == 0 ){
    CostXY = d0->Vec1[d0->I-1].xy;
    d0->Vec0[d0->I].x = 'n';
    d0->Vec0[d0->I].xy = CostXY;
    d0->Vec0[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if( d0->J % 2 == 1 ){
    CostXY = d0->Vec0[d0->I-1].xy;
    d0->Vec1[d0->I].x = 'n';
    d0->Vec1[d0->I].xy = CostXY;
    d0->Vec1[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


/***** dist_I0 *****/
dist_I0(d0)
struct DATA0 *d0;
{
  int CostX;

  CostX = d0->Vec0[d0->I-1].x;
  d0->Vec0[d0->I].x = CostX + outgapcost_I(d0);
  d0->Vec0[d0->I].xy = CostX + paircost_IJ_DX(d0);
  d0->Vec0[d0->I].y = CostX + gapcost_J_DX(d0);

  d0->Path[d0->J][d0->I].x = 'x'; 
  d0->Path[d0->J][d0->I].xy = 'x';
  d0->Path[d0->J][d0->I].y = 'x';

  /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	 d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	 d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
}


dist_I0_Cut(d0)
struct DATA0 *d0;
{
  int CostX;

  CostX = d0->Vec0[d0->I-1].x;
  d0->Vec0[d0->I].x = 'n';
  d0->Vec0[d0->I].xy = CostX + paircost_IJ_DX(d0);
  d0->Vec0[d0->I].y = CostX + gapcost_J_DX(d0);

  d0->Path[d0->J][d0->I].x = 'n';
  d0->Path[d0->J][d0->I].xy = 'x';
  d0->Path[d0->J][d0->I].y = 'x';

  /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	 d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	 d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
}


dist_X0(d0)
struct DATA0 *d0;
{
  int CostX;

  CostX = d0->Vec0[d0->I-1].x;
  d0->Vec0[d0->I].x = 'n';
  d0->Vec0[d0->I].xy = 'n';
  d0->Vec0[d0->I].y = CostX + outgapcost_J(d0);

  d0->Path[d0->J][d0->I].x = 'n';
  d0->Path[d0->J][d0->I].xy = 'n';
  d0->Path[d0->J][d0->I].y = 'x';

  /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	 d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	 d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
}


/***** dist_0J *****/
dist_0J(d0)
struct DATA0 *d0;
{
  int CostY;

  d0->Path[d0->J][d0->I].x = 'y';
  d0->Path[d0->J][d0->I].xy = 'y';
  d0->Path[d0->J][d0->I].y = 'y';

  if(d0->J % 2 == 0){
    CostY = d0->Vec1[d0->I].y;
    d0->Vec0[d0->I].x = CostY + gapcost_I_DY(d0);
    d0->Vec0[d0->I].xy = CostY + paircost_IJ_DY(d0);
    d0->Vec0[d0->I].y = CostY + outgapcost_J(d0);

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if(d0->J % 2 == 1){
    CostY = d0->Vec0[d0->I].y;
    d0->Vec1[d0->I].x = CostY + gapcost_I_DY(d0);
    d0->Vec1[d0->I].xy = CostY + paircost_IJ_DY(d0);
    d0->Vec1[d0->I].y = CostY + outgapcost_J(d0);

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


dist_0J_Cut(d0)
struct DATA0 *d0;
{
  int CostY;

  d0->Path[d0->J][d0->I].x = 'y';
  d0->Path[d0->J][d0->I].xy = 'y';
  d0->Path[d0->J][d0->I].y = 'n';

  if(d0->J % 2 == 0){
    CostY = d0->Vec1[d0->I].y;
    d0->Vec0[d0->I].x = CostY + gapcost_I_DY(d0);
    d0->Vec0[d0->I].xy = CostY + paircost_IJ_DY(d0);
    d0->Vec0[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if(d0->J % 2 == 1){
    CostY = d0->Vec0[d0->I].y;
    d0->Vec1[d0->I].x = CostY + gapcost_I_DY(d0);
    d0->Vec1[d0->I].xy = CostY + paircost_IJ_DY(d0);
    d0->Vec1[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


dist_0Y(d0)
struct DATA0 *d0;
{
  int CostY;

  d0->Path[d0->J][d0->I].x = 'y';
  d0->Path[d0->J][d0->I].xy = 'n';
  d0->Path[d0->J][d0->I].y = 'n';

  if(d0->J % 2 == 0){
    CostY = d0->Vec1[d0->I].y;
    d0->Vec0[d0->I].x = CostY + outgapcost_I(d0);
    d0->Vec0[d0->I].xy = 'n';
    d0->Vec0[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if(d0->J % 2 == 1){
    CostY = d0->Vec0[d0->I].y;
    d0->Vec1[d0->I].x = CostY + outgapcost_I(d0);
    d0->Vec1[d0->I].xy = 'n';
    d0->Vec1[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


/***** dist_IJ *****/
dist_IJ(d0)
struct DATA0 *d0;
{
  int CostX,CostXY,CostY;

  if(d0->J % 2 == 0){
    CostX = d0->Vec0[d0->I-1].x;
    CostXY = d0->Vec1[d0->I-1].xy;
    CostY = d0->Vec1[d0->I].y;
    
    d0->Vec0[d0->I].x = minimum_X(d0,CostX+gapcost_I_DX(d0),
                            CostXY+gapcost_I_DXY(d0),
			    CostY+gapcost_I_DY(d0)
			    );
    d0->Vec0[d0->I].xy = minimum_XY(d0,CostX+paircost_IJ_DX(d0),
			      CostXY+paircost_IJ_DXY(d0),
			      CostY+paircost_IJ_DY(d0)
			      );
    d0->Vec0[d0->I].y = minimum_Y(d0,CostX+gapcost_J_DX(d0),
			    CostXY+gapcost_J_DXY(d0),
			    CostY+gapcost_J_DY(d0)
			    );

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if(d0->J % 2 == 1){
    CostX = d0->Vec1[d0->I-1].x;
    CostXY = d0->Vec0[d0->I-1].xy;
    CostY = d0->Vec0[d0->I].y;
    
    d0->Vec1[d0->I].x = minimum_X(d0,CostX+gapcost_I_DX(d0),
                            CostXY+gapcost_I_DXY(d0),
			    CostY+gapcost_I_DY(d0)
			    );
    d0->Vec1[d0->I].xy = minimum_XY(d0,CostX+paircost_IJ_DX(d0),
			      CostXY+paircost_IJ_DXY(d0),
			      CostY+paircost_IJ_DY(d0)
			      );
    d0->Vec1[d0->I].y = minimum_Y(d0,CostX+gapcost_J_DX(d0),
			    CostXY+gapcost_J_DXY(d0),
			    CostY+gapcost_J_DY(d0)
			    );

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


dist_XJ(d0)
struct DATA0 *d0;
{
  int CostX,CostXY,CostY,CostR;
  
  d0->Path[d0->J][d0->I].x = 'n';
  d0->Path[d0->J][d0->I].xy = 'n';

  if(d0->J % 2 == 0){
    CostX = d0->Vec0[d0->I-1].x;
    CostXY = d0->Vec1[d0->I-1].xy;
    CostY = d0->Vec1[d0->I].y;
    
    CostR = minimum_Y(d0,CostX,CostXY,CostY);
    d0->Vec0[d0->I].xy = 'n';
    d0->Vec0[d0->I].x = 'n';
    d0->Vec0[d0->I].y = CostR + outgapcost_J(d0);

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if(d0->J % 2 == 1){
    CostX = d0->Vec1[d0->I-1].x;
    CostXY = d0->Vec0[d0->I-1].xy;
    CostY = d0->Vec0[d0->I].y;
    
    CostR = minimum_Y(d0,CostX,CostXY,CostY);
    d0->Vec1[d0->I].xy = 'n';
    d0->Vec1[d0->I].x = 'n';
    d0->Vec1[d0->I].y = CostR + outgapcost_J(d0);

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


dist_IY(d0)
struct DATA0 *d0;
{
  int CostX,CostXY,CostY,CostR;

  d0->Path[d0->J][d0->I].xy = 'n';
  d0->Path[d0->J][d0->I].y = 'n';

  if(d0->J % 2 == 0){
    CostX = d0->Vec0[d0->I-1].x;
    CostXY = d0->Vec1[d0->I-1].xy;
    CostY = d0->Vec1[d0->I].y;
    
    CostR = minimum_X(d0,CostX,CostXY,CostY);
    d0->Vec0[d0->I].xy = 'n';
    d0->Vec0[d0->I].x = CostR + outgapcost_I(d0);
    d0->Vec0[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if(d0->J % 2 == 1){
    CostX = d0->Vec1[d0->I-1].x;
    CostXY = d0->Vec0[d0->I-1].xy;
    CostY = d0->Vec0[d0->I].y;
    
    CostR = minimum_X(d0,CostX,CostXY,CostY);
    d0->Vec1[d0->I].xy = 'n';
    d0->Vec1[d0->I].x = CostR + outgapcost_I(d0);
    d0->Vec1[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


dist_XY(d0)
struct DATA0 *d0;
{
  int CostX,CostXY,CostY,CostR;

  d0->Path[d0->J][d0->I].x = 'n';
  d0->Path[d0->J][d0->I].y = 'n';

  if(d0->J % 2 == 0){
    CostX = d0->Vec0[d0->I-1].x;
    CostXY = d0->Vec1[d0->I-1].xy;
    CostY = d0->Vec1[d0->I].y;
    
    CostR = minimum_XY(d0,CostX,CostXY,CostY);
    d0->Vec0[d0->I].xy = CostR;
    d0->Vec0[d0->I].x = 'n';
    d0->Vec0[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if(d0->J % 2 == 1){
    CostX = d0->Vec1[d0->I-1].x;
    CostXY = d0->Vec0[d0->I-1].xy;
    CostY = d0->Vec0[d0->I].y;
    
    CostR = minimum_XY(d0,CostX,CostXY,CostY);
    d0->Vec1[d0->I].xy = CostR;
    d0->Vec1[d0->I].x = 'n';
    d0->Vec1[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


/***** dist_IJ_1 *****/
dist_IJ_1(d0)
struct DATA0 *d0;
{
  int CostX,CostXY;

  d0->Path[d0->J][d0->I].x = 'n';

  if(d0->J % 2 == 0){
    CostX = d0->Vec0[d0->I-1].x;
    CostXY = d0->Vec1[d0->I-1].xy;
    
    d0->Vec0[d0->I].x = 'n';
    d0->Vec0[d0->I].xy = minimum1_XY(d0,CostX+paircost_IJ_DX(d0),
			       CostXY+paircost_IJ_DXY(d0)
			       );
    d0->Vec0[d0->I].y = minimum1_Y(d0,CostX+gapcost_J_DX(d0),
			     CostXY+gapcost_J_DXY(d0)
			     );

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if(d0->J % 2 == 1){
    CostX = d0->Vec1[d0->I-1].x;
    CostXY = d0->Vec0[d0->I-1].xy;
    
    d0->Vec1[d0->I].x = 'n';
    d0->Vec1[d0->I].xy = minimum1_XY(d0,CostX+paircost_IJ_DX(d0),
			       CostXY+paircost_IJ_DXY(d0)
			       );
    d0->Vec1[d0->I].y = minimum1_Y(d0,CostX+gapcost_J_DX(d0),
			     CostXY+gapcost_J_DXY(d0)
			     );

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


dist_XJ_1(d0)
struct DATA0 *d0;
{
  int CostX,CostXY,CostR;

  d0->Path[d0->J][d0->I].xy = 'n';
  d0->Path[d0->J][d0->I].x = 'n';

  if(d0->J % 2 == 0){
    CostX = d0->Vec0[d0->I-1].x;
    CostXY = d0->Vec1[d0->I-1].xy;
    
    CostR = minimum1_Y(d0,CostX,CostXY);
    d0->Vec0[d0->I].xy = 'n';
    d0->Vec0[d0->I].x = 'n';
    d0->Vec0[d0->I].y = CostR + outgapcost_J(d0);

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if(d0->J % 2 == 1){
    CostX = d0->Vec1[d0->I-1].x;
    CostXY = d0->Vec0[d0->I-1].xy;
    
    CostR = minimum1_Y(d0,CostX,CostXY);
    d0->Vec1[d0->I].xy = 'n';
    d0->Vec1[d0->I].x = 'n';
    d0->Vec1[d0->I].y = CostR + outgapcost_J(d0);

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


dist_XY_1(d0)
struct DATA0 *d0;
{
  int CostX,CostXY,CostR;

  d0->Path[d0->J][d0->I].x = 'n';
  d0->Path[d0->J][d0->I].y = 'n';

  if(d0->J % 2 == 0){
    CostX = d0->Vec0[d0->I-1].x;
    CostXY = d0->Vec1[d0->I-1].xy;
    
    CostR = minimum1_XY(d0,CostX,CostXY);
    d0->Vec0[d0->I].xy = CostR;
    d0->Vec0[d0->I].x = 'n';
    d0->Vec0[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if(d0->J % 2 == 1){
    CostX = d0->Vec1[d0->I-1].x;
    CostXY = d0->Vec0[d0->I-1].xy;
    
    CostR = minimum1_XY(d0,CostX,CostXY);
    d0->Vec1[d0->I].xy = CostR;
    d0->Vec1[d0->I].x = 'n';
    d0->Vec1[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


/***** dist_IJ_2 *****/
dist_IJ_2(d0)
struct DATA0 *d0;
{
  int CostXY,CostY,CostR;

  d0->Path[d0->J][d0->I].y = 'n';

  if(d0->J % 2 == 0){
    CostXY = d0->Vec1[d0->I-1].xy;
    CostY = d0->Vec1[d0->I].y;
    
    d0->Vec0[d0->I].x = minimum2_X(d0,CostXY+gapcost_I_DXY(d0),
			     CostY+gapcost_I_DY(d0)
			     );
    d0->Vec0[d0->I].xy = minimum2_XY(d0,CostXY+paircost_IJ_DXY(d0),
			       CostY+paircost_IJ_DY(d0)
			       );
    d0->Vec0[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if(d0->J % 2 == 1){
    CostXY = d0->Vec0[d0->I-1].xy;
    CostY = d0->Vec0[d0->I].y;
    
    d0->Vec1[d0->I].x = minimum2_X(d0,CostXY+gapcost_I_DXY(d0),
			     CostY+gapcost_I_DY(d0)
			     );
    d0->Vec1[d0->I].xy = minimum2_XY(d0,CostXY+paircost_IJ_DXY(d0),
			       CostY+paircost_IJ_DY(d0)
			       );
    d0->Vec1[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


dist_IY_2(d0)
struct DATA0 *d0;
{
  int CostXY,CostY,CostR;

  d0->Path[d0->J][d0->I].xy = 'n';
  d0->Path[d0->J][d0->I].y = 'n';

  if(d0->J % 2 == 0){
    CostXY = d0->Vec1[d0->I-1].xy;
    CostY = d0->Vec1[d0->I].y;
    
    CostR = minimum2_X(d0,CostXY,CostY);
    d0->Vec0[d0->I].xy = 'n';
    d0->Vec0[d0->I].x = CostR + outgapcost_I(d0);
    d0->Vec0[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if(d0->J % 2 == 1){
    CostXY = d0->Vec0[d0->I-1].xy;
    CostY = d0->Vec0[d0->I].y;
    
    CostR = minimum2_X(d0,CostXY,CostY);
    d0->Vec1[d0->I].xy = 'n';
    d0->Vec1[d0->I].x = CostR + outgapcost_I(d0);
    d0->Vec1[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


dist_XY_2(d0)
struct DATA0 *d0;
{
  int CostXY,CostY,CostR;

  d0->Path[d0->J][d0->I].x = 'n';
  d0->Path[d0->J][d0->I].y = 'n';

  if(d0->J % 2 == 0){
    CostXY = d0->Vec1[d0->I-1].xy;
    CostY = d0->Vec1[d0->I].y;
    
    CostR = minimum2_XY(d0,CostXY,CostY);
    d0->Vec0[d0->I].xy = CostR;
    d0->Vec0[d0->I].x = 'n';
    d0->Vec0[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
  if(d0->J % 2 == 1){
    CostXY = d0->Vec0[d0->I-1].xy;
    CostY = d0->Vec0[d0->I].y;
    
    CostR = minimum2_XY(d0,CostXY,CostY);
    d0->Vec1[d0->I].xy = CostR;
    d0->Vec1[d0->I].x = 'n';
    d0->Vec1[d0->I].y = 'n';

    /* printf("I=%d,J=%d,CX=%d,CXY=%d,CY=%d,PX=%d,PXY=%d,PY=%d\n",
	   d0->I,d0->J,d0->Vec0[d0->I].x,d0->Vec0[d0->I].xy,d0->Vec0[d0->I].y,
	   d0->Path[d0->J][d0->I].x,d0->Path[d0->J][d0->I].xy,d0->Path[d0->J][d0->I].y); */
  }
}


/*
 * 
 *
 */

/***** outgapcost *****/
outgapcost_I(d0)
struct DATA0 *d0;
{
  int i;
  int Cost = 0;

  for(i=0;i<d0->NumX;i++){
    if(d0->CSeq1[i][d0->I] != '-' && d0->CSeq1[i][d0->I] != '#') Cost += d0->S*d0->NumY;
  }
  return Cost;
}


outgapcost_J(d0)
struct DATA0 *d0;
{
  int j;
  int Cost = 0;

  for(j=0;j<d0->NumY;j++){
    if(d0->CSeq2[j][d0->J] != '-' && d0->CSeq2[j][d0->J] != '#') Cost += d0->S*d0->NumX;
  }
  return Cost;
}


/***** paicost_IJ_F *****/
paircost_IJ_F(d0)
struct DATA0 *d0;
{
  int i,j;
  int Cost = 0;

  for(i=0;i<d0->NumX;i++){
    for(j=0;j<d0->NumY;j++){
      if(d0->CSeq1[i][d0->I] != '-' && d0->CSeq1[i][d0->I] != '#' && 
	 d0->CSeq2[j][d0->J] != '-' && d0->CSeq2[j][d0->J] != '#'
	 ) Cost += Dmatrix[ d0->Seq1[i][d0->I] ][ d0->Seq2[j][d0->J] ];
      else if(d0->CSeq1[i][d0->I] != '-' && d0->CSeq1[i][d0->I] != '#') Cost += d0->S;
      else if(d0->CSeq2[j][d0->J] != '-' && d0->CSeq2[j][d0->J] != '#') Cost += d0->S;
      else {}
    }
  }
  return Cost;
}


/***** paircost_IJ_DXY *****/
paircost_IJ_DXY(d0)
struct DATA0 *d0;
{
  int x,y,i,j;
  int Cost = 0;
  
  i = d0->I;
  j = d0->J;

  for(x=0;x<d0->NumX;x++){
    for(y=0;y<d0->NumY;y++){
      if(d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#' && 
	 d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') 
	Cost += Dmatrix[d0->Seq1[x][i]][d0->Seq2[y][j]];
      else if(d0->CSeq2[y][j] == '-' && d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#') 
	Cost += gapcost_v_I_DXY(x,y,i-1,j-1,d0);
      else if(d0->CSeq1[x][i] == '-' && d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') 
	Cost += gapcost_v_J_DXY(x,y,i-1,j-1,d0);
      else if(d0->CSeq2[y][j] == '#' && d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#') 
	Cost += d0->S;
      else if(d0->CSeq1[x][i] == '#' && d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') 
	Cost += d0->S;
      else {}
    }
  }
  return Cost;
}


/***** paircost_IJ_DX *****/
paircost_IJ_DX(d0)
struct DATA0 *d0;
{
  int x,y,i,j;
  int Cost = 0;
  
  i = d0->I;
  j = d0->J;

  for(x=0;x<d0->NumX;x++){
    for(y=0;y<d0->NumY;y++){
      if(d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#' && 
	 d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') 
	Cost += Dmatrix[d0->Seq1[x][i]][d0->Seq2[y][j]];
      else if(d0->CSeq2[y][j] == '-' && d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#') 
	Cost += gapcost_v_I_DX(x,y,i-1,j,d0);
      else if(d0->CSeq1[x][i] == '-' && d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') 
	Cost += gapcost_v_J_DX(x,y,i-1,j,d0);
      else if(d0->CSeq2[y][j] == '#' && d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#') 
	Cost += d0->S;
      else if(d0->CSeq1[x][i] == '#' && d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') 
	Cost += d0->S;
      else {}
    }
  }
  return Cost;
}


/***** paircost_IJ_DY *****/
paircost_IJ_DY(d0)
struct DATA0 *d0;
{
  int x,y,i,j;
  int Cost = 0;
  
  i = d0->I;
  j = d0->J;

  for(x=0;x<d0->NumX;x++){
    for(y=0;y<d0->NumY;y++){
      if(d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#' && 
	 d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') 
	Cost += Dmatrix[d0->Seq1[x][i]][d0->Seq2[y][j]];
      else if(d0->CSeq2[y][j] == '-' && d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#') 
	Cost += gapcost_v_I_DY(x,y,i,j-1,d0);
      else if(d0->CSeq1[x][i] == '-' && d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') 
	Cost += gapcost_v_J_DY(x,y,i,j-1,d0);
      else if(d0->CSeq2[y][j] == '#' && d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#') 
	Cost += d0->S;
      else if(d0->CSeq1[x][i] == '#' && d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') 
	Cost += d0->S;
      else {}
    }
  }
  return Cost;
}


/***** gapcost_I *****/
gapcost_I_DXY(d0)
struct DATA0 *d0;
{
  int x,y,i,j;
  int Cost = 0;
  
  i = d0->I;
  j = d0->J;

  for(x=0;x<d0->NumX;x++){
    if(d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#') {
      for(y=0;y<d0->NumY;y++){
	Cost += gapcost_v_I_DXY(x,y,i-1,j-1,d0);
      }
    }
  }
  return Cost;
}


gapcost_I_DX(d0)
struct DATA0 *d0;
{
  int x,y,i,j;
  int Cost = 0;
  
  i = d0->I;
  j = d0->J;

  for(x=0;x<d0->NumX;x++){
    if(d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#') {
      for(y=0;y<d0->NumY;y++){
	Cost += gapcost_v_I_DX(x,y,i-1,j,d0);
      }
    }
  }
  return Cost;
}


gapcost_I_DY(d0)
struct DATA0 *d0;
{
  int x,y,i,j;
  int Cost = 0;
  
  i = d0->I;
  j = d0->J;

  for(x=0;x<d0->NumX;x++){
    if(d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#') {
      for(y=0;y<d0->NumY;y++){
	Cost += gapcost_v_I_DY(x,y,i,j-1,d0);
      }
    }
  }
  return Cost;
}


/***** gapcost_J *****/
gapcost_J_DXY(d0)
struct DATA0 *d0;
{
  int x,y,i,j;
  int Cost = 0;
  
  i = d0->I;
  j = d0->J;

  for(y=0;y<d0->NumY;y++){
    if(d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') {
      for(x=0;x<d0->NumX;x++){
	Cost += gapcost_v_J_DXY(x,y,i-1,j-1,d0);
      }
    }
  }
  return Cost;
}


gapcost_J_DX(d0)
struct DATA0 *d0;
{
  int x,y,i,j;
  int Cost = 0;
  
  i = d0->I;
  j = d0->J;

  for(y=0;y<d0->NumY;y++){
    if(d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') {
      for(x=0;x<d0->NumX;x++){
	Cost += gapcost_v_J_DX(x,y,i-1,j,d0);
      }
    }
  }
  return Cost;
}


gapcost_J_DY(d0)
struct DATA0 *d0;
{
  int x,y,i,j;
  int Cost = 0;
  
  i = d0->I;
  j = d0->J;

  for(y=0;y<d0->NumY;y++){
    if(d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') {
      for(x=0;x<d0->NumX;x++){
	Cost += gapcost_v_J_DY(x,y,i,j-1,d0);
      }
    }
  }
  return Cost;
}


/**********  gapcost_v **********/
/***** gapcost_v_I *****/
gapcost_v_I_DXY(x,y,i,j,d0)
int x,y,i,j;
struct DATA0 *d0;
{
  int Cost;

  if(d0->CSeq2[y][j+1] == '#') Cost = d0->S;
  else if(d0->CSeq2[y][j] == '#') Cost = d0->S;
  else if(d0->CSeq1[x][i] == '#') Cost = d0->U + d0->V;
  else if(d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') Cost = d0->U + d0->V;
  else if(d0->CSeq2[y][j] == '-' && d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#') 
    Cost = d0->V;
  else if( i == 0 && j == 0 ) Cost = d0->S;
  else {
    if(d0->Path[j][i].xy == 'z') Cost = gapcost_v_I_DXY(x,y,i-1,j-1,d0);
    else if(d0->Path[j][i].xy == 'x') Cost = gapcost_v_I_DX(x,y,i-1,j,d0);
    else if(d0->Path[j][i].xy == 'y') Cost = gapcost_v_I_DY(x,y,i,j-1,d0);
    else {
      printf("error gapcost_v_I_DXY(%d,%d,%d,%d)\n",x,y,i,j);
      exit(1);
    }
  }
  return Cost;
}


gapcost_v_I_DX(x,y,i,j,d0)
int x,y,i,j;
struct DATA0 *d0;
{
  int Cost;

  if(d0->CSeq2[y][j] == '#') Cost = d0->S;
  else if(d0->CSeq2[y][j-1] == '#') Cost = d0->S;
  else if(d0->CSeq1[x][i] == '#') Cost = d0->U + d0->V;
  else if(d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#') Cost = d0->V;
  else if( i == 0 && j == 0 ) Cost = d0->S;
  else {
    if(d0->Path[j][i].x == 'z') Cost = gapcost_v_I_DXY(x,y,i-1,j-1,d0);
    else if(d0->Path[j][i].x == 'x') Cost = gapcost_v_I_DX(x,y,i-1,j,d0);
    else if(d0->Path[j][i].x == 'y') Cost = gapcost_v_I_DY(x,y,i,j-1,d0);
    else {
      printf("error gapcost_v_I_DX(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


gapcost_v_I_DY(x,y,i,j,d0)
int x,y,i,j;
struct DATA0 *d0;
{
  int Cost;

  if(d0->CSeq2[y][j+1] == '#') Cost = d0->S;
  else if(d0->CSeq2[y][j] == '#') Cost = d0->S;
  else if(d0->CSeq1[x][i-1] == '#') Cost = d0->U + d0->V;
  else if(d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') Cost = d0->U + d0->V;
  else if( i == 0 && j == 0 ) Cost = d0->S;
  else {
    if(d0->Path[j][i].y == 'z') Cost = gapcost_v_I_DXY(x,y,i-1,j-1,d0);
    else if(d0->Path[j][i].y == 'x') Cost = gapcost_v_I_DX(x,y,i-1,j,d0);
    else if(d0->Path[j][i].y == 'y') Cost = gapcost_v_I_DY(x,y,i,j-1,d0);
    else {
      printf("error gapcost_v_I_DY(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


/***** gapcost_v_J *****/
gapcost_v_J_DXY(x,y,i,j,d0)
int x,y,i,j;
struct DATA0 *d0;
{
  int Cost;

  if(d0->CSeq1[x][i+1] == '#') Cost = d0->S;
  else if(d0->CSeq1[x][i] == '#') Cost = d0->S;
  else if(d0->CSeq2[y][j] == '#') Cost = d0->U + d0->V;
  else if(d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#') Cost = d0->U + d0->V;
  else if(d0->CSeq1[x][i] == '-' && d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') 
    Cost = d0->V;
  else if( i == 0 && j == 0 ) Cost = d0->S;
  else {
    if(d0->Path[j][i].xy == 'z') Cost = gapcost_v_J_DXY(x,y,i-1,j-1,d0);
    else if(d0->Path[j][i].xy == 'x') Cost = gapcost_v_J_DX(x,y,i-1,j,d0);
    else if(d0->Path[j][i].xy == 'y') Cost = gapcost_v_J_DY(x,y,i,j-1,d0);
    else {
      printf("error gapcost_v_J_DXY(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


gapcost_v_J_DX(x,y,i,j,d0)
int x,y,i,j;
struct DATA0 *d0;
{
  int Cost;

  if(d0->CSeq1[x][i+1] == '#') Cost = d0->S;
  else if(d0->CSeq1[x][i] == '#') Cost = d0->S;
  else if(d0->CSeq2[y][j-1] == '#') Cost = d0->U + d0->V;
  else if(d0->CSeq1[x][i] != '-' && d0->CSeq1[x][i] != '#') Cost = d0->U + d0->V;
  else if( i == 0 && j == 0 ) Cost = d0->S;
  else {
    if(d0->Path[j][i].x == 'z') Cost = gapcost_v_J_DXY(x,y,i-1,j-1,d0);
    else if(d0->Path[j][i].x == 'x') Cost = gapcost_v_J_DX(x,y,i-1,j,d0);
    else if(d0->Path[j][i].x == 'y') Cost = gapcost_v_J_DY(x,y,i,j-1,d0);
    else {
      printf("error gapcost_v_J_DX(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


gapcost_v_J_DY(x,y,i,j,d0)
int x,y,i,j;
struct DATA0 *d0;
{
  int Cost;

  if(d0->CSeq1[x][i] == '#') Cost = d0->S;
  else if(d0->CSeq1[x][i-1] == '#') Cost = d0->S;
  else if(d0->CSeq2[y][j] == '#') Cost = d0->U + d0->V;
  else if(d0->CSeq2[y][j] != '-' && d0->CSeq2[y][j] != '#') Cost = d0->V;
  else if( i == 0 && j == 0 ) Cost = d0->S;
  else {
    if(d0->Path[j][i].y == 'z') Cost = gapcost_v_J_DXY(x,y,i-1,j-1,d0);
    else if(d0->Path[j][i].y == 'x') Cost = gapcost_v_J_DX(x,y,i-1,j,d0);
    else if(d0->Path[j][i].y == 'y') Cost = gapcost_v_J_DY(x,y,i,j-1,d0);
    else {
      printf("error gapcost_v_J_DY(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


/*
 *
 *
 */

/***** minimum *****/
minimum_X(d0,CostX,CostXY,CostY)
struct DATA0 *d0;
int CostX,CostXY,CostY;
{
  if(CostXY <= CostX && CostXY <= CostY){
    d0->Path[d0->J][d0->I].x = 'z';
    return CostXY;
  }
  else if(CostX <= CostXY && CostX <= CostY){
    d0->Path[d0->J][d0->I].x = 'x';
    return CostX;
  }
  else if(CostY <= CostXY && CostY <= CostX){
    d0->Path[d0->J][d0->I].x = 'y';
    return CostY;
  }
  else {
    printf("minimum error\n");
    exit(1);
  }
}


minimum_XY(d0,CostX,CostXY,CostY)
struct DATA0 *d0;
int CostX,CostXY,CostY;
{
  if(CostXY <= CostX && CostXY <= CostY){
    d0->Path[d0->J][d0->I].xy = 'z';
    return CostXY;
  }
  else if(CostX <= CostXY && CostX <= CostY){
    d0->Path[d0->J][d0->I].xy = 'x';
    return CostX;
  }
  else if(CostY <= CostXY && CostY <= CostX){
    d0->Path[d0->J][d0->I].xy = 'y';
    return CostY;
  }
  else {
    printf("minimum error\n");
    exit(1);
  }
}


minimum_Y(d0,CostX,CostXY,CostY)
struct DATA0 *d0;
int CostX,CostXY,CostY;
{
  if(CostXY <= CostX && CostXY <= CostY){
    d0->Path[d0->J][d0->I].y = 'z';
    return CostXY;
  }
  else if(CostX <= CostXY && CostX <= CostY){
    d0->Path[d0->J][d0->I].y = 'x';
    return CostX;
  }
  else if(CostY <= CostXY && CostY <= CostX){
    d0->Path[d0->J][d0->I].y = 'y';
    return CostY;
  }
  else {
    printf("minimum error\n");
    exit(1);
  }
}


minimum1_X(d0,CostX,CostXY)
struct DATA0 *d0;
int  CostX,CostXY;
{
  if(CostXY <= CostX){
    d0->Path[d0->J][d0->I].x = 'z';
    return CostXY;
  }
  else{
    d0->Path[d0->J][d0->I].x = 'x';
    return CostX;
  }
}


minimum1_XY(d0,CostX,CostXY)
struct DATA0 *d0;
int  CostX,CostXY;
{
  if(CostXY <= CostX){
    d0->Path[d0->J][d0->I].xy = 'z';
    return CostXY;
  }
  else{
    d0->Path[d0->J][d0->I].xy = 'x';
    return CostX;
  }
}


minimum1_Y(d0,CostX,CostXY)
struct DATA0 *d0;
int  CostX,CostXY;
{
  if(CostXY <= CostX){
    d0->Path[d0->J][d0->I].y = 'z';
    return CostXY;
  }
  else{
    d0->Path[d0->J][d0->I].y = 'x';
    return CostX;
  }
}


minimum2_X(d0,CostXY,CostY)
struct DATA0 *d0;
int  CostXY,CostY;
{
  if(CostXY <= CostY){
    d0->Path[d0->J][d0->I].x = 'z';
    return CostXY;
  }
  else{
    d0->Path[d0->J][d0->I].x = 'y';
    return CostY;
  }
}


minimum2_XY(d0,CostXY,CostY)
struct DATA0 *d0;
int  CostXY,CostY;
{
  if(CostXY <= CostY){
    d0->Path[d0->J][d0->I].xy = 'z';
    return CostXY;
  }
  else{
    d0->Path[d0->J][d0->I].xy = 'y';
    return CostY;
  }
}


minimum2_Y(d0,CostXY,CostY)
struct DATA0 *d0;
int  CostXY,CostY;
{
  if(CostXY <= CostY){
    d0->Path[d0->J][d0->I].y = 'z';
    return CostXY;
  }
  else{
    d0->Path[d0->J][d0->I].y = 'y';
    return CostY;
  }
}



