/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new19_stem.h"

extern int Dmatrix[26][26];

void 
readMatrix(p)
char *p;
{
  FILE *fopen(),*fp_r;
  char Buff[261];
  int i;

  void readMatrix_1();

  fp_r = fopen(p,"r");
  if(fp_r == NULL) {
    fprintf(stderr,"matrix file open error \n");exit(-1);
  }
  for(i=0;i<26;i++){
    if(fgets(Buff,260,fp_r) == NULL){
      fprintf(stderr,"matrix has only %d lines \n",i);exit(-1);
    }
    readMatrix_1(&Buff[0],260,i);
  }
  fclose(fp_r);
}

void 
readMatrix_1(p,leng,num)
char *p;
int  leng,num;
{
  char  *rp;
  int   a,i,fg=0;

  extern char *read_num();
  extern char *read_num_end();

  for(i=0;i<25;i++){
    rp = read_num(',',p,leng,&a,&fg);
    if(fg == 1){
      fprintf(stderr,"matrix file error at %d line %d colum\n",num,i);
      exit(1);
    }
    leng -= rp - p;  p = rp;
    Dmatrix[num][i] = a;
  }
  rp = read_num_end('\n',p,leng,&a,&fg);
  if(fg == 1){
    fprintf(stderr,"matrix file error at %d line %d colum\n",num,i);
    exit(1);
  }
  leng -= rp - p;  p = rp;
  Dmatrix[num][i] = a;
}


void 
remove_allgap(Seq1,Seq2,X,Y,NumX,NumY)
char **Seq1;
char **Seq2;
int *X,*Y,NumX,NumY;
{
  int i,j,k,k1;

  j = 0;
  for(i=0;i<*X;i++){
    for(k=0;k<NumX;k++){
      if(Seq1[k][i] != '-' && Seq1[k][i] != '#'){
	for(k1=0;k1<NumX;k1++){
	  Seq1[k1][j] = Seq1[k1][i];
	}
	j++;
	break;
      }
      else {}
    }
  }
  *X = j;

  j = 0;
  for(i=0;i<*Y;i++){
    for(k=0;k<NumY;k++){
      if(Seq2[k][i] != '-' && Seq2[k][i] != '#'){
	for(k1=0;k1<NumY;k1++){
	  Seq2[k1][j] = Seq2[k1][i];
	}
	j++;
	break;
      }
      else {}
    }
  }
  *Y = j;
}


void 
remove_allgap_sds_stem(Seq1,Seq2,sds1,sds2,stem1,stem2,X,Y,NumX,NumY)
char **Seq1,**Seq2;
char *sds1,*sds2;
char **stem1,**stem2;
int *X,*Y,NumX,NumY;
{
  int i,j,k,k1;

  j = 0;
  for(i=0;i<*X;i++){
    for(k=0;k<NumX;k++){
      if(Seq1[k][i] != '-' && Seq1[k][i] != '#'){
	for(k1=0;k1<NumX;k1++){
	  Seq1[k1][j] = Seq1[k1][i];
	  stem1[k1][j] = stem1[k1][i];
	}
	sds1[j] = sds1[i];
	j++;
	break;
      }
      else {}
    }
  }
  *X = j;

  j = 0;
  for(i=0;i<*Y;i++){
    for(k=0;k<NumY;k++){
      if(Seq2[k][i] != '-' && Seq2[k][i] != '#'){
	for(k1=0;k1<NumY;k1++){
	  Seq2[k1][j] = Seq2[k1][i];
	  stem2[k1][j] = stem2[k1][i];
	}
	sds2[j] = sds2[i];
	j++;
	break;
      }
      else {}
    }
  }
  *Y = j;
}


void 
remove_allgap_sds_stem_1(Seq1,Seq2,Seq1_sds,Seq2_sds,sds1,sds2,Stem1,Stem2,X,Y,NumX,NumY)
char **Seq1,**Seq2,**Seq1_sds,**Seq2_sds;
char *sds1,*sds2;
char **Stem1,**Stem2;
int *X,*Y,NumX,NumY;
{
  int i,j,k,k1;

  j = 0;
  for(i=0;i<*X;i++){
    for(k=0;k<NumX;k++){
      if(Seq1[k][i] != '-' && Seq1[k][i] != '#'){
	for(k1=0;k1<NumX;k1++){
	  Seq1[k1][j] = Seq1[k1][i];
	  Seq1_sds[k1][j] = Seq1_sds[k1][i];
	  Stem1[k1][j] = Stem1[k1][i];
	}
	sds1[j] = sds1[i];
	j++;
	break;
      }
      else {}
    }
  }
  *X = j;

  j = 0;
  for(i=0;i<*Y;i++){
    for(k=0;k<NumY;k++){
      if(Seq2[k][i] != '-' && Seq2[k][i] != '#'){
	for(k1=0;k1<NumY;k1++){
	  Seq2[k1][j] = Seq2[k1][i];
	  Seq2_sds[k1][j] = Seq2_sds[k1][i];
	  Stem2[k1][j] = Stem2[k1][i];
	}
	sds2[j] = sds2[i];
	j++;
	break;
      }
      else {}
    }
  }
  *Y = j;
}
