/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new19_stem.h"

int *amigapI,*amigapJ,*gapI,*gapJ;

int
check_seq(pa1)
PARAM1 *pa1;
{
  int i,num,x,buff;
  char Buff[MAXBUFF+1];

  int check_leng();

  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Seq= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"Seq=",4) == 0) break;
    else {}
  }

  num = 0;
  buff = 0;
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. END expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"END",3) == 0) break;
    else if(strncmp(Buff,"SEQ:",4) == 0){
      num++;
      if(fgets(Buff,MAXBUFF,stdin) == NULL){
	fprintf(stderr,"\n!!! Illegal Format !!!\n"); exit();
      }
      x = check_leng(&Buff[0]);
      if(x == 0){
	fprintf(stderr,"\n!!! Illegal Format !!!\n"); exit();
      }
      if(buff < x) buff = x;
      i = 0;
    }      
    else{}
  }

  if(num < 2){
    fprintf(stderr,"\n!!! Illegal Format !!!\n"); exit();
  }
  else pa1->SeqNum = num;

  return buff;

}


void
readfile_stem(pa1,data,stem)
PARAM1 *pa1;
DATA *data;
STEM *stem;
{
  int i,j,flag;
  char Buff[MAXBUFF+1];

  void readname();
  void readseq();
  void readstem0();
  void readstem1();
  void readPara();
  void readGapCost();

  rewind(stdin);
  for(;;){
    fgets(Buff,MAXBUFF,stdin);
    if(strncmp(Buff,"Seq=",4) == 0) break;
  }
  pa1->nameleng = 0;
  i = -1;
  flag = 0;
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. END expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"END",3) == 0) break;
    else if(strncmp(Buff,"SEQ:",4) == 0){
      i++;
      readname(&Buff[4],i,&(pa1->nameleng),data->Name);
      flag = 1;
    }
    else{
      if(flag == 1){
	readseq(&Buff[0],i,data);
	flag = 2;
	j=0;
      }
      else if(flag == 2){
	if(j == 0) readstem0(&Buff[0],i,data);
	readstem1(&Buff[0],i,j,stem,data->Leng);
	j++;
      }
      else{
	fprintf(stderr,"\n!!! Illegal Format !!!\n"); exit();
      }
    }
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. U,V,S= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"U,V,S=",6) == 0) {
      readGapCost(&Buff[6],MAXBUFF-6,&(pa1->U),&(pa1->V),&(pa1->S));
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. CutI= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"CutI=",5) == 0) {
      readPara(&Buff[5],MAXBUFF-5,&(pa1->CutI));
      break;
    }
    else {}
  }
  
  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. CutM= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"CutM=",5) == 0) {
      readPara(&Buff[5],MAXBUFF-5,&(pa1->CutM));
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. CutM= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"RLSame=",7) == 0) {
      readPara(&Buff[7],MAXBUFF-7,&RLSame);
      break;
    }
    else {}
  }

  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. CutM= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"RLDiff=",7) == 0) {
      readPara(&Buff[7],MAXBUFF-7,&RLDiff);
      break;
    }
    else {}
  }

/*
  rewind(stdin);
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. MFlag= expected !!!\n"); exit();
    }
    else if(strncmp(Buff,"MFlag=",6) == 0) {
      readPara(&Buff[6],MAXBUFF-6,&(pa1->MFlag));
      break;
    }
    else {}
  }
*/
  pa1->MFlag = MFLAG;

  fprintf(stderr,"End readFile\n\n");

}


int 
check_leng(p)
char *p;
{
  int  i;

  i = 0;
  while(*p != '\n'){
    if(*p == ' ' || *p == '\t')  p++;
    else{
      p++;
      i++;
    }
  }
  return i;

}


void
keep_memory_data(data,buffsn,buffsl)
DATA *data;
int buffsn,buffsl;
{
  int k;
  char *calloc();

  if( ( data->Seq = (char **)calloc( buffsn, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq\n"); exit();
  }
  for(k=0;k<buffsn;k++){
    if( ( data->Seq[k] = calloc( buffsl, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit();
    }
  }
  
  if( ( data->Seq_sds = (char **)calloc( buffsn, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq_sds\n"); exit();
  }
  for(k=0;k<buffsn;k++){
    if( ( data->Seq_sds[k] = calloc( buffsl, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq_sds\n"); exit();
    }
  }
  
  if( ( data->Seq_sds_stem = (char **)calloc( buffsn, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq_sds_stem\n"); exit();
  }
  for(k=0;k<buffsn;k++){
    if( ( data->Seq_sds_stem[k] = calloc( buffsl, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq_sds_stem\n"); exit();
    }
  }
  
  if( ( data->Name = (char **)calloc( buffsn, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq\n"); exit();
  }
  for(k=0;k<buffsn;k++){
    if( ( data->Name[k] = calloc( NAME_BUFF, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit();
    }
  }
  
  if( ( data->Leng = (int *)calloc( buffsn, sizeof(int) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Leng\n"); exit();
  }

  if( ( data->Num = (int *)calloc( buffsn, sizeof(int) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Num\n"); exit();
  }

  if( ( data->NumVec = (int **)calloc( buffsn, sizeof(int *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq\n"); exit();
  }
  for(k=0;k<buffsn;k++){
    if( ( data->NumVec[k] = (int *)calloc( buffsn, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit();
    }
  }
  
  if( ( data->Matrix = (long **)calloc( buffsn, sizeof(long *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq\n"); exit();
  }
  for(k=0;k<buffsn;k++){
    if( ( data->Matrix[k] = (long *)calloc( buffsn, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit();
    }
  }
  
  if( ( amigapI = (int *)calloc( buffsn, sizeof(int) ) ) == NULL ){
    fprintf(stderr,"calloc failed for amigapI\n"); exit();
  }

  if( ( amigapJ = (int *)calloc( buffsn, sizeof(int) ) ) == NULL ){
    fprintf(stderr,"calloc failed for amigapJ\n"); exit();
  }

  if( ( gapI = (int *)calloc( buffsn, sizeof(int) ) ) == NULL ){
    fprintf(stderr,"calloc failed for gapI\n"); exit();
  }

  if( ( gapJ = (int *)calloc( buffsn, sizeof(int) ) ) == NULL ){
    fprintf(stderr,"calloc failed for gapJ\n"); exit();
  }


}


void
keep_memory_stem(stem,buffsn,buffsl,stem_num)
STEM **stem;
int buffsn,buffsl;
int *stem_num;
{
  int i,k;
  char *calloc();

  if( ( *stem = ( STEM * )calloc( buffsn, sizeof(STEM) ) ) == NULL ){
    fprintf(stderr,"calloc failed for stem\n"); exit();
  }

  for(i=0;i<buffsn;i++){

    if(stem_num[i] > 0){
      if( ( (*stem+i)->sds = (char **)calloc( stem_num[i], sizeof(char *) ) ) == NULL ){
	fprintf(stderr,"calloc failed for stem->sds\n"); exit();
      }
      for(k=0;k<stem_num[i];k++){
	if( ( (*stem+i)->sds[k] = calloc( buffsl, sizeof(char) ) ) == NULL ){
	  fprintf(stderr,"calloc failed for stem->sds\n"); exit();
	}
      }

      if( ( (*stem+i)->stem = (char **)calloc( stem_num[i], sizeof(char *) ) ) == NULL ){
	fprintf(stderr,"calloc failed for stem->stem\n"); exit();
      }
      for(k=0;k<stem_num[i];k++){
	if( ( (*stem+i)->stem[k] = calloc( buffsl, sizeof(char) ) ) == NULL ){
	  fprintf(stderr,"calloc failed for stem->stem\n"); exit();
	}
      }

    }

  }

}


void
readname(p,num,nameleng,Name)
char *p;
int num;
int *nameleng;
char **Name;
{
  int  i,j;

  i=0;
  for(j=0;j<NAME_BUFF;j++){
/*    if(*p == '\n'){*/
    if( *p == '\n' || *p == 13 ){
      if(*nameleng < i) *nameleng = i;
      while(i<NAME_BUFF){
	Name[num][i] = ' ';
	i++;
      }
      break;
    }
    else {
      Name[num][i] = *p;
      i++;
      p++;
    }
  }
      
}


void
readseq(p,num,data)
char *p;
int num;
DATA *data;
{
  int  i,j,a=0;

  i = 0;
  while(*p != '\n'){
    if(*p == ' ' || *p == '\t')  p++;
    else{
      data->Seq[num][i] = *p;
      p++;
      i++;
    }
  }
  data->Leng[num] = i;
  data->Num[num] = 1;
  data->NumVec[num][0] = num;
  
}


void
readstem0(p,num,data)
char *p;
int num;
DATA *data;
{
  int  i,flag;

  flag=0;
  for(i=0;i<data->Leng[num];i++){
    if(*p == '<'){
      if(flag == 1) data->Seq_sds[num][i] = '#';
      else data->Seq_sds[num][i] = '*';
      data->Seq_sds_stem[num][i] = *p;
      flag = 1;
    }
    else if(*p == '>'){
      if(flag == 2) data->Seq_sds[num][i] = '#';
      else data->Seq_sds[num][i] = '*';
      data->Seq_sds_stem[num][i] = *p;
      flag = 2;
    }
    else{
      data->Seq_sds[num][i] = '*';
      data->Seq_sds_stem[num][i] = '*';
      flag = 0;
    }
    p++;
  }

}


void
readstem1(p,num,snum,stem,Leng)
char *p;
int num,snum;
STEM *stem;
int *Leng;
{
  int  i,flag;

  flag=0;
  for(i=0;i<Leng[num];i++){
    if(*p == '<'){
      if(flag == 1) stem[num].sds[snum][i] = '#';
      else stem[num].sds[snum][i] = '*';
      stem[num].stem[snum][i] = *p;
      flag = 1;
    }
    else if(*p == '>'){
      if(flag == 2) stem[num].sds[snum][i] = '#';
      else stem[num].sds[snum][i] = '*';
      stem[num].stem[snum][i] = *p;
      flag = 2;
    }
    else{
      stem[num].sds[snum][i] = '*';
      stem[num].stem[snum][i] = '*';
      flag = 0;
    }
    p++;
  }

}


void 
readGapCost(p,leng,U,V,S)
char *p;
int  leng;
int  *U,*V,*S;
{
  char  *rp;
  int   u,v,s,fg=0;

  char *read_num();
  char *read_num_end();

  rp = read_num(',',p,leng,&u,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readGapCost U\n"); exit();
  }
  leng -= rp - p;  p = rp;
  rp = read_num(',',p,leng,&v,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readGapCost V\n"); exit();
  }
  leng -= rp - p;  p = rp;
  rp = read_num_end('\n',p,leng,&s,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readGapCost S\n"); exit();
  }

  *U = u;
  *V = v;
  *S = s;
}


void 
readPara(p,leng,Para)
char *p;
int  leng;
int  *Para;
{
  int   pa,fg=0;

  char *read_num_end();

  read_num_end('\n',p,leng,&pa,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readPara\n"); exit();
  }

  *Para = pa;
}


char 
*read_num(c,p,leng,num,fg)
int c;
char *p;
int leng;
int *num,*fg;
{
  int  i,k = 0;
  char dest[10];

  double atof();

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else if(*p == (char)c && k == 0){
      fprintf(stderr,"Illegal Format. Number is expected\n");
      *fg = 1;
      goto label0;
    }
    else if(*p == (char)c){
      p++;
      break;
    }
    else{
      fprintf(stderr,"Illegal Format. Number or %c expected\n",c);
      *fg = 1;
      goto label0;
    }
  }

    dest[k] = 0;
    *num = (int)atof(dest);

    if(i>=leng){
      fprintf(stderr,"Illegal Format at read_num");
      *fg = 1;
      goto label0;
    }

 label0:
  return  p;
}


char 
*read_num_end(c,p,leng,num,fg)
int c;
char *p;
int leng;
int *num,*fg;
{
  int  i,k = 0;
  char dest[10];

  double atof();

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else if(*p == (char)c && k == 0){
      fprintf(stderr,"Illegal Format. Number is expected\n");
      *fg = 1;
      goto label0;
    }
    else if(*p == (char)c || *p == '\0'){
      p++;
      break;
    }
    else{
      fprintf(stderr,"Illegal Format. Number or %c expected\n",c);
      *fg = 1;
      goto label0;
    }
  }

    dest[k] = 0;
    *num = (int)atof(dest);

    if(i>=leng){
      fprintf(stderr,"Illegal Format at read_num");
      *fg = 1;
      goto label0;
    }

 label0:
  return  p;
}
