/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new19_stem.h"

int
calc_energy(pa1,data,column)
PARAM1 *pa1;
DATA *data;
int **column;
{
  int i,j,energy0,energy=0;

  for(i=1;i<data->Leng[0]-1;i++){
    for(j=i+5;j<data->Leng[0]-1;j++){
      energy0 = stem(i,j,pa1,data) + stem(i+1,j-1,pa1,data) + stem(i-1,j+1,pa1,data);
      if(energy0 > 0){
	energy += energy0;
	column[i][j] = 1;
      }
    }
  }
  fprintf(stdout,"StemEnergy = %d\n",energy);
  return energy;
}

int
stem(x,y,pa1,data)
int x,y;
PARAM1 *pa1;
DATA *data;
{
  int i,j,energy=0;
  int au=0,ua=0,gc=0,cg=0,max;

  for(i=0;i<pa1->SeqNum;i++){
    if( data->Seq[i][x] == 'A' && 
       (data->Seq[i][y] == 'U' || data->Seq[i][y] == 'T') ){
      energy += 2;
      au++;
    }
    else if( (data->Seq[i][x] == 'U' || data->Seq[i][x] == 'T') && 
	    data->Seq[i][y] == 'A' ){
      energy += 2;
      ua++;
    }
    else if( data->Seq[i][x] == 'G' && data->Seq[i][y] == 'C' ){
      energy += 2;
      gc++;
    }
    else if( data->Seq[i][x] == 'C' && data->Seq[i][y] == 'G' ){
      energy += 2;
      cg++;
    }
    else if( data->Seq[i][x] == 'G' && 
	    (data->Seq[i][y] == 'U' || data->Seq[i][y] == 'T') ) energy += 0;
    else if( (data->Seq[i][x] == 'U' || data->Seq[i][x] == 'T') && 
	    data->Seq[i][y] == 'G' ) energy += 0;
    else energy -= 2;
  }

  if(au>=ua && au>=gc && au>=cg) max = au;
  else if(ua >= gc && ua >= cg) max = ua;
  else if(gc >= cg) max = gc;
  else max = cg;

  energy -= max;

  return energy;
}

int
check_bad(pa1,data,column)
PARAM1 *pa1;
DATA *data;
int **column;
{
  int i,j,k,energy,max,num;

  max = -1000000;
  for(k=0;k<pa1->SeqNum;k++){
    energy = 0;
    for(i=1;i<data->Leng[0]-1;i++){
      for(j=i+5;j<data->Leng[0]-1;j++){
	if(column[i][j] == 1){
	  if( data->Seq[k][i] == 'A' && 
	     (data->Seq[k][j] == 'U' || data->Seq[k][j] == 'T') ) energy += 1;
	  else if( (data->Seq[k][i] == 'U' || data->Seq[k][i] == 'T') && 
		  data->Seq[k][j] == 'A' ) energy += 1;
	  else if( data->Seq[k][i] == 'G' && data->Seq[k][j] == 'C' ) energy += 1;
	  else if( data->Seq[k][i] == 'C' && data->Seq[k][j] == 'G' ) energy += 1;
	  else if( data->Seq[k][i] == 'G' && 
		  (data->Seq[k][j] == 'U' || data->Seq[k][j] == 'T') ) energy += 0;
	  else if( (data->Seq[k][i] == 'U' || data->Seq[k][i] == 'T') && 
		  data->Seq[k][j] == 'G' ) energy += 0;
	  else energy -= 2;
	}
      }
    }
    if(max < energy){
      max = energy;
      num = k;
    }
  }

  fprintf(stdout,"seq = %d\n\n",num+1);
  return num;

}

void
change_stem(pa1,data,stem,seq,num)
PARAM1 *pa1;
DATA *data;
STEM *stem;
int seq,num;
{
  int i,j,k,leng;

  leng = data->Leng[0];
  for(i=0;i<pa1->SeqNum;i++){
    k = 0;
    for(j=0;j<leng;j++){
      if(data->Seq[i][j] == '-'){}
      else{
	data->Seq[i][k] = data->Seq[i][j];
	data->Seq_sds[i][k] = data->Seq_sds[i][j];
	data->Seq_sds_stem[i][k] = data->Seq_sds_stem[i][j];
	k++;
      }
    }
    data->Leng[i] = k;
    data->Num[i] = 1;
    data->NumVec[i][0] = i;
  }

  for(i=0;i<data->Leng[seq];i++){
    data->Seq_sds[seq][i] = stem[seq].sds[num][i];
    data->Seq_sds_stem[seq][i] = stem[seq].stem[num][i];
  }

}
