/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new19_sds_stem.h"

extern int Dmatrix[26][26];
extern char **Stem1;
extern char **Stem2;

int  gapcost_v_I_DXY_s(),gapcost_v_I_DX_s(),gapcost_v_I_DY_s();
int  gapcost_v_J_DXY_s(),gapcost_v_J_DX_s(),gapcost_v_J_DY_s();
int  gapcost_v0_I_DXY_s(),gapcost_v0_I_DX_s(),gapcost_v0_I_DY_s();
int  gapcost_v0_J_DXY_s(),gapcost_v0_J_DX_s(),gapcost_v0_J_DY_s();

/***** outgapcost *****/
int 
outgapcost_I_s(Seq1,NumX,NumY,I,S)
char **Seq1;
int NumX,NumY;
int I;
int S;
{
  int i;
  int Cost = 0;

  for(i=0;i<NumX;i++){
    if(Seq1[i][I] != '-' && Seq1[i][I] != '#') Cost += S*NumY;
  }
  return Cost;
}


int 
outgapcost_J_s(Seq2,NumY,NumX,J,S)
char **Seq2;
int NumY,NumX;
int J;
int S;
{
  int j;
  int Cost = 0;

  for(j=0;j<NumY;j++){
    if(Seq2[j][J] != '-' && Seq2[j][J] != '#') Cost += S*NumX;
  }
  return Cost;
}


/***** paicost_IJ_F *****/
int 
paircost_IJ_F_s(Seq1,Seq2,NumX,NumY,I,J,S)
char **Seq1;
char **Seq2;
int NumX,NumY;
int I,J;
int S;
{
  int i,j;
  int Cost = 0;

  for(i=0;i<NumX;i++){
    for(j=0;j<NumY;j++){

      if(Seq1[i][I] != '-' && 
         Seq1[i][I] != '#' && 
         Seq2[j][J] != '-' && 
         Seq2[j][J] != '#'){
	Cost += Dmatrix[ Seq1[i][I] ][ Seq2[j][J] ];
	if( (Stem1[i][I] == '>' || Stem1[i][I] == '<') &&
	    (Stem2[j][J] == '>' || Stem2[j][J] == '<') ){
	  if(Stem1[i][I] == Stem2[j][J]) Cost += RLSame;
	  else Cost += RLDiff;
	}
/*
	if(Stem1[i][I] == '>' && Stem2[j][J] == '>') Cost += RLSame;
	else if(Stem1[i][I] == '>' && Stem2[j][J] == '<') Cost += RLDiff;
	else if(Stem1[i][I] == '<' && Stem2[j][J] == '<') Cost += RLSame;
	else if(Stem1[i][I] == '<' && Stem2[j][J] == '>') Cost += RLDiff;
	else {}
*/
      }
      else if(Seq1[i][I] != '-' && 
	      Seq1[i][I] != '#') Cost += S;

      else if(Seq2[j][J] != '-' && 
	      Seq2[j][J] != '#') Cost += S;

      else {}
    }
  }
  return Cost;
}


/***** paircost_IJ_DXY *****/
int 
paircost_IJ_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
int NumX,NumY;
int i,j;
{
  int x,y;
  int Cost = 0;
  
  for(x=0;x<NumX;x++){
    for(y=0;y<NumY;y++){

      if(Seq1[x][i] != '-' && 
	 Seq1[x][i] != '#' && 
         Seq2[y][j] != '-' && 
	 Seq2[y][j] != '#'){
	Cost += Dmatrix[Seq1[x][i]][Seq2[y][j]];
	if((Stem1[x][i] == '>' || Stem1[x][i] == '<') &&
	   (Stem2[y][j] == '>' || Stem2[y][j] == '<')){
	  if(Stem1[x][i] == Stem2[y][j]) Cost += RLSame;
	  else Cost += RLDiff;
	}
      }
      else if(Seq2[y][j] == '-' && 
              Seq1[x][i] != '-' && 
              Seq1[x][i] != '#') Cost += gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);

      else if(Seq1[x][i] == '-' && 
	      Seq2[y][j] != '-' && 
	      Seq2[y][j] != '#') Cost += gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);

      else if(Seq2[y][j] == '#' && 
	      Seq1[x][i] != '-' && 
	      Seq1[x][i] != '#') Cost += S;

      else if(Seq1[x][i] == '#' && 
	      Seq2[y][j] != '-' && 
	      Seq2[y][j] != '#') Cost += S;

      else {}

    }
  }
  return Cost;
}


/***** paircost_IJ_DX *****/
int 
paircost_IJ_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
int NumX,NumY;
int i,j;
{
  int x,y;
  int Cost = 0;
  
  for(x=0;x<NumX;x++){
    for(y=0;y<NumY;y++){

      if(Seq1[x][i] != '-' && 
	 Seq1[x][i] != '#' && 
	 Seq2[y][j] != '-' && 
	 Seq2[y][j] != '#'){
	Cost += Dmatrix[Seq1[x][i]][Seq2[y][j]];
	if((Stem1[x][i] == '>' || Stem1[x][i] == '<') &&
	   (Stem2[y][j] == '>' || Stem2[y][j] == '<')){
	  if(Stem1[x][i] == Stem2[y][j]) Cost += RLSame;
	  else Cost += RLDiff;
	}
      }
      else if(Seq2[y][j] == '-' && 
	      Seq1[x][i] != '-' && 
	      Seq1[x][i] != '#') Cost += gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);

      else if(Seq1[x][i] == '-' && 
	      Seq2[y][j] != '-' && 
	      Seq2[y][j] != '#') Cost += gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);

      else if(Seq2[y][j] == '#' && 
	      Seq1[x][i] != '-' && 
	      Seq1[x][i] != '#') Cost += S;

      else if(Seq1[x][i] == '#' && 
	      Seq2[y][j] != '-' && 
	      Seq2[y][j] != '#') Cost += S;

      else {}

    }
  }
  return Cost;
}


/***** paircost_IJ_DY *****/
int 
paircost_IJ_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
int NumX,NumY;
int i,j;
{
  int x,y;
  int Cost = 0;
  
  for(x=0;x<NumX;x++){
    for(y=0;y<NumY;y++){

      if(Seq1[x][i] != '-' && 
	 Seq1[x][i] != '#' && 
	 Seq2[y][j] != '-' && 
	 Seq2[y][j] != '#'){
	Cost += Dmatrix[Seq1[x][i]][Seq2[y][j]];
	if((Stem1[x][i] == '>' || Stem1[x][i] == '<') &&
	   (Stem2[y][j] == '>' || Stem2[y][j] == '<')){
	  if(Stem1[x][i] == Stem2[y][j]) Cost += RLSame;
	  else Cost += RLDiff;
	}
      }
      else if(Seq2[y][j] == '-' && 
	      Seq1[x][i] != '-' && 
	      Seq1[x][i] != '#') Cost += gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);

      else if(Seq1[x][i] == '-' && 
	      Seq2[y][j] != '-' && 
	      Seq2[y][j] != '#') Cost += gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);

      else if(Seq2[y][j] == '#' && 
	      Seq1[x][i] != '-' && 
	      Seq1[x][i] != '#') Cost += S;

      else if(Seq1[x][i] == '#' && 
	      Seq2[y][j] != '-' && 
	      Seq2[y][j] != '#') Cost += S;

      else {}

    }
  }
  return Cost;
}


/***** gapcost_I *****/
int 
gapcost_I_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
int NumX,NumY;
int i,j;
{
  int x,y;
  int Cost = 0;
  
  for(x=0;x<NumX;x++){
    if(Seq1[x][i] != '-' && Seq1[x][i] != '#') {
      for(y=0;y<NumY;y++){
	Cost += gapcost_v0_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
      }
    }
  }
  return Cost;
}


int 
gapcost_I_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
int NumX,NumY;
int i,j;
{
  int x,y;
  int Cost = 0;
  
  for(x=0;x<NumX;x++){
    if(Seq1[x][i] != '-' && Seq1[x][i] != '#') {
      for(y=0;y<NumY;y++){
	Cost += gapcost_v0_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
      }
    }
  }
  return Cost;
}


int 
gapcost_I_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
int NumX,NumY;
int i,j;
{
  int x,y;
  int Cost = 0;
  
  for(x=0;x<NumX;x++){
    if(Seq1[x][i] != '-' && Seq1[x][i] != '#') {
      for(y=0;y<NumY;y++){
	Cost += gapcost_v0_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
      }
    }
  }
  return Cost;
}


/***** gapcost_J *****/
int 
gapcost_J_DXY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
int NumX,NumY;
int i,j;
{
  int x,y;
  int Cost = 0;
  
  for(y=0;y<NumY;y++){
    if(Seq2[y][j] != '-' && Seq2[y][j] != '#') {
      for(x=0;x<NumX;x++){
	Cost += gapcost_v0_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
      }
    }
  }
  return Cost;
}


int 
gapcost_J_DX_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
int NumX,NumY;
int i,j;
{
  int x,y;
  int Cost = 0;
  
  for(y=0;y<NumY;y++){
    if(Seq2[y][j] != '-' && Seq2[y][j] != '#') {
      for(x=0;x<NumX;x++){
	Cost += gapcost_v0_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
      }
    }
  }
  return Cost;
}


int 
gapcost_J_DY_s(Path,Seq1,Seq2,U,V,S,NumX,NumY,i,j)
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
int NumX,NumY;
int i,j;
{
  int x,y;
  int Cost = 0;
  
  for(y=0;y<NumY;y++){
    if(Seq2[y][j] != '-' && Seq2[y][j] != '#') {
      for(x=0;x<NumX;x++){
	Cost += gapcost_v0_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
      }
    }
  }
  return Cost;
}


/**********  gapcost_v **********/
/***** gapcost_v_I *****/
int 
gapcost_v_I_DXY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
int x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
{
  int Cost;

  if(Seq1[x][i] == '#') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = V;
  else {
    if(Path[j][i].xy == 'z') Cost = gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'x') Cost = gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'y') Cost = gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v_I_DXY_s(%d,%d,%d,%d)\n",x,y,i,j);
      exit(1);
    }
  }
  return Cost;
}


int 
gapcost_v_I_DX_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
int x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
{
  int Cost;

  if(Seq1[x][i] == '#') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = V;
  else {
    if(Path[j][i].x == 'z') Cost = gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'x') Cost = gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'y') Cost = gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v_I_DX_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


int 
gapcost_v_I_DY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
int x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
{
  int Cost;

  if(Seq1[x][i-1] == '#') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = U + V;
  else {
    if(Path[j][i].y == 'z') Cost = gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'x') Cost = gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'y') Cost = gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v_I_DY_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


/***** gapcost_v_J *****/
int 
gapcost_v_J_DXY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
int x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
{
  int Cost;

  if(Seq2[y][j] == '#') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = V;
  else {
    if(Path[j][i].xy == 'z') Cost = gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'x') Cost = gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'y') Cost = gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v_J_DXY_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


int 
gapcost_v_J_DX_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
int x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
{
  int Cost;

  if(Seq2[y][j-1] == '#') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = U + V;
  else {
    if(Path[j][i].x == 'z') Cost = gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'x') Cost = gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'y') Cost = gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v_J_DX_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


int 
gapcost_v_J_DY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
int x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
{
  int Cost;

  if(Seq2[y][j] == '#') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = V;
  else {
    if(Path[j][i].y == 'z') Cost = gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'x') Cost = gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'y') Cost = gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v_J_DY_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


/**********  gapcost_v0 **********/
/***** gapcost_v0_I *****/
int 
gapcost_v0_I_DXY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
int x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
{
  int Cost;

  if(Seq2[y][j+1] == '#') Cost = S;
  else if(Seq2[y][j] == '#') Cost = S;
  else if(Seq1[x][i] == '#') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = V;
  else {
    if(Path[j][i].xy == 'z') Cost = gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'x') Cost = gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'y') Cost = gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v0_I_DXY_s(%d,%d,%d,%d)\n",x,y,i,j);
      exit(1);
    }
  }
  return Cost;
}


int 
gapcost_v0_I_DX_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
int x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
{
  int Cost;

  if(Seq2[y][j] == '#') Cost = S;
  else if(Seq2[y][j-1] == '#') Cost = S;
  else if(Seq1[x][i] == '#') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = V;
  else {
    if(Path[j][i].x == 'z') Cost = gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'x') Cost = gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'y') Cost = gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v0_I_DX_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


int 
gapcost_v0_I_DY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
int x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
{
  int Cost;

  if(Seq2[y][j+1] == '#') Cost = S;
  else if(Seq2[y][j] == '#') Cost = S;
  else if(Seq1[x][i-1] == '#') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = U + V;
  else {
    if(Path[j][i].y == 'z') Cost = gapcost_v_I_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'x') Cost = gapcost_v_I_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'y') Cost = gapcost_v_I_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v0_I_DY_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


/***** gapcost_v0_J *****/
int 
gapcost_v0_J_DXY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
int x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
{
  int Cost;

  if(Seq1[x][i+1] == '#') Cost = S;
  else if(Seq1[x][i] == '#') Cost = S;
  else if(Seq2[y][j] == '#') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = V;
  else {
    if(Path[j][i].xy == 'z') Cost = gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'x') Cost = gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].xy == 'y') Cost = gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v0_J_DXY_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


int 
gapcost_v0_J_DX_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
int x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
{
  int Cost;

  if(Seq1[x][i+1] == '#') Cost = S;
  else if(Seq1[x][i] == '#') Cost = S;
  else if(Seq2[y][j-1] == '#') Cost = U + V;
  else if(Seq1[x][i] != '-') Cost = U + V;
  else {
    if(Path[j][i].x == 'z') Cost = gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'x') Cost = gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].x == 'y') Cost = gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v0_J_DX_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}


int 
gapcost_v0_J_DY_s(x,y,i,j,Path,Seq1,Seq2,U,V,S)
int x,y,i,j;
PATH_s **Path;
char **Seq1;
char **Seq2;
int U,V,S;
{
  int Cost;

  if(Seq1[x][i] == '#') Cost = S;
  else if(Seq1[x][i-1] == '#') Cost = S;
  else if(Seq2[y][j] == '#') Cost = U + V;
  else if(Seq2[y][j] != '-') Cost = V;
  else {
    if(Path[j][i].y == 'z') Cost = gapcost_v_J_DXY_s(x,y,i-1,j-1,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'x') Cost = gapcost_v_J_DX_s(x,y,i-1,j,Path,Seq1,Seq2,U,V,S);
    else if(Path[j][i].y == 'y') Cost = gapcost_v_J_DY_s(x,y,i,j-1,Path,Seq1,Seq2,U,V,S);
    else {
      printf("error gapcost_v0_J_DY_s(%d,%d,%d,%d)\n",x,y,i,j);
/*      exit(1);
*/
    }
  }
  return Cost;
}
