/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new18.h"

void 
makeProf(Prof,Seq,Leng,Num)
PROF *Prof;
char **Seq;
int Leng,Num;
{
  int i,j,k,maxag,maxg;
  int *gap,amip[26],*amigapp,*gapp;
  int outgap;

  if( ( gap = (int *)calloc( Num, sizeof(int) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Num\n"); exit(0);
  }
  if( ( amigapp = (int *)calloc( Leng, sizeof(int) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Num\n"); exit(0);
  }
  if( ( gapp = (int *)calloc( Leng, sizeof(int) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Num\n"); exit(0);
  }

  for(j=0;j<Num;j++) gap[j] = 0;

  for(i=0;i<Leng;i++){
    for(j=0;j<Leng;j++){
      amigapp[j] = 0;
      gapp[j] = 0;
    }
    for(j=0;j<26;j++) amip[j] = 0;
    maxag = 0;
    maxg = 0;
    outgap = 0;

    for(j=0;j<Num;j++){
      if(Seq[j][i] == '#'){
	outgap++;
	gap[j]++; /* 1.21 $BD{@5(B */
      }
      else if(Seq[j][i] == '-'){
	if(gap[j] > maxg) maxg = gap[j];
	gapp[gap[j]]++;
	gap[j]++;
      }
      else{
	if(gap[j] > maxag) maxag = gap[j];
	if(Seq[j][i] >= 'A' && Seq[j][i] <= 'Z') amip[Seq[j][i] - 'A']++;
	if(Seq[j][i] >= 'a' && Seq[j][i] <= 'z') amip[Seq[j][i] - 'a']++;
	amigapp[gap[j]]++;
	gap[j] = 0;
      }	
    }
    Prof[i].outgap = outgap;
    k=0;
    for(j=0;j<maxg+1;j++){
      if(gapp[j] > 0){
	Prof[i].gap[k] = j;
	Prof[i].gapp[k] = gapp[j];
	k++;
      }
    }
    Prof[i].gapn = k;
    k=0;
    for(j=0;j<maxag+1;j++){
      if(amigapp[j] > 0){
	Prof[i].amigap[k] = j;
	Prof[i].amigapp[k] = amigapp[j];
	k++;
      }
    }
    Prof[i].amigapn = k;
    k=0;
    for(j=0;j<26;j++){
      if(amip[j] > 0){
	Prof[i].ami[k] = j;
	Prof[i].amip[k] = amip[j];
	k++;
      }
    }
    Prof[i].amin = k;
  }

  free(gap);
  free(amigapp);
  free(gapp);
}


void 
printProf(Prof,Leng)
PROF *Prof;
int Leng;
{
  int i,j;
  char p;

  for(i=0;i<Leng;i++){
    fprintf(stdout,"pos=%d\n",i);
    fprintf(stdout,"amin=%d\n",Prof[i].amin);
    for(j=0;j<Prof[i].amin;j++){
      p = Prof[i].ami[j] + 'A';
      fprintf(stdout,"%c-",p);
      fprintf(stdout,"%d,",Prof[i].amip[j]);
    }
    fprintf(stdout,"\n");
    fprintf(stdout,"amigapn=%d\n",Prof[i].amigapn);
    for(j=0;j<Prof[i].amigapn;j++){
      fprintf(stdout,"%d-",Prof[i].amigap[j]);
      fprintf(stdout,"%d,",Prof[i].amigapp[j]);
    }
    fprintf(stdout,"\n");
    fprintf(stdout,"gapn=%d\n",Prof[i].gapn);
    for(j=0;j<Prof[i].gapn;j++){
      fprintf(stdout,"%d-",Prof[i].gap[j]);
      fprintf(stdout,"%d,",Prof[i].gapp[j]);
    }
    fprintf(stdout,"\n");
    fprintf(stdout,"outgap=%d\n",Prof[i].outgap);
    fprintf(stdout,"\n");
  }

}
