/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new18.h"

void 
makeAlignmentString1_s(Path,Seq1,Seq2,Seq,NumVec,Leng,NumX,NumY,I,J,R1,R2,flag)
PATH_s **Path;
char **Seq1;
char **Seq2;
char **Seq;
int **NumVec;
int *Leng;
int NumX,NumY,I,J,R1,R2,flag;
{
  int i,j,k,mx,my,a,lim;
  char NextPath,c;

  i = 0;

  NextPath = Path[J][I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<NumX;k++){
	mx = NumVec[R2][k];
	if(Seq1[k][I-1] == '#' || Seq1[k][I-1] == '-'){
	  Seq[mx][i] = '-';
	}
	else{
	  Seq[mx][i] = Seq1[k][I-1] + 'A';
	}
      }
      for(k=0;k<NumY;k++){
	my = NumVec[R1][k];
	if(Seq2[k][J-1] == '#' || Seq2[k][J-1] == '-'){
	  Seq[my][i] = '-';
	}
	else{
	  Seq[my][i] = Seq2[k][J-1] + 'A';
	}
      }
      I--;
      J--;
      NextPath = Path[J][I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<NumX;k++){ 
	mx = NumVec[R2][k];
	if(Seq1[k][I-1] == '#' || Seq1[k][I-1] == '-'){
	  Seq[mx][i] = '-';
	}
	else{
	  Seq[mx][i] = Seq1[k][I-1] + 'A';
	}
      }
      for(k=0;k<NumY;k++) {
	my = NumVec[R1][k];
	Seq[my][i] = '-';
      }
      I--;
      NextPath = Path[J][I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<NumX;k++){ 
	mx = NumVec[R2][k];
	Seq[mx][i] = '-';
      }
      for(k=0;k<NumY;k++){
	my = NumVec[R1][k];
	if(Seq2[k][J-1] == '#' || Seq2[k][J-1] == '-'){
	  Seq[my][i] = '-';
	}
	else{
	  Seq[my][i] = Seq2[k][J-1] + 'A';
	}
      }
      J--;
      NextPath = Path[J][I].y;
    }
    else {
      printf("makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(I == 0 && J == 0) break;

  }
  Leng[R1] = i;
  Leng[R2] = 0;

  lim = Leng[R1] / 2;
  if(flag == 1 || flag == 2) fprintf(stdout,"\n");
  for(k=0;k<NumX;k++){
    mx = NumVec[R2][k];
    j = 0;
    i = Leng[R1] - 1;
    for(a=0;a<lim;a++){
      c = Seq[mx][j];
      Seq[mx][j] = Seq[mx][i];
      Seq[mx][i] = c;
      j++;
      i--;
    }
    if(flag == 1 || flag == 2){
      fprintf(stdout," ");
      for(j=0;j<Leng[R1];j++) fprintf(stdout,"%c",Seq[mx][j]);
      fprintf(stdout,"\n");
    }
  }
  fflush(stdout);
  for(k=0;k<NumY;k++){
    my = NumVec[R1][k];
    j = 0;
    i = Leng[R1] - 1;
    for(a=0;a<lim;a++){
      c = Seq[my][j];
      Seq[my][j] = Seq[my][i];
      Seq[my][i] = c;
      j++;
      i--;
    }
    if(flag == 1 || flag == 2){
      fprintf(stdout," ");
      for(j=0;j<Leng[R1];j++) fprintf(stdout,"%c",Seq[my][j]);
      fprintf(stdout,"\n");
    }
  }
  fflush(stdout);
}


void 
makeAlignmentString1_b(Path,Seq1,Seq2,Seq,NumVec,Leng,NumX,NumY,X,Y,I,R1,R2,flag)
PATH_b *Path;
char **Seq1;
char **Seq2;
char **Seq;
int **NumVec;
int *Leng;
int NumX,NumY,X,Y,I,R1,R2,flag;
{
  int i,j,k,leng,mx,my;

  for(i=0;i<NumX;i++){
    j = 0;
    while(Seq1[i][j] == '-' || Seq1[i][j] == '#'){
      Seq1[i][j] = '-';
      j++;
    }
    j = X -1;
    while(Seq1[i][j] == '-' || Seq1[i][j] == '#'){
      Seq1[i][j] = '-';
      j--;
    }
  }
  for(i=0;i<NumY;i++){
    j = 0;
    while(Seq2[i][j] == '-' || Seq2[i][j] == '#'){
      Seq2[i][j] = '-';
      j++;
    }
    j = Y -1;
    while(Seq2[i][j] == '-' || Seq2[i][j] == '#'){
      Seq2[i][j] = '-';
      j--;
    }
  }

  for(k=0;k<NumX;k++){
    mx = NumVec[R2][k];
    leng=0;
    j=0;
    for(i=0;i<Path[I].gapxy.gapi.num;i++){
      while(j<Path[I].gapxy.gapi.gap[i]){
	Seq[mx][leng] = Seq1[k][j];
	leng++;
	j++;
      }
      Seq[mx][leng] = '-';
      leng++;
    }
    while(j<X){
      Seq[mx][leng] = Seq1[k][j];
      leng++;
      j++;
    }
  }
  for(k=0;k<NumY;k++){
    my = NumVec[R1][k];
    leng=0;
    j=0;
    for(i=0;i<Path[I].gapxy.gapj.num;i++){
      while(j<Path[I].gapxy.gapj.gap[i]){
	Seq[my][leng] = Seq2[k][j];
	leng++;
	j++;
      }
      Seq[my][leng] = '-';
      leng++;
    }
    while(j<Y){
      Seq[my][leng] = Seq2[k][j];
      leng++;
      j++;
    }
  }
      
  Leng[R1] = leng;
  Leng[R2] = 0;

  if(flag == 1 || flag == 2){
    fprintf(stdout,"\n");
    for(k=0;k<NumX;k++){
      mx = NumVec[R2][k];
      fprintf(stdout," ");
      for(j=0;j<Leng[R1];j++) fprintf(stdout,"%c",Seq[mx][j]);
      fprintf(stdout,"\n");
    }      
    for(k=0;k<NumY;k++){
      my = NumVec[R1][k];
      fprintf(stdout," ");
      for(j=0;j<Leng[R1];j++) fprintf(stdout,"%c",Seq[my][j]);
      fprintf(stdout,"\n");
    }
    fflush(stdout);
  }
}


void 
makeAlignmentString2_s(Path,Seq1,Seq2,OSeq,NumVec,NumX,NumY,X,Y,I,J,R1,M)
PATH_s **Path;
char **Seq1;
char **Seq2;
char **OSeq;
int **NumVec;
int NumX,NumY,*X,*Y,I,J,R1,M;
{
  int i,j,k,mx,my,a,lim;
  char NextPath,c;

  i = 0;

  NextPath = Path[J][I].xy;

  for(;;){
    if(NextPath == 'z'){
      for(k=0;k<NumX;k++){
	mx = NumVec[R1][M];
	if(Seq1[k][I-1] == '#' || Seq1[k][I-1] == '-'){
	  OSeq[mx][i] = '-';
	}
	else{
	  OSeq[mx][i] = Seq1[k][I-1] + 'A';
	}
      }
      for(k=0;k<M;k++){
	my = NumVec[R1][k];
	if(Seq2[k][J-1] == '#' || Seq2[k][J-1] == '-'){
	  OSeq[my][i] = '-';
	}
	else{
	  OSeq[my][i] = Seq2[k][J-1] + 'A';
	}
      }
      for(k=M+1;k<NumY+1;k++){
	my = NumVec[R1][k];
	if(Seq2[(k-1)][J-1] == '#' || Seq2[(k-1)][J-1] == '-'){
	  OSeq[my][i] = '-';
	}
	else{
	  OSeq[my][i] = Seq2[(k-1)][J-1] + 'A';
	}
      }
      I--;
      J--;
      NextPath = Path[J][I].xy;
    }
    else if(NextPath == 'x'){
      for(k=0;k<NumX;k++){ 
	mx = NumVec[R1][M];
	if(Seq1[k][I-1] == '#' || Seq1[k][I-1] == '-'){
	  OSeq[mx][i] = '-';
	}
	else{
	  OSeq[mx][i] = Seq1[k][I-1] + 'A';
	}
      }
      for(k=0;k<M;k++) {
	my = NumVec[R1][k];
	OSeq[my][i] = '-';
      }
      for(k=M+1;k<NumY+1;k++) {
	my = NumVec[R1][k];
	OSeq[my][i] = '-';
      }
      I--;
      NextPath = Path[J][I].x;
    }
    else if(NextPath == 'y'){
      for(k=0;k<NumX;k++){ 
	mx = NumVec[R1][M];
	OSeq[mx][i] = '-';
      }
      for(k=0;k<M;k++){
	my = NumVec[R1][k];
	if(Seq2[k][J-1] == '#' || Seq2[k][J-1] == '-'){
	  OSeq[my][i] = '-';
	}
	else{
	  OSeq[my][i] = Seq2[k][J-1] + 'A';
	}
      }
      for(k=M+1;k<NumY+1;k++){
	my = NumVec[R1][k];
	if(Seq2[k-1][J-1] == '#' || Seq2[k-1][J-1] == '-'){
	  OSeq[my][i] = '-';
	}
	else{
	  OSeq[my][i] = Seq2[k-1][J-1] + 'A';
	}
      }
      J--;
      NextPath = Path[J][I].y;
    }
    else {
      fprintf(stderr,"makeAlignmentString error\n");
      exit(1);
    }

    i++;

    if(I == 0 && J == 0) break;

  }

  *X = *Y = i;

  lim = *X / 2;
  for(k=0;k<NumX;k++){
    mx = NumVec[R1][M];
    j = 0;
    i = *X - 1;
    for(a=0;a<lim;a++){
      c = OSeq[mx][j];
      OSeq[mx][j] = OSeq[mx][i];
      OSeq[mx][i] = c;
      j++;
      i--;
    }
  }
  for(k=0;k<M;k++){
    my = NumVec[R1][k];
    j = 0;
    i = *X - 1;
    for(a=0;a<lim;a++){
      c = OSeq[my][j];
      OSeq[my][j] = OSeq[my][i];
      OSeq[my][i] = c;
      j++;
      i--;
    }
  }
  for(k=M+1;k<NumY+1;k++){
    my = NumVec[R1][k];
    j = 0;
    i = *X - 1;
    for(a=0;a<lim;a++){
      c = OSeq[my][j];
      OSeq[my][j] = OSeq[my][i];
      OSeq[my][i] = c;
      j++;
      i--;
    }
  }
}


void 
makeAlignmentString2_b(Path,Seq1,Seq2,Seq,NumVec,NumX,NumY,X,Y,I,R1,M)
PATH_b *Path;
char **Seq1;
char **Seq2;
char **Seq;
int **NumVec;
int NumX,NumY,*X,*Y,I,R1,M;
{
  int i,j,k,leng,mx,my;

  for(i=0;i<NumX;i++){
    j = 0;
    while(Seq1[i][j] == '-' || Seq1[i][j] == '#'){
      Seq1[i][j] = '-';
      j++;
    }
    j = *X -1;
    while(Seq1[i][j] == '-' || Seq1[i][j] == '#'){
      Seq1[i][j] = '-';
      j--;
    }
  }
  for(i=0;i<NumY;i++){
    j = 0;
    while(Seq2[i][j] == '-' || Seq2[i][j] == '#'){
      Seq2[i][j] = '-';
      j++;
    }
    j = *Y -1;
    while(Seq2[i][j] == '-' || Seq2[i][j] == '#'){
      Seq2[i][j] = '-';
      j--;
    }
  }

  mx = NumVec[R1][M];
  leng=0;
  j=0;
  for(i=0;i<Path[I].gapxy.gapi.num;i++){
    while(j<Path[I].gapxy.gapi.gap[i]){
      Seq[mx][leng] = Seq1[0][j];
      leng++;
      j++;
    }
    Seq[mx][leng] = '-';
    leng++;
  }
  while(j<*X){
    Seq[mx][leng] = Seq1[0][j];
    leng++;
    j++;
  }
  for(k=0;k<M;k++){
    my = NumVec[R1][k];
    leng=0;
    j=0;
    for(i=0;i<Path[I].gapxy.gapj.num;i++){
      while(j<Path[I].gapxy.gapj.gap[i]){
	Seq[my][leng] = Seq2[k][j];
	leng++;
	j++;
      }
      Seq[my][leng] = '-';
      leng++;
    }
    while(j<*Y){
      Seq[my][leng] = Seq2[k][j];
      leng++;
      j++;
    }
  }
  for(k=M+1;k<NumY+1;k++){
    my = NumVec[R1][k];
    leng=0;
    j=0;
    for(i=0;i<Path[I].gapxy.gapj.num;i++){
      while(j<Path[I].gapxy.gapj.gap[i]){
	Seq[my][leng] = Seq2[k-1][j];
	leng++;
	j++;
      }
      Seq[my][leng] = '-';
      leng++;
    }
    while(j<*Y){
      Seq[my][leng] = Seq2[k-1][j];
      leng++;
      j++;
    }
  }
      
  *X = *Y = leng;

}
