/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include <stdio.h>
#include <ctype.h>

#define MAXBUFF 1000
#define NAMEBUFF 30
#define MAXLENG 10000
#define MAXNUM  1000

char Buff[MAXBUFF+1];
char Seq[MAXNUM][MAXLENG];
char Name[MAXNUM][NAMEBUFF];
int Leng[MAXNUM];

void
main(argc,argv)
int argc;
char *argv[];
{
  int i,j,num,nameleng,leng;
  int SeqNum;

  int readSeq();

  for(i=0;i<MAXNUM;i++) Leng[i] = 0;
  num=0;
  nameleng = 0;
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL){
      fprintf(stderr,"\n!!! Illegal Format. Name: expected at top of the alignment !!!\n"); 
      exit();
    }
    else if(strncmp(Buff," Name:",6) == 0){
      if(check_name(&Buff[6],num,&nameleng) == 0){
	fprintf(stderr,"\n!!! Illegal Format. Sequence Name expected at top of the alignment !!!\n"); 
	exit();
      }
      num++;
    }
    else if(strncmp(Buff,"//",2) == 0) break;
    else {}
  }
  SeqNum = num;
  for(;;){
    if(fgets(Buff,MAXBUFF,stdin) == NULL) break;
    else if(first_seq(Buff) == 0){
      if(readSeq(&Buff[0],0) == 0){
	fprintf(stderr,"\n!!! Illegal Format. Sequence expected !!!\n"); 
	exit();
      }
      for(i=1;i<SeqNum;i++){
	if(fgets(Buff,MAXBUFF,stdin) == NULL){
	  fprintf(stderr,"\n!!! Illegal Format. Sequence expected !!!\n"); 
	  exit();
	}
	else if(readSeq(&Buff[0],i) == 0){
	  fprintf(stderr,"\n!!! Illegal Format. Sequence expected !!!\n"); 
	  exit();
	}
	else{}
      }
    }
    else {}
  }

  leng=0;
  for(i=0;i<SeqNum;i++){
    if(leng < Leng[i]) leng = Leng[i];
  }
  fprintf(stdout," %d\n",SeqNum);
  fprintf(stdout," %d\n",leng);
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++) fprintf(stdout,"%c",Name[i][j]);
    fprintf(stdout,":");
    for(j=0;j<Leng[i];j++){
      if(Seq[i][j] == '.' || Seq[i][j] == '*') fprintf(stdout,"-");
      else fprintf(stdout,"%c",Seq[i][j]);
    }
    fprintf(stdout,"\n");
  }
}


int 
readSeq(p,num)
char *p;
int num;
{
  int  i,a=0,flag=1;

  for(;;){
    if(*p == '\0' || *p == '\n') break;
    else if(*p == ' ' && flag == 0) {
      p++;
      i = Leng[num];
      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  Seq[num][i] = *p;
	  p++;
	  i++;
	}
      }
      
      Leng[num] = i;
      
      a = 1;
      break;
    } 
    else {
      if(*p != ' ') flag=0;
      p++;
    }
  }
  return a;
}


int 
check_name(p,num,nameleng)
char *p;
int num;
int *nameleng;
{
  int  i,j,a=0,flag=1;

  i=0;
  for(j=0;j<NAMEBUFF;j++){
    if(*p == '\0' || *p == '\n') break;
    else if(*p == ' ' && flag == 0) {
      if(*nameleng < i) *nameleng = i;
      
      while(i<NAMEBUFF){
	Name[num][i] = ' ';
	i++;
      }
      a = 1;
      break;
    } 
    else {
      if(*p != ' '){
	flag=0;
	Name[num][i] = *p;
	i++;
      }
      else {}
      p++;
    }
  }
  return a;
}


int
first_seq(p)
char *p;
{
  int i,a=1;

  i=0;
  while(*p == ' ') p++;
  while(*p == Name[0][i] && *p != ' '){
    p++; 
    i++;
  }
  if(*p == ' ' && Name[0][i] == ' ') a=0;

  return a;
}
