/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new18.h"

void 
readGapCost(p,leng,U,V,S)
char *p;
int  leng;
int  *U,*V,*S;
{
  char  *rp;
  int   u,v,s,fg=0;

  char *read_num();
  char *read_num_end();

  rp = read_num(',',p,leng,&u,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readGapCost U\n"); exit();
  }
  leng -= rp - p;  p = rp;
  rp = read_num(',',p,leng,&v,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readGapCost V\n"); exit();
  }
  leng -= rp - p;  p = rp;
  rp = read_num_end('\n',p,leng,&s,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readGapCost S\n"); exit();
  }

  *U = u;
  *V = v;
  *S = s;
}


void 
readPara(p,leng,Para)
char *p;
int  leng;
int  *Para;
{
  int   pa,fg=0;

  char *read_num_end();

  read_num_end('\n',p,leng,&pa,&fg);
  if(fg == 1) {
    fprintf(stderr,"readfile error at readPara\n"); exit();
  }

  *Para = pa;
}


char 
*read_num(c,p,leng,num,fg)
int c;
char *p;
int leng;
int *num,*fg;
{
  int  i,k = 0;
  char dest[10];

  double atof();

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else if(*p == (char)c && k == 0){
      fprintf(stderr,"Illegal Format. Number is expected\n");
      *fg = 1;
      goto label0;
    }
    else if(*p == (char)c){
      p++;
      break;
    }
    else{
      fprintf(stderr,"Illegal Format. Number or %c expected\n",c);
      *fg = 1;
      goto label0;
    }
  }

    dest[k] = 0;
    *num = (int)atof(dest);

    if(i>=leng){
      fprintf(stderr,"Illegal Format at read_num");
      *fg = 1;
      goto label0;
    }

 label0:
  return  p;
}


char 
*read_num_end(c,p,leng,num,fg)
int c;
char *p;
int leng;
int *num,*fg;
{
  int  i,k = 0;
  char dest[10];

  double atof();

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else if(*p == (char)c && k == 0){
      fprintf(stderr,"Illegal Format. Number is expected\n");
      *fg = 1;
      goto label0;
    }
    else if(*p == (char)c || *p == '\0'){
      p++;
      break;
    }
    else{
      fprintf(stderr,"Illegal Format. Number or %c expected\n",c);
      *fg = 1;
      goto label0;
    }
  }

    dest[k] = 0;
    *num = (int)atof(dest);

    if(i>=leng){
      fprintf(stderr,"Illegal Format at read_num");
      *fg = 1;
      goto label0;
    }

 label0:
  return  p;
}


int 
readSeq_apdp(p,num,nameleng,Seq,Name,Leng)
char *p;
int *num;
int *nameleng;
char **Seq,**Name;
int *Leng;
{
  int  i,j,a=0;

  i=0;
  for(j=0;j<NAME_BUFF;j++){
    if(*p == '\n' || *p == '\0') break;
    else if(*p == ':') {
      if(*nameleng < i) *nameleng = i;
      
      while(i<NAME_BUFF){
	Name[*num][i] = ' ';
	i++;
      }

      p++;
      i = 0;
      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  Seq[*num][i] = *p;
	  p++;
	  i++;
	}
      }
      
      Leng[*num] = i;
      
      (*num)++;
      
      a = 1;
      break;
    } 
    else {
      Name[*num][i] = *p;
      i++;
      p++;
    }
  }
  return a;
}


void
keep_memory_apdp_s(data,buffsn,buffsl)
DATA *data;
int buffsn,buffsl;
{
  int k;
  char *calloc();

  if( ( data->Seq = (char **)calloc( buffsn, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq\n"); exit(0);
  }
  for(k=0;k<buffsn;k++){
    if( ( data->Seq[k] = calloc( buffsl, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit(0);
    }
  }
  
  if( ( data->Name = (char **)calloc( buffsn, sizeof(char *) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Seq\n"); exit(0);
  }
  for(k=0;k<buffsn;k++){
    if( ( data->Name[k] = calloc( NAME_BUFF, sizeof(char) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Seq\n"); exit(0);
    }
  }
  
  if( ( data->Leng = (int *)calloc( buffsn, sizeof(int) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Leng\n"); exit(0);
  }

}
