/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new18.h"

void 
keep_memory_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,buffx,buffy,NumX,NumY)
VEC **Vec0;
VEC **Vec1;
PATH_b **Path0;
PATH_b **Path1;
PROF **ProfI;
PROF **ProfJ;
int buffx,buffy,NumX,NumY;
{
  int i;
  char *calloc();

  
  if( ( *ProfI = ( PROF * )calloc( buffx, sizeof(PROF) ) ) == NULL ){
    fprintf(stderr,"calloc failed for ProfI\n"); exit(0);
  }
  if( ( *ProfJ = ( PROF * )calloc( buffy, sizeof(PROF) ) ) == NULL ){
    fprintf(stderr,"calloc failed for ProfJ\n"); exit(0);
  }

  for(i=0;i<buffx;i++){
    if( ( (*ProfI+i)->amigap = ( int * )calloc( NumX, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfI->amigap\n"); exit(0);
    }
    if( ( (*ProfI+i)->amigapp = ( int * )calloc( NumX, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfI->amigapp\n"); exit(0);
    }
    if( ( (*ProfI+i)->gap = ( int * )calloc( NumX, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfI->gap\n"); exit(0);
    }
    if( ( (*ProfI+i)->gapp = ( int * )calloc( NumX, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfI->gapp\n"); exit(0);
    }
  }

  for(i=0;i<buffy;i++){
    if( ( (*ProfJ+i)->amigap = ( int * )calloc( NumY, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfJ->amigap\n"); exit(0);
    }
    if( ( (*ProfJ+i)->amigapp = ( int * )calloc( NumY, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfJ->amigapp\n"); exit(0);
    }
    if( ( (*ProfJ+i)->gap = ( int * )calloc( NumY, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfJ->gap\n"); exit(0);
    }
    if( ( (*ProfJ+i)->gapp = ( int * )calloc( NumY, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfJ->gapp\n"); exit(0);
    }
  }

  if( ( *Vec0 = ( VEC * )calloc( buffx, sizeof(VEC) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Vec0\n"); exit(0);
  }
  if( ( *Vec1 = ( VEC * )calloc( buffx, sizeof(VEC) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Vec1\n"); exit(0);
  }

  if( ( *Path0 = ( PATH_b * )calloc( buffx, sizeof(PATH_b) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Path0\n"); exit(0);
  }
  if( ( *Path1 = ( PATH_b * )calloc( buffx, sizeof(PATH_b) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Path1\n"); exit(0);
  }

  for(i=0;i<buffx;i++){
    if( ( (*Path0+i)->gapx.gapi.gap = ( int * )calloc( buffy, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path0->gapx.gapi.gap\n"); exit(0);
    }
    if( ( (*Path0+i)->gapx.gapj.gap = ( int * )calloc( buffx, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path0->gapx.gapj.gap\n"); exit(0);
    }
    if( ( (*Path0+i)->gapxy.gapi.gap = ( int * )calloc( buffy, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path0->gapxy.gapi.gap\n"); exit(0);
    }
    if( ( (*Path0+i)->gapxy.gapj.gap = ( int * )calloc( buffx, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path0->gapxy.gapj.gap\n"); exit(0);
    }
    if( ( (*Path0+i)->gapy.gapi.gap = ( int * )calloc( buffy, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path0->gapy.gapi.gap\n"); exit(0);
    }
    if( ( (*Path0+i)->gapy.gapj.gap = ( int * )calloc( buffx, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path0->gapy.gapj.gap\n"); exit(0);
    }
    
    if( ( (*Path1+i)->gapx.gapi.gap = ( int * )calloc( buffy, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path1->gapx.gapi.gap\n"); exit(0);
    }
    if( ( (*Path1+i)->gapx.gapj.gap = ( int * )calloc( buffx, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path1->gapx.gapj.gap\n"); exit(0);
    }
    if( ( (*Path1+i)->gapxy.gapi.gap = ( int * )calloc( buffy, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path1->gapxy.gapi.gap\n"); exit(0);
    }
    if( ( (*Path1+i)->gapxy.gapj.gap = ( int * )calloc( buffx, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path1->gapxy.gapj.gap\n"); exit(0);
    }
    if( ( (*Path1+i)->gapy.gapi.gap = ( int * )calloc( buffy, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path1->gapy.gapi.gap\n"); exit(0);
    }
    if( ( (*Path1+i)->gapy.gapj.gap = ( int * )calloc( buffx, sizeof(int) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path1->gapy.gapj.gap\n"); exit(0);
    }

  }

}


void 
free_memory_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,buffx,buffy)
VEC *Vec0;
VEC *Vec1;
PATH_b *Path0;
PATH_b *Path1;
PROF *ProfI;
PROF *ProfJ;
int buffx,buffy;
{
  int i;

  free(Vec0);
  free(Vec1);

  for(i=0;i<buffx;i++){
    free((Path0+i)->gapx.gapi.gap);
    free((Path0+i)->gapx.gapj.gap);
    free((Path0+i)->gapxy.gapi.gap);
    free((Path0+i)->gapxy.gapj.gap);
    free((Path0+i)->gapy.gapi.gap);
    free((Path0+i)->gapy.gapj.gap);
    
    free((Path1+i)->gapx.gapi.gap);
    free((Path1+i)->gapx.gapj.gap);
    free((Path1+i)->gapxy.gapi.gap);
    free((Path1+i)->gapxy.gapj.gap);
    free((Path1+i)->gapy.gapi.gap);
    free((Path1+i)->gapy.gapj.gap);
  }
  free(Path0);
  free(Path1);

  for(i=0;i<buffx;i++){
    free((ProfI+i)->amigap);
    free((ProfI+i)->amigapp);
    free((ProfI+i)->gap);
    free((ProfI+i)->gapp);
  }
  for(i=0;i<buffy;i++){
    free((ProfJ+i)->amigap);
    free((ProfJ+i)->amigapp);
    free((ProfJ+i)->gap);
    free((ProfJ+i)->gapp);
  }
  free(ProfI);
  free(ProfJ);

}
