/* ---------------------------------------------------------- 
%   (C)1994 Institute for New Generation Computer Technology 
%       (Read COPYRIGHT for detailed information.) 
----------------------------------------------------------- */
#include "2dp_new18.h"

extern int Dmatrix[26][26];

void 
readFile(flag,algo)
int flag,algo;
{
  int num,MaxLeng;
  char Buff[MAXBUFF+1];

  PARAM1 pa1;

  DATA data;

  extern void readPara();
  extern void readGapCost();
  int readSeq();
  extern void keep_memory();
  void align();

  MaxLeng = 0;
  for(;;){
    fgets(Buff,MAXBUFF,stdin);
    if(strncmp(Buff,"End of readSeq",14) == 0) break;
    else if(strncmp(Buff,"CutM=",5) == 0) readPara(&Buff[5],MAXBUFF-5,&(pa1.CutM));
    else if(strncmp(Buff,"CutI=",5) == 0) readPara(&Buff[5],MAXBUFF-5,&(pa1.CutI));
    else if(strncmp(Buff,"U,V,S=",6) == 0) readGapCost(&Buff[6],MAXBUFF-6,&(pa1.U),&(pa1.V),&(pa1.S));
    else if(strncmp(Buff,"MFlag=",6) == 0) readPara(&Buff[6],MAXBUFF-6,&(pa1.MFlag));
    else if(strncmp(Buff,"SeqNum=",7) == 0) readPara(&Buff[7],MAXBUFF-7,&(pa1.SeqNum));
    else if(strncmp(Buff,"MaxLeng=",8) == 0) readPara(&Buff[8],MAXBUFF-8,&MaxLeng);
    else if(strncmp(Buff,"Seq=",4) == 0) {
      if(pa1.SeqNum == 0){
	fprintf(stderr,"\n!!! Illegal Format. SeqNum= expected !!!\n"); exit();
      }
      if(MaxLeng == 0){
	fprintf(stderr,"\n!!! Illegal Format. MaxLeng= expected !!!\n"); exit();
      }

      keep_memory(&data,pa1.SeqNum,MaxLeng);

      num = 0;
      pa1.nameleng = 0;
      for(;;){
	fgets(Buff,MAXBUFF,stdin);
	if( readSeq(&Buff[0],&num,&(pa1.nameleng),
		    data.Seq,data.Name,data.Leng,data.Num,data.NumVec) == 0 ) break;
      }
      fprintf(stderr,"\nEnd readSeq\n");
    }
    else {}
  }
  fprintf(stderr,"\nEnd readFile\n\n");

  align(&pa1,&data,flag,algo);

}


int 
readSeq(p,num,nameleng,Seq,Name,Leng,Num,NumVec)
char *p;
int *num,*nameleng;
char **Seq,**Name;
int *Leng,*Num,**NumVec;
{
  int  i,a=1;

  i=0;
  for(;;){
    if(*p == '\n' || *p == '\0') {
      a = 0;
      break;
    }
    else if(*p == ':') {
      if(*nameleng < i) *nameleng = i;
      
      while(i<NAME_BUFF){
	Name[*num][i] = ' ';
	i++;
      }

      p++;
      i = 0;
      while(*p != '\n' && *p != '\0'){
	if(*p == ' ' || *p == '\t')  p++;
	else{
	  Seq[*num][i] = *p;
	  p++;
	  i++;
	}
      }
      
      Leng[*num] = i;
      Num[*num] = 1;
      NumVec[*num][0] = *num;
      
      (*num)++;
      
      a = 1;
      break;
    } 
    else {
      Name[*num][i] = *p;
      i++;
      p++;
    }
  }
  return a;
}


void 
align(pa1,data,flag,algo)
PARAM1 *pa1;
DATA *data;
int flag,algo;
{
  int i,j;
  long energy;
  int R1,R2;
  int Leng0;

  void putMatrix();
  void minimumCost();
  void munson();
  void makeAlignmentString();
  long makeEnergy();

  if(flag != 3) {
    fprintf(stdout," Seq=\n");
    for(i=0;i<pa1->SeqNum;i++){
      fprintf(stdout," ");
      for(j=0;j<pa1->nameleng;j++){
	fprintf(stdout,"%c",data->Name[i][j]);
      }
      fprintf(stdout,":");
      for(j=0;j<data->Leng[i];j++){
	fprintf(stdout,"%c",data->Seq[i][j]);
      }
      fprintf(stdout,"\n");
    }
    fflush(stdout);
  }
    
  fprintf(stdout,"\n CutM=%d\n",pa1->CutM);
  fprintf(stdout," CutI=%d\n",pa1->CutI);
  fprintf(stdout," U,V,S=%d,%d,%d\n",pa1->U,pa1->V,pa1->S);
  fprintf(stdout," MFlag=%d\n\n",pa1->MFlag);
  fprintf(stderr,"MFlag=%d\n",pa1->MFlag);
  fprintf(stderr,"SeqNum=%d\n\n",pa1->SeqNum);
  fflush(stdout);
  fflush(stderr);
  
  putMatrix(data->Matrix,pa1->MFlag,pa1->SeqNum);

  for(i = 0 ; i < pa1->SeqNum - 1 ; i++){
    fprintf(stderr,"STEP %d\n",i);
    fprintf(stdout," STEP %d\n",i);
    minimumCost(pa1,data,&R1,&R2,flag,algo);
    fflush(stderr);
    fflush(stdout);
    if(algo == 2 || algo == 3) {
      fprintf(stderr,"RIA START .....\n");
      fprintf(stdout,"\n RIA START .....\n");
      munson(pa1,data,R1,flag,algo);
      fprintf(stderr,"RIA END .....\n\n");
      fprintf(stdout,"\n RIA END .....\n\n");
      fflush(stderr);
      fflush(stdout);
    }
    else {
      fprintf(stderr,"\n");
      fprintf(stdout,"\n");
    }      
  }

  if(algo == 4){
  }
  else{
    Leng0 = data->Leng[0];
    makeAlignmentString(data->Seq,data->Name,pa1->SeqNum,Leng0,pa1->nameleng);
    energy = makeEnergy(data->Seq,pa1->SeqNum,Leng0,pa1->U,pa1->V,pa1->S);
    fprintf(stderr,"\nResult = %d\n",energy);
    fprintf(stdout,"\n Result = %d\n",energy);
  }    
  fflush(stderr);
  fflush(stdout);
}


void 
putMatrix(Matrix,MFlag,SeqNum)
long **Matrix;
int MFlag;
int SeqNum;
{
  int i,j;
  char Buff[MAXBUFF+1];

  long readDisMatrix();

  for(;;){
    fgets(Buff,MAXBUFF,stdin);
    if(strncmp(Buff,"END",3) == 0) break;
    else if(strncmp(Buff,"ID1",3) == 0) {
      for(i=0;i<SeqNum;i++) {
	for(j=i+1;j<SeqNum;j++) {
	  fgets(Buff,MAXBUFF,stdin);
	  switch(MFlag)
	    {
	    case 1:Matrix[j][i] = readDisMatrix(&Buff[27],7);break;
	    case 2:Matrix[j][i] = -readDisMatrix(&Buff[34],5);break;
	    case 3:Matrix[j][i] = readDisMatrix(&Buff[39],5);break;
	    case 4:Matrix[j][i] = -readDisMatrix(&Buff[44],8);break;
	    default: printf("MFlag Error\n"); exit();
	    }
	}
      }
      break;
    }
    else continue;
  }
}


long 
readDisMatrix(p,leng)
char *p;
int leng;
{
  int  i,k = 0;
  char dest[10];
  long num;

  double atof();

  for(i=0;i<leng;++i){
    if(*p == ' ' || *p == '\t') p++;
    else if(*p == '-' || *p == '+' || isdigit(*p))  dest[k++] = *p++;
    else{
      fprintf(stderr,"Illegal Format in readDisMatrix\n"); exit();
    }
  }

  dest[k] = 0;
  num = (long)atof(dest);

/*  fprintf(stderr,"%d\n",num);*/

  return  num;
}


void 
minimumCost(pa1,data,R1,R2,flag,algo)
PARAM1 *pa1;
DATA *data;
int *R1,*R2,flag,algo;
{
  int i,j,m;
  long newcost,oldcost,cost=100000000;

  PARAM2 pa2;

  extern void gdp_1_s();
  extern void gdp_1_b();

  for(j=0;j<pa1->SeqNum;j++){
    for(i=j+1;i<pa1->SeqNum;i++){
      newcost = data->Matrix[i][j];
      if(newcost < cost){
	cost = newcost;
	*R1 = j;
	*R2 = i;
      }
    }
  }

  pa2.X = data->Leng[*R2];
  pa2.Y = data->Leng[*R1];
  fprintf(stderr,"X=%d,Y=%d  ",pa2.X,pa2.Y);
  fprintf(stdout," X=%d,Y=%d  ",pa2.X,pa2.Y);
  
  pa2.NumX = data->Num[*R2];
  pa2.NumY = data->Num[*R1];
  fprintf(stderr,"NumX=%d,NumY=%d  ",pa2.NumX,pa2.NumY);
  fprintf(stdout,"NumX=%d,NumY=%d  ",pa2.NumX,pa2.NumY);
    
  if(algo == 4){
    fprintf(stderr,"\nSeq1 = ");
    fprintf(stdout," \nSeq1 = ");
    for(i=0;i<pa2.NumX;i++){
      m = data->NumVec[*R2][i];
      fprintf(stderr,"%d,",m);
      fprintf(stdout,"%d,",m);
    }
    fprintf(stderr,"\nSeq2 = ");
    fprintf(stdout,"\n Seq2 = ");
    for(i=0;i<pa2.NumY;i++){
      m = data->NumVec[*R1][i];
      fprintf(stderr,"%d,",m);
      fprintf(stdout,"%d,",m);
    }
    fprintf(stderr,"\n");
    fprintf(stdout,"\n");
    fflush(stderr);
    fflush(stdout);
  }
  else{
    if( pa2.NumX * pa2.NumY <= 15 ){
      fprintf(stderr,"using gdp_s\n");
      fprintf(stdout,"using gdp_s\n");
      gdp_1_s(pa1,&pa2,*R1,*R2,data->Seq,data->Leng,data->NumVec,flag);
    }
    else{
      fprintf(stderr,"using gdp_b\n");
      fprintf(stdout,"using gdp_b\n");
      gdp_1_b(pa1,&pa2,*R1,*R2,data->Seq,data->Leng,data->NumVec,flag);
    }
  }

  for(j=0;j<*R1;j++){
    oldcost = data->Matrix[*R1][j];
    data->Matrix[*R1][j] = ( data->Matrix[*R2][j] + oldcost ) / 2;
  }
  for(i=*R1+1;i<*R2;i++){
    oldcost = data->Matrix[i][*R1];
    data->Matrix[i][*R1] = ( data->Matrix[*R2][i] + oldcost ) / 2;
  }
  for(i=*R2+1;i<pa1->SeqNum;i++){
    oldcost = data->Matrix[i][*R1];
    data->Matrix[i][*R1] = ( data->Matrix[i][*R2] + oldcost ) / 2;
  }
  
  for(i=0;i<*R2;i++){
    data->Matrix[*R2][i] = 1000000000;
  }
  
  for(i=*R2+1;i<pa1->SeqNum;i++){
    data->Matrix[i][*R2] = 1000000000;
  }
  
  data->Num[*R1] = pa2.NumX + pa2.NumY;
  data->Num[*R2] = 0;
  
  j = pa2.NumY;
  for(i=0;i<pa2.NumX;i++){
    data->NumVec[*R1][j] = data->NumVec[*R2][i];
    j++;
  }
}


void 
munson(pa1,data,R1,flag,algo)
PARAM1 *pa1;
DATA *data;
int R1,flag,algo;
{
  int i,j,k,m,ST;
  long energy,oldenergy;
  int NumXY;

  PARAM2 pa2;

  long makeEnergy1();
  extern void gdp_2_s();
  extern void gdp_2_b();

  char *calloc();

  NumXY = data->Num[R1];
  pa2.NumX = 1;
  pa2.NumY = NumXY - 1;

  pa2.X = pa2.Y = data->Leng[R1];

  oldenergy = makeEnergy1(data->Seq,data->NumVec,pa2.X,NumXY,R1,pa1->U,pa1->V,pa1->S);

  if( ( data->OSeq = (char **)calloc( pa1->SeqNum, sizeof(char *) ) ) == NULL){
    fprintf(stderr,"calloc failed for OSeq\n"); exit(0);
  }

  for(i=0;i<NumXY;i++){
    m = data->NumVec[R1][i];

    if( ( data->OSeq[m] = calloc( pa2.X, sizeof(char) ) ) == NULL){
      fprintf(stderr,"calloc failed for OSeq\n"); exit(0);
    }

    for(j=0;j<pa2.X;j++){
      data->OSeq[m][j] = data->Seq[m][j];
    }
  }

  ST = 0;  

  for(;;){
    ST++;
    fprintf(stderr,"STEP:%d  ",ST);
    fflush(stderr);

    if( pa2.NumX * pa2.NumY <= 15 ){
      fprintf(stderr,"using gdp_s  ");
      fprintf(stdout,"\n using gdp_s\n");
      gdp_2_s(pa1,&pa2,R1,data->OSeq,data->NumVec);
    }
    else{
      fprintf(stderr,"using gdp_b  ");
      fprintf(stdout,"\n using gdp_b\n");
      gdp_2_b(pa1,&pa2,R1,data->OSeq,data->NumVec);
    }
    fprintf(stderr,"\n");

    energy = makeEnergy1(data->OSeq,data->NumVec,pa2.X,NumXY,R1,pa1->U,pa1->V,pa1->S);

    if(energy < oldenergy){
      fprintf(stdout," ST:%d ",ST);
      if(flag == 2) fprintf(stdout,"\n");
      oldenergy = energy;
      data->Leng[R1] = pa2.X;

      for(i=0;i<NumXY;i++){
	m = data->NumVec[R1][i];
	free((char *)(data->Seq[m]));
      }

      for(i=0;i<NumXY;i++){
	m = data->NumVec[R1][i];
	if( ( data->Seq[m] = calloc(data->Leng[R1], sizeof(char) ) ) == NULL){
	  fprintf(stderr,"calloc failed for Seq\n"); exit(0);
	}
      }

      for(i=0;i<NumXY;i++){
	m = data->NumVec[R1][i];
	if(flag == 2) fprintf(stdout," ");
	for(k=0;k<data->Leng[R1];k++){
	  data->Seq[m][k] = data->OSeq[m][k];
	  if(flag == 2) fprintf(stdout,"%c",data->Seq[m][k]);
	}
	if(flag == 2) fprintf(stdout,"\n");
      }
      fprintf(stdout," Energy = %d\n",energy);
      fflush(stdout);
    }
    else {
      if(flag == 1) {
	for(i=0;i<NumXY;i++){
	  m = data->NumVec[R1][i];
	  fprintf(stdout," ");
	  for(k=0;k<data->Leng[R1];k++){
	    fprintf(stdout,"%c",data->Seq[m][k]);
	  }
	  fprintf(stdout,"\n");
	}
      }
      fprintf(stdout," Energy = %d\n",oldenergy);
      fflush(stdout);
      break;
    }
    
    if(algo == 2) break;

  }

  for(i=0;i<NumXY;i++){
    m = data->NumVec[R1][i];
    free(data->OSeq[m]);
  }
  free(data->OSeq);

}


long 
makeEnergy1(Seq,NumVec,X,Num,R1,U,V,S)
char **Seq;
int **NumVec;
int X,Num,R1,U,V,S;
{
  int i,j,k,K,m,mx,my;
  long energy=0;

  for(i=0;i<Num;i++){
    m = NumVec[R1][i];
    j = 0;
    while(Seq[m][j] == '-'){
      Seq[m][j] = '#';
      j++;
    }
    j = X - 1;
    while(Seq[m][j] == '-'){
      Seq[m][j] = '#';
      j--;
    }
  }

  for(i=0;i<Num;i++){
    mx = NumVec[R1][i];
    for(j=i+1;j<Num;j++){
      my = NumVec[R1][j];
      for(k=0;k<X;k++){
	if((Seq[mx][k] == '-' || Seq[mx][k] == '#') 
	   && (Seq[my][k] == '-' || Seq[my][k] == '#')) {}
	else if(Seq[mx][k] == '#' || Seq[my][k] == '#') energy += (long)S;
	else if(Seq[mx][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(Seq[mx][K] != '-'){
	      energy += (long)(U+V);
	      break;
	    }
	    else if(Seq[my][K] != '-'){
	      energy += (long)V;
	      break;
	    }
	    else {}
	  }
	}
	else if(Seq[my][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(Seq[my][K] != '-'){
	      energy += (long)(U+V);
	      break;
	    }
	    else if(Seq[mx][K] != '-'){
	      energy += (long)V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += (long)Dmatrix[Seq[mx][k] - 'A'][Seq[my][k] - 'A'];
	}
      }
    }
  }
  for(i=0;i<Num;i++){
    m = NumVec[R1][i];
    j = 0;
    while(Seq[m][j] == '#'){
      Seq[m][j] = '-';
      j++;
    }
    j = X - 1;
    while(Seq[m][j] == '#'){
      Seq[m][j] = '-';
      j--;
    }
  }
  return energy;
}


long 
makeEnergy(Seq,SeqNum,Leng0,U,V,S)
char **Seq;
int SeqNum,Leng0,U,V,S;
{
  int i,j,k,K;
  long energy=0;

  for(i=0;i<SeqNum;i++){
    j = 0;
    while(Seq[i][j] == '-'){
      Seq[i][j] = '#';
      j++;
    }
    j = Leng0-1;
    while(Seq[i][j] == '-'){
      Seq[i][j] = '#';
      j--;
    }
  }

  for(i=0;i<SeqNum;i++){
    for(j=i+1;j<SeqNum;j++){
      for(k=0;k<Leng0;k++){
	if((Seq[i][k] == '-' || Seq[i][k] == '#') 
	   && (Seq[j][k] == '-' || Seq[j][k] == '#')) {}
	else if(Seq[i][k] == '#' || Seq[j][k] == '#') energy += (long)S;
	else if(Seq[i][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(Seq[i][K] != '-'){
	      energy += (long)(U+V);
	      break;
	    }
	    else if(Seq[j][K] != '-'){
	      energy += (long)V;
	      break;
	    }
	    else {}
	  }
	}
	else if(Seq[j][k] == '-'){
	  K = k;
	  for(;;){
	    K--;
	    if(Seq[j][K] != '-'){
	      energy += (long)(U+V);
	      break;
	    }
	    else if(Seq[i][K] != '-'){
	      energy += (long)V;
	      break;
	    }
	    else {}
	  }
	}
	else{
	  energy += (long)Dmatrix[Seq[i][k] - 'A'][Seq[j][k] - 'A'];
	}
      }
    }
  }
  return energy;
}


void 
makeAlignmentString(Seq,Name,SeqNum,Leng0,nameleng)
char **Seq;
char **Name;
int SeqNum,Leng0,nameleng;
{
  int i,j;

  fprintf(stderr,"\nAlignmentSequences =\n\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stderr,"%c",Name[i][j]);
    }
    fprintf(stderr,":");
    for(j=0;j<Leng0;j++){
      fprintf(stderr,"%c",Seq[i][j]);
    }
    fprintf(stderr,"\n");
  }

  fprintf(stdout,"\n AlignmentSequences =\n\n");
  for(i=0;i<SeqNum;i++){
    for(j=0;j<nameleng;j++){
      fprintf(stdout,"%c",Name[i][j]);
    }
    fprintf(stdout,":");
    for(j=0;j<Leng0;j++){
      fprintf(stdout,"%c",Seq[i][j]);
    }
    fprintf(stdout,"\n");
  }
}
