/*----------------------------------------------------------------------

	ե̾	gavtg_iidwst.c
			ɡƥȡʸξ

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<stdio.h>

#include	<Xm/Text.h>

#include	"gavtg_iidwdef.h"

/*--------------------------------------------------------------------*/

#if	1
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

static int	dsplinecnt_iidw = 0;
static int	dspseqnum_iidw = 0;

/*--------------------------------------------------------------------*/

void
create_scrolledtext_iidw()
{
	extern Widget	st_iidw;
	extern Widget	fm_st_iidw;
	int		i;
	Arg		args[9];

	i = 0;
	XtSetArg(args[i], XmNcolumns, SCROLLEDTEXT_COLUMNS_IIDW);
	i++;
	XtSetArg(args[i], XmNrows, SCROLLEDTEXT_ROWS_IIDW);
	i++;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);
	i++;
/*
	XtSetArg(args[i], XmNscrollBarDisplayPolicy, XmAS_NEEDED);
	i++;
*/
	XtSetArg(args[i], XmNeditMode, XmMULTI_LINE_EDIT);
	i++;
	XtSetArg(args[i], XmNeditable, False);
	i++;
	XtSetArg(args[i], XmNcursorPositionVisible, False);
	i++;
/*
	XtSetArg(args[i], XmNscrollHorizontal, False);
	i++;
	XtSetArg(args[i], XmNwordWrap, True);
	i++;
	XtSetArg(args[i], XmNwidth, ST_WIDTH_IIDW);
	i++;
	XtSetArg(args[i], XmNheight, ST_HEIGHT_IIDW);
	i++;
*/
	st_iidw = XmCreateScrolledText(fm_st_iidw, "st_iidw", args, i);
	XtManageChild(st_iidw); 
}

/*--------------------------------------------------------------------*/

void
init_proc_iidw()
{
	extern Widget	st_iidw;

	XmTextSetString(st_iidw, "");
}

void
draw_proc_iidw()
{
	extern GAData	gadata_sf;
	extern int	genid_iidw;
	extern int	grpid_iidw;
	extern int	freqid_iidw;
	extern Widget	st_iidw;
	GenData		*gendata;
	GrpData		*grpdata;
	char		buffer[BUFSIZ];
	XmTextPosition	lpos;
	void		draw_proc_r_iidw();
	void		control_dspline_iidw();

	if ((gadata_sf.gendatamgr.gencnt <= 0    ||
	     gadata_sf.gendatamgr.gdipgencnt <= 0  ) ||
	    (genid_iidw <= 0 ||
	     grpid_iidw <= 0 ||
	     freqid_iidw <= 0  )                     )
		return;

	gendata = gadata_sf.gendatamgr.gendata + genid_iidw - 1;
	grpdata = gendata->grpdatamgr.grpdata + grpid_iidw - 1;
	if (grpdata->freqdatamgr.freqcnt <= 0)
		return;

	control_dspline_iidw(1);

	dspseqnum_iidw++;
	(void)sprintf(buffer,
		      "(%d) GENERATION:%d GROUPID:%c FREQID:%d (frequency %d)\n",
		      dspseqnum_iidw,
		      genid_iidw,
		      'A' + grpid_iidw - 1,
		      freqid_iidw,
		      (grpdata->freqdatamgr.freqdata+freqid_iidw-1)->frequency);
	lpos = XmTextGetLastPosition(st_iidw);
	XmTextReplace(st_iidw, lpos, lpos, buffer);

	draw_proc_r_iidw(grpdata->idvdatamgr.headdata, freqid_iidw);
}

static void
draw_proc_r_iidw(idvdata, freqid)
IdvData	*idvdata;
int	freqid;
{
	extern Widget	st_iidw;
	XmTextPosition	lpos;
	char		buffer[BUFSIZ];
	void		control_dspline_iidw();

	if (idvdata != (IdvData *)NULL) {
		if (idvdata->freqid == freqid) {
			control_dspline_iidw(4);
			(void)sprintf(buffer, "\tINDID:%d\n", idvdata->id);
			lpos = XmTextGetLastPosition(st_iidw);
			XmTextReplace(st_iidw, lpos, lpos, buffer);
			(void)sprintf(buffer, "\t\tSCORE:%d\n", idvdata->score);
			lpos = XmTextGetLastPosition(st_iidw);
			XmTextReplace(st_iidw, lpos, lpos, buffer);
			(void)sprintf(buffer, "\t\tLASTMIG:%d\n", idvdata->lastmig);
			lpos = XmTextGetLastPosition(st_iidw);
			XmTextReplace(st_iidw, lpos, lpos, buffer);
			(void)sprintf(buffer, "\t\tLASTX:%d\n", idvdata->lastx);
			lpos = XmTextGetLastPosition(st_iidw);
			XmTextReplace(st_iidw, lpos, lpos, buffer);
		}
		draw_proc_r_iidw(idvdata->nextdata, freqid);
	}
}

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
static void
control_dspline_iidw(line)
int	line;
{
	extern Widget	st_iidw;
	int		i;
	Arg		args[9];
	short		row;
	int		rows;
	int		next;
	int		diff;
	char		*value;
	char		*strchr_nth();
#ifdef	CHECK
	extern void	fatal_error();
#endif

	i = 0;
	XtSetArg(args[i], XmNrows, &row);
	i++;
	XtGetValues(st_iidw, args, i);

	rows = row * SCROLLEDTEXT_PAGE_IIDW;

#ifdef	DEBUG
	(void)printf("control_dspline_iidw --- line = %d\n", line);
	(void)printf("control_dspline_iidw --- rows = %d\n", rows);
#endif

	next = dsplinecnt_iidw + line;
	if (dsplinecnt_iidw < row) {
		if (next < row) {
			dsplinecnt_iidw = next;
		}
		else if (next < rows) {
			diff = next - (row - 1);
			XmTextScroll(st_iidw, diff);
			dsplinecnt_iidw = next;
		}
		else {
			diff = next - (rows - 1);
#ifdef	CHECK
			if (diff > rows)
				fatal_error("control_dspline_iidw",
					    "specified data too large (line = %d)\n",
					    line);
#endif
			dsplinecnt_iidw = rows - 1;
			value = XmTextGetString(st_iidw);
			if ((value = strchr_nth(value, '\n', diff)) != (char *)NULL) {
				value++;
				XmTextSetString(st_iidw, value);
			}
			else
				XmTextSetString(st_iidw, "");
/*
			lpos = XmTextGetLastPosition(st_iidw);
			XmTextShowPosition(st_iidw, lpos);
*/
			XmTextScroll(st_iidw, rows - row);
		}
	}
	else if (dsplinecnt_iidw < rows) {
		if (next < rows) {
			XmTextScroll(st_iidw, line);
			dsplinecnt_iidw = next;
		}
		else {
			diff = next - (rows - 1);
#ifdef	CHECK
			if (diff > rows)
				fatal_error("control_dspline_iidw",
					    "specified data too large (line = %d)\n",
					    line);
#endif
			dsplinecnt_iidw = rows - 1;
			value = XmTextGetString(st_iidw);
			if ((value = strchr_nth(value, '\n', diff)) != (char *)NULL) {
				value++;
				XmTextSetString(st_iidw, value);
			}
			else
				XmTextSetString(st_iidw, "");
/*
			lpos = XmTextGetLastPosition(st_iidw);
			XmTextShowPosition(st_iidw, lpos);
*/
			XmTextScroll(st_iidw, rows - row);
		}
	}
	else {
		diff = next - (rows - 1);
#ifdef	CHECK
		if (diff > rows)
			fatal_error("control_dspline_iidw",
				    "specified data too large (line = %d)\n",
				    line);
#endif
		value = XmTextGetString(st_iidw);
		if ((value = strchr_nth(value, '\n', diff)) != (char *)NULL) {
			value++;
			XmTextSetString(st_iidw, value);
		}
		else
			XmTextSetString(st_iidw, "");
/*
		lpos = XmTextGetLastPosition(st_iidw);
		XmTextShowPosition(st_iidw, lpos);
*/
		XmTextScroll(st_iidw, rows - row);
	}
}

/*--------------------------------------------------------------------*/

/* ---> utility */

static char *
strchr_nth(s, c, n)
char	*s;
char	c;
int	n;
{
	int	na;
	char	*p;

	na = 0;
	p = (char *)NULL;

	while (*s) {
		if (*s == c) {
			na++;
			if (na == n) {
				p = s;
				break;
			}
		}
		s++;
	}

	return p;
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
