/*----------------------------------------------------------------------

	ե̾	gavtg_iidwdialog.c
			ٹ𡢳ǧΤΥʸξ

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<varargs.h>
#include	<Xm/MessageB.h>

#include	"gavtg_iidwdef.h"

/*--------------------------------------------------------------------*/

#if	1
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

static Widget	warning_dialog = (Widget)NULL;
static Widget	confirm_dialog = (Widget)NULL;

/*--------------------------------------------------------------------*/

/*
  ٹΤΥ
*/

void
warning_dialog_iidw(va_alist)
va_dcl
{  
	va_list		args;
	char		str[BUFSIZ], *fmt;
	XmString	xms;
	int		i;
	Arg		wargs[2];
	Dimension	width, height;
	void		create_warning_dialog_iidw();

	if (warning_dialog == (Widget)NULL)
		create_warning_dialog_iidw();

	va_start(args);
	fmt = va_arg(args, char *);
	(void)vsprintf(str, fmt, args);
	va_end(args);

	xms = XmStringCreateLtoR(str, "warnchset");

	i = 0;
	XtSetArg(wargs[i], XmNmessageString, xms);
	i++;
	XtSetArg(wargs[i], XmNdialogStyle, XmDIALOG_SYSTEM_MODAL);
	i++;
	XtSetValues(warning_dialog, wargs, i);

	XmStringFree(xms);

	XtManageChild(warning_dialog);

	i = 0;
	XtSetArg(wargs[i], XmNwidth, &width);
	i++;
	XtSetArg(wargs[i], XmNheight, &height);
	i++;
	XtGetValues(warning_dialog, wargs, i);

	XWarpPointer(XtDisplay(warning_dialog),
			       None, XtWindow(warning_dialog),
			       0, 0, 0, 0,
			       width / 2, height / 2);
}

static void
create_warning_dialog_iidw()
{
	extern Widget	as_iidw;
	Widget		umc;

	warning_dialog = XmCreateWarningDialog(as_iidw, "Warning Dialog",
					       (Arg *)NULL, 0);

	umc = XmMessageBoxGetChild(warning_dialog, XmDIALOG_HELP_BUTTON);
	XtUnmanageChild(umc);

	umc = XmMessageBoxGetChild(warning_dialog, XmDIALOG_CANCEL_BUTTON);
	XtUnmanageChild(umc);
}

/*--------------------------------------------------------------------*/

/*
  ǧΤΥ
*/

void
confirm_dialog_iidw(va_alist)
va_dcl
{  
	va_list		args;
	char		str[BUFSIZ], *fmt;
	XmString	xms;
	int		i;
	Arg		wargs[3];
	Dimension	width, height;
	void		(*confirm_action)();
	caddr_t		client_data;
	Boolean		flag;
	Widget		w;
	void		create_confirm_dialog_iidw();

	if (confirm_dialog == (Widget)NULL)
		create_confirm_dialog_iidw();

	va_start(args);
	confirm_action = (void (*)())va_arg(args, void *);
	client_data = va_arg(args, caddr_t);
	flag = va_arg(args, int);     /* if True, OK button is default */
	fmt = va_arg(args, char *);
	(void)vsprintf(str, fmt, args);
	va_end(args);

	XtRemoveAllCallbacks(confirm_dialog, XmNcancelCallback);
	XtRemoveAllCallbacks(confirm_dialog, XmNokCallback);
	XtAddCallback(confirm_dialog, XmNokCallback, confirm_action, client_data);
	XtAddCallback(confirm_dialog, XmNcancelCallback, confirm_action, client_data);

	xms = XmStringCreateLtoR(str, "warnchset");

	if (flag == True)   /* ok is default button */
		w = XmMessageBoxGetChild(confirm_dialog, XmDIALOG_OK_BUTTON);
	else
		w = XmMessageBoxGetChild(confirm_dialog, XmDIALOG_CANCEL_BUTTON);

	i = 0;
	XtSetArg(wargs[i], XmNmessageString, xms);
	i++;
	XtSetArg(wargs[i], XmNdefaultButton, w);
	i++;
	XtSetArg(wargs[i], XmNdialogStyle, XmDIALOG_SYSTEM_MODAL);
	i++;
	XtSetValues(confirm_dialog, wargs, i);

	XmStringFree(xms);

	XtManageChild(confirm_dialog);

	i = 0;
	XtSetArg(wargs[i], XmNwidth, &width);
	i++;
	XtSetArg(wargs[i], XmNheight, &height);
	i++;
	XtGetValues(confirm_dialog, wargs, i);

	XWarpPointer(XtDisplay(confirm_dialog),
			       None, XtWindow(confirm_dialog),
			       0, 0, 0, 0,
			       width / 2, height / 2);
}

static void
create_confirm_dialog_iidw()
{
	extern Widget	as_iidw;
	Widget		umc;

	confirm_dialog = XmCreateQuestionDialog(as_iidw, "Confirm Dialog", (Arg *)NULL, 0);

	umc = XmMessageBoxGetChild(confirm_dialog, XmDIALOG_HELP_BUTTON);
	XtUnmanageChild(umc);
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
