/*----------------------------------------------------------------------

	ե̾	gavtg_idgwpickgf.c
			ηʬΤΥԥå󥰡ʸʬۥա

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<math.h>

#include	"gavtg_idgwdef.h"

/*--------------------------------------------------------------------*/

/* ---> gavtg_idgwdef.h */

#define	PICKGF_MODE_INIT_IDGW	0
#define	PICKGF_MODE_IIDW_IDGW	1
#define	PICKGF_MODE_ADW_IDGW	2

/*--------------------------------------------------------------------*/

static int	pickgf_mode = PICKGF_MODE_INIT_IDGW;	/* ʸ
							   ɽ
							   ⡼ */

static int	base_x = 0, base_y = 0;	/* ޥܥ󤬲줿
					   ΰ */

static int	grpid_tmp_iidw = 0;
static int	freqid_tmp_iidw = 0;

static int	grpid_tmp_adw = 0;

/*--------------------------------------------------------------------*/

#if	1
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

/*
  ޥܥ󤬲줿νԤ
*/

void
pickgf_proc_bp_idgw(event)
XButtonEvent	*event;	/* I:٥ */
{
	extern GAData		gadata_sf;
	extern IDGWDPMgr	idgwdpmgr_idgw;
	extern XFontStruct	*font20_idgw;
	extern int		genid_idgw;
	extern int		freqdvdcnt_idgw;
	int			xdiidwa, xdiidwb, ydiidwa, ydiidwb;
	int			xdadwa, xdadwb, ydadwa, ydadwb;
	int			an;
#ifdef	CHECK
	extern void		fatal_error();
#endif

#ifdef	DEBUG
	(void)printf("pickgf_proc_bp_idgw --- in\n");
	(void)printf("pickgf_proc_bp_idgw --- event->(x,y) = %d %d\n", event->x, event->y);
#endif

	if (gadata_sf.gendatamgr.gencnt <= 0 ||
	    gadata_sf.gendatamgr.gdipgencnt <= 0 ||
	    genid_idgw <= 0)
		return;

	/* ξθη٤λ */
	xdiidwa = *idgwdpmgr_idgw.gvwposx
		  + idgwdpmgr_idgw.margingvwleft
		  + idgwdpmgr_idgw.groupid
		  + idgwdpmgr_idgw.scaleaxisy
		  + idgwdpmgr_idgw.gapaxisy;
	xdiidwb = xdiidwa + idgwdpmgr_idgw.widthdvw;
	/* 饤Ȥθηλ */
	xdadwa = *idgwdpmgr_idgw.gvwposx
		 + idgwdpmgr_idgw.margingvwleft
		 +idgwdpmgr_idgw.fontwidth;
	xdadwb = xdadwa + font20_idgw->max_bounds.width;
#ifdef	DEBUG
	(void)printf("pickgf_proc_bp_idgw --- xdiidwa, xdiidwb = %d %d\n", xdiidwa, xdiidwb);
	(void)printf("pickgf_proc_bp_idgw --- xdadwa, xdadwb = %d %d\n", xdadwa, xdadwb);
#endif
	/* ξθη٤λ */
	if (event->x >= xdiidwa && event->x <= xdiidwb) {
		an = (event->y - *idgwdpmgr_idgw.gvwposy) / idgwdpmgr_idgw.heightgvw;
#ifdef	DEBUG
		(void)printf("pickgf_proc_bp_idgw --- an = %d\n", an);
#endif
		if (an >= 0 && an < idgwdpmgr_idgw.gvwcnt) {
			ydiidwa = *(idgwdpmgr_idgw.gvwposy+an)
				  + idgwdpmgr_idgw.margingvwtop
				  + idgwdpmgr_idgw.poweraxisy;
			ydiidwb = ydiidwa + idgwdpmgr_idgw.heightdvw;
#ifdef	DEBUG
			(void)printf("pickgf_proc_bp_idgw --- ydiidwa, ydiidwb = %d %d\n",
				     ydiidwa, ydiidwb);
#endif
			if (event->y >= ydiidwa && event->y <= ydiidwb) {
				base_x = event->x;
				base_y = event->y;
				grpid_tmp_iidw = an + 1;
				freqid_tmp_iidw = (int)(
							(float)(event->x - xdiidwa)
							/ (float)idgwdpmgr_idgw.widthdvw
							* (float)freqdvdcnt_idgw
						       )
						   + 1;
				if (freqid_tmp_iidw <= 0)
					freqid_tmp_iidw = 1;
				if (freqid_tmp_iidw > freqdvdcnt_idgw)
					freqid_tmp_iidw = freqdvdcnt_idgw;
				pickgf_mode = PICKGF_MODE_IIDW_IDGW;
			}
		}
#ifdef	DEBUG
(void)printf("pickgf_proc_bp_idgw --- genid_idgw, grpid_tmp_iidw, freqid_tmp_iidw = %d %d %d\n",
	     genid_idgw, grpid_tmp_iidw, freqid_tmp_iidw);
#endif
	}
	/* 饤Ȥθηλ */
	else if (event->x >= xdadwa && event->x <= xdadwb) {
		an = (event->y - *idgwdpmgr_idgw.gvwposy) / idgwdpmgr_idgw.heightgvw;
#ifdef	DEBUG
		(void)printf("pickgf_proc_bp_idgw --- an = %d\n", an);
#endif
		if (an >= 0 && an < idgwdpmgr_idgw.gvwcnt) {
			ydadwa = *(idgwdpmgr_idgw.gvwposy+an)
				 + idgwdpmgr_idgw.margingvwtop
				 + idgwdpmgr_idgw.fontheight;
			ydadwb = ydadwa + (font20_idgw->ascent + font20_idgw->descent);
			if (event->y >= ydadwa && event->y <= ydadwb) {
				base_x = event->x;
				base_y = event->y;
				grpid_tmp_adw = an + 1;
				pickgf_mode = PICKGF_MODE_ADW_IDGW;
			}
		}
#ifdef	DEBUG
(void)printf("pickgf_proc_bp_idgw --- genid_idgw, grpid_tmp_adw = %d %d \n",
	     genid_idgw, grpid_tmp_adw);
#endif
	}

}

/*
  ޥܥ줿νԤ
*/

void
pickgf_proc_br_idgw(event)
XButtonEvent	*event;	/* I:٥ */
{
	extern int	genid_idgw;
	extern int	genid_iidw;
	extern int	grpid_iidw;
	extern int	freqid_iidw;
	extern int	genid_adw;
	extern int	grpid_adw;
	extern int	winstatus_adw;
	extern void	display_window_iidw();
	extern void	draw_proc_iidw();
	extern void	display_window_adw();
	extern void	draw_proc_adw();

#ifdef	DEBUG
	(void)printf("pickgf_proc_br_idgw --- in\n");
#endif

	if (pickgf_mode == PICKGF_MODE_IIDW_IDGW) {
		if (event->x == base_x && event->y == base_y) {
			genid_iidw = genid_idgw;
			grpid_iidw = grpid_tmp_iidw;
			freqid_iidw = freqid_tmp_iidw;
			display_window_iidw();
			draw_proc_iidw();
#ifdef	DEBUG
(void)printf("pickgf_proc_br_idgw --- genid_iidw, grpid_iidw, freqid_iidw = %d %d %d\n",
	     genid_iidw, grpid_iidw, freqid_iidw);
#endif
		}
		base_x = 0;
		base_y = 0;
		grpid_tmp_iidw = 0;
		freqid_tmp_iidw = 0;
		pickgf_mode = PICKGF_MODE_INIT_IDGW;
	}
	else if (pickgf_mode == PICKGF_MODE_ADW_IDGW) {
		if (event->x == base_x && event->y == base_y) {
			genid_adw = genid_idgw;
			grpid_adw = grpid_tmp_adw;
			if (winstatus_adw)
				draw_proc_adw();
			else
				display_window_adw();
#ifdef	DEBUG
(void)printf("pickgf_proc_br_idgw --- genid_adw, grpid_adw = %d %d \n",
	     genid_adw, grpid_adw);
#endif
		}
		base_x = 0;
		base_y = 0;
		grpid_tmp_adw = 0;
		pickgf_mode = PICKGF_MODE_INIT_IDGW;
	}
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
