/*----------------------------------------------------------------------

	ե̾	gavtg_fgwview.c
			ɽ˴ؤŬ٥ա

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	"gavtg_fgwdef.h"

/*--------------------------------------------------------------------*/

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

void
view_full_proc_fgw()
{
	extern GAData	gadata_sf;
	extern int	sim_mode_fgw;
	extern void	set_gadatainf_sr_all();
	extern void	draw_proc_rl_full_fgw();
	extern void	set_dpmgr_full_fgw();
	extern void	draw_proc_fgw();
	extern void	set_sigblock_fgw();
	extern void	reset_sigblock_fgw();

#ifdef	DEBUG
	(void)printf("view_full_proc_fgw --- in\n");
#endif

	set_sigblock_fgw();

	if (gadata_sf.gendatamgr.gencnt > gadata_sf.gendatamgr.gdipgencnt) {
#ifdef	DEBUG
		(void)printf("view_full_proc_fgw --- gencnt > gdipgencnt\n");
#endif
		set_gadatainf_sr_all(gadata_sf.gendatamgr.gdipgencnt + 1,
				     gadata_sf.gendatamgr.gencnt);
		gadata_sf.gendatamgr.gdipgencnt = gadata_sf.gendatamgr.gencnt;
	}

#if	1
	if (sim_mode_fgw == SIM_MODE_RUN_FGW)
		draw_proc_rl_full_fgw();
	else {
		set_dpmgr_full_fgw();
		draw_proc_fgw();
	}
#else
	set_dpmgr_full_fgw();
	draw_proc_fgw();
#endif

	reset_sigblock_fgw();
}

/*--------------------------------------------------------------------*/

void
view_undo_proc_fgw()
{
	extern void	set_dparammgr_undo_fgw();
	extern void	draw_proc_fgw();
	extern void	set_sigblock_fgw();
	extern void	reset_sigblock_fgw();

#ifdef	DEBUG
	(void)printf("view_undo_proc_fgw --- in\n");
#endif

	set_sigblock_fgw();

	set_dparammgr_undo_fgw();

	draw_proc_fgw();

	reset_sigblock_fgw();
}

/*--------------------------------------------------------------------*/

void
view_refresh_proc_fgw()
{
	extern void	draw_proc_fgw();
	extern void	set_sigblock_fgw();
	extern void	reset_sigblock_fgw();

#ifdef	DEBUG
	(void)printf("view_refresh_proc_fgw --- in\n");
#endif

	set_sigblock_fgw();

	draw_proc_fgw();

	reset_sigblock_fgw();
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
