/*----------------------------------------------------------------------

	ե̾	gavtg_fgwsignal.c
			ʥŬ٥ա

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<signal.h>

#include	"gavtg_fgwdef.h"

/*--------------------------------------------------------------------*/

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

static int	sbflag_fgw = 0;
static int	oldmask_fgw;

/*--------------------------------------------------------------------*/

void
set_signal_fgw()
{
	extern int	errno;
	extern void	fatal_error();
	void		proc_sigusr1_fgw();

	if (signal(SIGUSR1, proc_sigusr1_fgw) == (void (*)())-1)
		fatal_error("set_signal_fgw",
			    "signal error (errno = %d)\n",
			    errno);
}

/*--------------------------------------------------------------------*/

static void
proc_sigusr1_fgw()
{
	extern int	sim_mode_fgw;
	extern int	scale_mode_fgw;
	extern int	pick_mode_fgw;
	extern GAData	gadata_sf;
	extern int	semid_gadatatmp;
	extern int	errno;
	int		status;
	extern void	lock_semaphore();
	extern int	read_gadatatmp();
	extern void	set_dctrl_flag_fgw();
	extern void	set_gadatainf_sr_all();
	extern void	draw_proc_rl_fgw();
	extern void	draw_proc_rl_end_fgw();
#if	0
	extern void	output_gadata();
#endif
	extern void	reset_semaphore_gadatatmp();
	extern void	fatal_error();
	void		proc_sigusr1_fgw();

#ifdef	DEBUG
	(void)printf("proc_sigusr1_fgw --- signal catching function\n");
#endif

	lock_semaphore(semid_gadatatmp, 1, 0);

	status = read_gadatatmp();

	if (status == 1) {
		set_dctrl_flag_fgw();
		if (signal(SIGUSR1, proc_sigusr1_fgw) == (void (*)())-1)
			fatal_error("proc_sigusr1_fgw",
				    "signal error (errno = %d)\n",
				    errno);
		lock_semaphore(semid_gadatatmp, 0, 1);
	}
	else if (status == 2) {
/*
		if (gadata_sf.gendatamgr.gencnt > 0) {
*/
			set_gadatainf_sr_all(gadata_sf.gendatamgr.gdipgencnt + 1,
					     gadata_sf.gendatamgr.gencnt);
			gadata_sf.gendatamgr.gdipgencnt = gadata_sf.gendatamgr.gencnt;
#if	0
/*
			if (gadata_sf.gendatamgr.gencnt == 2)
*/
				output_gadata_short("proc_sigusr1_fgw", &gadata_sf);
#endif
			draw_proc_rl_fgw();
/*
		}
*/
		if (signal(SIGUSR1, proc_sigusr1_fgw) == (void (*)())-1)
			fatal_error("proc_sigusr1_fgw",
				    "signal error (errno = %d)\n",
				    errno);
		lock_semaphore(semid_gadatatmp, 0, 1);
	}
	else {
		lock_semaphore(semid_gadatatmp, 0, 0);
		lock_semaphore(semid_gadatatmp, 0, 1);
		reset_semaphore_gadatatmp();
		sim_mode_fgw = SIM_MODE_STOP_FGW;
		draw_proc_rl_end_fgw();
#if	0
		output_gadata("proc_sigusr1_fgw", &gadata_sf);
#endif
	}
}

/*--------------------------------------------------------------------*/

void
set_sigblock_fgw()
{
/*
	extern void	fatal_error();
*/
	extern void	warning_message();

#ifdef	DEBUG
	(void)printf("set_sigblock_fgw --- in (sbflag_fgw, oldmask_fgw = %d %d)\n",
		     sbflag_fgw, oldmask_fgw);
#endif


	if (sbflag_fgw == 0) {
		oldmask_fgw = sigblock(sigmask(SIGUSR1));
		sbflag_fgw++;
#if	0
		(void)printf("set_sigblock_fgw --- sigmask(SIGUSR1) = %d)\n",
			     sigmask(SIGUSR1));
#endif
	}
	else if (sbflag_fgw > 0)
		sbflag_fgw++;
	else {
/*
		fatal_error("set_sigblock_fgw",
			    "illegal sbflag_fgw\n");
*/
		warning_message("set_sigblock_fgw",
				"illegal sbflag_fgw\n");
	}

#ifdef	DEBUG
	(void)printf("set_sigblock_fgw --- out (sbflag_fgw, oldmask_fgw = %d %d)\n",
		     sbflag_fgw, oldmask_fgw);
#endif
}

void
reset_sigblock_fgw()
{
#ifdef	DEBUG
	int	tmp;
#endif
/*
	extern void	fatal_error();
*/
	extern void	warning_message();

#ifdef	DEBUG
	(void)printf("reset_sigblock_fgw --- in (sbflag_fgw, oldmask_fgw = %d %d)\n",
		     sbflag_fgw, oldmask_fgw);
#endif

	if (sbflag_fgw == 1) {
		sbflag_fgw--;
		(void)sigsetmask(oldmask_fgw);
#if	0
		tmp = sigsetmask(oldmask_fgw);
		(void)printf("reset_sigblock_fgw --- tmp = %d\n", tmp);
#endif
	}
	else if (sbflag_fgw > 1)
		sbflag_fgw--;
	else {
/*
		fatal_error("reset_sigblock_fgw",
			    "illegal sbflag_fgw\n");
*/
		warning_message("reset_sigblock_fgw",
				"illegal sbflag_fgw\n");
	}

#ifdef	DEBUG
	(void)printf("reset_sigblock_fgw --- out (sbflag_fgw, oldmask_fgw = %d %d)\n",
		     sbflag_fgw, oldmask_fgw);
#endif
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
