/*----------------------------------------------------------------------

	ե̾	gavtg_fgwmenu.c
			˥塼Ŭ٥ա

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<Xm/RowColumn.h>
#include	<Xm/PushBG.h>
#include	<Xm/SeparatoG.h>
#include	<Xm/CascadeB.h>
#include	<Xm/CascadeBG.h>
#include	<Xm/ToggleBG.h>

#include	"gavtg_fgwdef.h"

/*--------------------------------------------------------------------*/

#if	1
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

extern void	file_open_proc_fgw();
extern void	file_exit_proc_fgw();

static MENU_ITEM	file_menu_fgw[] = {
				{"Open", &xmPushButtonGadgetClass, 'O',
				 (caddr_t)NULL, (caddr_t)NULL,
				 file_open_proc_fgw, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{"", &xmSeparatorGadgetClass, (char)NULL,
				 (caddr_t)NULL, (caddr_t)NULL,
				 (void (*)())NULL, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{"Exit", &xmPushButtonGadgetClass, 'E',
				 (caddr_t)NULL, (caddr_t)NULL,
				 file_exit_proc_fgw, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{NULL}
			};

extern void	sim_start_proc_fgw();

static MENU_ITEM	sim_menu_fgw[] = {
				{"Start", &xmPushButtonGadgetClass, 'S',
				 (caddr_t)NULL, (caddr_t)NULL,
				 sim_start_proc_fgw, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{NULL}
			};

extern void	view_full_proc_fgw();
extern void	view_undo_proc_fgw();
extern void	view_refresh_proc_fgw();

static MENU_ITEM	view_menu_fgw[] = {
				{"Full", &xmPushButtonGadgetClass, 'F',
				(caddr_t)NULL, (caddr_t)NULL,
				 view_full_proc_fgw, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{"", &xmSeparatorGadgetClass, (char)NULL,
				 (caddr_t)NULL, (caddr_t)NULL,
				 (void (*)())NULL, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{"Undo", &xmPushButtonGadgetClass, 'U',
				 (caddr_t)NULL, (caddr_t)NULL,
				 view_undo_proc_fgw, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{"", &xmSeparatorGadgetClass, (char)NULL,
				 (caddr_t)NULL, (caddr_t)NULL,
				 (void (*)())NULL, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{"Refresh", &xmPushButtonGadgetClass, 'R',
				 (caddr_t)NULL, (caddr_t)NULL,
				 view_refresh_proc_fgw, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{NULL}
			};

void	opt_esdir_proc_fgw();

static MENU_ITEM	esd_submenu_fgw[] = {
				{"X", &xmToggleButtonGadgetClass, 'X',
				 (caddr_t)NULL, (caddr_t)NULL,
			         opt_esdir_proc_fgw, (caddr_t)ESDIR_MODE_X_FGW,
				 (MENU_ITEM *)NULL, True,
				 False, XmONE_OF_MANY},
				{"Y", &xmToggleButtonGadgetClass, 'Y',
				 (caddr_t)NULL, (caddr_t)NULL,
				 opt_esdir_proc_fgw, (caddr_t)ESDIR_MODE_Y_FGW,
				 (MENU_ITEM *)NULL, True,
				 False, XmONE_OF_MANY},
				{"X And Y", &xmToggleButtonGadgetClass, 'A',
				 (caddr_t)NULL, (caddr_t)NULL,
				 opt_esdir_proc_fgw, (caddr_t)ESDIR_MODE_XAY_FGW,
				 (MENU_ITEM *)NULL, True,
				 True, XmONE_OF_MANY},
				{NULL}
			};

#if	0

void	opt_dspgrp_proc_fgw();

static MENU_ITEM	dspgrp_submenu_fgw[] = {
				{"A", &xmToggleButtonGadgetClass, 'A',
				 (caddr_t)NULL, (caddr_t)NULL,
			         opt_dspgrp_proc_fgw, (caddr_t)0,
				 (MENU_ITEM *)NULL, True,
				 True, XmONE_OF_MANY},
				{"B", &xmToggleButtonGadgetClass, 'B',
				 (caddr_t)NULL, (caddr_t)NULL,
				 opt_dspgrp_proc_fgw, (caddr_t)1,
				 (MENU_ITEM *)NULL, True,
				 True, XmONE_OF_MANY},
				{"C", &xmToggleButtonGadgetClass, 'C',
				 (caddr_t)NULL, (caddr_t)NULL,
				 opt_dspgrp_proc_fgw, (caddr_t)2,
				 (MENU_ITEM *)NULL, True,
				 True, XmONE_OF_MANY},
				{"D", &xmToggleButtonGadgetClass, 'D',
				 (caddr_t)NULL, (caddr_t)NULL,
				 opt_dspgrp_proc_fgw, (caddr_t)3,
				 (MENU_ITEM *)NULL, True,
				 True, XmONE_OF_MANY},
				{"All or Nothing", &xmToggleButtonGadgetClass, 'o',
				 (caddr_t)NULL, (caddr_t)NULL,
				 opt_dspgrp_proc_fgw, (caddr_t)GRPCNT_MAX,
				 (MENU_ITEM *)NULL, True,
				 True, XmONE_OF_MANY},
				{NULL}
			};
#endif

extern void	options_dctrl_proc_fgw();

static MENU_ITEM	options_menu_fgw[] = {
				{"Expand and Shrink Direction", &xmCascadeButtonGadgetClass, 'E',
				 (caddr_t)NULL, (caddr_t)NULL,
				 (void (*)())NULL, (caddr_t)NULL,
				 esd_submenu_fgw, True},
				{"", &xmSeparatorGadgetClass, (char)NULL,
				 (caddr_t)NULL, (caddr_t)NULL,
				 (void (*)())NULL, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{"Display Group", &xmPushButtonGadgetClass, 'D',
				 (caddr_t)NULL, (caddr_t)NULL,
				 options_dctrl_proc_fgw, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{NULL}
			};

extern void	test_proc_1_fgw();
extern void	test_proc_2_fgw();
extern void	test_proc_3_fgw();

static MENU_ITEM	test_menu_fgw[] = {
				{"Test1", &xmPushButtonGadgetClass, '1',
				 (caddr_t)NULL, (caddr_t)NULL,
				 test_proc_1_fgw, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{"", &xmSeparatorGadgetClass, NULL,
				 (caddr_t)NULL, (caddr_t)NULL,
				 (void (*)())NULL, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{"Test2", &xmPushButtonGadgetClass, '2',
				 (caddr_t)NULL, (caddr_t)NULL,
				 test_proc_2_fgw, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{"", &xmSeparatorGadgetClass, NULL,
				 (caddr_t)NULL, (caddr_t)NULL,
				 (void (*)())NULL, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{"Test3", &xmPushButtonGadgetClass, '3',
				 (caddr_t)NULL, (caddr_t)NULL,
				 test_proc_3_fgw, (caddr_t)NULL,
				 (MENU_ITEM *)NULL, True},
				{NULL}
			};

/*--------------------------------------------------------------------*/

/*
  ˥塼
*/

void
create_menu_fgw()
{
	extern Widget		mb_fgw;
	extern Widget		fm_mb_fgw;
	extern XFontStruct	*font_fgw;
	int			i;
	Arg			args[4];
	XmString		xms;
	Widget			helpcb;
	extern Widget		build_menu();
	void			help_proc_fgw();

	/* ˥塼С */

	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);
	i++;
	mb_fgw = XmCreateMenuBar(fm_mb_fgw, "mb_fgw", args, i);
	XtManageChild(mb_fgw);

	/* ե롦˥塼 */
	(void)build_menu(font_fgw, mb_fgw, XmMENU_PULLDOWN, "File", 'F', file_menu_fgw); 

	/* ߥ졼 */
	(void)build_menu(font_fgw, mb_fgw, XmMENU_PULLDOWN, "Simulation", 'S', sim_menu_fgw); 

	/* ӥ塼 */
	(void)build_menu(font_fgw, mb_fgw, XmMENU_PULLDOWN, "View", 'V', view_menu_fgw); 

	/* ץ */
	(void)build_menu(font_fgw, mb_fgw, XmMENU_PULLDOWN, "Options", 'O', options_menu_fgw); 

#if	0
	/* ƥ */
	(void)build_menu(font_fgw, mb_fgw, XmMENU_PULLDOWN, "Test", 'T', test_menu_fgw); 
#endif

	/* إס˥塼 */
	xms = XmStringCreate("Help", XmSTRING_DEFAULT_CHARSET); 
	i = 0;
	XtSetArg(args[i], XmNlabelString, xms);
	i++;
	XtSetArg(args[i], XmNmnemonic, 'H');
	i++;
	helpcb = XmCreateCascadeButton(mb_fgw, "helpcb", args, i);
	XtAddCallback(helpcb, XmNactivateCallback, help_proc_fgw, (caddr_t)NULL);
	XtManageChild(helpcb);

	i = 0;
	XtSetArg(args[i], XmNmenuHelpWidget, (XtArgVal)helpcb);
	i++;
	XtSetValues(mb_fgw, args, i);
}

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
static void
opt_esdir_proc_fgw(widget, clientdata, calldata)
Widget				widget;
caddr_t				clientdata;
XmToggleButtonCallbackStruct	*calldata;
{
	extern int	esdir_mode_fgw;
	extern void	fatal_error();

	esdir_mode_fgw = (int)clientdata;

	if (esdir_mode_fgw == ESDIR_MODE_X_FGW) {
		if (calldata->set) {
			XmToggleButtonSetState(esd_submenu_fgw[1].w, False, False);
			XmToggleButtonSetState(esd_submenu_fgw[2].w, False, False);
		}
		else
			XmToggleButtonSetState(esd_submenu_fgw[0].w, True, False);
	}
	else if (esdir_mode_fgw == ESDIR_MODE_Y_FGW) {
		if (calldata->set) {
			XmToggleButtonSetState(esd_submenu_fgw[0].w, False, False);
			XmToggleButtonSetState(esd_submenu_fgw[2].w, False, False);
		}
		else
			XmToggleButtonSetState(esd_submenu_fgw[1].w, True, False);
	}
	else if (esdir_mode_fgw == ESDIR_MODE_XAY_FGW) {
		if (calldata->set) {
			XmToggleButtonSetState(esd_submenu_fgw[0].w, False, False);
			XmToggleButtonSetState(esd_submenu_fgw[1].w, False, False);
		}
		else
			XmToggleButtonSetState(esd_submenu_fgw[2].w, True, False);
	}
	else
		fatal_error("opt_esdir_proc_fgw",
			    "illegal esdir_mode_fgw (%d)\n",
			    esdir_mode_fgw);
}

/*--------------------------------------------------------------------*/

#if	0

/*ARGSUSED*/
static void
opt_dspgrp_proc_fgw(widget, clientdata, calldata)
Widget				widget;
caddr_t				clientdata;
XmToggleButtonCallbackStruct	*calldata;
{
	extern int	dspgrp_flag_fgw[GRPCNT_MAX];
	extern GAData	gadata_sf;
	int		dspgrp;
	int		fvold, fv;
	int		i;
	extern void	fatal_error();
	extern void	draw_proc_fgw();
	extern void	set_sigblock_fgw();
	extern void	reset_sigblock_fgw();

	for (fvold = 0, i = 0; i < gadata_sf.initdata.grpcnt; i++)
		fvold += dspgrp_flag_fgw[i];

	dspgrp = (int)clientdata;

#ifdef	DEBUG
	(void)printf("dspgrp, calldata->set = %d %d\n",
		     dspgrp, calldata->set);
#endif

	if (dspgrp == 0) {
		dspgrp_flag_fgw[0] = calldata->set;
		for (fv = 0, i = 0; i < gadata_sf.initdata.grpcnt; i++)
			fv += dspgrp_flag_fgw[i];
		if (fv >= gadata_sf.initdata.grpcnt)
			XmToggleButtonSetState(dspgrp_submenu_fgw[GRPCNT_MAX].w,
					       True, False);
		else
			XmToggleButtonSetState(dspgrp_submenu_fgw[GRPCNT_MAX].w,
					       False, False);
	}
	else if (dspgrp == 1) {
		dspgrp_flag_fgw[1] = calldata->set;
		for (fv = 0, i = 0; i < gadata_sf.initdata.grpcnt; i++)
			fv += dspgrp_flag_fgw[i];
		if (fv >= gadata_sf.initdata.grpcnt)
			XmToggleButtonSetState(dspgrp_submenu_fgw[GRPCNT_MAX].w,
					       True, False);
		else
			XmToggleButtonSetState(dspgrp_submenu_fgw[GRPCNT_MAX].w,
					       False, False);
	}
	else if (dspgrp == 2) {
		dspgrp_flag_fgw[2] = calldata->set;
		for (fv = 0, i = 0; i < gadata_sf.initdata.grpcnt; i++)
			fv += dspgrp_flag_fgw[i];
		if (fv >= gadata_sf.initdata.grpcnt)
			XmToggleButtonSetState(dspgrp_submenu_fgw[GRPCNT_MAX].w,
					       True, False);
		else
			XmToggleButtonSetState(dspgrp_submenu_fgw[GRPCNT_MAX].w,
					       False, False);
	}
	else if (dspgrp == 3) {
		dspgrp_flag_fgw[3] = calldata->set;
		for (fv = 0, i = 0; i < gadata_sf.initdata.grpcnt; i++)
			fv += dspgrp_flag_fgw[i];
		if (fv >= gadata_sf.initdata.grpcnt)
			XmToggleButtonSetState(dspgrp_submenu_fgw[GRPCNT_MAX].w,
					       True, False);
		else
			XmToggleButtonSetState(dspgrp_submenu_fgw[GRPCNT_MAX].w,
					       False, False);
	}
	else if (dspgrp == GRPCNT_MAX) {
		for (i = 0; i < gadata_sf.initdata.grpcnt; i++)
			dspgrp_flag_fgw[i] = calldata->set;
		if (calldata->set) {
			fv = gadata_sf.initdata.grpcnt;
			for (i = 0; i < gadata_sf.initdata.grpcnt; i++)
				XmToggleButtonSetState(dspgrp_submenu_fgw[i].w,
						       True, False);
		}
		else {
			fv = 0;
			for (i = 0; i < gadata_sf.initdata.grpcnt; i++)
				XmToggleButtonSetState(dspgrp_submenu_fgw[i].w,
						       False, False);
		}
	}
	else
		fatal_error("opt_dspgrp_proc_fgw",
			    "illegal dspgrp_flag_fgw (%d)\n",
			    dspgrp_flag_fgw);

	if (fv != fvold) {
		set_sigblock_fgw();
		draw_proc_fgw();
		reset_sigblock_fgw();
	}
}

#endif

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
static void
help_proc_fgw(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata;
caddr_t	calldata;
{
#ifdef	DEBUG
	(void)printf("help_proc_fgw --- in\n");
#endif
}

/*--------------------------------------------------------------------*/

#if	0

void
set_dspgrp_menu_fgw()
{
	extern GAData	gadata_sf;
	extern int	dspgrp_flag_fgw[GRPCNT_MAX];
	int		i;

	for (i = 0; i < gadata_sf.initdata.grpcnt; i++) {
		XtManageChild(dspgrp_submenu_fgw[i].w);
		XmToggleButtonSetState(dspgrp_submenu_fgw[i].w, True, False);
		dspgrp_flag_fgw[i] = 1;
	}

	for (i = gadata_sf.initdata.grpcnt; i < GRPCNT_MAX; i++) {
		XtUnmanageChild(dspgrp_submenu_fgw[i].w);
		dspgrp_flag_fgw[i] = 1;
	}

	XmToggleButtonSetState(dspgrp_submenu_fgw[GRPCNT_MAX].w, True, False);
}

#endif

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
