/*----------------------------------------------------------------------

	ե̾	gavtg_fgwfile.c
			ե˴ؤŬ٥ա

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<string.h>

#include	<Xm/FileSB.h>
#include	<X11/cursorfont.h>

#include	"gavtg_fgwdef.h"

/*--------------------------------------------------------------------*/

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

static Widget	fsd_fgw = (Widget)NULL;

/*--------------------------------------------------------------------*/

void
file_open_proc_fgw()
{
	void	create_fsdialog_fgw();
	void	warp_pointer_fsd_fgw();

	if (fsd_fgw == (Widget)NULL)
		create_fsdialog_fgw();
	else {
	/* execute filter */
	}

	XtManageChild(fsd_fgw);

	warp_pointer_fsd_fgw();
}

static void
create_fsdialog_fgw()
{
	extern Widget	as_fgw;
	XmString	xms;
	int		i;
	Arg		args[2];
	void		ok_proc_fsd_fgw();
	void		cancel_proc_fsd_fgw();

	xms = XmStringCreate(FILENAME_REGEXP_TEXT, XmSTRING_DEFAULT_CHARSET); 

	i = 0;
	XtSetArg(args[i], XmNdirMask, xms);
	i++;
	XtSetArg(args[i], XmNdialogStyle, XmDIALOG_APPLICATION_MODAL);
	i++;
	fsd_fgw = XmCreateFileSelectionDialog(as_fgw, "Open", args, i);
	XtAddCallback(fsd_fgw, XmNokCallback, ok_proc_fsd_fgw, (caddr_t)NULL);
	XtAddCallback(fsd_fgw, XmNcancelCallback, cancel_proc_fsd_fgw, (caddr_t)NULL);

	XmStringFree(xms);
}

/*ARGSUSED*/
static void
ok_proc_fsd_fgw(widget, clientdata, calldata)
Widget					widget;
caddr_t					clientdata;
XmFileSelectionBoxCallbackStruct	*calldata;
{
	char		*pathname, *filename;
	Cursor		cursor;
	extern void	warning_dialog_fgw();
	extern void	erase_window_all();
	extern void	reset_setflag_dpmgr_fgw();
	extern void	reset_viewmode_dpmgr_fgw();
	extern void	read_gadata_all_text();
	extern void	set_gadatainf_all();
	extern void	set_dpmgr_full_fgw();
	extern void	set_dctrl_flag_fgw();

	XmStringGetLtoR(calldata->value, XmSTRING_DEFAULT_CHARSET, &pathname);
	if ((filename = strrchr(pathname, '/')) == (char *)NULL)
		filename = pathname;
	else
		filename++;
#ifdef	DEBUG
	(void)printf("ok_proc_fsd_fgw --- pathname = %s\n", pathname);
	(void)printf("ok_proc_fsd_fgw --- filename = %s\n", filename);
#endif
	if (strlen(filename) <= 0) {
		warning_dialog_fgw("File name is not specified.");
		return;
	}

	if (access(pathname, F_OK) != 0) {
		warning_dialog_fgw("File is not existent.");
		return;
	}

	if (access(pathname, R_OK) != 0) {
		warning_dialog_fgw("File read permission is denied.");
		return;
	}

	cursor = XCreateFontCursor(XtDisplay(widget), XC_watch);
	XDefineCursor(XtDisplay(widget), XtWindow(widget), cursor);
	XFlush(XtDisplay(widget));

	erase_window_all();
	reset_setflag_dpmgr_fgw();
	reset_viewmode_dpmgr_fgw();

	read_gadata_all_text(pathname);

	set_gadatainf_all();

	set_dpmgr_full_fgw();

	set_dctrl_flag_fgw();

	XUndefineCursor(XtDisplay(widget), XtWindow(widget));
	XFlush(XtDisplay(widget));
	XFreeCursor(XtDisplay(widget), cursor);

	XtUnmanageChild(widget); 
}

/*ARGSUSED*/
static void
cancel_proc_fsd_fgw(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata;
caddr_t	calldata;
{
	XtUnmanageChild(widget); 
}

static void
warp_pointer_fsd_fgw()
{
	int		i;
	Arg		args[2];
	Dimension	width, height;

	i = 0;
	XtSetArg(args[i], XmNwidth, &width);
	i++;
	XtSetArg(args[i], XmNheight, &height);
	i++;
	XtGetValues(fsd_fgw, args, i);

	XWarpPointer(XtDisplay(fsd_fgw),
		     None, XtWindow(fsd_fgw),
		     0, 0, 0, 0,
		     width / 2, height / 2);
}

/*--------------------------------------------------------------------*/

/*ARGSUSED*/
void
file_exit_proc_fgw(widget, clientdata, calldata)
Widget	widget;
caddr_t	clientdata;
caddr_t	calldata;
{
	extern void	confirm_dialog_fgw();
	void		confirm_exit_fgw();

#ifdef	DEBUG
	(void)printf("file_exit_proc_fgw --- in\n");
#endif

	confirm_dialog_fgw(confirm_exit_fgw, NULL, True,
			   "Are you sure you want to exit ?");
}

/*ARGSUSED*/
static void
confirm_exit_fgw(widget, clientdata, calldata)
Widget			widget;
caddr_t			clientdata;
XmAnyCallbackStruct	*calldata;
{
	extern Boolean	exit_flag;

#ifdef	DEBUG
	(void)printf("confirm_proc_exit --- in\n");
#endif

	if(calldata->reason == XmCR_OK)
		exit_flag = True;
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
