/*----------------------------------------------------------------------

	ե̾	gavtg_fgwda.c
			ɥ󥰡ꥢŬ٥ա

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<math.h>

#include	<Xm/DrawingA.h>

#include	"gavtg_fgwdef.h"

/*--------------------------------------------------------------------*/

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

static int	simstatus_strlen_fgw;

/*--------------------------------------------------------------------*/

void
create_drawingarea_fgw()
{
	extern Widget	da_fgw;
	extern Widget	fm_da_fgw;
	int		i;
	Arg		args[6];
	extern void	event_process_fgw();

	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNwidth, DA_WIDTH_FGW);
	i++;
	XtSetArg(args[i], XmNheight, DA_HEIGHT_FGW);
	i++;
	da_fgw = XmCreateDrawingArea(fm_da_fgw, "da_fgw", args, i);
	XtManageChild(da_fgw); 
	XtAddEventHandler(da_fgw, EV_MASK_FGW,
			  False, event_process_fgw, (caddr_t)NULL);
}

/*--------------------------------------------------------------------*/

void
draw_proc_fgw()
{
	extern int		sim_mode_fgw;
	extern DParamMgr	dparammgr_c_fgw;
	void			draw_proc_rl_start_fgw();
	void			draw_proc_normal_fgw();

	if (sim_mode_fgw == SIM_MODE_RUN_FGW &&
	    !dparammgr_c_fgw.setflag)
		draw_proc_rl_start_fgw();
	else
		draw_proc_normal_fgw();
}

/*--------------------------------------------------------------------*/

void
draw_proc_rl_start_fgw()
{
	extern Widget		da_fgw;
	extern GC		gc_da_bg_fgw;
	extern GC		gc_da_msg_fgw;
	extern DParamMgr	dparammgr_c_fgw;
	int			i;
	Arg			args[2];
	Dimension		width, height;

	i = 0;
	XtSetArg(args[i], XmNwidth, &width);
	i++;
	XtSetArg(args[i], XmNwidth, &height);
	i++;
	XtGetValues(da_fgw, args, i);

	XFillRectangle(XtDisplay(da_fgw), XtWindow(da_fgw), gc_da_bg_fgw,
		       0, 0, width, height);

	XDrawString(XtDisplay(da_fgw), XtWindow(da_fgw), gc_da_msg_fgw,
		    dparammgr_c_fgw.fontwidth,
		    dparammgr_c_fgw.fontheight + dparammgr_c_fgw.fontascent,
		    "Simulation has started.", 23);
	
}

void
draw_proc_rl_fgw()
{
	extern DParamMgr	dparammgr_c_fgw;
	extern GAData		gadata_sf;
/*
	int			udflag;
*/
	extern void		set_dpmgr_full_fgw();
	extern void		save_l_dpmgr_fgw();
	extern void		save_sfl_dpmgr_fgw();
	extern void		set_dpmgr_full_x_fgw();
	extern void		set_dpmgr_full_y_fgw();
	extern void		fatal_error();
	void			draw_proc_normal_fgw();
/*
	void			draw_proc_diff_fgw();
*/
	void			draw_proc_diff_2_fgw();
	void			redraw_simstatus_fgw();

	if (dparammgr_c_fgw.viewmode == VIEW_MODE_INIT_FGW) {
#if	0
		(void)printf("draw_proc_rl_fgw --- VIEW_MODE_INIT_FGW\n");
#endif
		set_dpmgr_full_fgw();
		save_sfl_dpmgr_fgw();
		draw_proc_normal_fgw();
#if	0
output_dparammgr_fgw("draw_proc_rl_fgw (INIT)", &dparammgr_c_fgw);
#endif
	}
	else if (dparammgr_c_fgw.viewmode == VIEW_MODE_FULL_FGW) {
#if	0
		(void)printf("draw_proc_rl_fgw --- VIEW_MODE_FULL_FGW\n");
#endif

		if (dparammgr_c_fgw.xacend < gadata_sf.gendatamgr.gdipgencnt) {
			set_dpmgr_full_x_fgw();
			if (gadata_sf.gendatamgr.scoremin < dparammgr_c_fgw.yaminimum ||
			    gadata_sf.gendatamgr.scoremax > dparammgr_c_fgw.yamaximum)
				set_dpmgr_full_y_fgw();
			save_l_dpmgr_fgw();
			save_sfl_dpmgr_fgw();
			draw_proc_normal_fgw();
		}
		else {
			if (gadata_sf.gendatamgr.scoremin < dparammgr_c_fgw.yaminimum ||
			    gadata_sf.gendatamgr.scoremax > dparammgr_c_fgw.yamaximum) {
				dparammgr_c_fgw.dpcend = gadata_sf.gendatamgr.gdipgencnt;
				set_dpmgr_full_y_fgw();
				save_l_dpmgr_fgw();
				save_sfl_dpmgr_fgw();
				draw_proc_normal_fgw();
			}
			else {
				draw_proc_diff_2_fgw(dparammgr_c_fgw.dpcend,
						     gadata_sf.gendatamgr.gdipgencnt);
				dparammgr_c_fgw.dpcend = gadata_sf.gendatamgr.gdipgencnt;
				redraw_simstatus_fgw();
			}
		}

#if	0
		udflag = 0;
/*
		if (dparammgr_c_fgw.xacend <= dparammgr_c_fgw.dpcend) {
*/
		if (dparammgr_c_fgw.xacend <= gadata_sf.gendatamgr.gdipgencnt) {
			set_dpmgr_full_x_fgw();
			save_l_dpmgr_fgw();
			udflag = 1;
		}
		if (gadata_sf.gendatamgr.scoremin < dparammgr_c_fgw.yaminimum ||
		    gadata_sf.gendatamgr.scoremax > dparammgr_c_fgw.yamaximum) {
			set_dpmgr_full_y_fgw();
			save_l_dpmgr_fgw();
			udflag = 1;
		}
		if (udflag) {
			save_sfl_dpmgr_fgw();
			draw_proc_normal_fgw();
		}
		else {
			draw_proc_diff_fgw();
			redraw_simstatus_fgw();
		}
#endif
#if	0
output_dparammgr_fgw("draw_proc_rl_fgw (FULL)", &dparammgr_c_fgw);
#endif
	}
	else if (dparammgr_c_fgw.viewmode == VIEW_MODE_EXPAND_FGW) {
#if	0
		(void)printf("draw_proc_rl_fgw --- VIEW_MODE_EXPAND_FGW\n");
#endif
		redraw_simstatus_fgw();
	}
	else if (dparammgr_c_fgw.viewmode == VIEW_MODE_SHRINK_FGW) {
#if	0
		(void)printf("draw_proc_rl_fgw --- VIEW_MODE_SHRINK_FGW\n");
#endif
		redraw_simstatus_fgw();
	}
	else
		fatal_error("draw_proc_rl_fgw",
			    "illegal viewmode\n");
}

void
draw_proc_rl_end_fgw()
{
	void	redraw_simstatus_fgw();

	redraw_simstatus_fgw();
}

/*--------------------------------------------------------------------*/

void
draw_proc_rl_full_fgw()
{
	extern DParamMgr	dparammgr_c_fgw, dparammgr_sfl_fgw;
	extern GAData		gadata_sf;
	extern void		set_dpmgr_full_x_fgw();
	extern void		set_dpmgr_full_y_fgw();
	void			draw_proc_normal_fgw();
	void			draw_proc_rl_start_fgw();

	if (dparammgr_sfl_fgw.setflag) {
		dparammgr_c_fgw = dparammgr_sfl_fgw;
		if (dparammgr_c_fgw.xacend <= gadata_sf.gendatamgr.gdipgencnt)
			set_dpmgr_full_x_fgw();
		if (gadata_sf.gendatamgr.scoremin < dparammgr_c_fgw.yaminimum ||
		    gadata_sf.gendatamgr.scoremax > dparammgr_c_fgw.yamaximum)
			set_dpmgr_full_y_fgw();
		draw_proc_normal_fgw();
	}
	else
		draw_proc_rl_start_fgw();
}

/*--------------------------------------------------------------------*/

void
draw_proc_diff_fgw()
{
	extern Widget		da_fgw;
	extern DParamMgr	dparammgr_c_fgw;
	extern GAData		gadata_sf;
	void			draw_graph_sr_fgw();

	draw_graph_sr_fgw(XtDisplay(da_fgw), XtWindow(da_fgw),
			  dparammgr_c_fgw.dpcend, gadata_sf.gendatamgr.gdipgencnt);
	dparammgr_c_fgw.dpcend = gadata_sf.gendatamgr.gdipgencnt;
}

void
draw_proc_diff_2_fgw(begin, end)
int	begin, end;
{
	extern Widget		da_fgw;
	void			draw_graph_sr_fgw();

	draw_graph_sr_fgw(XtDisplay(da_fgw), XtWindow(da_fgw),
			  begin, end);
}

/*--------------------------------------------------------------------*/

void
draw_proc_normal_fgw()
{
	extern DParamMgr	dparammgr_c_fgw;
	extern GAData		gadata_sf;
	extern Widget		da_fgw;
	void			draw_background_fgw();
	void			draw_axis_fgw();
	void			draw_graph_fgw();
	void			draw_comment_fgw();
	void			draw_simstatus_fgw();

#ifdef	DEBUG
	(void)printf("draw_proc_normal_fgw --- in\n");
#endif

/*
	if (gadata_sf.gendatamgr.gencnt <= 0 || gadata_sf.gendatamgr.gdipgencnt <= 0)
		return;
*/
	if (!dparammgr_c_fgw.setflag)
		return;

	draw_background_fgw(XtDisplay(da_fgw), XtWindow(da_fgw));

	draw_axis_fgw(XtDisplay(da_fgw), XtWindow(da_fgw));

	draw_graph_fgw(XtDisplay(da_fgw), XtWindow(da_fgw));

	draw_comment_fgw(XtDisplay(da_fgw), XtWindow(da_fgw));

	draw_simstatus_fgw(XtDisplay(da_fgw), XtWindow(da_fgw));

	XFlush(XtDisplay(da_fgw));
}

void
redraw_graph_fgw()
{
	void	draw_background_graph_fgw();
	void	draw_graph_fgw();

	draw_background_graph_fgw(XtDisplay(da_fgw), XtWindow(da_fgw));

	draw_graph_fgw(XtDisplay(da_fgw), XtWindow(da_fgw));
}

/*--------------------------------------------------------------------*/

static void
draw_background_fgw(display, window)
Display	*display;
Window	window;
{
	extern GC		gc_da_bg_fgw;
	extern DParamMgr	dparammgr_c_fgw;

	XFillRectangle(display, window, gc_da_bg_fgw,
		       0, 0, dparammgr_c_fgw.widthda, dparammgr_c_fgw.heightda);
}

static void
draw_background_graph_fgw(display, window)
Display	*display;
Window	window;
{
	extern GC		gc_da_bg_fgw;
	extern DParamMgr	dparammgr_c_fgw;

	XFillRectangle(display, window, gc_da_bg_fgw,
		       dparammgr_c_fgw.marginvwleft, dparammgr_c_fgw.marginvwtop,
		       dparammgr_c_fgw.widthvw, dparammgr_c_fgw.heightvw);
}

/*--------------------------------------------------------------------*/

static void
draw_axis_fgw(display, window)
Display	*display;
Window	window;
{
	void	draw_axis_x_fgw();
	void	draw_axis_full_y_fgw();
	void	draw_axis_y_fgw();

	draw_axis_x_fgw(display, window);

	if (dparammgr_c_fgw.viewmodey == VIEW_MODE_FULL_FGW)
		draw_axis_full_y_fgw(display, window);
	else
		draw_axis_y_fgw(display, window);
}

static void
draw_axis_x_fgw(display, window)
Display	*display;
Window	window;
{
	extern DParamMgr	dparammgr_c_fgw;
	extern GC		gc_da_axis_fgw;
	extern XFontStruct	*font15_fgw;
	char			buffer[BUFSIZ];
	int			xd;
	int			xd1, xd2, xd3;
	int			yd1, yd2, yd3, yd4;
	int			len;
	int			xw;
	float			p;
	int			svadj, pvadj;
	extern void		map_wtod_x_fgw();

	yd1 = dparammgr_c_fgw.marginvwtop
	      + (int)dparammgr_c_fgw.heightvw
	      + dparammgr_c_fgw.gapscalex;
	yd2 = yd1 + dparammgr_c_fgw.fontheight;
/*
	yd3 = yd2 + dparammgr_c_fgw.fontascent;
*/
	yd3 = yd2 + font15_fgw->ascent;
	yd4 = yd3 + (font15_fgw->ascent + font15_fgw->descent);

	p = (float)pow(10.0, (double)dparammgr_c_fgw.xap10);

	if (log10((double)dparammgr_c_fgw.xamax) < 1.0 &&
	    dparammgr_c_fgw.xap10 >= 1                   ) {
		svadj = 10;
		pvadj = -1;
	}
	else {
		svadj = 1;
		pvadj = 0;
	}

	for (xw = dparammgr_c_fgw.xamin;
	     xw <= dparammgr_c_fgw.xamax;
	     xw++) {
		map_wtod_x_fgw((float)xw * p, &xd);
		/* ؼν */
		XDrawLine(display, window, gc_da_axis_fgw,
			  xd, yd1, xd, yd2);
/*
		(void)sprintf(buffer, "%d", xw);
*/
		(void)sprintf(buffer, "%d", xw * svadj);
		len = strlen(buffer);
		/* ؼ */
		XDrawString(display, window, gc_da_axis_fgw,
			    xd, yd3, buffer, len);
	}

#ifdef	DEBUG
	(void)printf("draw_axis_x --- dparammgr_c_fgw.(dpcbegin,dpcend) = %d %d\n",
		      dparammgr_c_fgw.dpcbegin, dparammgr_c_fgw.dpcend);
#endif

/*
	xd1 = (int)((float)dparammgr_c_fgw.marginvwleft
		    - dparammgr_c_fgw.dgwmaximum / 2.0
		    + 0.5);
	xd2 = (int)((float)dparammgr_c_fgw.marginvwleft
		    + (float)dparammgr_c_fgw.widthvw
		    + dparammgr_c_fgw.dgwmaximum / 2.0
		    + 0.5);
*/
	xd1 = dparammgr_c_fgw.marginvwleft;
	xd2 = xd1 + dparammgr_c_fgw.widthvw;

	/* ؼβ */
	XDrawLine(display, window, gc_da_axis_fgw,
		  xd1, yd1, xd2, yd1);

/*
	(void)sprintf(buffer, "10**%d", dparammgr_c_fgw.xap10);
*/
	(void)sprintf(buffer, "10**%d", dparammgr_c_fgw.xap10 + pvadj);

	/* ؼΤ٤ */
	XDrawString(display, window, gc_da_axis_fgw,
		    xd2 + dparammgr_c_fgw.fontwidth / 2, yd1,
		    buffer, strlen(buffer));

	xd3 = dparammgr_c_fgw.marginvwleft + dparammgr_c_fgw.widthvw / 2;

	(void)sprintf(buffer, "Generation");
	len = strlen(buffer);

	/* ؼΥȥ */
/*
	XDrawString(display, window, gc_da_axis_fgw,
		    xd3 - len * dparammgr_c_fgw.fontwidth / 2, yd4,
		    buffer, len);
*/
	XDrawString(display, window, gc_da_axis_fgw,
		    xd3 - len * font15_fgw->max_bounds.width / 2, yd4,
		    buffer, len);
}

static void
draw_axis_full_y_fgw(display, window)
Display	*display;
Window	window;
{
	extern GC		gc_da_axis_fgw;
	extern DParamMgr	dparammgr_c_fgw;
	extern XFontStruct	*font15_fgw;
	char			buffer[BUFSIZ];
	int			len;
	float			yw;
	float			p;
	int			xd1, xd2;
	int			yd, yd0, yd1, yd2;
	extern void		map_wtod_y_fgw();

	xd2 = dparammgr_c_fgw.marginvwleft
	      - dparammgr_c_fgw.gapscaley;
	xd1 = xd2 - dparammgr_c_fgw.fontwidth;

	/*  */
	map_wtod_y_fgw(0.0, &yd0);
	/* ټβ */
	XDrawLine(display, window, gc_da_axis_fgw,
		  xd1, yd0, xd2, yd0);
	(void)sprintf(buffer, "0.0");
	len = strlen(buffer);
	/* ټ */
/*
	XDrawString(display, window, gc_da_axis_fgw,
		    xd1 - len * dparammgr_c_fgw.fontwidth, yd0,
		    buffer, len);
*/
	XDrawString(display, window, gc_da_axis_fgw,
		    xd1 - len * font15_fgw->max_bounds.width, yd0,
		    buffer, len);

	buffer[0] = '\0';

	/* ʬ */
	if (dparammgr_c_fgw.yapdf > 0.0) {
		p = (float)pow(10.0, (double)dparammgr_c_fgw.yapp10);
		for (yw = 1.0; yw <= dparammgr_c_fgw.yapdf; yw += 1.0) {
			map_wtod_y_fgw(yw * p, &yd);
			/* ټβ */
			XDrawLine(display, window, gc_da_axis_fgw,
				  xd1, yd, xd2, yd);
			(void)sprintf(buffer, "%.1f", yw);
			len = strlen(buffer);
			/* ټ */
/*
			XDrawString(display, window, gc_da_axis_fgw,
				    xd1 - len * dparammgr_c_fgw.fontwidth, yd,
				    buffer, len);
*/
			XDrawString(display, window, gc_da_axis_fgw,
				    xd1 - len * font15_fgw->max_bounds.width, yd,
				    buffer, len);
		}
		/* ټνĤ */
		XDrawLine(display, window, gc_da_axis_fgw,
			  xd2, yd0, xd2, dparammgr_c_fgw.marginvwtop);
		(void)sprintf(buffer, "10**%d", dparammgr_c_fgw.yapp10);
	}

	/* ʬ */
	if (dparammgr_c_fgw.yamdf < 0.0) {
		p = (float)pow(10.0, (double)dparammgr_c_fgw.yamp10);
		for (yw = -1.0; yw >= dparammgr_c_fgw.yamdf; yw -= 1.0) {
			map_wtod_y_fgw(yw * p, &yd);
			/* ټβ */
			XDrawLine(display, window, gc_da_axis_fgw,
				  xd1, yd, xd2, yd);
			(void)sprintf(buffer, "%.1f", yw);
			len = strlen(buffer);
			/* ټ */
/*
			XDrawString(display, window, gc_da_axis_fgw,
				    xd1 - len * dparammgr_c_fgw.fontwidth, yd,
				    buffer, len);
*/
			XDrawString(display, window, gc_da_axis_fgw,
				    xd1 - len * font15_fgw->max_bounds.width, yd,
				    buffer, len);
		}
		/* ټνĤ */
		XDrawLine(display, window, gc_da_axis_fgw,
			  xd2, yd0,
			  xd2, dparammgr_c_fgw.marginvwtop + (int)dparammgr_c_fgw.heightvw);
		(void)sprintf(buffer, "10**%d", dparammgr_c_fgw.yamp10);
	}

	if (buffer[0] == '\0')
		(void)sprintf(buffer, "10**0");

	yd1 = dparammgr_c_fgw.marginvwtop
	      - dparammgr_c_fgw.fontheight / 2
	      - font15_fgw->descent;
	yd2 = yd1 - (font15_fgw->ascent + font15_fgw->descent);

	/* ټΤ٤ */
	XDrawString(display, window, gc_da_axis_fgw,
		    xd2, yd1,
		    buffer, strlen(buffer));

	(void)sprintf(buffer, "Score");
	len = strlen(buffer);

	/* ټΥȥ */
/*
	XDrawString(display, window, gc_da_axis_fgw,
		    xd2 - len * dparammgr_c_fgw.fontwidth, yd2,
		    buffer, len);
*/
	XDrawString(display, window, gc_da_axis_fgw,
		    xd2 - len * font15_fgw->max_bounds.width / 2, yd2,
		    buffer, len);
}

static void
draw_axis_y_fgw(display, window)
Display	*display;
Window	window;
{
	extern DParamMgr	dparammgr_c_fgw;
	extern GC		gc_da_axis_fgw;
	extern XFontStruct	*font15_fgw;
	char			buffer[BUFSIZ];
	int			yd;
	int			xd1, xd2;
	int			yd1, yd2, yd3, yd4;
	int			len;
	int			yw;
	float			p;
	extern void		map_wtod_y_fgw();

#ifdef	DEBUG
	(void)printf("draw_axis_y_fgw --- in\n");
#endif

	xd2 = dparammgr_c_fgw.marginvwleft
	      - dparammgr_c_fgw.gapscaley;
	xd1 = xd2 - dparammgr_c_fgw.fontwidth;

	p = (float)pow(10.0, (double)dparammgr_c_fgw.yap10);

	for (yw = dparammgr_c_fgw.yamin;
	     yw <= dparammgr_c_fgw.yamax;
	     yw++) {
		map_wtod_y_fgw((float)yw * p, &yd);
		/* ټβ */
		XDrawLine(display, window, gc_da_axis_fgw,
			  xd1, yd, xd2, yd);
		(void)sprintf(buffer, "%.1f", (float)yw);
		len = strlen(buffer);
		/* ټ */
/*
		XDrawString(display, window, gc_da_axis_fgw,
			    xd1 - len * dparammgr_c_fgw.fontwidth, yd,
			    buffer, len);
*/
		XDrawString(display, window, gc_da_axis_fgw,
			    xd1 - len * font15_fgw->max_bounds.width, yd,
			    buffer, len);
	}

	yd1 = dparammgr_c_fgw.marginvwtop;
	yd2 = yd1 + dparammgr_c_fgw.heightvw;
	yd3 = dparammgr_c_fgw.marginvwtop
	      - dparammgr_c_fgw.fontheight / 2
	      - font15_fgw->descent;
	yd4 = yd3 - (font15_fgw->ascent + font15_fgw->descent);


	/* ټν */
	XDrawLine(display, window, gc_da_axis_fgw,
		  xd2, yd1, xd2, yd2);

	(void)sprintf(buffer, "10**%d", dparammgr_c_fgw.yap10);

	/* ټΤ٤ */
	XDrawString(display, window, gc_da_axis_fgw,
		    xd2, yd3,
		    buffer, strlen(buffer));

	(void)sprintf(buffer, "Score");
	len = strlen(buffer);

	/* ټΥȥ */
/*
	XDrawString(display, window, gc_da_axis_fgw,
		    xd2 - len * dparammgr_c_fgw.fontwidth, yd4,
		    buffer, len);
*/
	XDrawString(display, window, gc_da_axis_fgw,
		    xd2 - len * font15_fgw->max_bounds.width / 2, yd4,
		    buffer, len);
}

/*--------------------------------------------------------------------*/

static void
draw_graph_fgw(display, window)
Display	*display;
Window	window;
{
	extern DParamMgr	dparammgr_c_fgw;

	void	draw_graph_1_fgw();
	void	draw_graph_2_fgw();

	if (dparammgr_c_fgw.scalexc < 1.0)
/*
		draw_graph_1_fgw(display, window);
*/
		draw_graph_2_fgw(display, window);
	else
		draw_graph_2_fgw(display, window);
}

/*ARGSUSED*/
static void
draw_graph_1_fgw(display, window)
Display	*display;
Window	window;
{
}

static void
draw_graph_2_fgw(display, window)
Display	*display;
Window	window;
{
	extern GAData	gadata_sf;
	extern int	dgrp_flag_fgw[GRPCNT_MAX];
	extern int	dmma_flag_fgw[DSPITEM_CNT_FGW];
	extern GC	gc_da_gminmax_fgw[GRPCNT_MAX];
	extern GC	gc_da_gaverage_fgw[GRPCNT_MAX];
	int		fflag;
	int		i, j;
	GenData		*gendata;
	int		xd1, xd2;
	int		minyd1[GRPCNT_MAX], minyd2[GRPCNT_MAX];
	int		maxyd1[GRPCNT_MAX], maxyd2[GRPCNT_MAX];
	int		avyd1[GRPCNT_MAX], avyd2[GRPCNT_MAX];
#ifdef	CHECK
	extern void	fatal_error();
#endif

#ifdef	DEBUG
	(void)printf("draw_graph_2_fgw --- dparammgr_c_fgw.(dpcbegin,dpcend) = %d %d\n",
		     dparammgr_c_fgw.dpcbegin, dparammgr_c_fgw.dpcend);
#endif

	xd1 = 0;
/*
	for (i = 0; i < GRPCNT_MAX; i++)
	    *(avyd1+i) = 0;
*/

	for (fflag = 1, i = dparammgr_c_fgw.dpcbegin - 1; i < dparammgr_c_fgw.dpcend; i++) {
	    gendata = gadata_sf.gendatamgr.gendata + i;
	    map_wtod_x_fgw((float)gendata->id, &xd2);
#ifdef	CHECK
	    if (gendata->grpdatamgr.grpcnt > GRPCNT_MAX)
		fatal_error("draw_graph_2_fgw",
			    "gadata_sf.initdata.grpcnt = %d\n",
			    gadata_sf.initdata.grpcnt);
#endif
	    for (j = 0; j < gendata->grpdatamgr.grpcnt; j++) {
		if (!*(dgrp_flag_fgw+j))
		    continue;
		if (*dmma_flag_fgw) {
		    map_wtod_y_fgw((gendata->grpdatamgr.grpdata+j)->idvdatamgr.scoremax,
				   maxyd2 + j);
		    if (fflag)
			XDrawPoint(display, window, *(gc_da_gminmax_fgw+j),
				   xd2, *(maxyd2+j));
		    else
			XDrawLine(display, window, *(gc_da_gminmax_fgw+j),
				  xd1, *(maxyd1+j), xd2, *(maxyd2+j));
		}
		if (*(dmma_flag_fgw+1)) {
		    map_wtod_y_fgw((gendata->grpdatamgr.grpdata+j)->idvdatamgr.scoremin,
				   minyd2 + j);
		    if (fflag)
			XDrawPoint(display, window, *(gc_da_gminmax_fgw+j),
				   xd2, *(minyd2+j));
		    else
			XDrawLine(display, window, *(gc_da_gminmax_fgw+j),
				  xd1, *(minyd1+j), xd2, *(minyd2+j));
		}
		if (*(dmma_flag_fgw+2)) {
		    map_wtod_y_fgw((gendata->grpdatamgr.grpdata+j)->idvdatamgr.scoreave,
				   avyd2 + j);
		    if (fflag)
			XDrawPoint(display, window, *(gc_da_gaverage_fgw+j),
				   xd2, *(avyd2+j));
		    else
			XDrawLine(display, window, *(gc_da_gaverage_fgw+j),
				  xd1, *(avyd1+j), xd2, *(avyd2+j));
		}
		*(minyd1+j) = *(minyd2+j);
		*(maxyd1+j) = *(maxyd2+j);
		*(avyd1+j) = *(avyd2+j);
	    }
	    xd1 = xd2;
	    fflag = 0;
	}
}

static void
draw_graph_sr_fgw(display, window, begin, end)
Display	*display;
Window	window;
int	begin;
int	end;
{
	extern DParamMgr	dparammgr_c_fgw;

	void	draw_graph_sr_1_fgw();
	void	draw_graph_sr_2_fgw();

	if (dparammgr_c_fgw.scalexc < 1.0)
/*
		draw_graph_sr_1_fgw(display, window, begin, end);
*/
		draw_graph_sr_2_fgw(display, window, begin, end);
	else
		draw_graph_sr_2_fgw(display, window, begin, end);
}

/*ARGSUSED*/
static void
draw_graph_sr_1_fgw(display, window, begin, end)
Display	*display;
Window	window;
int	begin;
int	end;
{
}

static void
draw_graph_sr_2_fgw(display, window, begin, end)
Display	*display;
Window	window;
int	begin;
int	end;
{
	extern GAData	gadata_sf;
	extern int	dgrp_flag_fgw[GRPCNT_MAX];
	extern int	dmma_flag_fgw[DSPITEM_CNT_FGW];
	extern GC	gc_da_gminmax_fgw[GRPCNT_MAX];
	extern GC	gc_da_gaverage_fgw[GRPCNT_MAX];
	int		fflag;
	int		i, j;
	GenData		*gendata;
	int		xd1, xd2;
	int		minyd1[GRPCNT_MAX], minyd2[GRPCNT_MAX];
	int		maxyd1[GRPCNT_MAX], maxyd2[GRPCNT_MAX];
	int		avyd1[GRPCNT_MAX], avyd2[GRPCNT_MAX];
#ifdef	CHECK
	extern void	fatal_error();
#endif

#ifdef	DEBUG
	(void)printf("draw_graph_sr_2_fgw --- dparammgr_c_fgw.(dpcbegin,dpcend) = %d %d\n",
		     dparammgr_c_fgw.dpcbegin, dparammgr_c_fgw.dpcend);
#endif

	xd1 = 0;
/*
	for (i = 0; i < GRPCNT_MAX; i++)
		*(avyd1+i) = 0;
*/

	for (fflag = 1, i = begin - 1; i < end; i++) {
	    gendata = gadata_sf.gendatamgr.gendata + i;
	    map_wtod_x_fgw((float)gendata->id, &xd2);
#ifdef	CHECK
	    if (gendata->grpdatamgr.grpcnt > GRPCNT_MAX)
		fatal_error("draw_graph_sr_2_fgw",
			    "gadata_sf.initdata.grpcnt = %d\n",
			    gadata_sf.initdata.grpcnt);
#endif
	    for (j = 0; j < gendata->grpdatamgr.grpcnt; j++) {
		if (!*(dgrp_flag_fgw+j))
		    continue;
		if (*dmma_flag_fgw) {
		    map_wtod_y_fgw((gendata->grpdatamgr.grpdata+j)->idvdatamgr.scoremax,
				   maxyd2 + j);
		    if (fflag)
			XDrawPoint(display, window, *(gc_da_gminmax_fgw+j),
				   xd2, *(maxyd2+j));
		    else
			XDrawLine(display, window, *(gc_da_gminmax_fgw+j),
				  xd1, *(maxyd1+j), xd2, *(maxyd2+j));
		}
		if (*(dmma_flag_fgw+1)) {
		    map_wtod_y_fgw((gendata->grpdatamgr.grpdata+j)->idvdatamgr.scoremin,
				   minyd2 + j);
		    if (fflag)
			XDrawPoint(display, window, *(gc_da_gminmax_fgw+j),
				   xd2, *(minyd2+j));
		    else
			XDrawLine(display, window, *(gc_da_gminmax_fgw+j),
				  xd1, *(minyd1+j), xd2, *(minyd2+j));
		}
		if (*(dmma_flag_fgw+2)) {
		    map_wtod_y_fgw((gendata->grpdatamgr.grpdata+j)->idvdatamgr.scoreave,
				   avyd2 + j);
		    if (fflag)
			XDrawPoint(display, window, *(gc_da_gaverage_fgw+j),
				   xd2, *(avyd2+j));
		    else
			XDrawLine(display, window, *(gc_da_gaverage_fgw+j),
				  xd1, *(avyd1+j), xd2, *(avyd2+j));
		}
		*(minyd1+j) = *(minyd2+j);
		*(maxyd1+j) = *(maxyd2+j);
		*(avyd1+j) = *(avyd2+j);
	    }
	    xd1 = xd2;
	    fflag = 0;
	}
}

/*--------------------------------------------------------------------*/

static void
draw_comment_fgw(display, window)
Display	*display;
Window	window;
{
	extern GAData		gadata_sf;
	extern DParamMgr	dparammgr_c_fgw;
	extern GC		gc_da_comment_fgw[GRPCNT_MAX];
	extern XFontStruct	*font20_fgw;
	int			i;
	int			maxlen, len;
	int			x;
	int			y1, y2;
	char			buffer[BUFSIZ];

	x = dparammgr_c_fgw.marginvwleft
	     + 10 * dparammgr_c_fgw.fontwidth;
	y2 = dparammgr_c_fgw.marginvwtop
	     - dparammgr_c_fgw.fontheight / 2
	     - font20_fgw->descent;
	y1 = y2 - (font20_fgw->ascent + font20_fgw->descent);

	maxlen = 0;
	for (i = 0; i < gadata_sf.initdata.grpcnt; i++) {
		(void)sprintf(buffer,
			      "%c:%s",
			      'A' + i,
			      (gadata_sf.initdata.comment.charpdata+i)->cpdata);
		len = strlen(buffer);
		if (len > maxlen)
			maxlen = len;
		if (!(i % 2))
			XDrawString(display, window, *(gc_da_comment_fgw+i),
				    x, y1, buffer, strlen(buffer));
		else {
			XDrawString(display, window, *(gc_da_comment_fgw+i),
				    x, y2, buffer, strlen(buffer));
			x += (maxlen + 3) *  font20_fgw->max_bounds.width;
			maxlen = 0;
		}
	}
}

#if	0

static void
draw_comment_fgw(display, window)
Display	*display;
Window	window;
{
	extern GAData		gadata_sf;
	extern DParamMgr	dparammgr_c_fgw;
	extern GC		gc_da_comment_fgw[GRPCNT_MAX];
	int			i;
	int			len, maxlen;
	int			xo, yo;
	int			y;
	char			buffer[BUFSIZ];

	for (maxlen = 0, i = 0; i < gadata_sf.initdata.grpcnt; i++) {
		len = strlen((gadata_sf.initdata.comment.charpdata+i)->cpdata);
		if (len > maxlen)
			maxlen = len;
	}

	xo = dparammgr_c_fgw.widthda
	     - dparammgr_c_fgw.marginvwright
	     - (maxlen + 5) * dparammgr_c_fgw.fontwidth;
	yo = dparammgr_c_fgw.marginvwtop
	     - gadata_sf.initdata.grpcnt
	       * dparammgr_c_fgw.fontheight
	     + dparammgr_c_fgw.fontascent;

	for (y = yo, i = 0;
	     i < gadata_sf.initdata.grpcnt;
	     y+= dparammgr_c_fgw.fontascent, i++) {
		(void)sprintf(buffer,
			      "%c   %s",
			      'A' + i,
			      (gadata_sf.initdata.comment.charpdata+i)->cpdata);
		XDrawString(display, window, *(gc_da_comment_fgw+i),
			    xo, y, buffer, strlen(buffer));
	}
}

#endif

/*--------------------------------------------------------------------*/

static void
redraw_simstatus_fgw()
{
	extern Widget	da_fgw;
	void		erase_simstatus_fgw();
	void		draw_simstatus_fgw();

	erase_simstatus_fgw(XtDisplay(da_fgw), XtWindow(da_fgw));

	draw_simstatus_fgw(XtDisplay(da_fgw), XtWindow(da_fgw));
}

static void
draw_simstatus_fgw(display, window)
Display	*display;
Window	window;
{
	extern int		sim_mode_fgw;
	extern DParamMgr	dparammgr_c_fgw;
	extern GAData		gadata_sf;
	int			x, y;
	char			buffer[BUFSIZ];
	extern GC		ga_da_msg_fgw;

	if (sim_mode_fgw == SIM_MODE_INIT_FGW)
		return;

	x = dparammgr_c_fgw.marginvwright;
	y = dparammgr_c_fgw.marginvwtop
	    + dparammgr_c_fgw.heightvw
	    + dparammgr_c_fgw.gapscalex
	    + 4 * dparammgr_c_fgw.fontheight
	    + dparammgr_c_fgw.fontascent;

	if (sim_mode_fgw == SIM_MODE_RUN_FGW)
		(void)sprintf(buffer,
			      "Simulation has been running. ( %d / %d )",
			      dparammgr_c_fgw.dpcend,
			      gadata_sf.gendatamgr.gdipgencnt);
	else if (sim_mode_fgw == SIM_MODE_STOP_FGW)
		(void)sprintf(buffer,
			      "Simulation has stopped. ( %d / %d )",
			      dparammgr_c_fgw.dpcend,
			      gadata_sf.gendatamgr.gdipgencnt);
	else
		fatal_error("draw_simstatus_fgw",
			    "illegal sim_mode_fgw\n");

	simstatus_strlen_fgw = strlen(buffer);
	XDrawString(display, window, gc_da_msg_fgw,
		    x, y, buffer, simstatus_strlen_fgw);
}

static void
erase_simstatus_fgw(display, window)
Display	*display;
Window	window;
{
	extern int		sim_mode_fgw;
	extern DParamMgr	dparammgr_c_fgw;
	extern GAData		gadata_sf;
	int			x, y;
	Dimension		width, height;
	extern GC		ga_da_bg_fgw;

	if (sim_mode_fgw == SIM_MODE_INIT_FGW)
		;
	else if (sim_mode_fgw == SIM_MODE_RUN_FGW ||
		 sim_mode_fgw == SIM_MODE_STOP_FGW) {
		x = dparammgr_c_fgw.marginvwright;
		y = dparammgr_c_fgw.marginvwtop
		    + dparammgr_c_fgw.heightvw
		    + dparammgr_c_fgw.gapscalex
		    + 4 * dparammgr_c_fgw.fontheight;
/*
		width = dparammgr_c_fgw.widthvw;
*/
		width = simstatus_strlen_fgw * dparammgr_c_fgw.fontwidth;
		height = (Dimension)dparammgr_c_fgw.fontheight;
		XFillRectangle(display, window, gc_da_bg_fgw,
			       x, y, width, height);
	}
	else
		fatal_error("erase_simstatus_fgw",
			    "illegal sim_mode_fgw\n");
}

/*--------------------------------------------------------------------*/

static int
clip(xdo1, ydo1, xdo2, ydo2, xdn1, ydn1, xdn2, ydn2)
int	xdo1, ydo1, xdo2, ydo2;
int	*xdn1, *ydn1, *xdn2, *ydn2;
{
	extern DParamMgr	dparammgr_c_fgw;
	int			xdmin, xdmax;
	int			ydmin, ydmax;
	int			flag;

	xdmin = dparammgr_c_fgw.marginvwleft;
	xdmax = xdmin + dparammgr_c_fgw.widthvw;
	ydmin = dparammgr_c_fgw.marginvwtop;
	ydmax = ydmin + dparammgr_c_fgw.heightvw;

	*xdn1 = xdo1;
	*ydn1 = ydo1;
	*xdn2 = xdo2;
	*ydn2 = ydo2;

	if (*xdn1 == *xdn2) {
		if (*ydn1 > *ydn2) {
			*ydn1 = MIN(*ydn1, ydmax);
			*ydn2 = MAX(*ydn2, ydmin);
			if (*xdn1 >= xdmin && *xdn1 <= xdmax)
				flag = 1;
			else
				flag = -1;
		}
		else if (*ydn1 < *ydn2) {
			*ydn1 = MAX(*ydn1, ydmin);
			*ydn2 = MIN(*ydn2, ydmax);
			if (*xdn1 >= xdmin && *xdn1 <= xdmax)
				flag = 1;
			else
				flag = -1;
		}
		else {
			if ((*xdn1 >= xdmin && *xdn1 <= xdmax) &&
			    (*ydn1 >= ydmin && *ydn1 <= ydmax)   )
				flag = 1;
			else
				flag = -1;
		}
	}
	else if (*ydn1 == *ydn2) {
		if (*xdn1 > *xdn2) {
			*xdn1 = MIN(*xdn1, xdmax);
			*xdn2 = MAX(*xdn2, xdmin);
			if (*ydn1 >= ydmin && *ydn1 <= ydmax)
				flag = 1;
			else
				flag = -1;
		}
		else if (*xdn1 < *xdn2) {
			*xdn1 = MAX(*xdn1, xdmin);
			*xdn2 = MIN(*xdn2, xdmax);
			if (*ydn1 >= ydmin && *ydn1 <= ydmax)
				flag = 1;
			else
				flag = -1;
		}
		else {
			if ((*xdn1 >= xdmin && *xdn1 <= xdmax) &&
			    (*ydn1 >= ydmin && *ydn1 <= ydmax)   )
				flag = 1;
			else
				flag = -1;
		}
	}
	else
		flag = 0;

	return flag;
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
