/*----------------------------------------------------------------------

	ե̾	gavtg_adwda.c
			ɥ󥰡ꥢʥ饤ȡ

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<string.h>

#include	<Xm/ScrolledW.h>
#include	<Xm/DrawingA.h>

#include	"gavtg_adwdef.h"

/*--------------------------------------------------------------------*/

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

void
create_drawingarea_adw()
{
	extern Widget	da_adw;
	extern Widget	sw_adw;
	extern Widget	fm_da_adw;
	int		i;
	Arg		args[6];
	extern void	event_process_adw();
	extern void	create_scrolledwindow_adw();
	void		set_scrolledwindow_adw();

	create_scrolledwindow_adw();

	i = 0;
/*
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);
	i++;
*/
/* unset ---> set (read data) */
	XtSetArg(args[i], XmNwidth, DA_WIDTH_ADW);
	i++;
	XtSetArg(args[i], XmNheight, DA_HEIGHT_ADW);
	i++;
	da_adw = XmCreateDrawingArea(sw_adw, "da_adw", args, i);
	XtManageChild(da_adw); 
	XtAddEventHandler(da_adw, EV_MASK_ADW,
			  False, event_process_adw, (caddr_t)NULL);

	set_scrolledwindow_adw();
}

static void
create_scrolledwindow_adw()
{
	extern Widget	fm_da_adw;
	extern Widget	sw_adw;
	int		i;
	Arg		args[7];

	i = 0;
	XtSetArg(args[i], XmNtopAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNbottomAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNleftAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNrightAttachment, XmATTACH_FORM);
	i++;
	XtSetArg(args[i], XmNwidth, SW_WIDTH_ADW);
	i++;
	XtSetArg(args[i], XmNheight, SW_HEIGHT_ADW);
	i++;
	XtSetArg(args[i], XmNscrollingPolicy, XmAUTOMATIC);
	i++;
	sw_adw = XmCreateScrolledWindow(fm_da_adw, "sw_adw", args, i);
	XtManageChild(sw_adw); 
}

static void
set_scrolledwindow_adw()
{
	extern Widget	sw_adw;
	extern Widget	da_adw;

	XmScrolledWindowSetAreas(sw_adw, (Widget)NULL, (Widget)NULL, da_adw);
}

/*--------------------------------------------------------------------*/

void
draw_proc_adw()
{
	extern GAData	gadata_sf;
	extern int	genid_adw;
	extern int	grpid_adw;
	extern Widget	da_adw;
	extern void	fatal_error();
	void		draw_background_adw();
	void		draw_information_adw();
	void		draw_alname_adw();
	void		draw_alignment_aacid_adw();
	void		draw_alignment_nacid_adw();
	void		draw_scale_adw();
	void		draw_identity_adw();
	void		draw_costgraph_adw();

#ifdef	DEBUG
	(void)printf("draw_proc_adw --- in\n");
#endif

	if (gadata_sf.gendatamgr.gencnt <= 0     ||
	    gadata_sf.gendatamgr.gdipgencnt <= 0 ||
	    genid_adw <= 0                       ||
	    grpid_adw <= 0                         )
		return;

	draw_background_adw();

	draw_information_adw();

	draw_alname_adw();

	if (gadata_sf.initdata.acidmode == ACIDMODE_AMINO)
		draw_alignment_aacid_adw();
	else if (gadata_sf.initdata.acidmode == ACIDMODE_NUCLEIC)
		draw_alignment_nacid_adw();
	else
		fatal_error("draw_proc_adw",
			    "illegal acidmode (%d)\n",
			    gadata_sf.initdata.acidmode);

	draw_scale_adw();

	draw_identity_adw();

	draw_costgraph_adw();
}

void
redraw_information_proc_adw()
{
	void	erase_information_adw();
	void	draw_information_adw();

	erase_information_adw();

	draw_information_adw();
}

void
redraw_identity_proc_adw()
{
	void	erase_identity_adw();
	void	draw_identity_adw();

	erase_identity_adw();

	draw_identity_adw();
}

void
redraw_costgraph_proc_adw()
{
	void	erase_costgraph_adw();
	void	draw_costgraph_adw();

	erase_costgraph_adw();

	draw_costgraph_adw();
}

/*--------------------------------------------------------------------*/

static void
draw_background_adw()
{
	extern Widget	da_adw;
	extern GC	gc_da_bg_adw;
	int		i;
	Arg		args[2];
	Dimension	width, height;

	i = 0;
	XtSetArg(args[i], XmNwidth, &width);
	i++;
	XtSetArg(args[i], XmNheight, &height);
	i++;
	XtGetValues(da_adw, args, i);

	XFillRectangle(XtDisplay(da_adw), XtWindow(da_adw), gc_da_bg_adw,
		       0, 0, width, height);

	XFlush(XtDisplay(da_adw));
}

/*--------------------------------------------------------------------*/

static void
draw_information_adw()
{
	extern ADWDPMgr	adwdpmgr_adw;
	extern int	genid_adw;
	extern int	grpid_adw;
	extern GC	gc_da_inf_adw;
	extern Widget	da_adw;
	int		x, y;
	char		buffer[BUFSIZ];
	GenData		*gendata;
	GrpData		*grpdata;

	x = adwdpmgr_adw.marginvwleft
	    + adwdpmgr_adw.fontwidth;
	y = adwdpmgr_adw.marginvwtop
	    + adwdpmgr_adw.fontheight
	    + adwdpmgr_adw.fontascent;

	(void)sprintf(buffer,
		      "GENERATION:%d GROUPID:%c",
		      genid_adw, 'A' + grpid_adw - 1);

	XDrawString(XtDisplay(da_adw), XtWindow(da_adw), gc_da_inf_adw,
		    x, y, buffer, strlen(buffer));

	y += adwdpmgr_adw.fontheight;

	gendata = gadata_sf.gendatamgr.gendata + genid_adw - 1;
	grpdata = gendata->grpdatamgr.grpdata + grpid_adw - 1;

	(void)sprintf(buffer,
		      "SCORE:%d",
		      - grpdata->aldatamgr.totalcost);

	XDrawString(XtDisplay(da_adw), XtWindow(da_adw), gc_da_inf_adw,
		    x, y, buffer, strlen(buffer));

	XFlush(XtDisplay(da_adw));
}

static void
erase_information_adw()
{
	extern ADWDPMgr	adwdpmgr_adw;
	extern GC	gc_da_bg_adw;
	extern Widget	da_adw;
	int		x, y;
	int		i;
	Arg		args[1];
	Dimension	width, height;

	x = adwdpmgr_adw.marginvwleft;
	y = adwdpmgr_adw.marginvwtop;

	i = 0;
	XtSetArg(args[i], XmNwidth, &width);
	i++;
	XtGetValues(da_adw, args, i);
	height = (Dimension)adwdpmgr_adw.alinformation;

	XFillRectangle(XtDisplay(da_adw), XtWindow(da_adw), gc_da_bg_adw,
		       x, y, width, height);

	XFlush(XtDisplay(da_adw));
}

/*--------------------------------------------------------------------*/

static void
draw_alname_adw()
{
	extern GAData		gadata_sf;
	extern int		genid_adw;
	extern int		grpid_adw;
	extern ADWDPMgr		adwdpmgr_adw;
	extern ANATextDataMgr	anatdm_adw;
	extern Widget		da_adw;
	extern GC		gc_da_alname_adw;
	GenData			*gendata;
	GrpData			*grpdata;
	AlData			*aldata;
	int			i, j;
	int			xo, yo;
	int			dx, dy;
	int			x, y;

	gendata = gadata_sf.gendatamgr.gendata + genid_adw - 1;
	grpdata = gendata->grpdatamgr.grpdata + grpid_adw - 1;

	xo = adwdpmgr_adw.marginvwleft;
	yo = adwdpmgr_adw.marginvwtop
	     + adwdpmgr_adw.alinformation
	     + adwdpmgr_adw.alscale
	     + adwdpmgr_adw.fontascent;

/*
	dx = adwdpmgr_adw.fontwidth;
*/
	dx = MAX(adwdpmgr_adw.fontwidth, anatdm_adw.bw);
	dy = MAX(adwdpmgr_adw.fontheight, anatdm_adw.bh);

	for (y = yo, i = 0; i < grpdata->aldatamgr.alcnt; y += dy, i++) {
		aldata = grpdata->aldatamgr.aldata + i;
#if	1
		for (x = xo, j = 0; j < aldata->nmlen; x += dx, j++)
			XDrawString(XtDisplay(da_adw), XtWindow(da_adw), gc_da_alname_adw,
				    x, y, aldata->name + j, 1);
#else
		XDrawString(XtDisplay(da_adw), XtWindow(da_adw), gc_da_alname_adw,
			    xo, y, aldata->name, aldata->nmlen);
#endif
	}

	XFlush(XtDisplay(da_adw));
}

/*--------------------------------------------------------------------*/

static void
draw_alignment_aacid_adw()
{
	extern GAData		gadata_sf;
	extern int		genid_adw;
	extern int		grpid_adw;
	extern ADWDPMgr		adwdpmgr_adw;
	extern ANATextDataMgr	anatdm_adw;
	extern Widget		da_adw;
	GenData			*gendata;
	GrpData			*grpdata;
	AlData			*aldata;
	int			i, j;
	int			xo, yo;
	int			dx, dy;
	int			x, y;
	int			code;
	
	gendata = gadata_sf.gendatamgr.gendata + genid_adw - 1;
	grpdata = gendata->grpdatamgr.grpdata + grpid_adw - 1;

	xo = adwdpmgr_adw.marginvwleft
	     + adwdpmgr_adw.alnamewidth
	     + adwdpmgr_adw.algap;
	yo = adwdpmgr_adw.marginvwtop
	     + adwdpmgr_adw.alinformation
	     + adwdpmgr_adw.alscale;

	dx = MAX(anatdm_adw.bw, adwdpmgr_adw.fontwidth);
	dy = MAX(anatdm_adw.bh, adwdpmgr_adw.fontheight);

	for (y = yo, i = 0; i < grpdata->aldatamgr.alcnt; y += dy, i++) {
		aldata = grpdata->aldatamgr.aldata + i;
		for (x = xo, j = 0; j < aldata->allen; x += dx, j++) {
			code = *(aldata->alignment+j);
			XFillRectangle(XtDisplay(da_adw),
				       XtWindow(da_adw),
				       (anatdm_adw.td+code)->gcaabg,
				       x,
				       y,
				       (Dimension)anatdm_adw.bw,
				       (Dimension)anatdm_adw.bh);
			XDrawString(XtDisplay(da_adw), XtWindow(da_adw),
				    (anatdm_adw.td+code)->gct,
				    x + (anatdm_adw.td+code)->tosx,
				    y + (anatdm_adw.td+code)->tosy,
				    (anatdm_adw.td+code)->text,
				    strlen((anatdm_adw.td+code)->text));
		}
	}

	XFlush(XtDisplay(da_adw));
}

static void
draw_alignment_nacid_adw()
{
	extern GAData		gadata_sf;
	extern int		genid_adw;
	extern int		grpid_adw;
	extern ADWDPMgr		adwdpmgr_adw;
	extern ANATextDataMgr	anatdm_adw;
	extern Widget		da_adw;
	GenData			*gendata;
	GrpData			*grpdata;
	AlData			*aldata;
	int			i, j;
	int			xo, yo;
	int			dx, dy;
	int			x, y;
	int			code;
	
	gendata = gadata_sf.gendatamgr.gendata + genid_adw - 1;
	grpdata = gendata->grpdatamgr.grpdata + grpid_adw - 1;

	xo = adwdpmgr_adw.marginvwleft
	     + adwdpmgr_adw.alnamewidth
	     + adwdpmgr_adw.algap;
	yo = adwdpmgr_adw.marginvwtop
	     + adwdpmgr_adw.alinformation
	     + adwdpmgr_adw.alscale;

	dx = MAX(anatdm_adw.bw, adwdpmgr_adw.fontwidth);
	dy = MAX(anatdm_adw.bh, adwdpmgr_adw.fontheight);

	for (y = yo, i = 0; i < grpdata->aldatamgr.alcnt; y += dy, i++) {
		aldata = grpdata->aldatamgr.aldata + i;
		for (x = xo, j = 0; j < aldata->allen; x += dx, j++) {
			code = *(aldata->alignment+j);
			XFillRectangle(XtDisplay(da_adw),
				       XtWindow(da_adw),
				       (anatdm_adw.td+code)->gcnabg,
				       x,
				       y,
				       (Dimension)anatdm_adw.bw,
				       (Dimension)anatdm_adw.bh);
			XDrawString(XtDisplay(da_adw),
				    XtWindow(da_adw),
				    (anatdm_adw.td+code)->gct,
				    x + (anatdm_adw.td+code)->tosx,
				    y + (anatdm_adw.td+code)->tosy,
				    (anatdm_adw.td+code)->text,
				    strlen((anatdm_adw.td+code)->text));
		}
	}

	XFlush(XtDisplay(da_adw));
}

/*--------------------------------------------------------------------*/

static void
draw_scale_adw()
{
	extern GAData		gadata_sf;
	extern int		genid_adw;
	extern int		grpid_adw;
	extern ANATextDataMgr	anatdm_adw;
	extern ADWDPMgr		adwdpmgr_adw;
	extern Widget		da_adw;
	extern GC		gc_da_scale_adw;
	GenData			*gendata;
	GrpData			*grpdata;
	int			i;
	int			adjx;
	int			xo, yov, yol;
	int			dx;
	int			x;
	char			buffer[BUFSIZ];
	int			length;
	int			j;
	int			xxo;
	int			dxx;
	int			xx;

	gendata = gadata_sf.gendatamgr.gendata + genid_adw - 1;
	grpdata = gendata->grpdatamgr.grpdata + grpid_adw - 1;

	adjx = abs(anatdm_adw.bw - adwdpmgr_adw.fontwidth) / 2;
	xo = adwdpmgr_adw.marginvwleft
	     + adwdpmgr_adw.alnamewidth
	     + adwdpmgr_adw.algap
	     + adjx;;
	yov = adwdpmgr_adw.marginvwtop
	      + adwdpmgr_adw.alinformation
	      + adwdpmgr_adw.fontascent;
	yol = yov + adwdpmgr_adw.fontheight;
	dx = MAX(anatdm_adw.bw, adwdpmgr_adw.fontwidth);

	for (x = xo, i = 1; i <= grpdata->aldatamgr.allenmax; x += dx, i++) {
		if (i % 10 == 0) {
			(void)sprintf(buffer, "%d", i);
			length = strlen(buffer);
			xxo = x + (1 - length) * adwdpmgr_adw.fontwidth / 2;
			dxx = adwdpmgr_adw.fontwidth;
			for (xx = xxo, j = 0; j < length; xx += dxx, j++) {
				XDrawString(XtDisplay(da_adw),
					    XtWindow(da_adw),
					    gc_da_scale_adw,
					    xx,
					    yov,
					    buffer + j,
					    1);
			}
			XDrawString(XtDisplay(da_adw), XtWindow(da_adw), gc_da_scale_adw,
				    x, yol,
				    "|", 1);
		}
		else
			XDrawString(XtDisplay(da_adw), XtWindow(da_adw), gc_da_scale_adw,
				    x, yol,
				    "-", 1);
	}

	XFlush(XtDisplay(da_adw));
}

/*--------------------------------------------------------------------*/

static void
draw_identity_adw()
{
	extern GAData		gadata_sf;
	extern int		genid_adw;
	extern int		grpid_adw;
	extern ANATextDataMgr	anatdm_adw;
	extern ADWDPMgr		adwdpmgr_adw;
	extern Widget		da_adw;
	extern GC		gc_da_identity_adw;
	extern char		anacode_itoc_adw[ANACID_COUNT];
	GenData			*gendata;
	GrpData			*grpdata;
	int			i;
	int			adjx;
	int			xo, yo;
	int			dx;
	int			x;

	gendata = gadata_sf.gendatamgr.gendata + genid_adw - 1;
	grpdata = gendata->grpdatamgr.grpdata + grpid_adw - 1;

	adjx = abs(anatdm_adw.bw - adwdpmgr_adw.fontwidth) / 2;
	xo = adwdpmgr_adw.marginvwleft
	     + adwdpmgr_adw.alnamewidth
	     + adwdpmgr_adw.algap
	     + adjx;
	yo = adwdpmgr_adw.marginvwtop
	     + adwdpmgr_adw.alinformation
	     + adwdpmgr_adw.alscale
	     + adwdpmgr_adw.aldataheight
	     + adwdpmgr_adw.fontascent;
	dx = MAX(anatdm_adw.bw, adwdpmgr_adw.fontwidth);

	for (x = xo, i = 0; i < grpdata->aldatamgr.allenmax; x += dx, i++) {
		if (*(grpdata->aldatamgr.identity+i) >= ANACID_CODE_MIN &&
		    *(grpdata->aldatamgr.identity+i) <= ANACID_CODE_MAX)
			XDrawString(XtDisplay(da_adw), XtWindow(da_adw), gc_da_identity_adw,
				    x, yo,
				    anacode_itoc_adw + *(grpdata->aldatamgr.identity+i), 1);
	}

	XFlush(XtDisplay(da_adw));
}

static void
erase_identity_adw()
{
	extern GAData		gadata_sf;
	extern int		genid_adw;
	extern int		grpid_adw;
	extern ANATextDataMgr	anatdm_adw;
	extern ADWDPMgr		adwdpmgr_adw;
	extern Widget		da_adw;
	extern GC		gc_da_bg_adw;
	GenData			*gendata;
	GrpData			*grpdata;
	int			adjx;
	int			xo, yo;
	int			w, h;
	Dimension		width, height;

	gendata = gadata_sf.gendatamgr.gendata + genid_adw - 1;
	grpdata = gendata->grpdatamgr.grpdata + grpid_adw - 1;

	adjx = abs(anatdm_adw.bw - adwdpmgr_adw.fontwidth) / 2;
	xo = adwdpmgr_adw.marginvwleft
	     + adwdpmgr_adw.alnamewidth
	     + adwdpmgr_adw.algap
	     + adjx;
	yo = adwdpmgr_adw.marginvwtop
	     + adwdpmgr_adw.alinformation
	     + adwdpmgr_adw.alscale
	     + adwdpmgr_adw.aldataheight;
	w = MAX(anatdm_adw.bw, adwdpmgr_adw.fontwidth);
	h = MAX(anatdm_adw.bh, adwdpmgr_adw.fontheight);
	width = grpdata->aldatamgr.allenmax * w;
	height = h;

	XFillRectangle(XtDisplay(da_adw), XtWindow(da_adw), gc_da_bg_adw,
		       xo, yo, width, height);

	XFlush(XtDisplay(da_adw));
}

/*--------------------------------------------------------------------*/

static void
draw_costgraph_adw()
{
	extern GAData		gadata_sf;
	extern int		genid_adw;
	extern int		grpid_adw;
	extern ANATextDataMgr	anatdm_adw;
	extern ADWDPMgr		adwdpmgr_adw;
	extern int		barchart_mv_adw;
	extern int		barchart_mr_adw;
	extern Widget		da_adw;
	extern GC		gc_da_cost_plus_adw;
	extern GC		gc_da_cost_motif_adw;
	extern GC		gc_da_cost_minus_adw;
	GenData			*gendata;
	GrpData			*grpdata;
	int			i;
	int			adjx;
	int			xo, yo;
	int			dx;
	int			x, y;
	float			mcplus, mcminus;
	int			cost;
	Dimension		width, height;
	Dimension		mrheight;
	GC			gc;

	gendata = gadata_sf.gendatamgr.gendata + genid_adw - 1;
	grpdata = gendata->grpdatamgr.grpdata + grpid_adw - 1;

	adjx = abs(anatdm_adw.bw - adwdpmgr_adw.fontwidth) / 2;
	xo = adwdpmgr_adw.marginvwleft
	     + adwdpmgr_adw.alnamewidth
	     + adwdpmgr_adw.algap
	     + adjx;
	yo = adwdpmgr_adw.marginvwtop
	     + adwdpmgr_adw.alinformation
	     + adwdpmgr_adw.alscale
	     + adwdpmgr_adw.aldataheight
	     + adwdpmgr_adw.alidentity
	     + adwdpmgr_adw.alcgplus;
	dx = MAX(anatdm_adw.bw, adwdpmgr_adw.fontwidth);

	mcplus = (float)adwdpmgr_adw.alcgplus / (float)barchart_mv_adw;
	mcminus = (float)adwdpmgr_adw.alcgminus / (float)barchart_mv_adw;

	for (x = xo, i = 0; i < grpdata->aldatamgr.allenmax; x += dx, i++) {
		cost = - *(grpdata->aldatamgr.cost+i);
		if (cost == 0)
			continue;
		else if (cost > 0) {
			height = (Dimension)(mcplus * (float)cost + 0.5);
/*
			if (height == 0)
				height = 1;
*/
			if (height > adwdpmgr_adw.alcgplus)
				height = adwdpmgr_adw.alcgplus;
			y = yo - height;
			mrheight = (int)((float)adwdpmgr_adw.alcgplus
					 * (float)barchart_mr_adw
					 / 100.0);
			if (height >= mrheight)
				gc = gc_da_cost_motif_adw;
			else
				gc = gc_da_cost_plus_adw;
		}
		else if (cost < 0) {
			height = (Dimension)(mcminus * (float)(- cost) + 0.5);
/*
			if (height == 0)
				height = 1;
*/
			if (height > adwdpmgr_adw.alcgminus)
				height = adwdpmgr_adw.alcgminus;
			y = yo;
			gc = gc_da_cost_minus_adw;
		}
		width = (Dimension)dx;
		if (width > 1)
			width--;
		XFillRectangle(XtDisplay(da_adw), XtWindow(da_adw), gc,
			       x, y, width, height);
	}

	XFlush(XtDisplay(da_adw));
}

static void
erase_costgraph_adw()
{
	extern GAData		gadata_sf;
	extern int		genid_adw;
	extern int		grpid_adw;
	extern ANATextDataMgr	anatdm_adw;
	extern ADWDPMgr		adwdpmgr_adw;
	extern Widget		da_adw;
	extern GC		gc_da_bg_adw;
	GenData			*gendata;
	GrpData			*grpdata;
	int			adjx;
	int			xo, yo;
	int			w;
	Dimension		width, height;

	gendata = gadata_sf.gendatamgr.gendata + genid_adw - 1;
	grpdata = gendata->grpdatamgr.grpdata + grpid_adw - 1;

	adjx = abs(anatdm_adw.bw - adwdpmgr_adw.fontwidth) / 2;
	xo = adwdpmgr_adw.marginvwleft
	     + adwdpmgr_adw.alnamewidth
	     + adwdpmgr_adw.algap
	     + adjx;
	yo = adwdpmgr_adw.marginvwtop
	     + adwdpmgr_adw.alinformation
	     + adwdpmgr_adw.alscale
	     + adwdpmgr_adw.aldataheight
	     + adwdpmgr_adw.alidentity;
	w = MAX(anatdm_adw.bw, adwdpmgr_adw.fontwidth);
	width = grpdata->aldatamgr.allenmax * w;
	height = adwdpmgr_adw.alcostgraph;

	XFillRectangle(XtDisplay(da_adw), XtWindow(da_adw), gc_da_bg_adw,
		       xo, yo, width, height);

	XFlush(XtDisplay(da_adw));
}
/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
