/*----------------------------------------------------------------------

	ե̾	gavtd_realtime.c
			ꥢ륿ʥǡ١
			եͳ
	Ƥ	ʸǡΥסå

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<string.h>

#include	"gavt_def.h"

/*--------------------------------------------------------------------*/

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

static int	data_count = 0;

/*--------------------------------------------------------------------*/

/*
  ͡ơ
	ǡ
	ǣǡ
	λǡ
*/

int
read_gadatatmp()
{
	int		status;
	int		endflag;
	void		read_gadatatmp_initdata();
	int		read_gadatatmp_gendata();

	if (data_count == 0) {
		read_gadatatmp_initdata();
		status = 1;
	}
	else {
		endflag = read_gadatatmp_gendata();
		if (!endflag)
			status = 2;
		else
			status = 3;
	}

	if (status == 3)
		data_count = 0;
	else
		data_count++;

	return status;
}

/*--------------------------------------------------------------------*/

static void
read_gadatatmp_initdata()
{
	extern char	*fn_gadatatmp;
	extern GAData	gadata_sf;
	FILE		*fp;
	extern void	fatal_error();
	extern void	free_gadata();
	extern void	init_gadata();
#if	0
	extern void	output_gadata();
#endif
	extern void	input_initdata_text();
	extern void	alloc_gendatamgr();

	if ((fp = fopen(fn_gadatatmp, "r")) == (FILE *)NULL)
		fatal_error("read_gadatatmp_initdata",
			    "fopen error (filename = %s)\n",
			    fn_gadatatmp);

	free_gadata(&gadata_sf);
	init_gadata(&gadata_sf);

	input_initdata_text(fp, &gadata_sf.initdata);

	if (fclose(fp) != 0)
		fatal_error("read_gadatatmp_initdata",
			    "fclose error (filename = %s)\n",
			    fn_gadatatmp);

	alloc_gendatamgr(&gadata_sf.gendatamgr, GENDATA_ARRAY_INITSIZE);

#if	0
	output_gadata("read_gadatatmp_initdata", &gadata_sf);
#endif
}

/*--------------------------------------------------------------------*/

static int
read_gadatatmp_gendata()
{
	extern char	*fn_gadatatmp;
	extern GAData	gadata_sf;
	FILE		*fp;
	int		endflag;
	extern void	fatal_error();
#if	0
	extern void	output_gadata();
#endif
	int	input_gendatatmp_gendata();

	if ((fp = fopen(fn_gadatatmp, "r")) == (FILE *)NULL)
		fatal_error("read_gadatatmp_initdata",
			    "fopen error (filename = %s)\n",
			    fn_gadatatmp);

	endflag = input_gendatatmp_gendata(fp,
					   gadata_sf.initdata.grpcnt,
					   gadata_sf.initdata.idvcnt,
					   &gadata_sf.gendatamgr);

	if (fclose(fp) != 0)
		fatal_error("read_gadatatmp_initdata",
			    "fclose error (filename = %s)\n",
			    fn_gadatatmp);

#if	0
	output_gadata("read_gadatatmp_initdata", &gadata_sf);
#endif

	return endflag;
}

/*--------------------------------------------------------------------*/

static int
input_gendatatmp_gendata(fp, grpcnt, idvcnt, gendatamgr)
FILE		*fp;
int		grpcnt, idvcnt;
GenDataMgr	*gendatamgr;
{
	char		buffer[BUFSIZ];
	int		endflag;
	char		*p;
	int		n;
	extern int	get_linedata();
	extern void	fatal_error();
	extern void	realloc_gendatamgr();
	extern void	input_gendata_text();

	if (!get_linedata(fp, buffer))
		fatal_error("input_gendata_all_text",
			    "data not found\n");
	/* "#ALLEND" */
	if (!strcmp(buffer, "#ALLEND"))
		endflag = 1;
	/* "#GEN" */
	else if (!strcmp(buffer, "#GEN")) {
		if (gendatamgr->gencnt >= gendatamgr->genasz)
			realloc_gendatamgr(
			    gendatamgr,
			    (unsigned)gendatamgr->genasz + GENDATA_ARRAY_ADDSIZE);
		if (!get_linedata(fp, buffer))
			fatal_error("input_gendata_all_text",
				    "'GENERATION:' not found\n");
		if (strncmp(buffer, "GENERATION:", 11))
			fatal_error("input_gendata_all_text",
				    "'GENERATION:' not found\n");
		p = buffer + 11;
		n = atoi(p);
#ifdef	CHECK
		if (gendatamgr->gencnt > 0) {
			if (n <= (gendatamgr->gendata+gendatamgr->gencnt-1)->id)
				fatal_error("input_gendata_all_text",
					    "illegal GENERATION (%d)\n",
					    n);
		}
#endif
		input_gendata_text(fp, grpcnt, idvcnt,
				   gendatamgr->gendata + gendatamgr->gencnt, n);
		gendatamgr->gencnt++;
		/* "#GENEND" */
		if (!get_linedata(fp, buffer))
			fatal_error("input_gendata_all_text",
				    "'#GENEND' not found\n");
		if (strcmp(buffer, "#GENEND"))
			fatal_error("input_gendata_all_text",
				    "'#GENEND' not found\n");
		endflag = 0;
	}
	else
		fatal_error("input_gendata_all_text",
			    "illegal data (%s)\n",
			    buffer);

	return endflag;
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
