/*----------------------------------------------------------------------

	ե̾	gavtd_memory.c
			˴ؤʥǡ١

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/

#include	<stdio.h>
#include	<malloc.h>

#include	"gavt_def.h"

/*--------------------------------------------------------------------*/

#if	0
#ifdef	DEBUG
#undef	DEBUG
#endif
#endif

/*--------------------------------------------------------------------*/

/*  */

/* ǡ */

static void
init_intdata(intdata)
IntData	*intdata;
{
	intdata->idata = 0;
}

/* ǡ */

static void
init_intdatamgr(intdatamgr)
IntDataMgr	*intdatamgr;
{
	intdatamgr->intasz = 0;
	intdatamgr->intcnt = 0;
	intdatamgr->intdata = (IntData *)NULL;
}

/* ʸݥ󥿡ǡ */

static void
init_charpdata(charpdata)
CharPData	*charpdata;
{
	charpdata->cpdata = (char *)NULL;
}

/* ʸݥ󥿡ǡ */

static void
init_charpdatamgr(charpdatamgr)
CharPDataMgr	*charpdatamgr;
{
	charpdatamgr->charpasz = 0;
	charpdatamgr->charpcnt = 0;
	charpdatamgr->charpdata = (CharPData *)NULL;
}

/* ǡ */

static void
init_initdata(initdata)
InitData	*initdata;
{
	initdata->idvcnt = 0;
	initdata->grpcnt = 0;
	init_charpdatamgr(&initdata->comment);
	initdata->acidmode = 0;
}

/* Υǡ */

static void
init_idvdata(idvdata)
IdvData	*idvdata;
{
	idvdata->id = 0;
	idvdata->score = 0;
	idvdata->lastmig = 0;
	idvdata->lastx = 0;
	idvdata->freqid = 0;
	idvdata->nextdata = (IdvData *)NULL;
}

/* Υǡ */

static void
init_idvdatamgr(idvdatamgr)
IdvDataMgr	*idvdatamgr;
{
	idvdatamgr->idvcnt = 0;
	idvdatamgr->headdata = (IdvData *)NULL;
	idvdatamgr->scoremax = 0.0;
	idvdatamgr->scoremin = 0.0;
	idvdatamgr->scoreave = 0.0;
}

/* 饤ȡǡ */

static void
init_aldata(aldata)
AlData	*aldata;
{
	aldata->nmlen = 0;
	aldata->name = (char *)NULL;
	aldata->allen = 0;
	aldata->alignment = (char *)NULL;
}

/* 饤ȡǡ */

static void
init_aldatamgr(aldatamgr)
AlDataMgr	*aldatamgr;
{
	aldatamgr->nmlenmax = 0;
	aldatamgr->allenmax = 0;
	aldatamgr->alasz = 0;
	aldatamgr->alcnt = 0;
	aldatamgr->aldata = (AlData *)NULL;
	aldatamgr->identity = (char *)NULL;
	aldatamgr->totalcost = 0;
	aldatamgr->cost = (int *)NULL;
}

/* ٥ǡ */

static void
init_freqdata(freqdata)
FreqData	*freqdata;
{
	freqdata->lower = 0;
	freqdata->upper = 0;
	freqdata->frequency = 0;
}

/* ٥ǡ */

static void
init_freqdatamgr(freqdatamgr)
FreqDataMgr	*freqdatamgr;
{
	freqdatamgr->freqasz = 0;
	freqdatamgr->freqcnt = 0;
	freqdatamgr->freqdata = (FreqData *)NULL;
	freqdatamgr->freqmax = 0;
}

/* 롼סǡ */

static void
init_grpdata(grpdata)
GrpData	*grpdata;
{
	void	init_idvdatamgr();
	void	init_aldatamgr();
	void	init_freqdatamgr();

	grpdata->id = '\0';
	init_idvdatamgr(&grpdata->idvdatamgr);
	init_aldatamgr(&grpdata->aldatamgr);
	init_freqdatamgr(&grpdata->freqdatamgr);
}

/* 롼סǡ */

static void
init_grpdatamgr(grpdatamgr)
GrpDataMgr	*grpdatamgr;
{
	grpdatamgr->grpasz = 0;
	grpdatamgr->grpcnt = 0;
	grpdatamgr->grpdata = (GrpData *)NULL;
	grpdatamgr->scoremax = 0.0;
	grpdatamgr->scoremin = 0.0;
	grpdatamgr->scoreave = 0.0;
	grpdatamgr->freqmax = 0;
}

/* ǡ */

static void
init_gendata(gendata)
GenData	*gendata;
{
	void	init_grpdatamgr();

	gendata->id = 0;
	init_grpdatamgr(&gendata->grpdatamgr);
}

/* ǡ */

static void
init_gendatamgr(gendatamgr)
GenDataMgr	*gendatamgr;
{
	gendatamgr->genasz = 0;
	gendatamgr->gencnt = 0;
	gendatamgr->gdipgencnt = 0;
	gendatamgr->gendata = (GenData *)NULL;
	gendatamgr->scoremax = 0.0;
	gendatamgr->scoremin = 0.0;
}

/* ǣǡ */

void
init_gadata(gadata)
GAData	*gadata;
{
	void	init_initdata();
	void	init_gendatamgr();

	init_initdata(&gadata->initdata);
	init_gendatamgr(&gadata->gendatamgr);
}

/*--------------------------------------------------------------------*/

/*  */

/* ǡ */

static IntData *
alloc_intdata(nelem)
unsigned	nelem;
{
	IntData		*p;
	extern void	fatal_error();

	if ((p = (IntData *)calloc(nelem, sizeof(IntData))) == (IntData *)NULL)
		fatal_error("alloc_intdata", "calloc error\n");

	return p;
}

static IntData *
realloc_intdata(intdata, nelem)
IntData		*intdata;
unsigned	nelem;
{
	IntData		*p;
	extern void	fatal_error();

	if ((p = (IntData *)realloc((char *)intdata, nelem * sizeof(IntData)))
	    == (IntData *)NULL)
		fatal_error("realloc_intdata", "realloc error\n");

	return p;
}

/* ǡ */

void
alloc_intdatamgr(intdatamgr, nelem)
IntDataMgr	*intdatamgr;
unsigned	nelem;
{
	int		i;
	IntData		*alloc_intdata();
	void		init_intdata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0)
		fatal_error("alloc_intdatamgr", "nelem = %u\n", nelem);
#endif

	intdatamgr->intasz = nelem;
	intdatamgr->intcnt = 0;
	intdatamgr->intdata = alloc_intdata(nelem);

	for (i = 0; i < nelem; i++)
		init_intdata(intdatamgr->intdata + i);
}

void
realloc_intdatamgr(intdatamgr, nelem)
IntDataMgr	*intdatamgr;
unsigned	nelem;
{
	int		i;
	IntData		*realloc_intdata();
	void		init_intdata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0 || intdatamgr->intdata == (IntData *)NULL)
		fatal_error("realloc_intdatamgr",
			    "nelem, intdata = %u, %u\n",
			    nelem, intdatamgr->intdata);
#endif

#if	0
	(void)printf("nelem = %u\n", nelem);
	(void)printf("(1) intdatamgr->(intasz,intcnt,intdata) = %d %d %u\n",
		     intdatamgr->intasz, intdatamgr->intcnt, intdatamgr->intdata);
#endif

	intdatamgr->intdata = realloc_intdata(intdatamgr->intdata, nelem);

	intdatamgr->intasz = nelem;
	if (intdatamgr->intcnt > nelem)
		intdatamgr->intcnt = nelem;
	else if (intdatamgr->intcnt == nelem)
		;
	else {
		for (i = intdatamgr->intcnt; i < nelem; i++)
			init_intdata(intdatamgr->intdata + i);
	}

#if	0
	(void)printf("(2) intdatamgr->(intasz,intcnt,intdata) = %d %d %u\n",
		     intdatamgr->intasz, intdatamgr->intcnt, intdatamgr->intdata);
#endif
}

/* ʸݥ󥿡ǡ */

static CharPData *
alloc_charpdata(nelem)
unsigned	nelem;
{
	CharPData	*p;
	extern void	fatal_error();

	if ((p = (CharPData *)calloc(nelem, sizeof(CharPData))) == (CharPData *)NULL)
		fatal_error("alloc_charpdata", "calloc error\n");

	return p;
}

static CharPData *
realloc_charpdata(charpdata, nelem)
CharPData	*charpdata;
unsigned	nelem;
{
	CharPData	*p;
	extern void	fatal_error();

	if ((p = (CharPData *)realloc((char *)charpdata, nelem * sizeof(CharPData)))
	    == (CharPData *)NULL)
		fatal_error("realloc_charpdata", "realloc error\n");

	return p;
}

/* ʸݥ󥿡ǡ */

void
alloc_charpdatamgr(charpdatamgr, nelem)
CharPDataMgr	*charpdatamgr;
unsigned	nelem;
{
	int		i;
	CharPData	*alloc_charpdata();
	void		init_charpdata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0)
		fatal_error("alloc_charpdatamgr", "nelem = %u\n", nelem);
#endif

	charpdatamgr->charpasz = nelem;
	charpdatamgr->charpcnt = 0;
	charpdatamgr->charpdata = alloc_charpdata(nelem);

	for (i = 0; i < nelem; i++)
		init_charpdata(charpdatamgr->charpdata + i);
}

void
realloc_charpdatamgr(charpdatamgr, nelem)
CharPDataMgr	*charpdatamgr;
unsigned	nelem;
{
	int		i;
	CharPData	*realloc_charpdata();
	void		init_charpdata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0 || charpdatamgr->charpdata == (CharPData *)NULL)
		fatal_error("realloc_charpdatamgr",
			    "nelem, charpdata = %u, %u\n",
			    nelem, charpdatamgr->charpdata);
#endif

#if	0
	(void)printf("nelem = %u\n", nelem);
	(void)printf("(1) charpdatamgr->(charpasz,charpcnt,charpdata) = %d %d %u\n",
		     charpdatamgr->charpasz,
		     charpdatamgr->charpcnt,
		     charpdatamgr->charpdata);
#endif

	charpdatamgr->charpdata = realloc_charpdata(charpdatamgr->charpdata, nelem);

	charpdatamgr->charpasz = nelem;
	if (charpdatamgr->charpcnt > nelem)
		charpdatamgr->charpcnt = nelem;
	else if (charpdatamgr->charpcnt == nelem)
		;
	else {
		for (i = charpdatamgr->charpcnt; i < nelem; i++)
			init_charpdata(charpdatamgr->charpdata + i);
	}

#if	0
	(void)printf("(2) charpdatamgr->(charpasz,charpcnt,charpdata) = %d %d %u\n",
		     charpdatamgr->charpasz,
		     charpdatamgr->charpcnt,
		     charpdatamgr->charpdata);
#endif
}

/* Υǡ */

static IdvData *
alloc_idvdata(nelem)
unsigned	nelem;
{
	IdvData		*p;
	extern void	fatal_error();

	if ((p = (IdvData *)calloc(nelem, sizeof(IdvData))) == (IdvData *)NULL)
		fatal_error("alloc_idvdata", "calloc error\n");

	return p;
}

#if	0

static IdvData *
realloc_idvdata(idvdata, nelem)
IdvData		*idvdata;
unsigned	nelem;
{
	IdvData		*p;
	extern void	fatal_error();

	if ((p = (IdvData *)realloc((char *)idvdata, nelem * sizeof(IdvData)))
	    == (IdvData *)NULL)
		fatal_error("realloc_idvdata", "realloc error\n");

	return p;
}

#endif

/* Υǡ */

IdvData *
add_id_to_idvdatamgr(idvdatamgr, id)
IdvDataMgr	*idvdatamgr;
int		id;
{
	IdvData		*p;
	IdvData		*add_id_to_idvdatamgr_r();
#ifdef	CHECK
	extern void	fatal_error();

	if (id <= 0)
		fatal_error("add_id_to_idvdatamgr", "id = %d\n", id);
#endif

	p = add_id_to_idvdatamgr_r(&idvdatamgr->headdata, id);
	idvdatamgr->idvcnt++;

	return p;
}

static IdvData *
add_id_to_idvdatamgr_r(idvdata, id)
IdvData	**idvdata;
int	id;
{
	IdvData		*p;
	IdvData		*alloc_idvdata();
	void		init_idvdata();
	extern void	fatal_error();

	if (*idvdata == (IdvData *)NULL) {
		p = alloc_idvdata(1);
		init_idvdata(p);
		p->id = id;
		*idvdata = p;
	}
	else {
		if (id < (*idvdata)->id) {
			p = alloc_idvdata(1);
			init_idvdata(p);
			p->id = id;
			p->nextdata = *idvdata;
			*idvdata = p;
		}
		else if (id > (*idvdata)->id)
			 p = add_id_to_idvdatamgr_r(&(*idvdata)->nextdata, id);
		else
			fatal_error("add_id_to_idvdatamgr_r", "duplicate id\n");
	}

	return p;
}

#if	0

void
alloc_idvdatamgr(idvdatamgr, nelem)
IdvDataMgr	*idvdatamgr;
unsigned	nelem;
{
	int		i;
	IdvData		*alloc_idvdata();
	void		init_idvdata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0)
		fatal_error("alloc_idvdatamgr", "nelem = %u\n", nelem);
#endif

	idvdatamgr->idvasz = nelem;
	idvdatamgr->idvcnt = 0;
	idvdatamgr->idvdata = alloc_idvdata(nelem);

	for (i = 0; i < nelem; i++)
		init_idvdata(idvdatamgr->idvdata + i);
}

void
realloc_idvdatamgr(idvdatamgr, nelem)
IdvDataMgr	*idvdatamgr;
unsigned	nelem;
{
	int		i;
	IdvData		*realloc_idvdata();
	void		init_idvdata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0 || idvdatamgr->idvdata == (IdvData *)NULL)
		fatal_error("realloc_idvdatamgr",
			    "nelem, idvdata = %u, %u\n",
			    nelem, idvdatamgr->idvdata);
#endif

#if	0
	(void)printf("nelem = %u\n", nelem);
	(void)printf("(1) idvdatamgr->(idvasz,idvcnt,idvdata) = %d %d %u\n",
		     idvdatamgr->idvasz, idvdatamgr->idvcnt, idvdatamgr->idvdata);
#endif

	idvdatamgr->idvdata = realloc_idvdata(idvdatamgr->idvdata, nelem);

	idvdatamgr->idvasz = nelem;
	if (idvdatamgr->idvcnt > nelem)
		idvdatamgr->idvcnt = nelem;
	else if (idvdatamgr->idvcnt == nelem)
		;
	else {
		for (i = idvdatamgr->idvcnt; i < nelem; i++)
			init_idvdata(idvdatamgr->idvdata + i);
	}

#if	0
	(void)printf("(2) idvdatamgr->(idvasz,idvcnt,idvdata) = %d %d %u\n",
		     idvdatamgr->idvasz, idvdatamgr->idvcnt, idvdatamgr->idvdata);
#endif
}

#endif

/* 饤ȡǡ */

static AlData *
alloc_aldata(nelem)
unsigned	nelem;
{
	AlData		*p;
	extern void	fatal_error();

	if ((p = (AlData *)calloc(nelem, sizeof(AlData))) == (AlData *)NULL)
		fatal_error("alloc_aldata", "calloc error\n");

	return p;
}

static AlData *
realloc_aldata(aldata, nelem)
AlData		*aldata;
unsigned	nelem;
{
	AlData		*p;
	extern void	fatal_error();

	if ((p = (AlData *)realloc((char *)aldata, nelem * sizeof(AlData)))
	    == (AlData *)NULL)
		fatal_error("realloc_aldata", "realloc error\n");

	return p;
}

/* 饤ȡǡ */

void
alloc_aldatamgr(aldatamgr, nelem)
AlDataMgr	*aldatamgr;
unsigned	nelem;
{
	int		i;
	AlData		*alloc_aldata();
	void		init_aldata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0)
		fatal_error("alloc_aldatamgr", "nelem = %u\n", nelem);
#endif

	aldatamgr->alasz = nelem;
	aldatamgr->alcnt = 0;
	aldatamgr->aldata = alloc_aldata(nelem);

	for (i = 0; i < nelem; i++)
		init_aldata(aldatamgr->aldata + i);
}

void
realloc_aldatamgr(aldatamgr, nelem)
AlDataMgr	*aldatamgr;
unsigned	nelem;
{
	int		i;
	AlData		*realloc_aldata();
	void		init_aldata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0 || aldatamgr->aldata == (AlData *)NULL)
		fatal_error("realloc_aldatamgr",
			    "nelem, aldata = %u, %u\n",
			    nelem, aldatamgr->aldata);
#endif

#if	0
	(void)printf("nelem = %u\n", nelem);
	(void)printf("(1) aldatamgr->(alasz,alcnt,aldata) = %d %d %u\n",
		     aldatamgr->alasz, aldatamgr->alcnt, aldatamgr->aldata);
#endif

	aldatamgr->aldata = realloc_aldata(aldatamgr->aldata, nelem);

	aldatamgr->alasz = nelem;
	if (aldatamgr->alcnt > nelem)
		aldatamgr->alcnt = nelem;
	else if (aldatamgr->alcnt == nelem)
		;
	else {
		for (i = aldatamgr->alcnt; i < nelem; i++)
			init_aldata(aldatamgr->aldata + i);
	}

#if	0
	(void)printf("(2) aldatamgr->(alasz,alcnt,aldata) = %d %d %u\n",
		     aldatamgr->alasz, aldatamgr->alcnt, aldatamgr->aldata);
#endif
}

/* ٥ǡ */

static FreqData *
alloc_freqdata(nelem)
unsigned	nelem;
{
	FreqData	*p;
	extern void	fatal_error();

	if ((p = (FreqData *)calloc(nelem, sizeof(FreqData))) == (FreqData *)NULL)
		fatal_error("alloc_freqdata", "calloc error\n");

	return p;
}

static FreqData *
realloc_freqdata(freqdata, nelem)
FreqData	*freqdata;
unsigned	nelem;
{
	FreqData	*p;
	extern void	fatal_error();

	if ((p = (FreqData *)realloc((char *)freqdata, nelem * sizeof(FreqData)))
	    == (FreqData *)NULL)
		fatal_error("realloc_freqdata", "realloc error\n");

	return p;
}

/* ٥ǡ */

void
alloc_freqdatamgr(freqdatamgr, nelem)
FreqDataMgr	*freqdatamgr;
unsigned	nelem;
{
	int		i;
	FreqData	*alloc_freqdata();
	void		init_freqdata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0)
		fatal_error("alloc_freqdatamgr", "nelem = %u\n", nelem);
#endif

	freqdatamgr->freqasz = nelem;
	freqdatamgr->freqcnt = 0;
	freqdatamgr->freqdata = alloc_freqdata(nelem);

	for (i = 0; i < nelem; i++)
		init_freqdata(freqdatamgr->freqdata + i);
}

void
realloc_freqdatamgr(freqdatamgr, nelem)
FreqDataMgr	*freqdatamgr;
unsigned	nelem;
{
	int		i;
	FreqData	*realloc_freqdata();
	void		init_freqdata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0 || freqdatamgr->freqdata == (FreqData *)NULL)
		fatal_error("realloc_freqdatamgr",
			    "nelem, freqdata = %u, %u\n",
			    nelem, freqdatamgr->freqdata);
#endif

#if	0
	(void)printf("nelem = %u\n", nelem);
	(void)printf("(1) freqdatamgr->(freqasz,freqcnt,freqdata) = %d %d %u\n",
		     freqdatamgr->freqasz, freqdatamgr->freqcnt, freqdatamgr->freqdata);
#endif

	freqdatamgr->freqdata = realloc_freqdata(freqdatamgr->freqdata, nelem);

	freqdatamgr->freqasz = nelem;
	if (freqdatamgr->freqcnt > nelem)
		freqdatamgr->freqcnt = nelem;
	else if (freqdatamgr->freqcnt == nelem)
		;
	else {
		for (i = freqdatamgr->freqcnt; i < nelem; i++)
			init_freqdata(freqdatamgr->freqdata + i);
	}

#if	0
	(void)printf("(2) freqdatamgr->(freqasz,freqcnt,freqdata) = %d %d %u\n",
		     freqdatamgr->freqasz, freqdatamgr->freqcnt, freqdatamgr->freqdata);
#endif
}

/* 롼סǡ */

static GrpData *
alloc_grpdata(nelem)
unsigned	nelem;
{
	GrpData		*p;
	extern void	fatal_error();

	if ((p = (GrpData *)calloc(nelem, sizeof(GrpData))) == (GrpData *)NULL)
		fatal_error("alloc_grpdata", "calloc error\n");

	return p;
}

static GrpData *
realloc_grpdata(grpdata, nelem)
GrpData		*grpdata;
unsigned	nelem;
{
	GrpData		*p;
	extern void	fatal_error();

	if ((p = (GrpData *)realloc((char *)grpdata, nelem * sizeof(GrpData)))
	    == (GrpData *)NULL)
		fatal_error("realloc_grpdata", "realloc error\n");

	return p;
}

/* 롼סǡ */

void
alloc_grpdatamgr(grpdatamgr, nelem)
GrpDataMgr	*grpdatamgr;
unsigned	nelem;
{
	int		i;
	GrpData		*alloc_grpdata();
	void		init_grpdata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0)
		fatal_error("alloc_grpdatamgr", "nelem = %u\n", nelem);
#endif

	grpdatamgr->grpasz = nelem;
	grpdatamgr->grpcnt = 0;
	grpdatamgr->grpdata = alloc_grpdata(nelem);

	for (i = 0; i < nelem; i++)
		init_grpdata(grpdatamgr->grpdata + i);
}

void
realloc_grpdatamgr(grpdatamgr, nelem)
GrpDataMgr	*grpdatamgr;
unsigned	nelem;
{
	int		i;
	GrpData		*realloc_grpdata();
	void		init_grpdata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0 || grpdatamgr->grpdata == (GrpData *)NULL)
		fatal_error("realloc_grpdatamgr",
			    "nelem, grpdata = %u, %u\n",
			    nelem, grpdatamgr->grpdata);
#endif

#if	0
	(void)printf("nelem = %u\n", nelem);
	(void)printf("(1) grpdatamgr->(grpasz,grpcnt,grpdata) = %d %d %u\n",
		     grpdatamgr->grpasz, grpdatamgr->grpcnt, grpdatamgr->grpdata);
#endif

	grpdatamgr->grpdata = realloc_grpdata(grpdatamgr->grpdata, nelem);

	grpdatamgr->grpasz = nelem;
	if (grpdatamgr->grpcnt > nelem)
		grpdatamgr->grpcnt = nelem;
	else if (grpdatamgr->grpcnt == nelem)
		;
	else {
		for (i = grpdatamgr->grpcnt; i < nelem; i++)
			init_grpdata(grpdatamgr->grpdata + i);
	}

#if	0
	(void)printf("(2) grpdatamgr->(grpasz,grpcnt,grpdata) = %d %d %u\n",
		     grpdatamgr->grpasz, grpdatamgr->grpcnt, grpdatamgr->grpdata);
#endif
}

/* ǡ */

static GenData *
alloc_gendata(nelem)
unsigned	nelem;
{
	GenData		*p;
	extern void	fatal_error();

	if ((p = (GenData *)calloc(nelem, sizeof(GenData))) == (GenData *)NULL)
		fatal_error("alloc_gendata", "calloc error\n");

	return p;
}

static GenData *
realloc_gendata(gendata, nelem)
GenData		*gendata;
unsigned	nelem;
{
	GenData		*p;
	extern void	fatal_error();

	if ((p = (GenData *)realloc((char *)gendata, nelem * sizeof(GenData)))
	    == (GenData *)NULL)
		fatal_error("realloc_gendata", "realloc error\n");

	return p;
}

/* ǡ */

void
alloc_gendatamgr(gendatamgr, nelem)
GenDataMgr	*gendatamgr;
unsigned	nelem;
{
	int		i;
	GenData		*alloc_gendata();
	void		init_gendata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0)
		fatal_error("alloc_gendatamgr", "nelem = %u\n", nelem);
#endif

	gendatamgr->genasz = nelem;
	gendatamgr->gencnt = 0;
	gendatamgr->gendata = alloc_gendata(nelem);

	for (i = 0; i < nelem; i++)
		init_gendata(gendatamgr->gendata + i);
}

void
realloc_gendatamgr(gendatamgr, nelem)
GenDataMgr	*gendatamgr;
unsigned	nelem;
{
	int		i;
	GenData		*realloc_gendata();
	void		init_gendata();
#ifdef	CHECK
	extern void	fatal_error();

	if (nelem <= 0 || gendatamgr->gendata == (GenData *)NULL)
		fatal_error("realloc_gendatamgr",
			    "nelem, gendata = %u, %u\n",
			    nelem, gendatamgr->gendata);
#endif

#if	0
	(void)printf("nelem = %u\n", nelem);
	(void)printf("(1) gendatamgr->(genasz,gencnt,gendata) = %d %d %u\n",
		     gendatamgr->genasz, gendatamgr->gencnt, gendatamgr->gendata);
#endif

	gendatamgr->gendata = realloc_gendata(gendatamgr->gendata, nelem);

	gendatamgr->genasz = nelem;
	if (gendatamgr->gencnt > nelem)
		gendatamgr->gencnt = nelem;
	else if (gendatamgr->gencnt == nelem)
		;
	else {
		for (i = gendatamgr->gencnt; i < nelem; i++)
			init_gendata(gendatamgr->gendata + i);
	}

#if	0
	(void)printf("(2) gendatamgr->(genasz,gencnt,gendata) = %d %d %u\n",
		     gendatamgr->genasz, gendatamgr->gencnt, gendatamgr->gendata);
#endif
}

/*--------------------------------------------------------------------*/

/*  */

/* ǡ */

void
free_intdatamgr(intdatamgr)
IntDataMgr	*intdatamgr;
{
	void	cfree();

	if (intdatamgr->intdata != (IntData *)NULL)
		cfree((char *)intdatamgr->intdata);
}

/* ʸݥ󥿡ǡ */

static void
free_charpdatamgr(charpdatamgr)
CharPDataMgr	*charpdatamgr;
{
	int	i;
	void	cfree();

	if (charpdatamgr->charpdata != (CharPData *)NULL) {
		for (i = 0; i < charpdatamgr->charpcnt; i++)
			free((charpdatamgr->charpdata+i)->cpdata);
		cfree((char *)charpdatamgr->charpdata);
	}
}

/* ǡ */

static void
free_initdata(initdata)
InitData	*initdata;
{
	void	free_charpdatamgr();

	free_charpdatamgr(&initdata->comment);
}

/* Υǡ */

static void
free_idvdata(idvdata)
IdvData	*idvdata;
{
	void	free_idvdata();
	void	cfree();

	if (idvdata != (IdvData *)NULL)
		free_idvdata(idvdata->nextdata);

	cfree((char *)idvdata);
}

/* Υǡ */

static void
free_idvdatamgr(idvdatamgr)
IdvDataMgr	*idvdatamgr;
{
	void	free_idvdata();

	free_idvdata(idvdatamgr->headdata);
}

/* 饤ȡǡ */

static void
free_aldata(aldata)
AlData	*aldata;
{
	if (aldata->name != (char *)NULL)
		free(aldata->name);
	if (aldata->alignment != (char *)NULL)
		free(aldata->alignment);
}

/* 饤ȡǡ */

static void
free_aldatamgr(aldatamgr)
AlDataMgr	*aldatamgr;
{
	int	i;
	void	free_aldata();
	void	cfree();

	if (aldatamgr->aldata != (AlData *)NULL) {
		for (i = 0; i < aldatamgr->alcnt; i++)
			free_aldata(aldatamgr->aldata+i);
		cfree((char *)aldatamgr->aldata);
	}

	if (aldatamgr->identity != (char *)NULL)
		cfree(aldatamgr->identity);

	if (aldatamgr->cost != (int *)NULL)
		cfree((char *)aldatamgr->cost);
}

/* ٥ǡ */

static void
free_freqdatamgr(freqdatamgr)
FreqDataMgr	*freqdatamgr;
{
	void	cfree();

	if (freqdatamgr->freqdata != (FreqData *)NULL)
		cfree((char *)freqdatamgr->freqdata);
}

/* 롼סǡ */

static void
free_grpdata(grpdata)
GrpData	*grpdata;
{
	void	free_idvdatamgr();
	void	free_aldatamgr();
	void	free_freqdatamgr();

	free_idvdatamgr(&grpdata->idvdatamgr);
	free_aldatamgr(&grpdata->aldatamgr);
	free_freqdatamgr(&grpdata->freqdatamgr);
}

/* 롼סǡ */

static void
free_grpdatamgr(grpdatamgr)
GrpDataMgr	*grpdatamgr;
{
	int	i;
	void	free_grpdata();
	void	cfree();

	if (grpdatamgr->grpdata != (GrpData *)NULL) {
		for (i = 0; i < grpdatamgr->grpcnt; i++)
			free_grpdata(grpdatamgr->grpdata+i);
		cfree((char *)grpdatamgr->grpdata);
	}
}

/* ǡ */

static void
free_gendata(gendata)
GenData	*gendata;
{
	void	free_grpdatamgr();

	free_grpdatamgr(&gendata->grpdatamgr);
}

/* ǡ */

static void
free_gendatamgr(gendatamgr)
GenDataMgr	*gendatamgr;
{
	int	i;
	void	free_gendata();
	void	cfree();

	if (gendatamgr->gendata != (GenData *)NULL) {
		for (i = 0; i < gendatamgr->gencnt; i++)
			free_gendata(gendatamgr->gendata+i);
		cfree((char *)gendatamgr->gendata);
	}
}

/* ǣǡ */

void
free_gadata(gadata)
GAData	*gadata;
{
	void	free_initdata();
	void	free_gendatamgr();

	free_initdata(&gadata->initdata);
	free_gendatamgr(&gadata->gendatamgr);
}

/*--------------------------------------------------------------------*/

/* ٿΥ */

void
free_scorefreq_gadata(gadata)
GAData	*gadata;
{
	void	free_scorefreq_gendatamgr();

	free_scorefreq_gendatamgr(&gadata->gendatamgr);
}

static void
free_scorefreq_gendatamgr(gendatamgr)
GenDataMgr	*gendatamgr;
{
	int	i;
	void	free_scorefreq_gendata();

	if (gendatamgr->gendata != (GenData *)NULL) {
		for (i = 0; i < gendatamgr->gencnt; i++)
			free_scorefreq_gendata(gendatamgr->gendata + i);
	}
}

/*--------------------------------*/

void
free_scorefreq_sr_gadata(gadata, gennum1, gennum2)
GAData	*gadata;
int		gennum1;
int		gennum2;
{
	void	free_scorefreq_sr_gendatamgr();

	free_scorefreq_sr_gendatamgr(&gadata->gendatamgr, gennum1, gennum2);
}

static void
free_scorefreq_sr_gendatamgr(gendatamgr, gennum1, gennum2)
GenDataMgr	*gendatamgr;
int		gennum1;
int		gennum2;
{
	int		i;
#ifdef	CHECK
	extern void	fatal_error();
#endif
	void		free_scorefreq_gendata();

#ifdef	CHECK
	if (gennum1 <= 0 ||
	    gennum2 > gendatamgr->gencnt ||
	    gennum1 > gennum2)
		fatal_error("free_scorefreq_sr_gendatamgr",
			    "illegal gennum (gennum1, gennum2 = %d %d)\n",
			    gennum1, gennum2);
#endif

	for (i = gennum1 - 1; i < gennum2; i++)
		free_scorefreq_gendata(gendatamgr->gendata + i);
}

/*--------------------------------*/

static void
free_scorefreq_gendata(gendata)
GenData	*gendata;
{
	void	free_scorefreq_grpdatamgr();

	free_scorefreq_grpdatamgr(&gendata->grpdatamgr);
}

static void
free_scorefreq_grpdatamgr(grpdatamgr)
GrpDataMgr	*grpdatamgr;
{
	int	i;
	void	free_scorefreq_grpdata();

	if (grpdatamgr->grpdata != (GrpData *)NULL) {
		for (i = 0; i < grpdatamgr->grpcnt; i++)
			free_scorefreq_grpdata(grpdatamgr->grpdata+i);
	}
}

static void
free_scorefreq_grpdata(grpdata)
GrpData	*grpdata;
{
	void	free_freqdatamgr();

	free_freqdatamgr(&grpdata->freqdatamgr);
}

/*--------------------------------------------------------------------*/

/* ǥƥƥΥ */

void
free_identity_gadata(gadata)
GAData	*gadata;
{
	void	free_identity_gendatamgr();

	free_identity_gendatamgr(&gadata->gendatamgr);
}

static void
free_identity_gendatamgr(gendatamgr)
GenDataMgr	*gendatamgr;
{
	int	i;
	void	free_identity_gendata();

	if (gendatamgr->gendata != (GenData *)NULL) {
		for (i = 0; i < gendatamgr->gencnt; i++)
			free_identity_gendata(gendatamgr->gendata+i);
	}
}

static void
free_identity_gendata(gendata)
GenData	*gendata;
{
	void	free_identity_grpdatamgr();

	free_identity_grpdatamgr(&gendata->grpdatamgr);
}

static void
free_identity_grpdatamgr(grpdatamgr)
GrpDataMgr	*grpdatamgr;
{
	int	i;
	void	free_identity_grpdata();

	if (grpdatamgr->grpdata != (GrpData *)NULL) {
		for (i = 0; i < grpdatamgr->grpcnt; i++)
			free_identity_grpdata(grpdatamgr->grpdata+i);
	}
}

static void
free_identity_grpdata(grpdata)
GrpData	*grpdata;
{
	extern void	free_identity_aldatamgr();

	free_identity_aldatamgr(&grpdata->aldatamgr);
}

static void
free_identity_aldatamgr(aldatamgr)
AlDataMgr	*aldatamgr;
{
	void	cfree();

	cfree(aldatamgr->identity);
}

/*--------------------------------------------------------------------*/

/* ȤΥ */

void
free_cost_gadata(gadata)
GAData	*gadata;
{
	void	free_cost_gendatamgr();

	free_cost_gendatamgr(&gadata->gendatamgr);
}

static void
free_cost_gendatamgr(gendatamgr)
GenDataMgr	*gendatamgr;
{
	int	i;
	void	free_cost_gendata();
	void	cfree();

	if (gendatamgr->gendata != (GenData *)NULL) {
		for (i = 0; i < gendatamgr->gencnt; i++)
			free_cost_gendata(gendatamgr->gendata+i);
	}
}

static void
free_cost_gendata(gendata)
GenData	*gendata;
{
	void	free_cost_grpdatamgr();

	free_cost_grpdatamgr(&gendata->grpdatamgr);
}

static void
free_cost_grpdatamgr(grpdatamgr)
GrpDataMgr	*grpdatamgr;
{
	int	i;
	void	free_cost_grpdata();

	if (grpdatamgr->grpdata != (GrpData *)NULL) {
		for (i = 0; i < grpdatamgr->grpcnt; i++)
			free_cost_grpdata(grpdatamgr->grpdata+i);
	}
}

static void
free_cost_grpdata(grpdata)
GrpData	*grpdata;
{
	extern void	free_cost_aldatamgr();

	free_cost_aldatamgr(&grpdata->aldatamgr);
}

static void
free_cost_aldatamgr(aldatamgr)
AlDataMgr	*aldatamgr;
{
	void	cfree();

	cfree((char *)aldatamgr->cost);
}

/*----------------------------------------------------------------------
	eof
----------------------------------------------------------------------*/
