/*----------------------------------------------------------------------

	$B%U%!%$%kL>(B	keep_m_b.c

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/
#include "2dp_new_klic.h"

void 
keep_memory_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,buffx,buffy,NumX,NumY)
VEC **Vec0;
VEC **Vec1;
PATH_b **Path0;
PATH_b **Path1;
PROF **ProfI;
PROF **ProfJ;
long buffx,buffy,NumX,NumY;
{
  long i;
  char *calloc();

  
  if( ( *ProfI = ( PROF * )calloc( buffx, sizeof(PROF) ) ) == NULL ){
    fprintf(stderr,"calloc failed for ProfI\n"); exit();
  }
  if( ( *ProfJ = ( PROF * )calloc( buffy, sizeof(PROF) ) ) == NULL ){
    fprintf(stderr,"calloc failed for ProfJ\n"); exit();
  }

  for(i=0;i<buffx;i++){
    if( ( (*ProfI+i)->amigap = ( long * )calloc( NumX, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfI->amigap\n"); exit();
    }
    if( ( (*ProfI+i)->amigapp = ( long * )calloc( NumX, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfI->amigapp\n"); exit();
    }
    if( ( (*ProfI+i)->gap = ( long * )calloc( NumX, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfI->gap\n"); exit();
    }
    if( ( (*ProfI+i)->gapp = ( long * )calloc( NumX, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfI->gapp\n"); exit();
    }
  }

  for(i=0;i<buffy;i++){
    if( ( (*ProfJ+i)->amigap = ( long * )calloc( NumY, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfJ->amigap\n"); exit();
    }
    if( ( (*ProfJ+i)->amigapp = ( long * )calloc( NumY, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfJ->amigapp\n"); exit();
    }
    if( ( (*ProfJ+i)->gap = ( long * )calloc( NumY, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfJ->gap\n"); exit();
    }
    if( ( (*ProfJ+i)->gapp = ( long * )calloc( NumY, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for ProfJ->gapp\n"); exit();
    }
  }

  if( ( *Vec0 = ( VEC * )calloc( buffx, sizeof(VEC) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Vec0\n"); exit();
  }
  if( ( *Vec1 = ( VEC * )calloc( buffx, sizeof(VEC) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Vec1\n"); exit();
  }

  if( ( *Path0 = ( PATH_b * )calloc( buffx, sizeof(PATH_b) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Path0\n"); exit();
  }
  if( ( *Path1 = ( PATH_b * )calloc( buffx, sizeof(PATH_b) ) ) == NULL ){
    fprintf(stderr,"calloc failed for Path1\n"); exit();
  }

  for(i=0;i<buffx;i++){
    if( ( (*Path0+i)->gapx.gapi.gap = ( long * )calloc( buffy, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path0->gapx.gapi.gap\n"); exit();
    }
    if( ( (*Path0+i)->gapx.gapj.gap = ( long * )calloc( buffx, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path0->gapx.gapj.gap\n"); exit();
    }
    if( ( (*Path0+i)->gapxy.gapi.gap = ( long * )calloc( buffy, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path0->gapxy.gapi.gap\n"); exit();
    }
    if( ( (*Path0+i)->gapxy.gapj.gap = ( long * )calloc( buffx, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path0->gapxy.gapj.gap\n"); exit();
    }
    if( ( (*Path0+i)->gapy.gapi.gap = ( long * )calloc( buffy, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path0->gapy.gapi.gap\n"); exit();
    }
    if( ( (*Path0+i)->gapy.gapj.gap = ( long * )calloc( buffx, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path0->gapy.gapj.gap\n"); exit();
    }
    
    if( ( (*Path1+i)->gapx.gapi.gap = ( long * )calloc( buffy, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path1->gapx.gapi.gap\n"); exit();
    }
    if( ( (*Path1+i)->gapx.gapj.gap = ( long * )calloc( buffx, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path1->gapx.gapj.gap\n"); exit();
    }
    if( ( (*Path1+i)->gapxy.gapi.gap = ( long * )calloc( buffy, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path1->gapxy.gapi.gap\n"); exit();
    }
    if( ( (*Path1+i)->gapxy.gapj.gap = ( long * )calloc( buffx, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path1->gapxy.gapj.gap\n"); exit();
    }
    if( ( (*Path1+i)->gapy.gapi.gap = ( long * )calloc( buffy, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path1->gapy.gapi.gap\n"); exit();
    }
    if( ( (*Path1+i)->gapy.gapj.gap = ( long * )calloc( buffx, sizeof(long) ) ) == NULL ){
      fprintf(stderr,"calloc failed for Path1->gapy.gapj.gap\n"); exit();
    }

  }

}


void 
free_memory_b(Vec0,Vec1,Path0,Path1,ProfI,ProfJ,buffx,buffy)
VEC *Vec0;
VEC *Vec1;
PATH_b *Path0;
PATH_b *Path1;
PROF *ProfI;
PROF *ProfJ;
long buffx,buffy;
{
  long i;

  free(Vec0);
  free(Vec1);

  for(i=0;i<buffx;i++){
    free((Path0+i)->gapx.gapi.gap);
    free((Path0+i)->gapx.gapj.gap);
    free((Path0+i)->gapxy.gapi.gap);
    free((Path0+i)->gapxy.gapj.gap);
    free((Path0+i)->gapy.gapi.gap);
    free((Path0+i)->gapy.gapj.gap);
    
    free((Path1+i)->gapx.gapi.gap);
    free((Path1+i)->gapx.gapj.gap);
    free((Path1+i)->gapxy.gapi.gap);
    free((Path1+i)->gapxy.gapj.gap);
    free((Path1+i)->gapy.gapi.gap);
    free((Path1+i)->gapy.gapj.gap);
  }
  free(Path0);
  free(Path1);

  for(i=0;i<buffx;i++){
    free((ProfI+i)->amigap);
    free((ProfI+i)->amigapp);
    free((ProfI+i)->gap);
    free((ProfI+i)->gapp);
  }
  for(i=0;i<buffy;i++){
    free((ProfJ+i)->amigap);
    free((ProfJ+i)->amigapp);
    free((ProfJ+i)->gap);
    free((ProfJ+i)->gapp);
  }
  free(ProfI);
  free(ProfJ);

}
