/*----------------------------------------------------------------------

	$B%U%!%$%kL>(B	dist_b.c

	(C)1994 Institute for New Generation Computer Technology
	Read COPYRIGHT for detailed information.

----------------------------------------------------------------------*/
#include "2dp_new_klic.h"

#define DUMMY 1000000

extern long  outgapcost_I_b(),outgapcost_J_b();
extern long  paircost_IJ_F_b(),paircost_IJ_DXY_b(),paircost_IJ_DX_b(),paircost_IJ_DY_b();
extern long  gapcost_I_DXY_b(),gapcost_I_DX_b(),gapcost_I_DY_b();
extern long  gapcost_J_DXY_b(),gapcost_J_DX_b(),gapcost_J_DY_b();

extern long  minimum_X_b(),minimum_XY_b(),minimum_Y_b();
extern long  minimum1_X_b(),minimum1_XY_b(),minimum1_Y_b();
extern long  minimum2_X_b(),minimum2_XY_b(),minimum2_Y_b();


/*
 *   dist_00,dist_I0,dist_0J,dist_IJ
 *
 * /

/***** dist_00 *****/
void 
dist_00_b(Path0,Vec0,ProfI,ProfJ,I,J,S)
PATH_b *Path0;
VEC *Vec0;
PROF *ProfI,*ProfJ;
long I,J,S;
{
  Vec0[I].x = (long)outgapcost_I_b(ProfI,ProfJ,I,J,S);
  Vec0[I].xy = (long)paircost_IJ_F_b(ProfI,ProfJ,I,J,S);
  Vec0[I].y = (long)outgapcost_J_b(ProfI,ProfJ,I,J,S);

  Path0[I].gapx.gapj.num = 1;
  Path0[I].gapx.gapi.num = 0;

  Path0[I].gapxy.gapi.num = 0;
  Path0[I].gapxy.gapj.num = 0;

  Path0[I].gapy.gapj.num = 0;
  Path0[I].gapy.gapi.num = 1;

  Path0[I].gapx.gapj.gap[0] = J; 
  Path0[I].gapy.gapi.gap[0] = I; 

/*  fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
}


void 
dist_00_Cut_1_b(Path0,Vec0,ProfI,ProfJ,I,J,S)
PATH_b *Path0;
VEC *Vec0;
PROF *ProfI,*ProfJ;
long I,J,S;
{
  Vec0[I].x = DUMMY;
  Vec0[I].xy = (long)paircost_IJ_F_b(ProfI,ProfJ,I,J,S);
  Vec0[I].y = (long)outgapcost_J_b(ProfI,ProfJ,I,J,S);


  Path0[I].gapxy.gapi.num = 0;
  Path0[I].gapxy.gapj.num = 0;

  Path0[I].gapy.gapj.num = 0;
  Path0[I].gapy.gapi.num = 1;

  Path0[I].gapy.gapi.gap[0] = I; 

/*  fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
}


void 
dist_00_Cut_2_b(Path0,Vec0,ProfI,ProfJ,I,J,S)
PATH_b *Path0;
VEC *Vec0;
PROF *ProfI,*ProfJ;
long I,J,S;
{
  Vec0[I].x = (long)outgapcost_I_b(ProfI,ProfJ,I,J,S);
  Vec0[I].xy = (long)paircost_IJ_F_b(ProfI,ProfJ,I,J,S);
  Vec0[I].y = DUMMY;

  Path0[I].gapx.gapj.num = 1;
  Path0[I].gapx.gapi.num = 0;

  Path0[I].gapxy.gapi.num = 0;
  Path0[I].gapxy.gapj.num = 0;

  Path0[I].gapx.gapj.gap[0] = J; 

/*  fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
}


void 
dist_00_II_b(Path0,Vec0,ProfI,ProfJ,I,J,S)
PATH_b *Path0;
VEC *Vec0;
PROF *ProfI,*ProfJ;
long I,J,S;
{
  Vec0[I].x = DUMMY;
  Vec0[I].xy = (long)paircost_IJ_F_b(ProfI,ProfJ,I,J,S);
  Vec0[I].y = DUMMY;

  Path0[I].gapxy.gapi.num = 0;
  Path0[I].gapxy.gapj.num = 0;

/*  fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
}


/***** dist_II *****/
void 
dist_II_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,I,J,U,V,S)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
PROF *ProfI,*ProfJ;
long I,J,U,V,S;
{
  long i;
  long CostXY;

  if( J % 2 == 0 ){
    CostXY = Vec1[I-1].xy;
    Vec0[I].x = DUMMY;
    Vec0[I].xy = CostXY + (long)paircost_IJ_DXY_b(Path1,ProfI,ProfJ,U,V,S,I,J);
    Vec0[I].y = DUMMY;

    for(i=0;i<Path1[I-1].gapxy.gapi.num;i++) Path0[I].gapxy.gapi.gap[i] = Path1[I-1].gapxy.gapi.gap[i];
    for(i=0;i<Path1[I-1].gapxy.gapj.num;i++) Path0[I].gapxy.gapj.gap[i] = Path1[I-1].gapxy.gapj.gap[i];

    Path0[I].gapxy.gapi.num = Path1[I-1].gapxy.gapi.num;
    Path0[I].gapxy.gapj.num = Path1[I-1].gapxy.gapj.num;

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if( J % 2 == 1 ){
    CostXY = Vec0[I-1].xy;
    Vec1[I].x = DUMMY;
    Vec1[I].xy = CostXY + (long)paircost_IJ_DXY_b(Path0,ProfI,ProfJ,U,V,S,I,J);
    Vec1[I].y = DUMMY;

    for(i=0;i<Path0[I-1].gapxy.gapi.num;i++) Path1[I].gapxy.gapi.gap[i] = Path0[I-1].gapxy.gapi.gap[i];
    for(i=0;i<Path0[I-1].gapxy.gapj.num;i++) Path1[I].gapxy.gapj.gap[i] = Path0[I-1].gapxy.gapj.gap[i];

    Path1[I].gapxy.gapi.num = Path0[I-1].gapxy.gapi.num;
    Path1[I].gapxy.gapj.num = Path0[I-1].gapxy.gapj.num;

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}


void 
dist_XX_b(Path0,Path1,Vec0,Vec1,I,J)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
long I,J;
{
  long i;
  long CostXY;

  if( J % 2 == 0 ){
    CostXY = Vec1[I-1].xy;
    Vec0[I].x = DUMMY;
    Vec0[I].xy = CostXY;
    Vec0[I].y = DUMMY;

    for(i=0;i<Path1[I-1].gapxy.gapi.num;i++) Path0[I].gapxy.gapi.gap[i] = Path1[I-1].gapxy.gapi.gap[i];
    for(i=0;i<Path1[I-1].gapxy.gapj.num;i++) Path0[I].gapxy.gapj.gap[i] = Path1[I-1].gapxy.gapj.gap[i];

    Path0[I].gapxy.gapi.num = Path1[I-1].gapxy.gapi.num;
    Path0[I].gapxy.gapj.num = Path1[I-1].gapxy.gapj.num;

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if( J % 2 == 1 ){
    CostXY = Vec0[I-1].xy;
    Vec1[I].x = DUMMY;
    Vec1[I].xy = CostXY;
    Vec1[I].y = DUMMY;

    for(i=0;i<Path0[I-1].gapxy.gapi.num;i++) Path1[I].gapxy.gapi.gap[i] = Path0[I-1].gapxy.gapi.gap[i];
    for(i=0;i<Path0[I-1].gapxy.gapj.num;i++) Path1[I].gapxy.gapj.gap[i] = Path0[I-1].gapxy.gapj.gap[i];

    Path1[I].gapxy.gapi.num = Path0[I-1].gapxy.gapi.num;
    Path1[I].gapxy.gapj.num = Path0[I-1].gapxy.gapj.num;

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }

}


/***** dist_I0 *****/
void 
dist_I0_b(Path0,Vec0,ProfI,ProfJ,I,J,U,V,S)
PATH_b *Path0;
VEC *Vec0;
PROF *ProfI,*ProfJ;
long I,J,U,V,S;
{
  long i;
  long CostX;

  CostX = Vec0[I-1].x;
  Vec0[I].x = CostX + (long)outgapcost_I_b(ProfI,ProfJ,I,J,S);
  Vec0[I].xy = CostX + (long)paircost_IJ_DX_b(Path0,ProfI,ProfJ,U,V,S,I,J);
  Vec0[I].y = CostX + (long)gapcost_J_DX_b(Path0,ProfI,ProfJ,U,V,S,I,J);

  for(i=0;i<Path0[I-1].gapx.gapi.num;i++){
    Path0[I].gapx.gapi.gap[i] = Path0[I-1].gapx.gapi.gap[i];
    Path0[I].gapxy.gapi.gap[i] = Path0[I-1].gapx.gapi.gap[i];
    Path0[I].gapy.gapi.gap[i] = Path0[I-1].gapx.gapi.gap[i];
  }
  for(i=0;i<Path0[I-1].gapx.gapj.num;i++){
    Path0[I].gapx.gapj.gap[i] = Path0[I-1].gapx.gapj.gap[i];
    Path0[I].gapxy.gapj.gap[i] = Path0[I-1].gapx.gapj.gap[i];
    Path0[I].gapy.gapj.gap[i] = Path0[I-1].gapx.gapj.gap[i];
  }

  Path0[I].gapx.gapi.num = Path0[I-1].gapx.gapi.num;
  Path0[I].gapx.gapj.num = Path0[I-1].gapx.gapj.num + 1;

  Path0[I].gapxy.gapi.num = Path0[I-1].gapx.gapi.num;
  Path0[I].gapxy.gapj.num = Path0[I-1].gapx.gapj.num;

  Path0[I].gapy.gapi.num = Path0[I-1].gapx.gapi.num + 1;
  Path0[I].gapy.gapj.num = Path0[I-1].gapx.gapj.num;

  Path0[I].gapx.gapj.gap[Path0[I-1].gapx.gapj.num] = J; 
  Path0[I].gapy.gapi.gap[Path0[I-1].gapx.gapi.num] = I; 

/*  fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
}


void 
dist_I0_Cut_b(Path0,Vec0,ProfI,ProfJ,I,J,U,V,S)
PATH_b *Path0;
VEC *Vec0;
PROF *ProfI,*ProfJ;
long I,J,U,V,S;
{
  long i;
  long CostX;

  CostX = Vec0[I-1].x;
  Vec0[I].x = DUMMY;
  Vec0[I].xy = (long)CostX + paircost_IJ_DX_b(Path0,ProfI,ProfJ,U,V,S,I,J);
  Vec0[I].y = (long)CostX + gapcost_J_DX_b(Path0,ProfI,ProfJ,U,V,S,I,J);

  for(i=0;i<Path0[I-1].gapx.gapi.num;i++){
    Path0[I].gapxy.gapi.gap[i] = Path0[I-1].gapx.gapi.gap[i];
    Path0[I].gapy.gapi.gap[i] = Path0[I-1].gapx.gapi.gap[i];
  }
  for(i=0;i<Path0[I-1].gapx.gapj.num;i++){
    Path0[I].gapxy.gapj.gap[i] = Path0[I-1].gapx.gapj.gap[i];
    Path0[I].gapy.gapj.gap[i] = Path0[I-1].gapx.gapj.gap[i];
  }

  Path0[I].gapxy.gapi.num = Path0[I-1].gapx.gapi.num;
  Path0[I].gapxy.gapj.num = Path0[I-1].gapx.gapj.num;

  Path0[I].gapy.gapi.num = Path0[I-1].gapx.gapi.num + 1;
  Path0[I].gapy.gapj.num = Path0[I-1].gapx.gapj.num;

  Path0[I].gapy.gapi.gap[Path0[I-1].gapx.gapi.num] = I; 

/*  fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
}


void 
dist_X0_b(Path0,Vec0,ProfI,ProfJ,I,J,S)
PATH_b *Path0;
VEC *Vec0;
PROF *ProfI,*ProfJ;
long I,J,S;
{
  long i;
  long CostX;

  CostX = Vec0[I-1].x;
  Vec0[I].x = DUMMY;
  Vec0[I].xy = DUMMY;
  Vec0[I].y = CostX + (long)outgapcost_J_b(ProfI,ProfJ,I-1,J,S);

  for(i=0;i<Path0[I-1].gapx.gapi.num;i++){
    Path0[I].gapy.gapi.gap[i] = Path0[I-1].gapx.gapi.gap[i];
  }
  for(i=0;i<Path0[I-1].gapx.gapj.num;i++){
    Path0[I].gapy.gapj.gap[i] = Path0[I-1].gapx.gapj.gap[i];
  }

  Path0[I].gapy.gapi.num = Path0[I-1].gapx.gapi.num + 1;
  Path0[I].gapy.gapj.num = Path0[I-1].gapx.gapj.num;

  Path0[I].gapy.gapi.gap[Path0[I-1].gapx.gapi.num] = I; 

/*  fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
}


/***** dist_0J *****/
void 
dist_0J_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,I,J,U,V,S)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
PROF *ProfI,*ProfJ;
long I,J,U,V,S;
{
  long i;
  long CostY;

  if(J % 2 == 0){
    CostY = Vec1[I].y;
    Vec0[I].x = CostY + (long)gapcost_I_DY_b(Path1,ProfI,ProfJ,U,V,S,I,J);
    Vec0[I].xy = CostY + (long)paircost_IJ_DY_b(Path1,ProfI,ProfJ,U,V,S,I,J);
    Vec0[I].y = CostY + (long)outgapcost_J_b(ProfI,ProfJ,I,J,S);

    for(i=0;i<Path1[I].gapy.gapi.num;i++){
      Path0[I].gapx.gapi.gap[i] = Path1[I].gapy.gapi.gap[i];
      Path0[I].gapxy.gapi.gap[i] = Path1[I].gapy.gapi.gap[i];
      Path0[I].gapy.gapi.gap[i] = Path1[I].gapy.gapi.gap[i];
    }
    for(i=0;i<Path1[I].gapy.gapj.num;i++){
      Path0[I].gapx.gapj.gap[i] = Path1[I].gapy.gapj.gap[i];
      Path0[I].gapxy.gapj.gap[i] = Path1[I].gapy.gapj.gap[i];
      Path0[I].gapy.gapj.gap[i] = Path1[I].gapy.gapj.gap[i];
    }    

    Path0[I].gapx.gapi.num = Path1[I].gapy.gapi.num;
    Path0[I].gapx.gapj.num = Path1[I].gapy.gapj.num + 1;

    Path0[I].gapxy.gapi.num = Path1[I].gapy.gapi.num;
    Path0[I].gapxy.gapj.num = Path1[I].gapy.gapj.num;

    Path0[I].gapy.gapi.num = Path1[I].gapy.gapi.num + 1;
    Path0[I].gapy.gapj.num = Path1[I].gapy.gapj.num;

    Path0[I].gapx.gapj.gap[Path1[I].gapy.gapj.num] = J; 
    Path0[I].gapy.gapi.gap[Path1[I].gapy.gapi.num] = I; 

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if(J % 2 == 1){
    CostY = Vec0[I].y;
    Vec1[I].x = CostY + (long)gapcost_I_DY_b(Path0,ProfI,ProfJ,U,V,S,I,J);
    Vec1[I].xy = CostY + (long)paircost_IJ_DY_b(Path0,ProfI,ProfJ,U,V,S,I,J);
    Vec1[I].y = CostY + (long)outgapcost_J_b(ProfI,ProfJ,I,J,S);

    for(i=0;i<Path0[I].gapy.gapi.num;i++){
      Path1[I].gapx.gapi.gap[i] = Path0[I].gapy.gapi.gap[i];
      Path1[I].gapxy.gapi.gap[i] = Path0[I].gapy.gapi.gap[i];
      Path1[I].gapy.gapi.gap[i] = Path0[I].gapy.gapi.gap[i];
    }
    for(i=0;i<Path0[I].gapy.gapj.num;i++){
      Path1[I].gapx.gapj.gap[i] = Path0[I].gapy.gapj.gap[i];
      Path1[I].gapxy.gapj.gap[i] = Path0[I].gapy.gapj.gap[i];
      Path1[I].gapy.gapj.gap[i] = Path0[I].gapy.gapj.gap[i];
    }

    Path1[I].gapx.gapi.num = Path0[I].gapy.gapi.num;
    Path1[I].gapx.gapj.num = Path0[I].gapy.gapj.num + 1;

    Path1[I].gapxy.gapi.num = Path0[I].gapy.gapi.num;
    Path1[I].gapxy.gapj.num = Path0[I].gapy.gapj.num;

    Path1[I].gapy.gapi.num = Path0[I].gapy.gapi.num + 1;
    Path1[I].gapy.gapj.num = Path0[I].gapy.gapj.num;

    Path1[I].gapx.gapj.gap[Path0[I].gapy.gapj.num] = J; 
    Path1[I].gapy.gapi.gap[Path0[I].gapy.gapi.num] = I; 

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}


void 
dist_0J_Cut_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,I,J,U,V,S)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
PROF *ProfI,*ProfJ;
long I,J,U,V,S;
{
  long i;
  long CostY;

  if(J % 2 == 0){
    CostY = Vec1[I].y;
    Vec0[I].x = CostY + (long)gapcost_I_DY_b(Path1,ProfI,ProfJ,U,V,S,I,J);
    Vec0[I].xy = CostY + (long)paircost_IJ_DY_b(Path1,ProfI,ProfJ,U,V,S,I,J);
    Vec0[I].y = DUMMY;

    for(i=0;i<Path1[I].gapy.gapi.num;i++){
      Path0[I].gapx.gapi.gap[i] = Path1[I].gapy.gapi.gap[i];
      Path0[I].gapxy.gapi.gap[i] = Path1[I].gapy.gapi.gap[i];
    }
    for(i=0;i<Path1[I].gapy.gapj.num;i++){
      Path0[I].gapx.gapj.gap[i] = Path1[I].gapy.gapj.gap[i];
      Path0[I].gapxy.gapj.gap[i] = Path1[I].gapy.gapj.gap[i];
    }    

    Path0[I].gapx.gapi.num = Path1[I].gapy.gapi.num;
    Path0[I].gapx.gapj.num = Path1[I].gapy.gapj.num + 1;

    Path0[I].gapxy.gapi.num = Path1[I].gapy.gapi.num;
    Path0[I].gapxy.gapj.num = Path1[I].gapy.gapj.num;

    Path0[I].gapx.gapj.gap[Path1[I].gapy.gapj.num] = J; 

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if(J % 2 == 1){
    CostY = Vec0[I].y;
    Vec1[I].x = CostY + (long)gapcost_I_DY_b(Path0,ProfI,ProfJ,U,V,S,I,J);
    Vec1[I].xy = CostY + (long)paircost_IJ_DY_b(Path0,ProfI,ProfJ,U,V,S,I,J);
    Vec1[I].y = DUMMY;

    for(i=0;i<Path0[I].gapy.gapi.num;i++){
      Path1[I].gapx.gapi.gap[i] = Path0[I].gapy.gapi.gap[i];
      Path1[I].gapxy.gapi.gap[i] = Path0[I].gapy.gapi.gap[i];
    }
    for(i=0;i<Path0[I].gapy.gapj.num;i++){
      Path1[I].gapx.gapj.gap[i] = Path0[I].gapy.gapj.gap[i];
      Path1[I].gapxy.gapj.gap[i] = Path0[I].gapy.gapj.gap[i];
    }

    Path1[I].gapx.gapi.num = Path0[I].gapy.gapi.num;
    Path1[I].gapx.gapj.num = Path0[I].gapy.gapj.num + 1;

    Path1[I].gapxy.gapi.num = Path0[I].gapy.gapi.num;
    Path1[I].gapxy.gapj.num = Path0[I].gapy.gapj.num;

    Path1[I].gapx.gapj.gap[Path0[I].gapy.gapj.num] = J; 

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}


void 
dist_0Y_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,I,J,S)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
PROF *ProfI,*ProfJ;
long I,J,S;
{
  long i;
  long CostY;

  if(J % 2 == 0){
    CostY = Vec1[I].y;
    Vec0[I].x = CostY + (long)outgapcost_I_b(ProfI,ProfJ,I,J-1,S);
    Vec0[I].xy = DUMMY;
    Vec0[I].y = DUMMY;

    for(i=0;i<Path1[I].gapy.gapi.num;i++){
      Path0[I].gapx.gapi.gap[i] = Path1[I].gapy.gapi.gap[i];
    }
    for(i=0;i<Path1[I].gapy.gapj.num;i++){
      Path0[I].gapx.gapj.gap[i] = Path1[I].gapy.gapj.gap[i];
    }    

    Path0[I].gapx.gapi.num = Path1[I].gapy.gapi.num;
    Path0[I].gapx.gapj.num = Path1[I].gapy.gapj.num + 1;

    Path0[I].gapx.gapj.gap[Path1[I].gapy.gapj.num] = J; 

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if(J % 2 == 1){
    CostY = Vec0[I].y;
    Vec1[I].x = CostY + (long)outgapcost_I_b(ProfI,ProfJ,I,J-1,S);
    Vec1[I].xy = DUMMY;
    Vec1[I].y = DUMMY;

    for(i=0;i<Path0[I].gapy.gapi.num;i++){
      Path1[I].gapx.gapi.gap[i] = Path0[I].gapy.gapi.gap[i];
    }
    for(i=0;i<Path0[I].gapy.gapj.num;i++){
      Path1[I].gapx.gapj.gap[i] = Path0[I].gapy.gapj.gap[i];
    }

    Path1[I].gapx.gapi.num = Path0[I].gapy.gapi.num;
    Path1[I].gapx.gapj.num = Path0[I].gapy.gapj.num + 1;

    Path1[I].gapx.gapj.gap[Path0[I].gapy.gapj.num] = J; 

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}


/***** dist_IJ *****/
void 
dist_IJ_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,I,J,U,V,S)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
PROF *ProfI,*ProfJ;
long I,J,U,V,S;
{
  long CostX,CostXY,CostY;

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    Vec0[I].x = minimum_X_b(
		Path0,Path1,J,I,
                CostX + (long)gapcost_I_DX_b(Path0,ProfI,ProfJ,U,V,S,I,J),
		CostXY + (long)gapcost_I_DXY_b(Path1,ProfI,ProfJ,U,V,S,I,J),
		CostY + (long)gapcost_I_DY_b(Path1,ProfI,ProfJ,U,V,S,I,J)
		);
    Vec0[I].xy = minimum_XY_b(
                 Path0,Path1,J,I,
                 CostX + (long)paircost_IJ_DX_b(Path0,ProfI,ProfJ,U,V,S,I,J),
		 CostXY + (long)paircost_IJ_DXY_b(Path1,ProfI,ProfJ,U,V,S,I,J),
		 CostY + (long)paircost_IJ_DY_b(Path1,ProfI,ProfJ,U,V,S,I,J)
		 );
    Vec0[I].y = minimum_Y_b(
		Path0,Path1,J,I,
                CostX + (long)gapcost_J_DX_b(Path0,ProfI,ProfJ,U,V,S,I,J),
		CostXY + (long)gapcost_J_DXY_b(Path1,ProfI,ProfJ,U,V,S,I,J),
		CostY + (long)gapcost_J_DY_b(Path1,ProfI,ProfJ,U,V,S,I,J)
		);

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    Vec1[I].x = minimum_X_b(
                Path1,Path0,J,I,
                CostX + (long)gapcost_I_DX_b(Path1,ProfI,ProfJ,U,V,S,I,J),
                CostXY + (long)gapcost_I_DXY_b(Path0,ProfI,ProfJ,U,V,S,I,J),
		CostY + (long)gapcost_I_DY_b(Path0,ProfI,ProfJ,U,V,S,I,J)
		);
    Vec1[I].xy = minimum_XY_b(
                 Path1,Path0,J,I,
                 CostX + (long)paircost_IJ_DX_b(Path1,ProfI,ProfJ,U,V,S,I,J),
		 CostXY + (long)paircost_IJ_DXY_b(Path0,ProfI,ProfJ,U,V,S,I,J),
		 CostY + (long)paircost_IJ_DY_b(Path0,ProfI,ProfJ,U,V,S,I,J)
		 );
    Vec1[I].y = minimum_Y_b(
                Path1,Path0,J,I,
                CostX + (long)gapcost_J_DX_b(Path1,ProfI,ProfJ,U,V,S,I,J),
		CostXY + (long)gapcost_J_DXY_b(Path0,ProfI,ProfJ,U,V,S,I,J),
		CostY + (long)gapcost_J_DY_b(Path0,ProfI,ProfJ,U,V,S,I,J)
		);

/*    fprintf_b(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}


void 
dist_XJ_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,I,J,S)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
PROF *ProfI,*ProfJ;
long I,J,S;
{
  long CostX,CostXY,CostY,CostR;

/*  
  Path[J][I].x = 'n';
  Path[J][I].xy = 'n';
*/

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    CostR = minimum_Y_b(Path0,Path1,J,I,CostX,CostXY,CostY);
    Vec0[I].xy = DUMMY;
    Vec0[I].x = DUMMY;
    Vec0[I].y = CostR + (long)outgapcost_J_b(ProfI,ProfJ,I-1,J,S);

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    CostR = minimum_Y_b(Path1,Path0,J,I,CostX,CostXY,CostY);
    Vec1[I].xy = DUMMY;
    Vec1[I].x = DUMMY;
    Vec1[I].y = CostR + (long)outgapcost_J_b(ProfI,ProfJ,I-1,J,S);

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}


void 
dist_IY_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,I,J,S)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
PROF *ProfI,*ProfJ;
long I,J,S;
{
  long CostX,CostXY,CostY,CostR;

/*
  Path[J][I].xy = 'n';
  Path[J][I].y = 'n';
*/

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    CostR = minimum_X_b(Path0,Path1,J,I,CostX,CostXY,CostY);
    Vec0[I].xy = DUMMY;
    Vec0[I].x = CostR + (long)outgapcost_I_b(ProfI,ProfJ,I,J-1,S);
    Vec0[I].y = DUMMY;

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    CostR = minimum_X_b(Path1,Path0,J,I,CostX,CostXY,CostY);
    Vec1[I].xy = DUMMY;
    Vec1[I].x = CostR + (long)outgapcost_I_b(ProfI,ProfJ,I,J-1,S);
    Vec1[I].y = DUMMY;

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}


void 
dist_XY_b(Path0,Path1,Vec0,Vec1,I,J)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
long I,J;
{
  long CostX,CostXY,CostY,CostR;

/*
  Path[J][I].x = 'n';
  Path[J][I].y = 'n';
*/

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    CostR = minimum_XY_b(Path0,Path1,J,I,CostX,CostXY,CostY);
    Vec0[I].xy = CostR;
    Vec0[I].x = DUMMY;
    Vec0[I].y = DUMMY;

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    CostR = minimum_XY_b(Path1,Path0,J,I,CostX,CostXY,CostY);
    Vec1[I].xy = CostR;
    Vec1[I].x = DUMMY;
    Vec1[I].y = DUMMY;

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}


/***** dist_IJ_1 *****/
void 
dist_IJ_1_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,I,J,U,V,S)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
PROF *ProfI,*ProfJ;
long I,J,U,V,S;
{
  long CostX,CostXY;

/*
  Path[J][I].x = 'n';
*/

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;
    
    Vec0[I].x = DUMMY;
    Vec0[I].xy = minimum1_XY_b(
                 Path0,Path1,J,I,
                 CostX + (long)paircost_IJ_DX_b(Path0,ProfI,ProfJ,U,V,S,I,J),
		 CostXY + (long)paircost_IJ_DXY_b(Path1,ProfI,ProfJ,U,V,S,I,J)
		 );
    Vec0[I].y = minimum1_Y_b(
                Path0,Path1,J,I,
                CostX + (long)gapcost_J_DX_b(Path0,ProfI,ProfJ,U,V,S,I,J),
		CostXY + (long)gapcost_J_DXY_b(Path1,ProfI,ProfJ,U,V,S,I,J)
		);

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    
    Vec1[I].x = DUMMY;
    Vec1[I].xy = minimum1_XY_b(
                 Path1,Path0,J,I,
                 CostX + (long)paircost_IJ_DX_b(Path1,ProfI,ProfJ,U,V,S,I,J),
		 CostXY + (long)paircost_IJ_DXY_b(Path0,ProfI,ProfJ,U,V,S,I,J)
		 );
    Vec1[I].y = minimum1_Y_b(
                Path1,Path0,J,I,
                CostX + (long)gapcost_J_DX_b(Path1,ProfI,ProfJ,U,V,S,I,J),
		CostXY + (long)gapcost_J_DXY_b(Path0,ProfI,ProfJ,U,V,S,I,J)
                );

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}


void 
dist_XJ_1_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,I,J,S)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
PROF *ProfI,*ProfJ;
long I,J,S;
{
  long CostX,CostXY,CostR;

/*
  Path[J][I].xy = 'n';
  Path[J][I].x = 'n';
*/

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;
    
    CostR = minimum1_Y_b(Path0,Path1,J,I,CostX,CostXY);
    Vec0[I].xy = DUMMY;
    Vec0[I].x = DUMMY;
    Vec0[I].y = CostR + (long)outgapcost_J_b(ProfI,ProfJ,I-1,J,S);

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    
    CostR = minimum1_Y_b(Path1,Path0,J,I,CostX,CostXY);
    Vec1[I].xy = DUMMY;
    Vec1[I].x = DUMMY;
    Vec1[I].y = CostR + (long)outgapcost_J_b(ProfI,ProfJ,I-1,J,S);

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}


void 
dist_XY_1_b(Path0,Path1,Vec0,Vec1,I,J)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
long I,J;
{
  long CostX,CostXY,CostR;

/*
  Path[J][I].x = 'n';
  Path[J][I].y = 'n';
*/

  if(J % 2 == 0){
    CostX = Vec0[I-1].x;
    CostXY = Vec1[I-1].xy;
    
    CostR = minimum1_XY_b(Path0,Path1,J,I,CostX,CostXY);
    Vec0[I].xy = CostR;
    Vec0[I].x = DUMMY;
    Vec0[I].y = DUMMY;

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if(J % 2 == 1){
    CostX = Vec1[I-1].x;
    CostXY = Vec0[I-1].xy;
    
    CostR = minimum1_XY_b(Path1,Path0,J,I,CostX,CostXY);
    Vec1[I].xy = CostR;
    Vec1[I].x = DUMMY;
    Vec1[I].y = DUMMY;

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}


/***** dist_IJ_2 *****/
void 
dist_IJ_2_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,I,J,U,V,S)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
PROF *ProfI,*ProfJ;
long I,J,U,V,S;
{
  long CostXY,CostY,CostR;

/*
  Path[J][I].y = 'n';
*/

  if(J % 2 == 0){
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    Vec0[I].x = minimum2_X_b(
                Path0,Path1,J,I,
                CostXY + (long)gapcost_I_DXY_b(Path1,ProfI,ProfJ,U,V,S,I,J),
		CostY + (long)gapcost_I_DY_b(Path1,ProfI,ProfJ,U,V,S,I,J)
		);
    Vec0[I].xy = minimum2_XY_b(
                 Path0,Path1,J,I,
                 CostXY + (long)paircost_IJ_DXY_b(Path1,ProfI,ProfJ,U,V,S,I,J),
		 CostY + (long)paircost_IJ_DY_b(Path1,ProfI,ProfJ,U,V,S,I,J)
		 );
    Vec0[I].y = DUMMY;

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if(J % 2 == 1){
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    Vec1[I].x = minimum2_X_b(
                Path1,Path0,J,I,
                CostXY + (long)gapcost_I_DXY_b(Path0,ProfI,ProfJ,U,V,S,I,J),
		CostY + (long)gapcost_I_DY_b(Path0,ProfI,ProfJ,U,V,S,I,J)
		);
    Vec1[I].xy = minimum2_XY_b(
                 Path1,Path0,J,I,
                 CostXY + (long)paircost_IJ_DXY_b(Path0,ProfI,ProfJ,U,V,S,I,J),
		 CostY + (long)paircost_IJ_DY_b(Path0,ProfI,ProfJ,U,V,S,I,J)
		 );
    Vec1[I].y = DUMMY;

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}


void 
dist_IY_2_b(Path0,Path1,Vec0,Vec1,ProfI,ProfJ,I,J,S)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
PROF *ProfI,*ProfJ;
long I,J,S;
{
  long CostXY,CostY,CostR;

/*
  Path[J][I].xy = 'n';
  Path[J][I].y = 'n';
*/

  if(J % 2 == 0){
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    CostR = minimum2_X_b(Path0,Path1,J,I,CostXY,CostY);
    Vec0[I].xy = DUMMY;
    Vec0[I].x = CostR + (long)outgapcost_I_b(ProfI,ProfJ,I,J-1,S);
    Vec0[I].y = DUMMY;

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if(J % 2 == 1){
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    CostR = minimum2_X_b(Path1,Path0,J,I,CostXY,CostY);
    Vec1[I].xy = DUMMY;
    Vec1[I].x = CostR + (long)outgapcost_I_b(ProfI,ProfJ,I,J-1,S);
    Vec1[I].y = DUMMY;

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}


void 
dist_XY_2_b(Path0,Path1,Vec0,Vec1,I,J)
PATH_b *Path0,*Path1;
VEC *Vec0,*Vec1;
long I,J;
{
  long CostXY,CostY,CostR;

/*
  Path[J][I].x = 'n';
  Path[J][I].y = 'n';
*/

  if(J % 2 == 0){
    CostXY = Vec1[I-1].xy;
    CostY = Vec1[I].y;
    
    CostR = minimum2_XY_b(Path0,Path1,J,I,CostXY,CostY);
    Vec0[I].xy = CostR;
    Vec0[I].x = DUMMY;
    Vec0[I].y = DUMMY;

/*    fprintf(stdout,"%d,%d,%d\n",Vec0[I].x,Vec0[I].xy,Vec0[I].y);*/
  }
  if(J % 2 == 1){
    CostXY = Vec0[I-1].xy;
    CostY = Vec0[I].y;
    
    CostR = minimum2_XY_b(Path1,Path0,J,I,CostXY,CostY);
    Vec1[I].xy = CostR;
    Vec1[I].x = DUMMY;
    Vec1[I].y = DUMMY;

/*    fprintf(stdout,"%d,%d,%d\n",Vec1[I].x,Vec1[I].xy,Vec1[I].y);*/
  }
}
